#include <cstdio>
#include <ctime>
#include <string>
#include <cstdlib>
#include <unistd.h>
#include <pwd.h>
#include <sys/stat.h>
#include <iostream>
#include <fstream>
#include <Xm/Xm.h>
#include <Xm/IconG.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/ScrolledW.h>
#include <Xm/MessageB.h>
#include <Xm/Container.h>
#include <Xm/Text.h>
#include <Xm/Label.h>
#include <Xm/Frame.h>
#include <Xm/TextStrSoP.h>
#include <X11/Xmu/Editres.h>

#include "akPixmap.h"
#include "mxMailCompose.h"
#include "mxSetup.h"
#include "mxMailAddressSelect.h"
#include "mxMailAttachmentTypes.xpm"
#include "mxMailComposeIcon.xpm"
#include "mxButtons.xpm"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
mxMailCompose::mxMailCompose(char *name,
			     mxMailAddressBook *book,
			     mxMailComposeType type,
			     mxMailAddress *address,
			     mxMailMsg *msg,
			     XtCallbackProc callback,
			     XtPointer clientData)
	:akWindow(name),
	 _addressbook(book),
	 _userCB(callback),
	 _userData(clientData),
	 _display((mxMailMsgDisplay *)0),
	 _sendAndQuitButton((akButton *)0),
	 _sendAndContinueButton((akButton *)0),
	 _resetButton((akButton *)0),
	 _cancelButton((akButton *)0),
	 _addAttachmentButton((akButton *)0),
	 _deleteAttachmentButton((akButton *)0),
	 _attachmentSpecifier((mxMailAttachmentSpecify *)0),
	 _confirmDialog((akMessageDialog *)0)
{

//	Create the panel

	initialize();
	installWMClose();
	setIcon("mxMail - Compose",mxMailComposeIcon_xpm);
	setTitle("mxMail - Message Compose");

//	Addressee - sending a message to an addressee (fill the 'To' field)

	if (type == MX_MAIL_COMPOSE_ADDRESSEE)
	   {
	    _display->setTo(address->alias());
	   }

//	Reply - set the subject,to and message fields

	else if (type == MX_MAIL_COMPOSE_REPLY)
	  {
	    string	subject;
	    string	text;
	    int		pos,pos1,pos2;

	    // Add 'Re: ' unless already starts with this
	    if ((pos=msg->subject().find("Re:")) == 0)
	      subject = msg->subject();
	    else
	      subject = "Re: " + msg->subject();
	    _display->setSubject(subject);
	    _display->setTo(msg->mailid());
	    _display->setCc(msg->ccAddressee());

	    // Take the message text, indent it and put it in message field
	    text = msg->bodyText();
	    text.insert(0,theMxSetup->mailIndentString());
	    pos = 0;
	    while ((pos = text.find('\n',pos)) >= 0)
	       {
		text.insert(pos+1,theMxSetup->mailIndentString());
		pos++;
	       }
	    text += "\n--\n";
	    text += signatureText();
	    _display->setText(text);
	   }

//	Forward - set the subject field and add message as an attachment

	else if (type == MX_MAIL_COMPOSE_FORWARD)
	   {
	    string	subject;
	    string	text;
	    subject = msg->subject() + " (Forward)";
	    _display->setSubject(subject);

	    text += "\n--\n";
	    text += signatureText();
	    _display->setText(text);

	    mxMailAttachment	*att;
	    att = new mxMailAttachment(*msg);
	    _display->addAttachment(*att);
	    delete att;
	   }

//	New (basic) message

	else
	   {
	    string	text;

	    text += "\n--\n";
	    text += signatureText();
	    _display->setText(text);
	   }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
mxMailCompose::~mxMailCompose()
{
	if (_display)
	  delete _display;
	if (_sendAndQuitButton)
	  delete _sendAndQuitButton;
	if (_sendAndContinueButton)
	  delete _sendAndContinueButton;
	if (_resetButton)
	  delete _resetButton;
	if (_cancelButton)
	  delete _cancelButton;
	if (_addAttachmentButton)
	  delete _addAttachmentButton;
	if (_deleteAttachmentButton)
	  delete _deleteAttachmentButton;
	if (_confirmDialog)
	  delete _confirmDialog;
	if (_attachmentSpecifier)
	  delete _attachmentSpecifier;
}
////////////////////////////////////////////////////////////////////////////////
//
//	CreateWorkArea
//
////////////////////////////////////////////////////////////////////////////////
Widget	mxMailCompose::createWorkArea(Widget parent)
{
	Arg		args[20];
	Widget		form;
	Widget		messagebox;

//	Add 'editres' support

	XtAddEventHandler(_w,(EventMask)0,TRUE,
			  (XtEventHandler)_XEditResCheckMessages,0);

//	Add a form to attach everything to

	form =
		XtVaCreateManagedWidget("ComposeForm",
					xmFormWidgetClass,
					parent,
					0);
//	Add messagebox to hold buttons

	messagebox =
		XtVaCreateManagedWidget("ButtonBar",
					xmMessageBoxWidgetClass,
					form,
		      			XmNrightAttachment,XmATTACH_FORM,
		      			XmNleftAttachment,XmATTACH_FORM,
		      			XmNtopAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					0);
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_OK_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_CANCEL_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_HELP_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_MESSAGE_LABEL));
	XtUnmanageChild(XmMessageBoxGetChild(messagebox,XmDIALOG_SYMBOL_LABEL));

//	Set up option buttons

	_sendAndQuitButton =
	  new akButton(messagebox,"SendAndQuit",mxSendAndQuit_xpm,
		       &mxMailCompose::sendAndQuitCB,(XtPointer)this);
	_sendAndQuitButton->installHelp("Send the message\nand quit the panel");
	_sendAndQuitButton->manage();

	_sendAndContinueButton =
	  new akButton(messagebox,"SendAndContinue",mxSendAndContinue_xpm,
		       &mxMailCompose::sendAndContinueCB,(XtPointer)this);
	_sendAndContinueButton->installHelp("Send the message\nand continue");
	_sendAndContinueButton->manage();

	_resetButton =
	  new akButton(messagebox,"Reset",mxReset_xpm,
		       &mxMailCompose::resetCB,(XtPointer)this);
	_resetButton->installHelp("Reset the message");
	_resetButton->manage();

	_addAttachmentButton =
	  new akButton(messagebox,"Add",mxAdd_xpm,
		       &mxMailCompose::addAttachmentCB,(XtPointer)this);
	_addAttachmentButton->installHelp("Add a file attachment");
	_addAttachmentButton->manage();

	_deleteAttachmentButton =
	  new akButton(messagebox,"Delete",mxDelete_xpm,
		       &mxMailCompose::deleteAttachmentCB,(XtPointer)this);
	_deleteAttachmentButton->installHelp("Delete the selected\nfile attachment");
	_deleteAttachmentButton->manage();

	_cancelButton =
	  new akButton(messagebox,"Close",mxClose_xpm,
		       &mxMailCompose::quitCB,(XtPointer)this);
	_cancelButton->installHelp("Quit the Compose option");
	_cancelButton->manage();

//	Add the message specification object

	mxMailMsg	msg;
	_display =
	   new mxMailMsgDisplay(messagebox,
			"mxMailMsgDisplay",
			MX_MSG_COMPOSE,
			msg,
			_addressbook);
	_display->manage();

	return form;
}
////////////////////////////////////////////////////////////////////////////////
//
//	signatureText - returns the contents of the signature file
//
////////////////////////////////////////////////////////////////////////////////
string	mxMailCompose::signatureText()
{
	string	signature;

	signature = fileText(theMxSetup->mailSignatureName(),false);

	return signature;
}
////////////////////////////////////////////////////////////////////////////////
//
//	resetCB - reset the panel's fields
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailCompose::resetCB(Widget w,XtPointer clientData,XtPointer)
{
	mxMailCompose	*obj = (mxMailCompose *)clientData;

	obj->_display->clearMessage();

//	(Re-)append signature file to message text

	string	text;
	text = "\n--\n";
	text += obj->signatureText();
	obj->_display->setText(text);
}
////////////////////////////////////////////////////////////////////////////////
//
//	quitCB - Confirm the close of the panel
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailCompose::quitCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailCompose	*obj = (mxMailCompose *)clientData;

//	Create confirm dialog

	if (!obj->_confirmDialog)
	  obj->_confirmDialog = new akMessageDialog(obj->_w,"MessageDialog",
						    QUESTION,true,
						    "Quit without sending",
						    (XtPointer)obj,
						    &mxMailCompose::quitOK,
						    &mxMailCompose::quitCancel);
	obj->_confirmDialog->setTitle("Confirm Cancel");
	obj->_confirmDialog->manage();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Quit OK
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailCompose::quitOK(XtPointer clientData,XtPointer)
{
	mxMailCompose	*obj = (mxMailCompose *)clientData;

	obj->unmanage();
	if (obj->_userCB)
	  obj->_userCB(obj->_w,obj->_userData,(XtPointer)obj);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Quit Cancel
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailCompose::quitCancel(XtPointer,XtPointer)
{
//	Empty
}
////////////////////////////////////////////////////////////////////////////////
//
//	sendAndContinueCB - send the message
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailCompose::sendAndContinueCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailCompose	*obj = (mxMailCompose *)clientData;

//	Send the message - check on return code

	if (!obj->send())
	  cout << "mxMail ERROR : Error sending message" << endl;
}
////////////////////////////////////////////////////////////////////////////////
//
//	sendAndQuitCB - send the message and close the panel
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailCompose::sendAndQuitCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailCompose	*obj = (mxMailCompose *)clientData;

//	Send the mail message - remove panel if sent OK

	if (obj->send())
	  {
	   obj->unmanage();
	   if (obj->_userCB)
	     obj->_userCB(obj->_w,obj->_userData,(XtPointer)obj);
	  }
	else
	  cout << "mxMail ERROR : Error sending message" << endl;
}
////////////////////////////////////////////////////////////////////////////////
//
//	addAttachment Callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailCompose::addAttachmentCB(Widget,XtPointer clientData,XtPointer)
{
	mxMailCompose	*obj = (mxMailCompose *)clientData;

	if (!obj->_attachmentSpecifier)
	  obj->_attachmentSpecifier =
		new mxMailAttachmentSpecify(obj->_w,"AttachmentSpecify",
					    &mxMailCompose::attachmentSpecifiedCB,
					    (XtPointer)obj);
	obj->_attachmentSpecifier->manage();
}
////////////////////////////////////////////////////////////////////////////////
//
//	attachment specified Callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailCompose::attachmentSpecifiedCB(Widget,XtPointer clientData,XtPointer callData)
{
	mxMailCompose	*obj = (mxMailCompose *)clientData;
	mxMailAttachCallbackStruct *cbs =
		(mxMailAttachCallbackStruct *)callData;

//	Insert file into text as quoted

	if (cbs->method == 0)
	  {
	   string	text = fileText(cbs->filename,true);
	   obj->_display->insertText(text);
	  }

//	Insert file into text as-is

	else if (cbs->method == 1)
	  {
	   string	text = fileText(cbs->filename,false);
	   obj->_display->insertText(text);
	  }

//	Attach file as an attachment

	else if (cbs->method == 2)
	  {
	   mxMailFile		file;
	   mxMailAttachment	*att;
	   file.filename = cbs->filename;
	   file.contents = fileText(cbs->filename,false);
	   att = new mxMailAttachment(file);
	   att->setType(cbs->type);
	   att->setSubtype(cbs->subtype);
	   obj->_display->addAttachment(*att);
	   delete att;
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	deleteAttachment Callback
//
////////////////////////////////////////////////////////////////////////////////
void	mxMailCompose::deleteAttachmentCB(Widget w,XtPointer clientData,XtPointer)
{
	mxMailCompose	*obj = (mxMailCompose *)clientData;
	Widget	*selections;
	int	nselections;

	obj->busy();
	if (!obj->_display->deleteSelectedAttachment())
	  XBell(XtDisplay(w),50);
	obj->ready();
}
////////////////////////////////////////////////////////////////////////////////
//
//	send - send the message using 'sendmail'
//
////////////////////////////////////////////////////////////////////////////////
bool	mxMailCompose::send()
{
	string			address_to;
	string			address_cc;
	string			address_bcc;

	// Check existence of sendmail binary

	struct stat	stbuf;
	if (stat(theMxSetup->mailProcessFilename().c_str(),&stbuf) == -1)
           {
	    XBell(XtDisplay(_w),50);
	    cout << "ERROR : Specified 'sendmail' binary doesnt exist - use Setup option" << endl;
	    return false;
           }

	mxMailMsg		msg=_display->msg();

	address_to  = msg.toAddressee();
	address_cc  = msg.ccAddressee();
	address_bcc = msg.bccAddressee();

//	If no addressee - return false

	if (address_to.empty())
	  {
	   XBell(XtDisplay(_w),50);
	   return false;
	  }

//	Update message header to include aliases

	if (!(theMxSetup->organisation().empty()))
	  msg.setOrganisation(theMxSetup->organisation());
	msg.setToAddressee(parseAddressList(address_to));
	msg.setCcAddressee(parseAddressList(address_cc));
	msg.setBccAddressee(parseAddressList(address_bcc));

//	Write updated message to OUTBOX and file for sendmail

	// Set up temporary file name for 'sendmail'

	time_t	the_time;
	tm 	*t;
	char	tempfile[50];
	string	mailfile;

	time(&the_time);
	t = localtime(&the_time);
	strftime(tempfile,50,"mxSend_%d%m%y.%H%M%S",t);
	mailfile = theMxSetup->tempDirectory() + tempfile;

	if (theMxSetup->mailOutboxName().c_str())
	  msg.writeToFile((char *)theMxSetup->mailOutboxName().c_str(),true,true);
	msg.writeToFile(mailfile,false,false);

//	Use 'sendmail' to send the message, then delete the temporary file

	string	command = theMxSetup->mailProcessFilename() + " -t < " + mailfile;
	system((char *)command.c_str());
	unlink((char *)mailfile.c_str());

	return true;
}
////////////////////////////////////////////////////////////////////////////////
//
// 	fileText - return the text from a file (as a string) & optional indents
//
////////////////////////////////////////////////////////////////////////////////
string	mxMailCompose::fileText(string filename,bool indent)
{
	string	text;

//	Find the file size and allocate that much space in the string

	struct stat	stbuf;
	stat((char *)filename.c_str(),&stbuf);
	text.reserve(stbuf.st_size);

//	Open the file for reading

  	ifstream	infile((char *)filename.c_str());
	if (infile)
	  {
	   char	ch;
	   while (infile.get(ch))
	     {
	      text += ch;
	      if (ch == '\n' && indent)
		text += theMxSetup->mailIndentString();
	     }
	   infile.close();
	  }
	return text;
}
////////////////////////////////////////////////////////////////////////////////
//
//	parseAddressList - interrogate the addressbook and resolve aliases
//			   Returns an address-list (separated by comma's).
//
////////////////////////////////////////////////////////////////////////////////
string	mxMailCompose::parseAddressList(string original_list)
{
	string	new_list;
	string	next_list;
	string	address;
	string	temp_address;
	bool	updated=false;

//	Return if NULL

	if (original_list.empty())
	  return new_list;

//	Search through list and find addresses

	int	pos1,pos2;
	int	pos_start,pos_end;

	pos_start = 0;
	pos_end   = 0;

	// Search for next separator character (start at char after prev addr)

	while (pos_start <= original_list.size()-1)
	  {
	   pos1=original_list.find(' ',pos_start);
	   pos2=original_list.find(',',pos_start);
	   if (pos1 >= 0 && pos2 >= 0 && pos1 <= pos2)
	     pos_end = pos1;
	   else if (pos1 >= 0 && pos2 >= 0 && pos2 < pos1)
	     pos_end = pos2;
	   else if (pos1 >= 0)
	     pos_end = pos1;
	   else if (pos2 >= 0)
	     pos_end = pos2;
	   else
	     pos_end = original_list.size();

	   // Found separator >1 place after -> got next address
	   if (pos_end > pos_start)
	     {
	      address.assign(original_list,pos_start,pos_end-pos_start);

	      // Check address in addressbook
	      if (_addressbook)
		{
		 temp_address = _addressbook->addressForAlias(address);
		 if (!(temp_address == address))
		   updated = true;
		 address = temp_address;
		}
	      if (!new_list.empty())
	        new_list += ',';
	      new_list += address;

	      pos_start = pos_end+1;
	     }
	   // Next separator is at next space -> continue searching
	   else if (pos_end == pos_start)
	     {
	      pos_start++;
	      pos_end++;
	     }
	  }

//	Check if addressbook has updated the addresses, recurse if so

	if (updated)
	  {
	   next_list = parseAddressList(new_list);
	   if (!(next_list == new_list))
	     new_list = next_list;
	  }

	return new_list;
}
