////////////////////////////////////////////////////////////////////////////////
//
//	Class : mxMailAttachment
//
//	Author : Andy Jefferson
//
//	Description :
//		mxMailAttachment is a representation of a mail attachment.
//		An attachment can be either of a message or a file.
//		The mxMailFile represents either a file on the local system,
//		or a file stored within a message. If it represents a file
//		within a message, the contents string will be set to the
//		contents of the file.
//
//	Public Methods :
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef mxMailAttachment_h
#define mxMailAttachment_h
#ifdef __cplusplus

#include <string>
#include <Xm/Xm.h>

class mxMailMsg;

typedef enum
{
	MX_FILE,
	MX_IMAGE,
	MX_AUDIO,
	MX_VIDEO,
	MX_MESSAGE,
	MX_APPLICATION
} mxMailAttachmentType;
typedef struct
{
	string	filename;	// The filename
	string	contents;	// The file contents (if part of a message)
} mxMailFile;

class mxMailAttachment
{
	public:

		// Constructor/Destructor

		mxMailAttachment();
		mxMailAttachment(const mxMailMsg& msg);
		mxMailAttachment(const mxMailFile& file);
		~mxMailAttachment();
		mxMailAttachment(const mxMailAttachment& att);
		mxMailAttachment& operator=(const mxMailAttachment& att);

		// Access functions

		const mxMailMsg&	message() const;
		const mxMailFile&	file() const;
		mxMailAttachmentType	type() const;
		string			subtype() const;

		// Update functions

		void			setType(mxMailAttachmentType);
		void			setSubtype(string);

	private:

		mxMailAttachmentType	_type;
		string			_subtype;
		mxMailFile		*_file;
		mxMailMsg		*_msg;
};

typedef struct
{
	Widget			w;	// The iconGadget
	mxMailAttachment	att;	// The attachment
} mxMailAttachmentIcon;

inline
const mxMailMsg&	mxMailAttachment::message() const
	{return *_msg;}
inline
const mxMailFile&	mxMailAttachment::file() const
	{return *_file;}
inline
mxMailAttachmentType	mxMailAttachment::type() const
	{return _type;}
inline
string	mxMailAttachment::subtype() const
	{return _subtype;}
inline
void	mxMailAttachment::setType(mxMailAttachmentType type)
	{_type = type;}
inline
void	mxMailAttachment::setSubtype(string subtype)
	{_subtype = subtype;}

#endif
#endif
