#include <Xm/Xm.h>
#include <Xm/PushB.h>
#include <Xm/TextF.h>
#include <sys/stat.h>
#include <cstdio>
#include <string>
#include <cstdlib>
#include <cstdarg>
#include <iostream>

#include "akPromptFile.h"
#include "akFileSelectIcon.xpm"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function for the akPromptFile object.
//
////////////////////////////////////////////////////////////////////////////////
akPromptFile::akPromptFile(Widget parent,
			     char *name,
			     string variable_name,
			     akPromptFileCB callback,
			     XtPointer clientData)
	: akPrompt(parent,name,variable_name),
	  _userCB(callback),
	  _userClientData(clientData),
	  _fileDialog((akFileDialog *)0)
{
//	Detach field from right of label widget

	XtVaSetValues(_field,
		      XmNleftAttachment,XmATTACH_NONE,
		      XmNcolumns,40,
		      NULL);

//	Add file-selection button at end of field

	_selectButton =
	  new akButton(_w,"Button",akFileSelectIcon_xpm,
			&akPromptFile::fileSelectCB,(XtPointer)this);
	_selectButton->manage();
	XtVaSetValues(_selectButton->baseWidget(),
		      XmNtopAttachment,XmATTACH_FORM,
		      XmNbottomAttachment,XmATTACH_FORM,
		      NULL);

	if (_label != (Widget)0)
	  XtVaSetValues(_selectButton->baseWidget(),
			XmNleftAttachment,XmATTACH_WIDGET,
			XmNleftWidget,_label,
			XmNleftOffset,5,NULL);
	else
	  XtVaSetValues(_selectButton->baseWidget(),
			XmNleftAttachment,XmATTACH_FORM,NULL);

//	Attach the field to the button

	XtVaSetValues(_field,
		      XmNleftAttachment,XmATTACH_WIDGET,
		      XmNleftWidget,_selectButton->baseWidget(),
		      NULL);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
akPromptFile::~akPromptFile()
{
	if (_fileDialog)
	  delete _fileDialog;
	if (_selectButton)
	  delete _selectButton;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Help installation function
//
////////////////////////////////////////////////////////////////////////////////
bool	akPromptFile::installHelp(string help)
{
//	Install help for select button

	_selectButton->installHelp("Provide a file selection dialog");

//	Install help for component

	akComponent::installHelp(help);

	return true;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Help removal function
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptFile::removeHelp()
{
//	Remove help for select button

	_selectButton->removeHelp();

//	Remove help for component

	akComponent::removeHelp();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Value retrieval function
//
////////////////////////////////////////////////////////////////////////////////
string	akPromptFile::value(void)
{
	string	temp_string;

//	Retrieve field string

	char	*field_string = XmTextFieldGetString(_field);
	temp_string = field_string;
	XtFree(field_string);

	return temp_string;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Value-changed callback (called when value is changed)
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptFile::changeCB(string value)
{
	if (_userCB)
	  (*_userCB)(_userClientData,value);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set Value utility function
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptFile::setValue(string new_value)
{
	if (!new_value.empty())
	  XmTextFieldSetString(_field,(char *)new_value.c_str());
	else
	  XmTextFieldSetString(_field,"");
}
////////////////////////////////////////////////////////////////////////////////
//
//	File Selection dialog callback
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptFile::fileSelectCB(Widget,XtPointer clientData,XtPointer)
{
	akPromptFile	*obj = (akPromptFile *)clientData;
	string		value;

	if (!obj->_fileDialog)
	  {
	   obj->_fileDialog =
		new akFileDialog(obj->_w,
				  "FileDialog",
				  true,
				  (XtPointer)obj,
				  &akPromptFile::fileSelectOK,
				  &akPromptFile::fileSelectCANCEL);
	   XtVaSetValues(obj->_fileDialog->baseWidget(),
			 XmNresizePolicy,XmRESIZE_NONE,
			 XmNwidth,500,
			 XmNheight,500,
			 NULL);
	  }

//	Set default to be consistent with entered text

	obj->_fileDialog->setDefault(obj->value().c_str());
	obj->_fileDialog->manage();
}
////////////////////////////////////////////////////////////////////////////////
//
//	File Selection dialog OK callback
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptFile::fileSelectOK(XtPointer clientData,XtPointer callData)
{
	akPromptFile	*obj = (akPromptFile *)clientData;
	XmFileSelectionBoxCallbackStruct *cbs =
		(XmFileSelectionBoxCallbackStruct *)callData;
	char		*filename;

//	Extract filename and put into field

	XmStringGetLtoR(cbs->value,XmFONTLIST_DEFAULT_TAG,&filename);
	XmTextFieldSetString(obj->_field,filename);

//	Call users callback

	if (obj->_userCB)
	  (*obj->_userCB)(obj->_userClientData,filename);
	XtFree(filename);
}
////////////////////////////////////////////////////////////////////////////////
//
//	File Selection dialog CANCEL callback
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptFile::fileSelectCANCEL(XtPointer,XtPointer)
{
//	Empty
}
