#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/Frame.h>
#include <cstdio>
#include <string>
#include <cstdlib>
#include <cstdarg>

#include "akMessageLine.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function for the akMessageLine object.
//
////////////////////////////////////////////////////////////////////////////////
akMessageLine::akMessageLine(Widget parent,char *name)
	: akComponent(name)
{
	Arg	args[2];

//	Create a frame for the line

	_w = XmCreateFrame(parent,_name,NULL,0);

//	Create label widget

	XtSetArg(args[0],XmNalignment,XmALIGNMENT_BEGINNING);
	XmString tempstr = XmStringCreateLocalized("");
	XtSetArg(args[1],XmNlabelString,tempstr);
	_label = XmCreateLabel(_w,"Label",args,2);
	XmStringFree(tempstr);
	XtManageChild(_label);

	installDestroyHandler();

}
////////////////////////////////////////////////////////////////////////////////
//
//	Write Message function.
//
////////////////////////////////////////////////////////////////////////////////
void 	akMessageLine::write(akMessageType type,const char *format, ...)
{
	char		message_text[2024];
	char		*new_string;
	XmString	label_string;
	va_list		args;

//	If widget is NULL then return immediately

	if (!_w) return;

//	Start parse of input

	va_start(args,format);

//	Extract string to add

	vsprintf(message_text,format,args);

//	Construct string to update message label with

	switch (type)
	  {
	   case AK_ERROR:
	     {
	      new_string = new char[strlen(message_text)+10];
	      sprintf(new_string,"ERROR >> %s",message_text);
	      XBell(XtDisplay(_w),30);
	      break;
	     }
	   case AK_WARNING:
	     {
	      new_string = new char[strlen(message_text)+12];
	      sprintf(new_string,"WARNING >> %s",message_text);
	      break;
	     }
	   default:
	   case AK_INFO:
	     {
	      new_string = new char[strlen(message_text)+1];
	      strcpy(new_string,message_text);
	      break;
	     }
	   case AK_CONTINUE:
	     {
	      char *current;

	      XtVaGetValues(_w,XmNlabelString,&label_string,NULL);
	      XmStringGetLtoR(label_string,XmFONTLIST_DEFAULT_TAG,&current);
	      XmStringFree(label_string);
	      new_string = new char[strlen(message_text)+strlen(current)+1];
	      sprintf(new_string,"%s%s",current,message_text);
	      XtFree(current);
	      break;
	     }
	  }
	label_string = XmStringCreateLocalized(new_string);
	XtVaSetValues(_label,XmNlabelString,label_string,NULL);
	XmStringFree(label_string);
	delete new_string;

	XFlush(XtDisplay(_w));
	XmUpdateDisplay(_w);

//	Clean up variable args

	va_end(args);
}
