#include <cstdio>
#include <ctype.h>
#include <iostream>
#include <fstream>
#include <cstdlib>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include "mxSetup.h"

mxSetup	*theMxSetup = 0;
////////////////////////////////////////////////////////////////////////////////
//
//	Default Constructor
//
////////////////////////////////////////////////////////////////////////////////
mxSetup::mxSetup()
	:_filename(""),

	 _organisation(""),
	 _tempDirectory("/tmp/"),
	 _helpDirectory("/usr/local/lib/mxapps/doc/"),
	 _audioDirectory("/usr/local/lib/mxapps/sounds/"),
	 _mailServer("post.demon.co.uk"),
	 _newsServer("news.demon.co.uk"),
	 _timeServer("ntp.demon.co.uk"),
	 _introSound(true),
	 _checkMailSound(true),
	 _newMailSound(true),
	 _ftpTransferSound(true),

	 _ftpShowPermissions(true),
	 _ftpShowNumberLinks(false),
	 _ftpShowOwner(false),
	 _ftpShowGroup(false),
	 _ftpShowSize(true),
	 _ftpShowDate(true),
	 _ftpDefaultLocalDir(""),
	 _ftpDefaultRemoteDir("/pub"),
	 _ftpProcessFilename("/usr/bin/ftp"),

	 _mailIndentString(">"),
	 _mailProcessFilename("/usr/sbin/sendmail"),
	 _mailUpdateInterval(60),
	 _mailMimeFormat(true),

	 _newsBaseDirectory("/var/spool/news/"),

	 _modemSpeed(57600),
	 _modemPort(4),
	 _modemInit("AT&F1"),
	 _modemIdle(300),
	 _modemNoRetries(5),
	 _supplierName("Demon"),
	 _supplierLocation("COLT ROMP"),
	 _supplierPhoneNo("0845-3535666"),
	 _supplierPassword(""),
	 _wwwCommand("/usr/local/bin/netscape"),
	 _newsCommand("xterm -e /usr/bin/tin")
{
	string	home;

	if (getenv("HOME"))
	  home = getenv("HOME");
	else
	  home = ".";
	if (getenv("HOST"))
	  _supplierLogin = getenv("HOST");

	passwd	*password = getpwuid(getuid());
	if (getenv("HOSTNAME"))
	   {
	    _mailSenderName = password->pw_name;
	    _mailSenderName += "@";
	    _mailSenderName += getenv("HOSTNAME");
	   }
	else
	  _mailSenderName = password->pw_name;

	_mailInboxName = "/usr/spool/mail/";
	_mailInboxName += password->pw_name;

	_mailOutboxName      = home + "/mail/sent-mail";
	_mailAddressbookName = home + "/.addressbook";
	_mailSpambookName    = home + "/.mxMail_SpamBook";
	_mailSignatureName   = home + "/.signature";
	_mailFolderDirectory = home + "/mail/";
	_mailInboxReadFolder = home + "/mail/read-messages";

//	Use .mxsetup in users home directory for setup file

	_filename = home + "/.mxsetup";
	read();
	write();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor
//
////////////////////////////////////////////////////////////////////////////////
mxSetup::mxSetup(string the_filename)
	:_filename(the_filename),

	 _organisation(""),
	 _tempDirectory("/tmp"),
	 _helpDirectory("/usr/local/lib/mxapps/doc/"),
	 _audioDirectory("/usr/local/lib/mxapps/sounds/"),
	 _mailServer("post.demon.co.uk"),
	 _newsServer("news.demon.co.uk"),
	 _timeServer("ntp.demon.co.uk"),
	 _introSound(true),
	 _checkMailSound(true),
	 _newMailSound(true),
	 _ftpTransferSound(true),

	 _ftpShowPermissions(true),
	 _ftpShowNumberLinks(false),
	 _ftpShowOwner(false),
	 _ftpShowGroup(false),
	 _ftpShowSize(true),
	 _ftpShowDate(true),
	 _ftpDefaultLocalDir(""),
	 _ftpDefaultRemoteDir("/pub"),
	 _ftpProcessFilename("/usr/bin/ftp"),

	 _mailIndentString(">"),
	 _mailProcessFilename("/usr/sbin/sendmail"),
	 _mailUpdateInterval(60),
	 _mailMimeFormat(true),

	 _newsBaseDirectory("/var/spool/news/"),

	 _modemSpeed(57600),
	 _modemPort(4),
	 _modemInit("AT&F1"),
	 _modemIdle(300),
	 _modemNoRetries(5),
	 _supplierName("Demon"),
	 _supplierLocation("COLT ROMP"),
	 _supplierPhoneNo("0845-3535666"),
	 _supplierPassword(""),
	 _wwwCommand("/usr/local/bin/netscape"),
	 _newsCommand("xterm -e /usr/bin/tin")
{
	string	home;

	if (getenv("HOME"))
	  home = getenv("HOME");
	else
	  home = ".";
	if (getenv("HOST"))
	  _supplierLogin = getenv("HOST");

	passwd	*password = getpwuid(getuid());
	if (getenv("HOSTNAME"))
	   {
	    _mailSenderName = password->pw_name;
	    _mailSenderName += "@";
	    _mailSenderName += getenv("HOSTNAME");
	   }
	else
	  _mailSenderName = password->pw_name;

	_mailInboxName       = "/usr/spool/mail/";
	_mailInboxName += password->pw_name;

	_mailOutboxName      = home + "/mail/sent-mail";
	_mailAddressbookName = home + "/.addressbook";
	_mailSpambookName    = home + "/.mxMail_SpamBook";
	_mailSignatureName   = home + "/.signature";
	_mailFolderDirectory = home + "/mail/";
	_mailInboxReadFolder = home + "/mail/read-messages";

	read();
	write();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Copy constructor
//
////////////////////////////////////////////////////////////////////////////////
mxSetup::mxSetup(const mxSetup& setup)
{
	_filename            = setup._filename;

	_organisation        = setup._organisation;
	_tempDirectory       = setup._tempDirectory;
	_helpDirectory       = setup._helpDirectory;
	_audioDirectory      = setup._audioDirectory;
	_mailServer          = setup._mailServer;
	_newsServer          = setup._newsServer;
	_timeServer          = setup._timeServer;
	_introSound          = setup._introSound;
	_checkMailSound      = setup._checkMailSound;
	_newMailSound        = setup._newMailSound;
	_ftpTransferSound    = setup._ftpTransferSound;

	_ftpShowPermissions  = setup._ftpShowPermissions;
	_ftpShowNumberLinks  = setup._ftpShowNumberLinks;
	_ftpShowOwner        = setup._ftpShowOwner;
	_ftpShowGroup        = setup._ftpShowGroup;
	_ftpShowSize         = setup._ftpShowSize;
	_ftpShowDate         = setup._ftpShowDate;
	_ftpDefaultLocalDir  = setup._ftpDefaultLocalDir;
	_ftpDefaultRemoteDir = setup._ftpDefaultRemoteDir;
	_ftpProcessFilename  = setup._ftpProcessFilename;
	_ftpSites            = setup._ftpSites;

	_mailSenderName      = setup._mailSenderName;
	_mailInboxName       = setup._mailInboxName;
	_mailOutboxName      = setup._mailOutboxName;
	_mailAddressbookName = setup._mailAddressbookName;
	_mailSpambookName    = setup._mailSpambookName;
	_mailSignatureName   = setup._mailSignatureName;
	_mailFolderDirectory = setup._mailFolderDirectory;
	_mailInboxReadFolder = setup._mailInboxReadFolder;
	_mailIndentString    = setup._mailIndentString;
	_mailProcessFilename = setup._mailProcessFilename;
	_mailUpdateInterval  = setup._mailUpdateInterval;
	_mailStartupFolders  = setup._mailStartupFolders;
	_mailMimeFormat      = setup._mailMimeFormat;

	_newsBaseDirectory   = setup._newsBaseDirectory;

	_modemSpeed          = setup._modemSpeed;
	_modemPort           = setup._modemPort;
	_modemInit           = setup._modemInit;
	_modemIdle           = setup._modemIdle;
	_modemNoRetries      = setup._modemNoRetries;
	_supplierName        = setup._supplierName;
	_supplierLocation    = setup._supplierLocation;
	_supplierPhoneNo     = setup._supplierPhoneNo;
	_supplierLogin       = setup._supplierLogin;
	_supplierPassword    = setup._supplierPassword;
	_wwwCommand          = setup._wwwCommand;
	_newsCommand         = setup._newsCommand;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Destructor
//
////////////////////////////////////////////////////////////////////////////////
mxSetup::~mxSetup()
{
	write();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Assignment operator
//
////////////////////////////////////////////////////////////////////////////////
mxSetup&	mxSetup::operator=(const mxSetup& setup)
{
	if (this != &setup)
	   {
	    _filename            = setup._filename;

	    _organisation        = setup._organisation;
	    _tempDirectory       = setup._tempDirectory;
	    _helpDirectory       = setup._helpDirectory;
	    _audioDirectory      = setup._audioDirectory;
	    _mailServer          = setup._mailServer;
	    _newsServer          = setup._newsServer;
	    _timeServer          = setup._timeServer;
	    _introSound          = setup._introSound;
	    _checkMailSound      = setup._checkMailSound;
	    _newMailSound        = setup._newMailSound;

	    _ftpTransferSound    = setup._ftpTransferSound;
	    _ftpShowPermissions  = setup._ftpShowPermissions;
	    _ftpShowNumberLinks  = setup._ftpShowNumberLinks;
	    _ftpShowOwner        = setup._ftpShowOwner;
	    _ftpShowGroup        = setup._ftpShowGroup;
	    _ftpShowSize         = setup._ftpShowSize;
	    _ftpShowDate         = setup._ftpShowDate;
	    _ftpDefaultLocalDir  = setup._ftpDefaultLocalDir;
	    _ftpDefaultRemoteDir = setup._ftpDefaultRemoteDir;
	    _ftpProcessFilename  = setup._ftpProcessFilename;
	    _ftpSites            = setup._ftpSites;

	    _mailSenderName      = setup._mailSenderName;
	    _mailInboxName       = setup._mailInboxName;
	    _mailOutboxName      = setup._mailOutboxName;
	    _mailAddressbookName = setup._mailAddressbookName;
	    _mailSpambookName    = setup._mailSpambookName;
	    _mailSignatureName   = setup._mailSignatureName;
	    _mailFolderDirectory = setup._mailFolderDirectory;
	    _mailInboxReadFolder = setup._mailInboxReadFolder;
	    _mailIndentString    = setup._mailIndentString;
	    _mailProcessFilename = setup._mailProcessFilename;
	    _mailUpdateInterval  = setup._mailUpdateInterval;
	    _mailStartupFolders  = setup._mailStartupFolders;
	    _mailMimeFormat      = setup._mailMimeFormat;

	    _newsBaseDirectory   = setup._newsBaseDirectory;

	    _modemSpeed          = setup._modemSpeed;
	    _modemPort           = setup._modemPort;
	    _modemInit           = setup._modemInit;
	    _modemIdle           = setup._modemIdle;
	    _modemNoRetries      = setup._modemNoRetries;
	    _supplierName        = setup._supplierName;
	    _supplierLocation    = setup._supplierLocation;
	    _supplierPhoneNo     = setup._supplierPhoneNo;
	    _supplierLogin       = setup._supplierLogin;
	    _supplierPassword    = setup._supplierPassword;
	    _wwwCommand          = setup._wwwCommand;
	    _newsCommand         = setup._newsCommand;
	   }
	return *this;
}
////////////////////////////////////////////////////////////////////////////////
//
//	write - Write setup back to file
//
////////////////////////////////////////////////////////////////////////////////
void 	mxSetup::write()
{
//	Write the setup file

	ofstream	outfile(_filename.c_str());
	if (outfile)
	   {
	    // General parameters
	    outfile << "ORGANISATION:" << _organisation << endl;
	    outfile << "TEMP_DIRECTORY:" << _tempDirectory << endl;
	    outfile << "HELP_DIRECTORY:" << _helpDirectory << endl;
	    outfile << "AUDIO_DIRECTORY:" << _audioDirectory << endl;
	    outfile << "MAIL_SERVER:" << _mailServer << endl;
	    outfile << "NEWS_SERVER:" << _newsServer << endl;
	    outfile << "TIME_SERVER:" << _timeServer << endl;
	    if (_introSound)
	      outfile << "INTRO_SOUND:TRUE" << endl;
	    else
	      outfile << "INTRO_SOUND:FALSE" << endl;
	    if (_checkMailSound)
	      outfile << "CHECK_MAIL_SOUND:TRUE" << endl;
	    else
	      outfile << "CHECK_MAIL_SOUND:FALSE" << endl;
	    if (_newMailSound)
	      outfile << "NEW_MAIL_SOUND:TRUE" << endl;
	    else
	      outfile << "NEW_MAIL_SOUND:FALSE" << endl;
	    if (_ftpTransferSound)
	      outfile << "FTP_TRANSFER_SOUND:TRUE" << endl;
	    else
	      outfile << "FTP_TRANSFER_SOUND:FALSE" << endl;

	    // FTP parameters
	    if (_ftpShowPermissions)
	      outfile << "FTP_SHOW_PERMISSIONS:TRUE" << endl;
	    else
	      outfile << "FTP_SHOW_PERMISSIONS:FALSE" << endl;
	    if (_ftpShowNumberLinks)
	      outfile << "FTP_SHOW_NUMBERLINKS:TRUE" << endl;
	    else
	      outfile << "FTP_SHOW_NUMBERLINKS:FALSE" << endl;
	    if (_ftpShowOwner)
	      outfile << "FTP_SHOW_OWNER:TRUE" << endl;
	    else
	      outfile << "FTP_SHOW_OWNER:FALSE" << endl;
	    if (_ftpShowGroup)
	      outfile << "FTP_SHOW_GROUP:TRUE" << endl;
	    else
	      outfile << "FTP_SHOW_GROUP:FALSE" << endl;
	    if (_ftpShowSize)
	      outfile << "FTP_SHOW_SIZE:TRUE" << endl;
	    else
	      outfile << "FTP_SHOW_SIZE:FALSE" << endl;
	    if (_ftpShowDate)
	      outfile << "FTP_SHOW_DATE:TRUE" << endl;
	    else
	      outfile << "FTP_SHOW_DATE:FALSE" << endl;
	    outfile << "FTP_DEFAULT_LOCAL_DIR:" << _ftpDefaultLocalDir << endl;
	    outfile << "FTP_DEFAULT_REMOTE_DIR:" << _ftpDefaultRemoteDir << endl;
	    outfile << "FTP_PROCESS_FILENAME:" << _ftpProcessFilename << endl;
	    for (int i=0;i<_ftpSites.size();i++)
	       {
		outfile << "FTP_SITES:" << _ftpSites[i] << endl;
	       }

	    // Mail parameters
	    outfile << "MAIL_SENDER_NAME:" << _mailSenderName << endl;
	    outfile << "MAIL_INBOX_NAME:" << _mailInboxName << endl;
	    outfile << "MAIL_OUTBOX_NAME:" << _mailOutboxName << endl;
	    outfile << "MAIL_ADDRESSBOOK_NAME:" << _mailAddressbookName << endl;
	    outfile << "MAIL_SPAMBOOK_NAME:" << _mailSpambookName << endl;
	    outfile << "MAIL_SIGNATURE_NAME:" << _mailSignatureName << endl;
	    outfile << "MAIL_FOLDER_DIRECTORY:" << _mailFolderDirectory << endl;
	    outfile << "MAIL_INBOX_READ_FOLDER:" << _mailInboxReadFolder << endl;
	    outfile << "MAIL_INDENT_STRING:" << _mailIndentString << endl;
	    outfile << "MAIL_PROCESS_FILENAME:" << _mailProcessFilename << endl;
	    outfile << "MAIL_UPDATE_INTERVAL:" << _mailUpdateInterval << endl;
	    if (!_mailStartupFolders.empty())
	       {
		outfile << "MAIL_STARTUP_FOLDERS:";
		for (int i=0;i<_mailStartupFolders.size();i++)
		  outfile << " " << _mailStartupFolders[i];
		outfile << endl;
	       }
	    if (_mailMimeFormat)
	      outfile << "MAIL_MIME_FORMAT:TRUE" << endl;
	    else
	      outfile << "MAIL_MIME_FORMAT:FALSE" << endl;

	    // News parameters
	    outfile << "NEWS_BASE_DIRECTORY:" << _newsBaseDirectory << endl;

	    // Net parameters
	    outfile << "MODEM_SPEED:" << _modemSpeed << endl;
	    outfile << "MODEM_PORT:" << _modemPort << endl;
	    outfile << "MODEM_INIT:" << _modemInit << endl;
	    outfile << "MODEM_IDLE:" << _modemIdle << endl;
	    outfile << "MODEM_NO_RETRIES:" << _modemNoRetries << endl;
	    outfile << "SUPPLIER_NAME:" << _supplierName << endl;
	    outfile << "SUPPLIER_LOCATION:" << _supplierLocation << endl;
	    outfile << "SUPPLIER_PHONE_NO:" << _supplierPhoneNo << endl;
	    outfile << "SUPPLIER_LOGIN:" << _supplierLogin << endl;
	    outfile << "SUPPLIER_PASSWORD:" << _supplierPassword << endl;
	    outfile << "WWW_COMMAND:" << _wwwCommand << endl;
	    outfile << "NEWS_COMMAND:" << _newsCommand << endl;

	    outfile.close();
	   }
}
////////////////////////////////////////////////////////////////////////////////
//
//	read - Read setup from file
//
////////////////////////////////////////////////////////////////////////////////
void	mxSetup::read()
{
	char		line[BUFSIZ];
	string		tag,info;
	string		theline;

//	Erase all current ftp sites

	_ftpSites.erase(_ftpSites.begin(),_ftpSites.end());

//	Open the setup file for reading

	ifstream	infile((char *)_filename.c_str());
	if (infile)
	   {
	    while (infile.getline(line,BUFSIZ,'\n') != NULL)
	       {
		theline = line;
		int	pos = theline.find(':');
		if (pos > 0)
		   {
		    tag.assign(theline,0,pos);
		    info.assign(theline,pos+1,theline.size()-pos);

		    // General parameters
		    if (tag == "ORGANISATION")
		      _organisation = info;
		    if (tag == "TEMP_DIRECTORY")
		      _tempDirectory = info;
		    if (tag == "HELP_DIRECTORY")
		      _helpDirectory = info;
		    if (tag == "AUDIO_DIRECTORY")
		      _audioDirectory = info;
		    if (tag == "MAIL_SERVER")
		      _mailServer = info;
		    if (tag == "NEWS_SERVER")
		      _newsServer = info;
		    if (tag == "TIME_SERVER")
		      _timeServer = info;
		    if (tag == "INTRO_SOUND")
		       {
			if (info == "TRUE")
			  _introSound = true;
			else
			  _introSound = false;
		       }
		    if (tag == "CHECK_MAIL_SOUND")
		       {
			if (info == "TRUE")
			  _checkMailSound = true;
			else
			  _checkMailSound = false;
		       }
		    if (tag == "NEW_MAIL_SOUND")
		       {
			if (info == "TRUE")
			  _newMailSound = true;
			else
			  _newMailSound = false;
		       }
		    if (tag == "FTP_TRANSFER_SOUND")
		       {
			if (info == "TRUE")
			  _ftpTransferSound = true;
			else
			  _ftpTransferSound = false;
		       }

		    // FTP parameters
		    if (tag == "FTP_SHOW_PERMISSIONS")
		       {
			if (info == "TRUE")
			  _ftpShowPermissions = true;
			else
			  _ftpShowPermissions = false;
		       }
		    if (tag == "FTP_SHOW_NUMBERLINKS")
		       {
			if (info == "TRUE")
			  _ftpShowNumberLinks = true;
			else
			  _ftpShowNumberLinks = false;
		       }
		    if (tag == "FTP_SHOW_OWNER")
		       {
			if (info == "TRUE")
			  _ftpShowOwner = true;
			else
			  _ftpShowOwner = false;
		       }
		    if (tag == "FTP_SHOW_GROUP")
		       {
			if (info == "TRUE")
			  _ftpShowGroup = true;
			else
			  _ftpShowGroup = false;
		       }
		    if (tag == "FTP_SHOW_SIZE")
		       {
			if (info == "TRUE")
			  _ftpShowSize = true;
			else
			  _ftpShowSize = false;
		       }
		    if (tag == "FTP_SHOW_DATE")
		       {
			if (info == "TRUE")
			  _ftpShowDate = true;
			else
			  _ftpShowDate = false;
		       }
		    if (tag == "FTP_DEFAULT_LOCAL_DIR")
		      _ftpDefaultLocalDir = info;
		    if (tag == "FTP_DEFAULT_REMOTE_DIR")
		      _ftpDefaultRemoteDir = info;
		    if (tag == "FTP_PROCESS_FILENAME")
		      _ftpProcessFilename = info;
		    if (tag == "FTP_SITES")
		      _ftpSites.push_back(info);

		    // Mail parameters
		    if (tag == "MAIL_SENDER_NAME")
		      _mailSenderName = info;
		    if (tag == "MAIL_INBOX_NAME")
		      _mailInboxName = info;
		    if (tag == "MAIL_OUTBOX_NAME")
		      _mailOutboxName = info;
		    if (tag == "MAIL_ADDRESSBOOK_NAME")
		      _mailAddressbookName = info;
		    if (tag == "MAIL_SPAMBOOK_NAME")
		      _mailSpambookName = info;
		    if (tag == "MAIL_SIGNATURE_NAME")
		      _mailSignatureName = info;
		    if (tag == "MAIL_FOLDER_DIRECTORY")
		      _mailFolderDirectory = info;
		    if (tag == "MAIL_INBOX_READ_FOLDER")
		      _mailInboxReadFolder = info;
		    if (tag == "MAIL_INDENT_STRING")
		      _mailIndentString = info;
		    if (tag == "MAIL_PROCESS_FILENAME")
		      _mailProcessFilename = info;
		    if (tag == "MAIL_UPDATE_INTERVAL")
		      _mailUpdateInterval = atoi((char *)info.c_str());
		    if (tag == "MAIL_STARTUP_FOLDERS")
		       {
			int	pos1,pos2;
			string	folder;

			_mailStartupFolders.erase(_mailStartupFolders.begin(),
						  _mailStartupFolders.end());
			pos1 = 0;
			while (pos1 <= info.size())
			   {
			    pos2 = info.find(" ",pos1);
			    if (pos2 < 0)
			      pos2 = info.size();
			    if (pos2 > pos1)
			       {
				folder.assign(info,pos1,pos2-pos1);
				_mailStartupFolders.push_back(folder);
				pos1 = pos2+1;
			       }
			    if (pos2 == pos1)
			      pos1++;
			   }
		       }
		    if (tag == "MAIL_MIME_FORMAT")
		       {
			if (info == "TRUE")
			  _mailMimeFormat = true;
			else
			  _mailMimeFormat = false;
		       }

		    // News parameters
		    if (tag == "NEWS_BASE_DIRECTORY")
		      _newsBaseDirectory = info;

		    // Net parameters
		    if (tag == "MODEM_SPEED")
		      _modemSpeed = atoi(info.c_str());
		    if (tag == "MODEM_PORT")
		      _modemPort = atoi(info.c_str());
		    if (tag == "MODEM_INIT")
		      _modemInit = info;
		    if (tag == "MODEM_IDLE")
		      _modemIdle = atoi(info.c_str());
		    if (tag == "MODEM_NO_RETRIES")
		      _modemNoRetries = atoi(info.c_str());
		    if (tag == "SUPPLIER_NAME")
		      _supplierName = info;
		    if (tag == "SUPPLIER_LOCATION")
		      _supplierLocation = info;
		    if (tag == "SUPPLIER_PHONE_NO")
		      _supplierPhoneNo = info;
		    if (tag == "SUPPLIER_LOGIN")
		      _supplierLogin = info;
		    if (tag == "SUPPLIER_PASSWORD")
		      _supplierPassword = info;
		    if (tag == "WWW_COMMAND")
		      _wwwCommand = info;
		    if (tag == "NEWS_COMMAND")
		      _newsCommand = info;
		   }
	      }
	   infile.close();
	  }
}
