////////////////////////////////////////////////////////////////////////////////
//
//	Class : mxMailSpamBook
//
//	Author : Andy Jefferson
//
//	Description :
//		mxMailSpamBook is a repository for known spammers id's.
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef mxMailSpamBook_h
#define mxMailSpamBook_h
#ifdef __cplusplus

#include <vector>
#include <algorithm>
#include <string>

class mxMailSpamBook
{
	public:

//		Constructor, Destructor, assignment operator etc

		mxMailSpamBook();
		mxMailSpamBook(string the_filename);
		~mxMailSpamBook();
		mxMailSpamBook& operator=(const mxMailSpamBook&);

//		Access functions

		const string&	filename() const;
		int		noOfSpammers() const;
		const string&	spammer(int no) const;

//		Update functions

		void		read();
		void		write();

		void		add(const string& spammer);
		void		remove(const string& spammer);

		friend ostream&	operator<< (ostream& s,mxMailSpamBook& book);

	private:

		// Data members

		string		_filename;
		vector<string>	_spammers;
};

inline
const string&	mxMailSpamBook::filename() const
	{return _filename;}
inline
int		mxMailSpamBook::noOfSpammers() const
	{return _spammers.size();}
inline
const string&	mxMailSpamBook::spammer(int no) const
{
	if (no < 0 || no >= _spammers.size())
	  return _spammers[0];
	else
	  return _spammers[no];
}
inline
void	mxMailSpamBook::remove(const string& spammer)
{
	for (int i=0;i<_spammers.size();i++)
	   {
	    if (spammer == _spammers[i])
	      _spammers.erase(_spammers.begin()+i);
	   }
}
inline
void	mxMailSpamBook::add(const string& spammer)
{
	if (spammer.size() <= 0)
	  return;

	bool	already_exists=false;
	for (int i=0;i<_spammers.size();i++)
	   {
	    if (spammer == _spammers[i])
	       {
		already_exists = true;
		break;
	       }
	   }
	if (!already_exists)
	  _spammers.push_back(spammer);
}

#endif
#endif
