////////////////////////////////////////////////////////////////////////////////
//
//	Class : mxMailAddressSelect
//
//	Author : Andy Jefferson
//
//	Description :
//		mxMailAddressSelect provides a selection mechanism from an
//		addressbook. It allows selection of To, Cc, and Bcc addressees.
//		It requires a pointer to an mxMailAddressBook at construction
//		and displays the addresses from that addressbook in a panel.
//
//	Public Methods :
//		(Constructor) requires :
//			parent		Widget used as paretn of the panel.
//			name		Name used for resource specifications.
//			book		Pointer to mxMailAddressBook object.
//			callback	Callback called when panel is closed.
//			clientData	Client Data passed to the callback.
//
//		update()	Removes all addresses from the list and
//				re-adds them.
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef mxMailAddressSelect_h
#define mxMailAddressSelect_h
#ifdef __cplusplus

#include <string>
#include "akDialog.h"
#include "akButton.h"
#include "akList.h"
#include "mxMailAddressBook.h"

typedef enum
{
	MX_MAIL_ADDRESS_TO,
	MX_MAIL_ADDRESS_CC,
	MX_MAIL_ADDRESS_BCC
} mxMailAddressDestination;
typedef struct
{
	mxMailAddress			address;
	mxMailAddressDestination	destination;
} mxMailAddressSelection;
typedef void (*mxMailAddressSelectCB) (XtPointer,mxMailAddressSelection);

class mxMailAddressSelect : public akDialog
{
	public:

		// Constructor and destructor

		mxMailAddressSelect(Widget parent,
				  char *name,
				  mxMailAddressBook *book,
				  mxMailAddressSelectCB callback=0,
				  XtPointer clientData=0);
		~mxMailAddressSelect();

		// Update

		const	mxMailAddressBook&	book();
		void				setBook(mxMailAddressBook *book);
		void				update();

	private:

		mxMailAddressBook	*_addressbook;

		// Panel functions/components

		Widget			createWorkArea(Widget parent);
		akList			*_addressList;
		akButton		*_closeButton;
		akButton		*_toButton;
		akButton		*_ccButton;
		akButton		*_bccButton;

		mxMailAddressSelectCB	_userCB;
		XtPointer		_userData;

		// Option callbacks

		static void	closeCB(Widget,XtPointer,XtPointer);
		static void	toCB(Widget,XtPointer,XtPointer);
		static void	ccCB(Widget,XtPointer,XtPointer);
		static void	bccCB(Widget,XtPointer,XtPointer);
};


inline
const mxMailAddressBook&	mxMailAddressSelect::book()
	{return *_addressbook;}

#endif
#endif
