#include <Xm/Xm.h>
#include <Xm/ArrowB.h>
#include <Xm/TextF.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <iostream.h>

#include "akPromptInt.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function for the akPromptInt object.
//
////////////////////////////////////////////////////////////////////////////////
akPromptInt::akPromptInt(Widget parent,
			   char *name,
			   string variable_name,
			   akPromptIntCB callback,
			   XtPointer clientData)
	: akPrompt(parent,name,variable_name)
{
	Widget		arrow_up,arrow_down;
	Dimension	height;

//	Save user callback stuff

	userCB = callback;
	userClientData = clientData;

//	Limit the user to entering 9 characters (to approximately match
//	the max hardware value of an integer

	XtVaSetValues(_field,XmNmaxLength,9,NULL);

//	Add arrow buttons at end of field

	XtVaGetValues(_field,XmNheight,&height,NULL);
	arrow_up =
		XtVaCreateManagedWidget("ArrowUp",
					xmArrowButtonWidgetClass,
					_w,
					XmNheight,height/2,
					XmNwidth,height/2,
					XmNtopAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_POSITION,
					XmNbottomPosition,50,
					XmNarrowDirection,XmARROW_UP,
					XmNhighlightThickness,0,
					NULL);
	arrow_down =
		XtVaCreateManagedWidget("ArrowDown",
					xmArrowButtonWidgetClass,
					_w,
					XmNheight,height/2,
					XmNwidth,height/2,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNtopAttachment,XmATTACH_POSITION,
					XmNtopPosition,50,
					XmNarrowDirection,XmARROW_DOWN,
					XmNhighlightThickness,0,
					NULL);
	XtAddCallback(arrow_up,
		      XmNactivateCallback,
		      &akPromptInt::increaseCB,
		      (XtPointer)this);
	XtAddCallback(arrow_down,
		      XmNactivateCallback,
		      &akPromptInt::decreaseCB,
		      (XtPointer)this);

//	If a label prompt exists, change priority order so that the
//	label varies in size, and field is fixed size.

	if (_label != (Widget)0)
	  {
	   XtVaSetValues(_field,XmNleftAttachment,XmATTACH_NONE,NULL);
	   XtVaSetValues(arrow_up,
			 XmNrightAttachment,XmATTACH_WIDGET,
			 XmNrightWidget,_field,NULL);
	   XtVaSetValues(arrow_down,
			 XmNrightAttachment,XmATTACH_WIDGET,
			 XmNrightWidget,_field,NULL);
	   XtVaSetValues(_label,
			 XmNrightAttachment,XmATTACH_WIDGET,
			 XmNrightWidget,arrow_up,
			 NULL);
	  }

//	Set the initial value to be 0

	XmTextFieldSetString(_field,"0");
}
////////////////////////////////////////////////////////////////////////////////
//
//	Up Arrow callback function
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptInt::increaseCB(Widget,XtPointer clientData,XtPointer)
{
	akPromptInt *obj = (akPromptInt *)clientData;

	obj->increaseValue();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Increase value function
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptInt::increaseValue(void)
{
	int	the_value;

	the_value = value();
	the_value++;
	setValue(the_value);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Down Arrow callback function
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptInt::decreaseCB(Widget,XtPointer clientData,XtPointer)
{
	akPromptInt *obj = (akPromptInt *)clientData;

	obj->decreaseValue();
}
////////////////////////////////////////////////////////////////////////////////
//
//	Decrease value function
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptInt::decreaseValue(void)
{
	int	the_value;

	the_value = value();
	the_value--;
	setValue(the_value);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Value retrieval function
//
////////////////////////////////////////////////////////////////////////////////
int	akPromptInt::value(void)
{
	int	int_value;

//	Retrieve field string

	char	*field_string = XmTextFieldGetString(_field);
	int_value = atoi(field_string);
	XtFree(field_string);

	return int_value;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Value-changed callback (called when value is changed)
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptInt::changeCB(string value)
{
	int	int_value;

	if (userCB != (akPromptIntCB)0)
	  {
	   int_value = atoi(value.c_str());
	   (*userCB)(userClientData,int_value);
	  }
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set Value utility function
//
////////////////////////////////////////////////////////////////////////////////
void	akPromptInt::setValue(int new_value)
{
	char	new_string[100];

//	LIMITATION NOTE - new_string is size 100.

	sprintf(new_string,"%d",new_value);
	XmTextFieldSetString(_field,new_string);
}
