////////////////////////////////////////////////////////////////////////////////
//
//	Class :	mxMailBoxControl
//
//	Author : Andy Jefferson
//
//	Description :
//		mxMailBoxControl is effectively a representation of a mailbox.
//		It represents not just the actual data (mxMailBox), but a view
//		of the data (mxMailBoxDisplay), and a monitoring facility
//		checking for mail box update. It is represented by an icon
//		(XmIconGadget) - for addition to an XmContainer widget.
//
//	Limitations :
//		Based around Motif 2.0 (XmNotebook,XmIconGadget) and so cannot
//		be built with earlier version of Motif.
//
////////////////////////////////////////////////////////////////////////////////
#ifndef mxMailBoxControl_h
#define mxMailBoxControl_h
#ifdef __cplusplus

#include "akComponent.h"
#include "akPixmap.h"
#include "mxMailBox.h"
#include "mxMailBoxDisplay.h"
#include "mxMailSpamBook.h"
#include "mxMailAddressBook.h"

typedef void (*mxMailBoxControlCB) (XtPointer,XtPointer,bool);

class mxMailBoxControl : public akComponent
{
	public:

		// Constructor and destructor

		mxMailBoxControl(Widget parent,
				 char *name,
				 string box_filename,
				 mxMailBoxType box_type,
				 mxMailAddressBook *book=0,
				 mxMailSpamBook *spam=0,
				 mxMailBoxControlCB callback=0,
				 XtPointer clientData=0);
		~mxMailBoxControl();

		// Update facility

		void		update();
		void		select();
		int		noOfMsgs() const;
		int		noOfMsgsRead() const;
		mxMailBoxType	type() const;
		const string&	filename() const;

	private:

		// The mailbox data and its display component

		akPixmap		*_iconPixmap;
		mxMailBox		*_mailbox;
		mxMailBoxDisplay	*_display;
		mxMailSpamBook		*_spambook;
		mxMailAddressBook	*_addressbook;
		XtIntervalId		_id;

		// Mailbox monitor function

		static void	monitor(XtPointer,XtIntervalId);
		int		_prevNoOfMessages;
		int		_prevNoOfMessagesRead;

		// Utility functions

		void		updateBoxSummaryLine(int nmessages,int nunread);
		void		readAndRemoveSPAM();
		void		checkForNewMail(bool update_if_no_changes);

		static void	displayClosedCB(Widget,XtPointer,XtPointer);

		// Users Callback

		mxMailBoxControlCB	_userCB;
		XtPointer		_userData;
};

inline
int	mxMailBoxControl::noOfMsgs() const
	{return _mailbox->noOfMsgsLatest();}
inline
int	mxMailBoxControl::noOfMsgsRead() const
	{return _mailbox->noOfMsgsLatestRead();}
inline
mxMailBoxType	mxMailBoxControl::type() const
	{return _mailbox->type();}
inline
const string&	mxMailBoxControl::filename() const
	{return _mailbox->filename();}

#endif
#endif
