////////////////////////////////////////////////////////////////////////////////
//
//	Class : mxMail
//
//	Author : Andy Jefferson
//
//	Description :
//		mxMail is the main window class for the mxMail application.
//		It manages an array of mailboxes, displaying them within a
//		container. It consists of (amongst others) an addressbook
//		(single addressbook for ALL mxMail instances), a help document,
//		and an animated application logo. It additionally controls the
//		setting of the window icon depending on the state of the inbox.
//
//	Public Methods :
//		(Constructor) requires :-
//			name		Name used for resource specification.
//
//	Limitations :
//		Linked in with mxSetup item, so relies on there being a global
//		mxSetup object.
//
////////////////////////////////////////////////////////////////////////////////
#ifndef mxMail_h
#define mxMail_h
#ifdef __cplusplus

#include <vector.h>
#include <std/string.h>
#include "mxMailLogo.h"
#include "mxMailBoxControl.h"
#include "mxMailBoxSelector.h"
#include "mxMailSpamBook.h"
#include "mxMailAddressBook.h"
#include "mxMailAddressView.h"
#include "akWindow.h"
#include "akLabel.h"
#include "akClock.h"
#include "akButton.h"
#include "akDocView.h"
#include "akMessageDialog.h"
#include "akCopyright.h"

class mxMail : public akWindow
{
	public:

		// Constructor,destructor

		mxMail(char *name,
		       XtCallbackProc callback=0,
		       XtPointer clientData=0);
		~mxMail();

	private:

		vector<mxMailBoxControl*>	_boxes;
		static	mxMailSpamBook		*_spambook;
		static	mxMailAddressBook	*_addressbook;
		static	mxMailAddressView	*_addressview;
		XtCallbackProc			_userCB;
		XtPointer			_userData;

		// Panel widgets/methods

		Widget			createWorkArea(Widget parent);
		Widget			createMenuBar(Widget parent);
		Widget			createToolBar(Widget parent);
		Widget			_mailboxContainer;
		mxMailLogo		*_logo;
		akDocView		*_helpDocument;
		akClock			*_date;
		akClock			*_time;
		akButton		*_openOption;
		akButton		*_closeOption;
		akButton		*_deleteOption;
		akButton		*_setupOption;
		akButton		*_composeOption;
		akButton		*_addressbookOption;
		akButton		*_quitOption;
		akButton		*_helpOption;
		akButton		*_copyrightOption;
		akButton		*_quitButton;
		akButton		*_setupButton;
		akButton		*_composeButton;
		akButton		*_addressbookButton;
		akButton		*_helpButton;
		akMessageDialog		*_messageDialog;
		mxMailBoxSelector	*_mailboxSelector;
		akCopyright		*_copyright;

		akMessageDialog		*_deleteConfirmDialog;

		// Utility functions

		void	update();
		void	addMailbox(string filename,mxMailBoxType type);
		void	deleteMailbox(int);

		// Function callbacks

		static	void	openCB(Widget,XtPointer,XtPointer);
		static	void	openFolderOK(XtPointer,string);
		static	void	closeCB(Widget,XtPointer,XtPointer);
		static	void	deleteCB(Widget,XtPointer,XtPointer);
		static	void	deleteOK(XtPointer,XtPointer);
		static	void	deleteCancel(XtPointer,XtPointer);
		static	void	addressbookCB(Widget,XtPointer,XtPointer);
		static	void	composeCB(Widget,XtPointer,XtPointer);
		static	void	setupCB(Widget,XtPointer,XtPointer);
		static	void	helpCB(Widget,XtPointer,XtPointer);
		static	void	copyrightCB(Widget,XtPointer,XtPointer);
		static	void	quitCB(Widget,XtPointer,XtPointer);
		static	void	quitOK(XtPointer,XtPointer);
		static	void	quitCancel(XtPointer,XtPointer);

		static	void	mailboxSelectedCB(Widget,XtPointer,XtPointer);
		static	void	displayMailboxCB(Widget,XtPointer,XtPointer);
		static	void	inboxUpdatedCB(XtPointer,XtPointer,bool);
		static	void	setupChangedCB(Widget,XtPointer,XtPointer);
		static	void	addressbookClosedCB(Widget,XtPointer,XtPointer);
		static	void	composeClosedCB(Widget,XtPointer,XtPointer);

		static	void	TerminateCB(int);
		static	void	ExitCB();
};

#endif
#endif
