#include <Xm/Xm.h>
#include <Xm/ComboBox.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/List.h>
#include <Xm/TextF.h>
#include <string.h>
#include <iostream.h>

#include "akComboBox.h"
////////////////////////////////////////////////////////////////////////////////
//
//	Constructor function for the akComboBox object.
//
////////////////////////////////////////////////////////////////////////////////
akComboBox::akComboBox(Widget parent,
			 char *name,
			 string prompt,
			 akComboBoxCB callback,
			 XtPointer clientData)
	: akComponent(name),
	  _userCB(callback),
	  _userData(clientData)
{
	Widget	label=(Widget)0;
	Arg	args[10];

//	Create form to attach option menu to

	_w = XmCreateForm(parent,_name,NULL,0);
	installDestroyHandler();

//	Attach a label containing prompt (if required)

	if (prompt.size() > 0)
	  label =
		XtVaCreateManagedWidget(prompt.c_str(),
					xmLabelWidgetClass,
					_w,
					XmNtopAttachment,XmATTACH_FORM,
					XmNleftAttachment,XmATTACH_FORM,
					XmNbottomAttachment,XmATTACH_FORM,
					XmNalignment,XmALIGNMENT_END,
					NULL);

//	Add the combo box

	XtSetArg(args[0],XmNarrowSpacing,5);
	XtSetArg(args[1],XmNcomboBoxType,XmDROP_DOWN_COMBO_BOX);
	XtSetArg(args[2],XmNvisibleItemCount,10);
	XtSetArg(args[3],XmNrightAttachment,XmATTACH_FORM);
	if (label)
	  {
	   XtSetArg(args[4],XmNleftAttachment,XmATTACH_WIDGET);
	   XtSetArg(args[5],XmNleftWidget,label);
	   _combo = XmCreateComboBox(_w,"ComboBox",args,6);
	  }
	else
	  {
	   XtSetArg(args[4],XmNleftAttachment,XmATTACH_FORM);
	   _combo = XmCreateComboBox(_w,"ComboBox",args,5);
	  }
	XtManageChild(_combo);

//	Add the selection callback if provided

	if (callback)
	  XtAddCallback(_combo,
			XmNselectionCallback,
			&akComboBox::selectionCB,
			(XtPointer)this);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Add an option
//
////////////////////////////////////////////////////////////////////////////////
void	akComboBox::addOption(string option)
{
	Widget		list=XtNameToWidget(_combo,"*List");
	XmString	item=XmStringCreateLtoR((char *)option.c_str(),XmFONTLIST_DEFAULT_TAG);

	XmListAddItemUnselected(list,item,0);
	XmStringFree(item);
	XmComboBoxUpdate(_combo);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Set the options
//
////////////////////////////////////////////////////////////////////////////////
void	akComboBox::setOptions(string *opts,int nopts)
{
	XmString	*options;
	Widget		list;

	options = new XmString[nopts];
	for (int i=0;i<nopts;i++)
	  options[i] = XmStringCreateLtoR((char *)opts[i].c_str(),XmFONTLIST_DEFAULT_TAG);
	list = XtNameToWidget(_combo,"*List");

	XtVaSetValues(list,
		      XmNitems,options,
		      XmNitemCount,nopts,0);
	for (int i=0;i<nopts;i++)
	  XmStringFree(options[i]);
	delete []options;
	XmComboBoxUpdate(_combo);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Select an option
//
////////////////////////////////////////////////////////////////////////////////
void	akComboBox::select(string option)
{
	XmString	tempstr;

	tempstr = XmStringCreateLtoR((char *)option.c_str(),XmFONTLIST_DEFAULT_TAG);
	XtVaSetValues(_combo,XmNselectedItem,tempstr,0);
	XmStringFree(tempstr);
	XmComboBoxUpdate(_combo);
}
////////////////////////////////////////////////////////////////////////////////
//
//	Currently entered value
//
////////////////////////////////////////////////////////////////////////////////
string	akComboBox::value(void)
{
	char	*tempstr;
	string	value;
	Widget	field = XtNameToWidget(_combo,"*Text");

	tempstr = XmTextFieldGetString(field);
	value = tempstr;
	XtFree(tempstr);

	return value;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Selected option retrieval
//
////////////////////////////////////////////////////////////////////////////////
string	akComboBox::selectedOption(void)
{
	XmString	tempstr;
	int		pos;
	char		*item;
	string		the_selection;

	XtVaGetValues(_combo,
		      XmNselectedItem,&tempstr,
		      XmNselectedPosition,&pos,0);
	if (pos > 0)
	  {

	   item = (char *)XmStringUnparse(tempstr,NULL,XmCHARSET_TEXT,
				   XmCHARSET_TEXT,NULL,0,XmOUTPUT_ALL);
	   if (item)
	     {
	      the_selection = item;
	      XtFree(item);
	     }
	  }
	return the_selection;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Selection callback
//
////////////////////////////////////////////////////////////////////////////////
void	akComboBox::selectionCB(Widget,XtPointer clientData,XtPointer callData)
{
	akComboBox	*obj = (akComboBox *)clientData;
	XmComboBoxCallbackStruct	*cbs =
		(XmComboBoxCallbackStruct *)callData;
	string		new_selection="";
	char		*item;

	item = (char *)XmStringUnparse(cbs->item_or_text,NULL,XmCHARSET_TEXT,
			       XmCHARSET_TEXT,NULL,0,XmOUTPUT_ALL);
	if (item)
	  new_selection = item;

	if (obj->_userCB)
	  obj->_userCB(obj->_userData,new_selection);
}
