#include <stdio.h>
#include <errno.h>
#include <sys/mount.h>
#include <linux/fs.h>
#include <mntent.h>

#define UFSTAB "/usr/local/lib/userfstab"
#define MTAB "/etc/mtab"

#ifndef MS_SYNCHRONOUS
#define MS_SYNCHRONOUS MS_SYNC
#endif

int main(int argc, char *argv[])
{
 struct mntent *entry;
 FILE *ufstab;
 FILE *mtab;
 unsigned long rwflag = MS_MGC_VAL;
 int found = 0;

 if (argc != 2)
 {
     fprintf(stderr, "usermount - Usage: usermount <device>\n");
     exit(-2);
 }
 if (!(ufstab = setmntent(UFSTAB, "r")))
 {
     fprintf(stderr, "usermount: Could not open %s\n", UFSTAB);
     exit(-1);
 }
 while ((entry = getmntent(ufstab)))
 {
     if (!strcmp(argv[1], entry->mnt_fsname) || !strcmp(argv[1], entry->mnt_dir))
     {
	 found = 1;
	 break;
     }
 }
 if (!found)
 {
     fprintf(stderr, "usermount: no entry matching %s found in %s\n", argv[1], UFSTAB);
     endmntent(ufstab);
     exit(-3);
 }
 if (hasmntopt(entry, "ro"))
     rwflag |= MS_RDONLY;
 if (hasmntopt(entry, "nosuid"))
     rwflag |= MS_NOSUID;
 if (hasmntopt(entry, "nodev"))
     rwflag |= MS_NODEV;
 if (hasmntopt(entry, "noexec"))
     rwflag |= MS_NOEXEC;
 if (hasmntopt(entry, "sync"))
     rwflag |= MS_SYNCHRONOUS;
 if (mount(entry->mnt_fsname, entry->mnt_dir, entry->mnt_type, rwflag, NULL))
 {
     fprintf(stderr, "usermount: Could not mount %s on %s: %s\n", entry->mnt_fsname, entry->mnt_dir, sys_errlist[errno]);
     endmntent(ufstab);
     exit(errno);
 }
 else if  (!(mtab = setmntent(MTAB, "r+")) || addmntent(mtab, entry))
 {
     fprintf(stderr, "usermount: Warning - error updating %s: %s\n", MTAB, sys_errlist[errno]);
     endmntent(mtab);
 }
 endmntent(ufstab);
 return 0;
}
