/*
 * sens.c
 *	Widget sensitivity handling for mgv.
 *
 * Copyright (C) 1996  Eric A. Howe
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Authors:	Matthew D. Francey
 *		Eric A. Howe (mu@echo-on.net)
 */
#include	<wlib/rcs.h>
MU_ID("$Mu: mgv/sens.c,v 1.41 $")

#include	<X11/Intrinsic.h>

#include	<wlib/wlib.h>
#include	<mine/sens.h>

/*
 * common combinations
 */
#define	MgvSOPENDOC	(MgvSOPEN | MgvSDOC)

/*
 * we could do this through the resources (using the same technique
 * as the help system) but we really don't want to walk the entire
 * widget tree all the time; however, it might be nice to build
 * and cache the sensitivity list whenever some thing new gets created
 */
static struct {
	char	*name;		/* widget name				*/
	int	primary;	/* primary sensitivity mask		*/
	int	secondary;	/* secondary sensitivity mask		*/
} sens[] = {
	{"*menuBar*file_pd*reopen",	MgvSOPEN},
	{"*menuBar*file_pd*print",	MgvSOPEN},
	{"*menuBar*file_pd*save",	MgvSOPEN},
	{"*fileSave*saveUnmark",	MgvSMARKED},
	{"*fileSave*saveMarked",	MgvSMARKED},
	{"*menuBar*page_pd*prev",	MgvSOPENDOC | MgvSNOTFIRST},
	{"*menuBar*page_pd*next",	MgvSOPENDOC | MgvSNOTLAST,
					MgvSOPEN    | MgvSNOTLAST},
	{"*menuBar*page_pd*center",	MgvSOPEN},
	{"*menuBar*page_pd*redisplay",	MgvSOPENDOC},
	{"*menuBar*page_pd*showLabels",	MgvSOPENDOC},
	{"*menuBar*page_pd*showPgNums",	MgvSOPENDOC},
	{"*menuBar*mark",		MgvSOPENDOC},
	{"*menuBar*mark_pd*mark",	MgvSOPENDOC | MgvSPAGES},
	{"*menuBar*mark_pd*markAll",	MgvSOPENDOC | MgvSPAGES},
	{"*menuBar*mark_pd*unmark",	MgvSOPENDOC | MgvSPAGES | MgvSMARKED},
	{"*menuBar*mark_pd*unmarkAll",	MgvSOPENDOC | MgvSPAGES | MgvSMARKED},
	{"*menuBar*mark_pd*even",	MgvSOPENDOC | MgvSPAGES},
	{"*menuBar*mark_pd*odd",	MgvSOPENDOC | MgvSPAGES},
	{"*menuBar*mark_pd*invert",	MgvSOPENDOC | MgvSPAGES},
	{"*menuBar*magstep",		MgvSOPEN},
	{"*menuBar*orientation",	MgvSOPEN},
	{"*menuBar*media",		MgvSOPEN},
	{"*printDialog*markedOnly",	MgvSMARKED},
	{"*printDialog*unmark",		MgvSMARKED},
	{"*listSW", 			MgvSPAGES},
	{"*menuBar*window_pd*closeZoom",MgvSGOTZOOMS},
	{"*popup*closeZoom",		MgvSGOTZOOMS},
	{NULL}
};

void
mgv_sens(Widget top, int mask)
{
	Widget	w;
	int	i;
	Boolean	b;

	/*
	 * Lesstif sometimes uses the wrong parent for dialogs
	 * so we'll just start at the very tippy-top.  Putting this
	 * here isolated the change.
	 */
	top = wl_top(top);

	for(i = 0; sens[i].name != NULL; ++i) {
		if((w = wl_find1(top, sens[i].name)) == NULL)
			continue;
		b = False;
		if((sens[i].primary & mask) == sens[i].primary)
			b = True;
		else if(sens[i].secondary != 0
		    && (sens[i].secondary & mask) == sens[i].secondary)
			b = True;
		XtSetSensitive(w, b);
	}
}
