# @(#)$Mu: make/tar.mk,v 1.16 $
##
## tar.mk
##	GNU Makefile for generating tar files.
##
## Copyright (C) 1996  Eric A. Howe
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##   Authors:	Matthew D. Francey
##		Eric A. Howe (mu@echo-on.net)
##

##
## This Makefile requires GNU Make
##

## 
## build a gzipped tar file of the current sources, this is only
## useful if you're me or you've gone and put $(projname) under cvs control 
## locally (the Entries.Log appears to be a bug in CVS or just confusion on
## my part)
##
## this assumes (in one place) that you're doing "make tar" on a linux
## machine and it assumes that you're using wlib
##
## All the documentation and everything that needs m4 will get generated
## here.
##
tools  = $(shell cat tools/.tools)
tarver = $(projname)-$(subst .,_,$(version))
tardir = $(projname)-$(version)
targen = res.m4 $(appdef).ad _switch_help.c $(projname).man
tar::
	@rm -rf $(tardir)
	@mkdirhier $(tardir)
	@cvs export -r $(tarver) -d $(tardir) $(projname)
	@rm -f CVS/Entries.Log
	@sed 's/^rclean/#rclean/' < $(tardir)/doc/GNUmakefile > ..docgmake.. \
		&& mv ..docgmake.. $(tardir)/doc/GNUmakefile \
		|| (rm -f ..docgmake..; exit 1)
	@(cd $(tardir)/make; ln -s sys.linux.mk sys.mk)
	@make -C $(tardir)/tools all
	@make -C $(tardir)/doc all clean
	@make -C $(tardir)/tools realclean
	@make -C $(tardir) $(targen)
	@(cd $(tardir); $(top)/tools/adpp SY_IRIX $(top)/$(tardir) \
		$(appdef).ad.in > $(appdef).ad.sgi)
	@touch $(addprefix $(tardir)/doc/, *.sgml *.txt *.ps *.html *.gif)
	@touch $(tardir)/doc/HISTORY $(tardir)/doc/INSTALL
	@touch $(addprefix $(tardir)/, $(targen))
	@rm -f $(tardir)/make/sys.mk
	@find $(tardir) -type f -print | xargs chmod 644
	@chmod 755 $(addprefix $(tardir)/tools/, $(tools))
	@find $(tardir) -type d -print | xargs chmod 755
	@echo "Making PostScript archive..."
	@tar cf - $(tardir)/doc/*.ps $(tardir)/doc/GNUmakefile \
		| gzip -9 > $(tardir)-ps.tar.gz
	@rm -f $(tardir)/doc/*.ps
	@chmod 644 $(tardir)-ps.tar.gz
	@sed '/^all/s/ *ps */ /' < $(tardir)/doc/GNUmakefile > ..docgmake.. \
		&& mv ..docgmake.. $(tardir)/doc/GNUmakefile \
		|| (rm -f ..docgmake..; exit 1)
	@echo "Making archive..."
	@tar cf - $(tardir) | gzip -9 > $(tardir).tar.gz
	@chmod 644 $(tardir).tar.gz
	@rm -rf $(tardir)
