/*****************************************************************************

	main.c

	Environment:    Unix R40V3/Solaris2/Linux.

	Revision history:	@(#)main.c	1.9	97/06/23


	DESCRIPTION: Mdb. Motif based database manager 
			for Phone and  Adress Books.

	SEE ALSO:	README, troff(1), dpost(1)
			and the freeware programs 'mp',
			'groff' and 'ispell'.

        COPYRIGHT NOTICE:
        Permission to use,  copy,  modify,  and  distribute  this
        software  and  its    documentation   is  hereby  granted
        without fee, provided that  the  above  copyright  notice
        appear  in all copies and that both that copyright notice
        and  this  permission   notice   appear   in   supporting
        documentation.  The   author  makes  no   representations
        about   the   suitability   of   this  software  for  any
        purpose.  It  is  provided  "as  is"  without  express or
        implied warranty.

        THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD  TO  THIS
        SOFTWARE,    INCLUDING    ALL   IMPLIED   WARRANTIES   OF
        MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE AUTHOR
        BE  LIABLE  FOR  ANY  SPECIAL,  INDIRECT OR CONSEQUENTIAL
        DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS  OF
        USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
        NEGLIGENCE  OR  OTHER  TORTIOUS   ACTION,   ARISING   OUT
        OF   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
        SOFTWARE.

******************************************************************************/
/******************************************************************************/
#pragma ident "@(#)main.c      1.9		97/06/23"

#define MAIN
#include "mdb.h"
#include "mdb_icon.h"

/*
 * Application wide Global Variables.
 */
long NextPos		= 0;
items Item[MAXITEMS];
Boolean Case		= False;
Boolean Fmode		= False;
Boolean Debug		= False;

/*
 * Local variables.
 */
static Widget	Top;
static Widget	Titems_w;
static Widget	Type_w;
static Widget	Sel1_w;
static Widget	Sel2_w;
static Widget	TogglePane;
static Widget	HorVerRC;
static Widget	TglRemRC;
static Widget	ActArea;
static Widget	Control;
static Widget	MenuBar;
static Widget	Save;
static Widget	Delete;
static Widget	Prev;
static Widget	PrtTgl;
static Widget	Active_w[20];

static Pixmap	Mdb_pixm;
static XtAppContext App;

static int	TextItems	= 0;
static int	FPos		= -1;
static int	MaxLine		= 0;
static int	MaxNotes	= 0;
static int	Nstext		= 0;
static int	MailItem	= -1;
static int	MaxItems	= 0;
static int	KeyItem		= 0;
static int	SKeyItem	= 0;
static int	ItemXTcolumns	= 40;
static XmTextPosition   Pofs 	= 1;
static Dimension ItemXLwidth	= 120;
static Dimension Xd, Yd;

static Boolean Titems_used	= False;
static Boolean Type_used	= False;
static Boolean Sel1_used	= False;
static Boolean Sel2_used	= False;
static Boolean Rem_used		= False;
static Boolean Greet		= True;
static Boolean Test		= False;

static FILE	*Errlog;

static char	FolderClass[80];
static char	EmailFormat[40];
static char	Xpath[PATH_MAX*3];
static char	Layout[64];
static char	FolderPath[PATH_MAX];
static char	PfolderPath[PATH_MAX];
static char	*Folders[MAXFOLDS];
static char	*Layouts[50];
static char	*StartDir	= NULL;
static char	*Argv0;
/*
 * Default orientation is the opposite
 * of the (toggled) value stated here.
 */
static unsigned char Ori	= XmHORIZONTAL;

#if !defined(lint) && !defined(__lint)
static char *HelloMsg = {"\
Version 1.9\n\n\
Author:\n\
Erland Hedman\n\
1996, 1997\n\n%s\
"};
#endif


/*
 * Forward declarations.
 */
static void	orient_cb(Widget w, int cd, XmPushButtonCallbackStruct *cbs);
static void	showErrs( FILE *fd, char *prg, char *prgn );
static void	forceExit(void);
static void	forceExit1(void);
static void	xydiff(void);
static Widget	initWin(void);
static Pixmap	setPixmap( Widget w, int sval );
static int	initVars(void);
static int	initItems(void);

/*
 * Global.
 */
Widget		Hello(int argc, char *argv[], char *layout, int sval);
void		MdbSens(Boolean stat);

XtActionsRec actions [] = { {"mdbHelp", (XtActionProc)help_action} };

/*
 * The Main Action Area:
 *   LabelString:	Callback:    cbValue: Sens: Help: */
static ActionAreaItem action_items[] = {
   { "searchButton",	(XtCP)search_cb,DEF,   1,   HSE },
   { "prevButton",	(XtCP)search_cb,PREV,  1,   HPE },
   { "saveButton",	(XtCP)save_cb,	DEF,   0,   HSV },
   { "deleteButton",	(XtCP)save_cb,	DEL,   0,   HDE },
   { "resetButton",	(XtCP)reset_cb,	DEF,   1,   HRE },
};

/*
 * Help on Version.
 */
static ActionAreaItem VersionItems[] = {
   { "cancelButton",	(XtCP)help_cb,   QUIT,   0,   HCA },
};

/*
 * Edit remarks.
 */
static ActionAreaItem RemarksItems[] = {
   { "remarksButton",	(XtCP)NULL,   0,   0,   QUICK },
};

/*
 * The "File" pop down menu:
 * Type = 1: Button, Type = 2: Toggle.
 *	LabelString:	Callback:      cbValue: Type: Sens: Sep: Help */
static MenuItem FileItems[] = {
   { "listButton",	(XtCP)main_cb,  LIST,    1,    1,   0,   HLI },
   { "copypButton",	(XtCP)main_cb,  CUTP,    1,    1,   0,   HCP },
   { "caseToggle",	(XtCP)main_cb,  CASE,    2,    1,   1,   HCS },
   { "importButton",	(XtCP)main_cb,  IMP,     1,    1,   0,   HIM },
   { "exportButton",	(XtCP)main_cb,  EXP,     1,    1,   1,   HEX },
   { "printButton",	(XtCP)main_cb,  PRINT,   1,    1,   1,   HPR },
   { "exitButton",	(XtCP)main_cb,  QUIT,    1,    0,   0,   QUICK},
};

/*
 * The "Folder" pop down menu:
 * Same type (fields) as the "File" menu.
 */
static MenuItem SelectItems[] = {
   { "protectToggle",	(XtCP)folder_cb,  PRT,   2,   1,   1,   QUICK },
};

/*
 * The "Options" pop down menu:
 * Same type (fields) as the "File" menu.
 */
static MenuItem OptionItems[] = {
   { "orientButton",	(XtCP)orient_cb,  DEF,   1,   0,   1,   HOR },
   { "gsearchButton",	(XtCP)gsearch_cb, DEF,   1,   1,   0,   HGS },
   { "gchangeButton",	(XtCP)gchange_cb, DEF,   1,   1,   1,   HGC },
   { "configButton",	(XtCP)config_cb,  DEF,   1,   0,   0,   HCN },
};

/*
 * The "Help" pop down menu:
 * Same type (fields) as the "File" menu.
 */
static MenuItem HelpItems[] = {
   { "helpContextButton",	(XtCP)help_cb, HONC,   1,   0,   0,   QUICK },
   { "helpIndexButton",		(XtCP)help_cb, HINDX,  1,   0,   0,   QUICK },
   { "helpPrdInfoButton",	(XtCP)help_cb, HPRD,   1,   0,   0,   QUICK },
   { "helpVersionButton",	(XtCP)help_cb, HVERS,  1,   0,   0,   QUICK },
};


/*
 * Start of mdb.
 */
/*ARGSUSED*/
void main( int argc, char *argv[] )
{

	Widget win;
	int i;
	int err = 0;
	Atom wm_close;
	char *tmpf = "";

	/*
	 * First set our private  search path for the
	 * reource files to $PWD, $HOME/.mdb and global
	 * path. This will override the usual expectation
	 * of where resource files should exists.
	 */
	(void)sprintf( Xpath, "XUSERFILESEARCHPATH=%s/%s/%cN:%s/%cN:%s/%cN:",
		       _XmOSGetHomeDirName(), PMDBDIR, '%',
		       GMDBDIR, '%',
		       getcwd( NULL, sizeof(Xpath) ), '%' );

	(void)putenv( Xpath );
	(void)putenv( "XFILESEARCHPATH=" );


	/*
	 * Save the name of us, and the default application
	 * class, here referred to as "Layout".
	 */
	Argv0 = argv[0];
	(void)strcpy( Layout, LAYOUT );

	for( i = 1; i < argc; i++ ) {

		/*
		 * Disable the "hello" Dialog,
		 * error messages to stderr instead
		 * of the "Fatal" Dialog and certain
		 * widgets are not set insensitive.
		 */
		if ( ! strcmp( argv[i], "-debug" ) ) {
			Debug = True;
			continue;
		}

		/*
		 * This execution mode is used by
		 * the configurator to test a new
		 * Layout under development.
		 * It will provide limited functionality
		 * and the Main Widget containers will be
		 * highlighted by means of thick borders.
		 */
		if ( ! strcmp( argv[i], "-test" ) ) {
			Debug = True;
			Test = True;
			continue;
		}

		/*
		 * Disable the "hello" Dialog,
		 */
		if ( ! strcmp( argv[i], "-hello" ) ) {
			Greet = False;
			continue;
		}

		/*
		 * Orientation.
		 */
		if ( ! strcmp( argv[i], "-hrz" ) ) {
			Ori = XmVERTICAL;
			continue;
		}

		/*
		 * Command line defined Layout
		 * overrides the default "LAYOUT".
		 */
		if ( ! strcmp( argv[i], "-layout" ) ) {
			if ( i+1 < argc ) {
				(void)strcpy( Layout, argv[++i] );
			}
		}
	}

	if ( Debug == False && Greet == True )
		(void)Hello( argc, argv, Layout, 5 );

	if ( (Debug == True) && (Test == False) )
		Errlog = stderr;
	else {
		Errlog = fopen( tmpf = GetTempFile(1), "w+" );
		/*
		 * Looking Glass is moving us to
		 * the directory where the binary is
		 * installed. We don't want that.
		 */
		StartDir = getcwd( NULL, PATH_MAX );
		(void)chdir( _XmOSGetHomeDirName() );
	}


	/*
	 * To make ctype C Library Functions
	 * work correctly, provided that the
	 * current locale on this compter is
	 * properly defined. This will also
	 * make the xpmsg() dialog to use
	 * native language if available.
	 */
#if defined(SVR4) || defined(linux)
	(void)setlocale( LC_ALL, "" );
#endif

	/*
	 * initialize  the  X  Toolkit  internals.
	 */
	Top = XtVaAppInitialize( &App, Layout, NULL, 0,
		&argc, argv, fall_back_res,
		XmNdeleteResponse, XmDO_NOTHING,
		XmNmwmFunctions, ~( MWM_HINTS_FUNCTIONS | MWM_FUNC_MAXIMIZE ),
		XmNmappedWhenManaged, False,
		NULL);

	XtAppAddActions( App, actions, XtNumber(actions) );
	Mdb_pixm = setPixmap( Top, 0 );

	/*
	 * Bind the window manager's close
	 * button to our exit routine.
	 */
	wm_close = XmInternAtom(XtDisplay(Top), "WM_DELETE_WINDOW", False );
	XmAddWMProtocolCallback(Top, wm_close, (XtCP)main_cb,(XtPointer)QUIT);

	/*
	 * Initialize database variables and realize main layout.
	 */
	if ( initVars() )
		err = 1;
	else if ( (win = initWin()) != NULL )
		XtManageChild(win);
	else
		err = 1;

	/*
	 * Realize Top before
	 * we go ahead and size it.
	 */
	XtRealizeWidget(Top);
	if ( ! err )
		orient_cb( NULL, 0, NULL );


	/*
	 * Launch the Fatal Error Dialog.
	 */
	if ( err ) {
		if ( (Debug == True) && (Test == False) )
			exit(1);
		showErrs(Errlog, Argv0, Layout );
	}

	if ( (Debug == False) && (Test == True) )
		(void)unlink(tmpf);

	/*
	 * Catch some signals.
	 */
	if ( Debug == False ) {
		(void)signal( SIGBUS,  (void(*)())forceExit );
		(void)signal( SIGSEGV, (void(*)())forceExit );
		(void)signal( SIGHUP,  (void(*)())forceExit1 );
		(void)signal( SIGINT,  (void(*)())forceExit1 );
		(void)signal( SIGTERM, (void(*)())forceExit1 );
		(void)signal( SIGABRT, (void(*)())forceExit1 );
		(void)signal( SIGABRT, (void(*)())forceExit1 );
		(void)signal( SIGQUIT, (void(*)())forceExit1 );
	}

	if ( Debug == False && Greet == True )
		(void)sleep(3);

	XtVaGetValues( Top, XmNx, &Xd, XmNy, &Yd,  NULL );
	(void)signal( SIGALRM, (void(*)())xydiff );
	(void)alarm( 1 );

	/*
	 * Here we go ..
	 */
	XtMapWidget(Top);
	XtAppMainLoop(App);
}


/*
 * Initialize mandatory Mdb variables.
 */
static int initVars(void)
{

	char *ptr;
	int i, j;
	int err = 0;

	/*
	 * The FolderClass represents the
	 * actual format and the layout
	 * contents of the database.
	 */
	if ( (ptr = GetRes( "*folderClass" )) == NULL ) {
		(void)fprintf( Errlog, " - error: missing \"folderClass\"\n" );
		err = 1;
	} else
		(void)strcpy( FolderClass, ptr );

	/*
	 * The Primary Key Item. This is the main
	 * text item for a item registration.
	 */
	if ( (ptr = GetRes( "*pKeyItem" )) == NULL ) {
		(void)fprintf( Errlog, " - error: missing \"pKeyItem\"\n" );
		err = 1;
	} else
		KeyItem = atoi( ptr );

	/*
	 * The secondary Key Item. This is a
	 * complementary item to KeyItem.
	 */
	if ( (ptr = GetRes( "*sKeyItem" )) == NULL ) {
		(void)fprintf( Errlog, " - error: missing \"sKeyItem\"\n" );
		err = 1;
	} else
		SKeyItem = atoi( ptr );

	/*
	 * MaxLine. This is the maximum
	 * No. of chars in one text item.
	 */
	if ( (ptr = GetRes( "*MaxLine" )) == NULL ) {
		(void)fprintf( Errlog, " - error: missing \"MaxLine\"\n" );
		err = 1;
	} else
		MaxLine = atoi( ptr );

	/*
	 * Get folder path.
	 */
	if ( (ptr = GetRes( "*folderGlobal" )) == NULL ) {
		(void)fprintf( Errlog, " - error: missing \"folderPath\"\n" );
		err = 1;
	} else
		(void)strcpy( FolderPath, ptr );

	/*
	 * Get private folder path.
	 * $HOME is put in front of this.
	 */
	if ( (ptr = GetRes( "*folderPrivate" )) == NULL )
		PfolderPath[0] = '\0';
	else
		(void)strcpy( PfolderPath, ptr );

	/*
	 * Add folders.
	 */
	bzero( Folders, sizeof(Folders) );
	j = 0;
	for( i = 0; i < sizeof(Folders)/sizeof(char *); i++ ) {

		if ( (ptr = GetRes( "*folderName%d", i )) == NULL )
			continue;

		Folders[j] = (char *)XtMalloc(80);

		(void)strcpy( Folders[j++], ptr );
	}

	if ( ! j ) {
		(void)fprintf( Errlog, " - error: no folders declared\n" );
		err = 1;
	}

	/*
	 * Add layouts.
	 */
	bzero( Layouts, sizeof(Layouts) );
	j = 0;
	for( i = 0; i < sizeof(Layouts)/sizeof(char *); i++ ) {

		if ( (ptr = GetRes( "*folderLayout%d", i )) == NULL )
			continue;

		Layouts[j] = (char *)XtMalloc(80);

		(void)strcpy( Layouts[j++], ptr );
	}

	if ( ! j ) {
		(void)fprintf( Errlog, " - error: no layouts declared\n" );
		err = 1;
	}

	/*
	 * Get width of parent -1-, left most Label.
	 * Used in the Item Form.
	 */
	if ( (ptr = GetRes( "*ItemXlabelWidth" )) != NULL )
		ItemXLwidth = (Dimension)atoi(ptr);

	/*
	 * Get width of parent -1-, right most Text.
	 * Used in Item Form.
	 */
	if ( (ptr = GetRes( "*ItemXTextcolumns" )) != NULL )
		ItemXTcolumns = atoi(ptr);

	/*
	 * Summarize MaxItems.
	 */
	for ( i = 0; i < MAXITEMS; i++ ) {

		if (  (ptr = GetRes( "*Item%d.parent", i )) == NULL )
			break;

		MaxItems++;

		if ( atoi(ptr) == 1 )
			TextItems++;
	}

	/*
	 * Register Item Titles.
	 */
	j = 0;
	for ( i = 0; i < MaxItems; i++ ) {

		if (  (ptr = GetRes( "*Item%d.labelString", i )) == NULL )
			break;

		Item[i].title = ptr;	j++;

	}

	if ( j != MaxItems ) {
		/*
		 * Something is really wrong !!.
		 */
		(void)fprintf( Errlog,
			" - error: title/parent missmatch - %d/%d\n",
			j, MaxItems );
		err = 1;
	}

	/*
	 * Now check consistency.
	 */
	for ( i = 0; i < MaxItems; i++ ) {

		for ( j = 0; j < MaxItems; j++ ) {

			if ( j == i ) continue;
			if ( ! strcmp( Item[i].title, "NULL" ) ) continue;

			if ( ! strcmp( Item[i].title, Item[j].title ) ) {
				(void)fprintf( Errlog,
				  " - error: item %d \"%s\" shadows item %d\n",
				  i, Item[i].title, j );
				err = 1;
			}
		}

	}

	return(err);
}


/*
 * Initialize the main layout of mdb.
 */
static Widget initWin(void)
{

	Widget main_w, menup_w;
	Widget act_w, rowcol_w;
	Widget frame_w, form_w;
	Widget search_w, toggle_w;
	Widget tmp_w, *wptr;
	int n, i;
	int sens = 0;
	int pos = 0;
	Arg args[20];

	bzero( Active_w, sizeof(Active_w));

	/*
	 * The main title bar.
	 */
	if ( Test )
		XtVaSetValues( Top, XtNtitle, "MDB TEST MODE", NULL );
	else
		XtVaSetValues( Top, XtNtitle, "No Folder", NULL );

	/*
	 * The main window.
	 */
	main_w = XmCreateMainWindow( Top, "mainWin", NULL, 0 );

	MenuBar = XmCreateMenuBar( main_w, "menuBar", NULL, 0 );
	XtManageChild(MenuBar);

	/*
	 * Set up the File Pulldown menu.
	 */
	(void)CreatePulldownMenu( MenuBar, "fileMenuLabel",
			FileItems, XtNumber(FileItems), Active_w, &sens );

	if ( Test ) {
		i = 0;
		while( Active_w[i] != NULL )
			XtSetSensitive( Active_w[i++], False );
	}

	/*
	 * Set up the folder menu.
	 */
	menup_w = CreatePulldownMenu( MenuBar, "selectMenuLabel",
			SelectItems, XtNumber(SelectItems), Active_w, &sens );

	PrtTgl = Active_w[sens-1];

	if ( Test )
		XtSetSensitive( menup_w, False );

	/*
	 * Now add all folders.
	 */
	i = 0;
	while( Folders[i] != NULL ) {
		(void)CreatePushButton( menup_w, Folders[i],
			(XtCP)folder_cb, i, NULL );
		i++;
	}

	/*
	 * Set up layout menu.
	 */
	menup_w = CreatePulldownMenu( MenuBar, "layoutMenuLabel",
			NULL, 0, NULL, NULL );
	if ( Test )
		XtSetSensitive( menup_w, False );

	/*
	 * Now add all layouts.
	 */
	i = 0;
	while( Layouts[i] != NULL ) {
		(void)CreatePushButton( menup_w, Layouts[i],
			(XtCP)layout_cb, i, NULL );
		i++;
	}

	/*
	 * Set up the Option menu.
	 */
	tmp_w = CreatePulldownMenu( MenuBar, "optionMenuLabel",
			OptionItems, XtNumber(OptionItems), Active_w, &sens );
	if ( Test )
		XtSetSensitive( tmp_w, False );

	/*
	 * The Help menu.
	 */
	(void)CreateHelpPulldownMenu( MenuBar, "helpMenuLabel",
			HelpItems, XtNumber(HelpItems), NULL, 0 );

	/*
	 * The Main Form Window.
	 */
	n = 0;
	XtSetArg(args[n], XmNmarginWidth,	0); n++;
	XtSetArg(args[n], XmNmarginHeight,	0); n++;
	form_w = XmCreateForm( main_w, "mainFormWin", args, n );
	XtManageChild(form_w);

	/*
	 * The main action button area.
	 */
	n = 0;
	XtSetArg(args[n], XmNtopAttachment,	XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment,    XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_FORM); n++;

	if ( XDefaultDepth( XtDisplay(Top), 0 ) == MONOCH ) {
		XtSetArg(args[n], XmNmarginWidth,	5); n++;
		XtSetArg(args[n], XmNmarginHeight,	5); n++;
		XtSetArg(args[n], XmNshadowThickness,	0); n++;
		XtSetArg(args[n], XmNborderWidth,	0); n++;
	}

	act_w = XmCreateFrame( form_w, "frameWin", args, n );
	XtManageChild(act_w);
	ActArea = act_w;

	/*
	 * The main control area.
	 */
	n = 0;
	XtSetArg(args[n], XmNtopAttachment,	XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget,		act_w); n++;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment,    XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_FORM); n++;

	if ( XDefaultDepth( XtDisplay(Top), 0 ) == MONOCH ) {
		XtSetArg(args[n], XmNmarginWidth,	5); n++;
		XtSetArg(args[n], XmNmarginHeight,	5); n++;
		XtSetArg(args[n], XmNshadowThickness,	0); n++;
		XtSetArg(args[n], XmNborderWidth,	0); n++;
	}

	frame_w = XmCreateFrame( form_w, "frameWin", args, n );
	XtManageChild(frame_w);

	Active_w[sens++] = frame_w;

	/*
	 * The main action buttons.
	 */
	wptr = (Widget *)XtMalloc( XtNumber(action_items) * sizeof(Widget) );

	tmp_w = CreateActionArea( act_w, action_items,
			 XtNumber(action_items), Active_w, &sens, wptr, False );

	XtVaSetValues( tmp_w, XmNborderWidth, 1, NULL );

	/*
	 * Pick out Delete and Save and
	 * deactivate them.
	 */
	XtSetSensitive( (Prev = wptr[1]), False );
	XtSetSensitive( (Save = wptr[2]), False );
	XtSetSensitive( (Delete = wptr[3]), False );

	/*
	 * The default for Text Item Form button.
	 */
	search_w = wptr[0];

	/*
	 * The Main scrollbar Window.
	 */
	n = 0;
	XtSetArg(args[n], XmNscrollingPolicy, XmAUTOMATIC); n++;
	XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmAS_NEEDED); n++;
	Control = XmCreateScrolledWindow( frame_w, "scrollWin", args, n );


	/*
	 * Add all windows.
	 * Start with main container window.
	 */
	HorVerRC = CreateRowColumn( Control, "mainRcWin", XmVERTICAL, 0 );

	/*
	 * Add the Help "DB Item" help callback.
	 */
	AddHelp( HorVerRC, "mainRcWin", HDI );

	if ( XDefaultDepth( XtDisplay(Top), 0 ) == MONOCH ) 
		XtVaSetValues( HorVerRC, XmNborderWidth, 2 , NULL );

	/*
	 * The main windows for Text Items.
	 */
	rowcol_w = CreateRowColumn( HorVerRC, "textWin", XmHORIZONTAL, 0 );
	XtVaSetValues( rowcol_w, XmNadjustLast, False, NULL );

	if ( TextItems ) {
		n = 0;
		if ( Test )
			XtSetArg(args[n],		XmNborderWidth, 2); n++;
		XtSetArg(args[n], XmNfractionBase,	TextItems); n++;
		XtSetArg(args[n], XmNmarginWidth,	0); n++;
		XtSetArg(args[n], XmNmarginHeight,	0); n++;
		Titems_w = XmCreateForm( rowcol_w, "textFormWin", args, n );
		AddHelp( Titems_w, "textFormWin", HDI );
	}

	/*
	 * The main Pane for toggles and remarks.
	 */
	TglRemRC = CreateRowColumn( HorVerRC, "rowcolWin", XmVERTICAL, 0 );
	AddHelp( TglRemRC, "rowcolWin", HDI );
	XtManageChild(TglRemRC);

	(void)CreateSeparator( TglRemRC, 0 );

	TogglePane = XmCreatePanedWindow( TglRemRC, "panedWin", NULL, 0 );

	toggle_w =  XmCreateForm( TogglePane, "formWin", NULL, 0 );

	Type_w = CreateRowColumn( toggle_w, "typeWin", XmVERTICAL, 0 );
	(void)CreateLabel( Type_w, "typeLabel" );

	Sel1_w = CreateRowColumn( toggle_w, "sel1Win", XmVERTICAL, 0 );
	(void)CreateLabel( Sel1_w, "sel1Label" );

	Sel2_w = CreateRowColumn( toggle_w, "sel2Win", XmVERTICAL, 0 );
	(void)CreateLabel( Sel2_w, "sel2Label" );

	n = 0;
	if ( Test )
		XtSetArg(args[n], XmNborderWidth, 2); n++;
	XtSetArg(args[n], XmNspacing, 0); n++;
	XtSetValues( Type_w, args, n );
	XtSetValues( Sel1_w, args, n );
	XtSetValues( Sel2_w, args, n );

	/*
	 * Add all user defined db items.
	 */
	if ( initItems() )
		return(NULL);


	if ( Titems_used == True ) {
		XtVaSetValues( Titems_w, XmNdefaultButton, search_w, NULL );
		XtManageChild(Titems_w);
		XtManageChild(rowcol_w);
	}

	if ( (Type_used==True) || (Sel1_used==True) || (Sel2_used==True) ) {

		if ( Type_used == True ) {
			XtVaSetValues( Type_w,
				XmNleftOffset, 8,
				XmNleftAttachment, XmATTACH_POSITION,
				XmNleftPosition, pos++, NULL );
			XtManageChild(Type_w);
		}


		if ( Sel1_used == True ) {
			XtVaSetValues( Sel1_w,
				XmNleftAttachment, XmATTACH_POSITION,
				XmNleftPosition, pos++, NULL );
			XtManageChild(Sel1_w);
		}

		if ( Sel2_used == True ) {
			XtVaSetValues( Sel2_w,
				XmNleftAttachment, XmATTACH_POSITION,
				XmNleftPosition, pos++, NULL );
			XtManageChild(Sel2_w);
		}

		XtVaSetValues( toggle_w, XmNfractionBase, pos, NULL );

		XtManageChild(toggle_w);

		XtManageChild(TogglePane);


	} else if ( Rem_used == True )
		XtManageChild(TogglePane);

	XtManageChild(HorVerRC);
	XtManageChild(Control);


	/*
	 * Deactivate areas.
	 */
	MdbSens( False );

	return(main_w);
}


/*
 * Compact Parent 1 items as much as possible.
 */
#define ITEM_MARGIN_H   2	/* Text Item's XmNmarginHeight */
#define ITEM_RLOFFSET   2	/* Text Item's XmN[right/left]Offset */
#define ITEM_SHADOWTH   1	/* Text Item's XmNshadowThickness */
#define ITEM_HIGHLITH   1	/* Text Item's XmNhighlightThickness */

/*
 * Add a widget representing a db item.
 */
/*ARGSUSED*/
static Widget add_item( char *class, char *parent, int item )
{

	Widget w, tmp_w, parent_w;
	static Widget sep;
	int n, i, nopt;
	char *ptr, *ptrn, *hlp;
	char name[80];
	unsigned char ori;
	Radio *rptr;
	Pixel pbg;
	XmString str;
	Arg args[30];

	/*
	 * Map the user defined widget
	 * items to their parents.
	 */
	switch ( atoi( parent ) ) {
		case 0: return( (Widget)-1 );

		case 1:	parent_w = Titems_w;

			/*
			 * Parent for text widgets and radio buttons.
			 */
			if ( Titems_used == False ) {
				/*
				 * If this is the first Titems_w
				 * entry, then add a separator.
				 */
				sep = CreateSeparator(Titems_w, 1);

				XtVaSetValues( sep,
					XmNtopAttachment,	XmATTACH_FORM,
					XmNbottomAttachment,	XmATTACH_FORM,
					XmNrightAttachment,	XmATTACH_FORM,
					NULL );
			}

			Titems_used = True;
			FPos++;
			break;

		/*
		 * Parent Type_w, Sel1_w and Sel2_w. Vertical
		 * Row Column widgets for toggles and radio buttons.
		 */
		case 2: parent_w = Type_w;	Type_used   = True;	break;
		case 3: parent_w = Sel1_w;	Sel1_used   = True;	break;
		case 4: parent_w = Sel2_w;	Sel2_used   = True;	break;
		case 5: parent_w = TogglePane;	Rem_used    = True;	break;

		default:
			(void)fprintf( Errlog,
				" - item %d: invalid parent number - %d\n",
				item, atoi( parent ) );
		return((Widget)NULL);
	}

	/*
	 * Background for Labels.
	 */
	XtVaGetValues( parent_w, XmNbackground, &pbg, NULL );

	/*
	 * Single Line Text Items for Parent 1 to 4.
	 */
	if ( ! strncmp( class, TEXTN, sizeof(TEXTN) ) ) {

		(void)sprintf( name, "Item%d", item );

		n = 0;
		if ( parent_w == Titems_w ) {
			XtSetArg(args[n], XmNwidth, ItemXLwidth); n++;
		}
		XtSetArg(args[n], XmNtopAttachment,	XmATTACH_POSITION); n++;
		XtSetArg(args[n], XmNtopPosition,	FPos); n++;
		XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_POSITION); n++;
		XtSetArg(args[n], XmNbottomPosition,	FPos+1); n++;
		XtSetArg(args[n], XmNleftAttachment,	XmATTACH_FORM); n++;
		XtSetArg(args[n], XmNbackground,	pbg); n++;
		tmp_w = XmCreateLabelGadget( parent_w, name, args, n );
		XtManageChild(tmp_w);

		n = 0;
		if ( parent_w == Titems_w ) {
			XtSetArg(args[n], XmNcolumns, ItemXTcolumns); n++;
		}

		XtSetArg(args[n], XmNtopAttachment,	XmATTACH_POSITION); n++;
		XtSetArg(args[n], XmNtopPosition,	FPos); n++;
		XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_POSITION); n++;
		XtSetArg(args[n], XmNbottomPosition,	FPos+1); n++;
		XtSetArg(args[n], XmNrightAttachment,	XmATTACH_WIDGET); n++;
		XtSetArg(args[n], XmNrightWidget,	sep); n++;
		XtSetArg(args[n], XmNrightOffset,	ITEM_RLOFFSET); n++;
		XtSetArg(args[n], XmNleftAttachment,	XmATTACH_WIDGET); n++;
		XtSetArg(args[n], XmNleftWidget,	tmp_w); n++;
		XtSetArg(args[n], XmNleftOffset,	ITEM_RLOFFSET); n++;
		XtSetArg(args[n], XmNmaxLength,		MaxLine); n++;
		XtSetArg(args[n], XmNmarginHeight,	ITEM_MARGIN_H); n++;
		XtSetArg(args[n], XmNshadowThickness,	ITEM_SHADOWTH); n++;
		XtSetArg(args[n], XmNhighlightThickness,ITEM_HIGHLITH); n++;
		XtSetArg(args[n], XmNhighlightOnEnter,	True); n++;

		if ( (hlp = GetRes( "*Item%d.help", item )) == NULL )
			hlp = HDI;
		else hlp = QUICK;

		w = CreateText( parent_w, name, hlp );
		XtSetValues( w, args, n );

		XtAddCallback( w, XmNmodifyVerifyCallback,
			(XtCP)verify_cb, (XtPointer)NULL );

		Item[item].type = TEXTW;
		Item[item].data = (char *)XtMalloc(MaxLine);
		Item[item].len  = MaxLine;
		bzero( Item[item].data, MaxLine );
		return(w);
	}

	/*
	 * Single Line Email Items for Parent 1.
	 */
	if ( ! strncmp( class, EMAIL, sizeof(EMAIL) ) ) {

		if ( atoi( parent ) != 1 ) {
			(void)fprintf( Errlog,
				" - item %d: illegally mapped to parent - %d\n",
					item, atoi( parent ) );
			return((Widget)NULL);
		}

		if ( MailItem == -1 )
			MailItem = item;
		else {
			(void)fprintf( Errlog,
			    " - item %d: only one Email item must be defined\n",
			        item );
			return((Widget)NULL);
		}

		if ( (ptr = GetRes( "*Item%d.htmlFormat", item)) != NULL )
			(void)strcpy( EmailFormat, ptr );

		(void)sprintf( name, "Item%d", item );

		n = 0;
		XtSetArg(args[n], XmNtopAttachment,	XmATTACH_POSITION); n++;
		XtSetArg(args[n], XmNtopPosition,	FPos); n++;
		XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_POSITION); n++;
		XtSetArg(args[n], XmNbottomPosition,	FPos+1); n++;
		XtSetArg(args[n], XmNleftAttachment,	XmATTACH_FORM); n++;
		w = CreateRowColumn( parent_w, name, XmHORIZONTAL, 0 );
		XtSetValues( w, args, n );
		XtManageChild(w);

		n = 0;
		XtSetArg(args[n], XmNwidth,		ItemXLwidth); n++;
		XtSetArg(args[n], XmNrecomputeSize,	False); n++;
		XtSetArg(args[n], XmNdefaultButtonShadowThickness, 0); n++;
		XtSetArg(args[n], XmNshowAsDefault,	0); n++;
		XtSetArg(args[n], XmNmarginLeft,	0); n++;
		XtSetArg(args[n], XmNmarginRight,	0); n++;
		XtSetArg(args[n], XmNmarginTop,		0); n++;
		XtSetArg(args[n], XmNmarginBottom,	0); n++;
		XtSetArg(args[n], XmNbackground,	pbg); n++;
		tmp_w =  XmCreatePushButtonGadget( w, name, args, n );
		XtAddCallback( tmp_w,
			XmNactivateCallback, (XtCP)mail_cb, (XtPointer)0 );
		AddHelp( tmp_w, "mailButton", QUICK );
		XtVaSetValues( tmp_w, XmNalignment, XmALIGNMENT_CENTER, NULL );
		XtSetSensitive( tmp_w, False );
		XtManageChild(tmp_w);

		n = 0;
		if ( parent_w == Titems_w ) {
			XtSetArg(args[n], XmNcolumns, ItemXTcolumns); n++;
		}

		XtSetArg(args[n], XmNtopAttachment,	XmATTACH_POSITION); n++;
		XtSetArg(args[n], XmNtopPosition,	FPos); n++;
		XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_POSITION); n++;
		XtSetArg(args[n], XmNbottomPosition,	FPos+1); n++;
		XtSetArg(args[n], XmNrightAttachment,	XmATTACH_WIDGET); n++;
		XtSetArg(args[n], XmNrightWidget,	sep); n++;
		XtSetArg(args[n], XmNrightOffset,	ITEM_RLOFFSET); n++;
		XtSetArg(args[n], XmNleftAttachment,	XmATTACH_WIDGET); n++;
		XtSetArg(args[n], XmNleftWidget,	tmp_w); n++;
		XtSetArg(args[n], XmNleftOffset,	ITEM_RLOFFSET); n++;
		XtSetArg(args[n], XmNmaxLength,		MaxLine); n++;
		XtSetArg(args[n], XmNmarginHeight,	ITEM_MARGIN_H); n++;
		XtSetArg(args[n], XmNshadowThickness,	ITEM_SHADOWTH); n++;
		XtSetArg(args[n], XmNhighlightThickness,ITEM_HIGHLITH); n++;
		XtSetArg(args[n], XmNhighlightOnEnter,	True); n++;

		if ( (hlp = GetRes( "*Item%d.help", item )) == NULL )
			hlp = HDI;
		else hlp = QUICK;

		w = CreateText( parent_w, name, hlp );
		XtSetValues( w, args, n );

		XtAddCallback( w, XmNvalueChangedCallback,
				(XtCP)mail_cb, (XtPointer)tmp_w );

		XtAddCallback( w, XmNmodifyVerifyCallback,
			(XtCP)verify_cb, (XtPointer)NULL );

		Item[item].type = TEXTW;
		Item[item].data = (char *)XtMalloc(MaxLine);
		Item[item].len  = MaxLine;
		bzero( Item[item].data, MaxLine );
		return(w);
	}

	/*
	 * Radio buttons for parent 1 to 4.
	 */
	if ( ! strncmp( class, RADIO, sizeof(RADIO) ) ) {

		(void)sprintf( name, "Item%d", item );

		n = 0;
		XtSetArg(args[n], XmNwidth,		ItemXLwidth); n++;
		XtSetArg(args[n], XmNtopAttachment,	XmATTACH_POSITION); n++;
		XtSetArg(args[n], XmNtopPosition,	FPos); n++;
		XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_POSITION); n++;
		XtSetArg(args[n], XmNbottomPosition,	FPos+1); n++;
		XtSetArg(args[n], XmNleftAttachment,	XmATTACH_FORM); n++;
		XtSetArg(args[n], XmNbackground,	pbg); n++;
		/*
		 * A title label is not needed for the
		 * toggle windows except for parent 1.
		 */
		if ( parent_w == Titems_w ) {
			tmp_w = XmCreateLabelGadget( parent_w, name, args, n );
			XtManageChild(tmp_w);
		}

		n = 0;
		if ( parent_w == Titems_w ) {
			XtSetArg(args[n], XmNshadowType,XmSHADOW_IN);n++;
		} else {
			XtSetArg(args[n], XmNshadowType,XmSHADOW_ETCHED_IN);n++;
		}
		XtSetArg(args[n], XmNtopAttachment,	XmATTACH_POSITION); n++;
		XtSetArg(args[n], XmNtopPosition,	FPos); n++;
		XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_POSITION); n++;
		XtSetArg(args[n], XmNbottomPosition,	FPos+1); n++;
		XtSetArg(args[n], XmNrightAttachment,	XmATTACH_WIDGET); n++;
		XtSetArg(args[n], XmNrightWidget,	sep); n++;
		XtSetArg(args[n], XmNrightOffset,	ITEM_RLOFFSET); n++;
		XtSetArg(args[n], XmNleftAttachment,	XmATTACH_WIDGET); n++;
		XtSetArg(args[n], XmNleftWidget,	tmp_w); n++;
		XtSetArg(args[n], XmNleftOffset,	ITEM_RLOFFSET); n++;
		XtSetArg(args[n], XmNmarginWidth,	0); n++;
		XtSetArg(args[n], XmNmarginHeight,	0); n++;
		tmp_w = XmCreateFrame( parent_w, name, args, n );
		XtManageChild(tmp_w);

		if ( parent_w == Titems_w )
			ori = XmHORIZONTAL;
		else 
			XtVaGetValues( parent_w, XmNorientation, &ori, NULL );

		n = 0;
		XtSetArg(args[n], XmNpacking,		XmPACK_TIGHT); n++;
		XtSetArg(args[n], XmNradioBehavior,	True); n++;
		XtSetArg(args[n], XmNmarginWidth,	0); n++;
		XtSetArg(args[n], XmNmarginHeight,	0); n++;
		XtSetArg(args[n], XmNspacing,		0); n++;
		w = XmCreateRowColumn( tmp_w, name, args, n );
		XtManageChild(w);

		n = 0;
		if ( parent_w == Titems_w ) {
			XtSetArg(args[n], XmNmarginWidth,	6); n++;
		} else {
			tmp_w = XmCreateLabelGadget( w, name, NULL, 0 );
			XtManageChild(tmp_w);
			XtSetArg(args[n], XmNmarginWidth,	0); n++;
		}

		XtSetArg(args[n], XmNmarginWidth,	2); n++;
		XtSetArg(args[n], XmNmarginHeight,	0); n++;
		XtSetArg(args[n], XmNshadowThickness,	0); n++;
		XtSetArg(args[n], XmNhighlightOnEnter,	True); n++;
		XtSetArg(args[n], XmNhighlightThickness,ITEM_HIGHLITH); n++;


		if ( (ptr = GetRes( "*Item%d.options", item )) == NULL ) {
			(void)fprintf( Errlog,
				" - item %d: no options declared\n", item );
			return((Widget)NULL);
		}
		(void)strcpy( name, ptr );

		ptr = name;
		nopt = 1;
		while( (ptr = strchr( ptr, ' ' )+1) != (char *)1 ) nopt++;
		nopt = nopt > MAXRB ? MAXRB : nopt;

		ptr = name;

		rptr = (Radio *)XtMalloc( sizeof(Radio) );
		bzero( rptr, sizeof(Radio) );

		if ( (hlp = GetRes( "*Item%d.help", item )) == NULL )
			hlp = HDI;

		for( i = 0; i < nopt; i++ ) {
			if ( (ptrn = strchr( ptr, ' ' )) != NULL )
				*ptrn = '\0';

			tmp_w = XmCreateToggleButtonGadget( w, ptr, args, n );
			XtManageChild(tmp_w);

			XtAddCallback( tmp_w, XmNhelpCallback,
				hlp == HDI ? (XtCP)dhelp_cb : (XtCP)qhelp_cb,
				(XtPointer)hlp );

			rptr->button[i] = tmp_w;
			(void)strcpy( &rptr->label[i*MAXRBL], ptr );

			ptr = ++ptrn;

		}

		Item[item].type = RADIOW;
		Item[item].data = (char *)XtMalloc(MaxLine);
		Item[item].len  = MaxLine;
		bzero( Item[item].data, MaxLine );
		return((Widget)rptr); 
	}


	/*
	 * Toggle buttons for parent 2 to 4.
	 */
	if ( ! strncmp( class, TOGGLE, sizeof(TOGGLE) ) ) {


		if ( (atoi( parent ) <2) || (atoi( parent ) >4) ) {
			(void)fprintf( Errlog,
				" - item %d: illegally mapped to parent - %d\n",
					item, atoi( parent ) );
			return((Widget)NULL);
		}

		(void)sprintf( name, "Item%d", item );

		if ( (hlp = GetRes( "*Item%d.help", item )) == NULL )
			hlp = HDI;
		else hlp = QUICK;

		w = CreateToggleButton( parent_w, name, (XtCP)NULL, 0, hlp );

		n = 0;
		XtSetArg(args[n], XmNmarginHeight,	0); n++;
		XtSetArg(args[n], XmNshadowThickness,	0); n++;
		XtSetArg(args[n], XmNmarginWidth,	0); n++;
		XtSetArg(args[n], XmNhighlightOnEnter,	True); n++;
		XtSetArg(args[n], XmNhighlightThickness,ITEM_HIGHLITH); n++;
		XtSetArg(args[n], XmNbackground,	pbg); n++;
		XtSetValues( w, args, n );

		Item[item].type = TOGLW;
		Item[item].data = (char *)XtMalloc(MaxLine);
		Item[item].len  = MaxLine;
		bzero( Item[item].data, MaxLine );
		return(w);
	}

	/*
	 * The Scrolled Text (Variable Lenght) - Remarks field for Parent 5.
	 */
	if ( ! strncmp( class, STEXT, sizeof(STEXT) ) ) {

		if ( atoi( parent ) != 5 ) {
			(void)fprintf( Errlog,
				" - item %d: illegally mapped to parent - %d\n",
					item, atoi( parent ) );
			return((Widget)NULL);
		}

		/*
		 * Max No. of chars in the remarks area.
		 */
		if ( ! (MaxNotes = atoi( GetRes( "*MaxNotes" ) )) ) {
			(void)fprintf( Errlog,
				" - item %d: missing \"MaxNotes\"\n", item );
			return((Widget)NULL);
		}

		tmp_w = XmCreatePanedWindow( TogglePane, name, NULL, 0 ); 
		XtManageChild(tmp_w);

		(void)sprintf( name, "Item%d", item );

		n = 0;
		XtSetArg(args[n], XmNeditable,		False); n++;
		XtSetArg(args[n], XmNscrollHorizontal,  False); n++;
		XtSetArg(args[n], XmNmaxLength,		MaxNotes); n++;
		XtSetArg(args[n], XmNcursorPositionVisible, False); n++;
		XtSetArg(args[n], XmNeditMode,		XmMULTI_LINE_EDIT); n++;
		XtSetArg(args[n], XmNwordWrap,		True); n++;
		XtSetArg(args[n], XmNtraversalOn,	False); n++;
		XtSetArg(args[n], XmNhighlightOnEnter,	False); n++;
		w = XmCreateScrolledText( tmp_w, name, args, n );

		if ( (hlp = GetRes( "*Item%d.help", item )) != NULL )
			XtAddCallback( w, XmNhelpCallback,
				(XtCP)qhelp_cb, (XtPointer)hlp );
		else
			XtAddCallback( w, XmNhelpCallback,
				 (XtCP)dhelp_cb, (XtPointer)HRM );

		XtManageChild(w);

		/*
		 * This is to compensate for a difference
		 * in motif versions where the position
		 * is updated pre/post an insert.
		 */
		XmTextInsert( w, 0, "0" );
		Pofs = XmTextGetInsertionPosition(w);
		XmTextSetString( w, "" );

		(void)CreateActionArea( TogglePane, RemarksItems,
			XtNumber(RemarksItems), NULL, 0, &tmp_w, False );

		if ( (ptr = GetRes( "*Item%d.labelString", item )) != NULL ) {
			str = XmStringCreateSimple( ptr );
			XtVaSetValues( tmp_w, XmNlabelString, str, NULL );
			XmStringFree(str);
		}

		/*
		 * Attach the editor callback to us.
		 */
		XtAddCallback( tmp_w, XmNactivateCallback,
			(XtCP)edit_cb, (XtPointer)item );

		Item[item].type = STEXTW;
		Item[item].data = (char *)XtMalloc(MaxNotes);
		Item[item].len  = MaxNotes;
		bzero( Item[item].data, MaxNotes );

		Nstext++;

		return(w);
	}

	(void)fprintf( Errlog,
		" - item %d: unknown item class \"%s\"\n", item, class );
	return((Widget)NULL);
}


/*
 * Initialize db items according to
 * the resource file's user definitions.
 */
static int initItems(void)
{
	int err = 0;
	int i;
	char *parent, *class;

	/*
	 * Get all Items, class and parent. 
	 */
	for( i = 0; i < MaxItems; i++ ) {

		/*
		 * Initialize default.
		 */
		Item[i].type = NULLW;

		class = GetRes( "*Item%d.class", i );
		parent = GetRes( "*Item%d.parent", i );

		if ( (class == NULL ) || (parent == NULL) ) {
			if ( class == NULL )
				(void)fprintf( Errlog,
				" - item %d: missing \"class\" declaration\n",
				i );
			if ( parent == NULL )
				(void)fprintf( Errlog,
				" - item %d: missing \"parent\" declaration\n",
				i );
			err = 1;
			continue;
		}

		/*
		 * Create the widget.
		 */
		if ( ( Item[i].w = add_item( class, parent, i )) == NULL )
			err = 1;
	}

	return(err);
}


/*
 * Misc. returned values.
 */
Widget GetTopWidget(void)
{
	return(Top);
}

int GetMaxItems(void)
{
	return(MaxItems);
}

int GetKeyItem(void)
{
	return(KeyItem);
}

int GetSKeyItem(void)
{
	return(SKeyItem);
}

int GetItemXTcolumns(void)
{
	return(ItemXTcolumns);
}

Dimension GetItemXLwidth(void)
{
	return(ItemXLwidth);
}

char *GetFolderPath(void)
{
	return(FolderPath);
}

char *GetPrivateFolderPath(void)
{
	return(PfolderPath);
}

void GetXYd( Dimension *x, Dimension *y )
{
	*x = Xd; *y = Yd;
}

/*ARGSUSED*/
char *GetFolder(int folder)
{
	return(Folders[folder]);
}

/*ARGSUSED*/
char *GetLayout(int layout)
{
	return(Layouts[layout]);
}

char *GetStartDir(void)
{
	return(StartDir);
}

char *GetArgv(void)
{
	return(Argv0);
}

Pixmap GetMdbPixmap(void)
{
	return(Mdb_pixm);
}

unsigned char GetAppOrientation(void)
{
	/*
	 * Orientation.
	 */
	return(Ori);
}

char *GetFolderClass(void)
{
	/*
	 * Folder Class Name.
	 */
	return( FolderClass );
}

char *GetAppClass(void)
{
	/*
	 * Application  class.
	 */
	return( Layout );
}

XmTextPosition GetPofs(void)
{
	/*
	 * This is to compensate for a motif bug.
	 */
	return(Pofs);
}

int GetMailItem(void)
{
	return( MailItem );
}

char *GetMailFormat(void)
{
	if ( MailItem == -1 )
		return("");

	return(EmailFormat);
}

XtAppContext GetAppContext(void)
{
	return(App);
}

size_t GetMaxFieldLen(void)
{
	return(MaxLine + (MaxNotes*Nstext) );
}

size_t GetMaxNameLen(void)
{
	return(MaxLine);
}


/*
 * Sensitivity Control.
 */
/*ARGSUSED*/
void WrtSens( Boolean stat )
{
	/*
	 * Write Protect.
	 */
	XtSetSensitive( Save, stat );
	XtSetSensitive( Delete, stat );
	XmToggleButtonSetState( PrtTgl, stat, False );
}

/*ARGSUSED*/
void PrvSens( Boolean stat )
{
	/*
	 * Previous button.
	 */
	XtSetSensitive( Prev, stat );
}

/*ARGSUSED*/
void MdbSens( Boolean stat )
{

	int i = 0;

	if ( Debug == True ) return;

	/*
	 * Buttons within Cascades etc.
	 */
	while( Active_w[i] != NULL )
		XtSetSensitive( Active_w[i++], stat );
}


/*
 * This procedure controls the initial size of mdb, based
 * on the size of the Parent 1 container. In addition
 * we have the Vert/Hor layout change control here.
 */
#define SBW		15	/* Width of vertical Scrollbar */
#define MDBHEIGHT	(h1+h+(h4*2)+(((h2+h3)*2)+(w1*2))+w2+6)
#define MDBVWIDTH	((h4*2)+(w*2)+(w1*2)+(h3*2)+(w2*2)+4+SBW)

/*ARGSUSED*/
static void
orient_cb( Widget widget, int client_data, XmPushButtonCallbackStruct *cbs )
{
	Dimension p1h, p1w, p5h, p5w;
	Dimension h, h1, h2, h3, h4;
	Dimension w, w1, w2;

	/*
	 * Size and toggle Horizontal / Vertical orientation.
	 * The application MUST have been Realized at this point.
	 */

	XtVaGetValues( Titems_w, XmNheight, &p1h, XmNwidth, &p1w, NULL );

	XtVaGetValues( ActArea,
		XmNheight, &h1,
		XmNmarginHeight, &h2,
		XmNshadowThickness, &h3,
		XmNmarginWidth, &w,
		XmNborderWidth, &w1,
		NULL );

	XtVaGetValues( MenuBar, XmNheight, &h, NULL );
	XtVaGetValues( Control, XmNshadowThickness, &h4, NULL );
	XtVaGetValues( HorVerRC, XmNborderWidth, &w2, NULL );
	XtVaGetValues( TglRemRC, XmNheight, &p5h, XmNwidth, &p5w, NULL );

	if ( Ori == XmVERTICAL ) {

		Ori = XmHORIZONTAL;
		/*
		 * Set the Size so that mdb
		 * is fully exposed.
		 */

		p1h = p1h > p5h ? p1h : p5h;
		p1h += MDBHEIGHT;

		p1w += p5w;

		p1w += MDBVWIDTH - SBW;

	} else {

		Ori = XmVERTICAL;
		/*
		 * Set the Size so that the entire
		 * Parent 1 container is exposed.
		 */

		p1h += MDBHEIGHT;
		p1w = p1w > p5w ? p1w : p5w;
		p1w  += MDBVWIDTH;

	}

	XtVaSetValues( Top, XmNwidth, p1w, XmNheight, p1h, NULL );
	XtVaSetValues( HorVerRC, XmNorientation, Ori, NULL );
}


/*
 * Initial Greeting and Help on Version.
 */
/*ARGSUSED*/
Widget Hello( int argc, char *argv[], char *layout, int sval )
{
	XtAppContext app;
	Widget tmp_w, top, frame_w;
	Widget frame1_w, rowcol_w;
	Pixmap mdb_pixm;
	char geom[64];
	XmString str;
#if !defined(lint) && !defined(__lint)
	char *ptr, vbuff[100], dbuff[100];
#endif
	Arg args[20];
	Dimension x, y;
	Dimension h = 300;
	Dimension w = 250;
	int n;

	/*
	 * Hello will execute as its own psocess 
	 * during start up, or as a popup from
	 * Help as defined by `sval'.
	 */

	if ( sval ) {

		if ( fork() != (pid_t)0 )
			return(NULL);
		/*
		 * initialize  the  X  Toolkit  internals.
		 */
		top = XtVaAppInitialize( &app, layout, NULL, 0,
			&argc, argv, fall_back_res,
			XmNheight, h, XmNwidth, w,
			XmNmwmDecorations,~( MWM_HINTS_DECORATIONS |
				MWM_DECOR_BORDER | MWM_DECOR_TITLE ),
			NULL);

		y = (HeightOfScreen(XtScreen(top))/2) - (h/2);
		x = (WidthOfScreen(XtScreen(top))/2) - (w/2);
		(void)sprintf( geom, "+%d+%d", x, y );
		XtVaSetValues( top, XmNgeometry, geom, NULL );

		XtAppAddActions( app, actions, XtNumber(actions) );
		mdb_pixm = setPixmap( top, 1 );

	} else {

		top = CreateDialog( Top, GetFolderClass() );
		mdb_pixm = Mdb_pixm;
	}

	n = 0;
	XtSetArg(args[n], XmNshadowType, XmSHADOW_OUT); n++;
	frame_w = XmCreateFrame( top, "frameWin", args, n );

	n = 0;
	XtSetArg(args[n], XmNshadowType, XmSHADOW_IN); n++;
	frame1_w = XmCreateFrame( frame_w, "frameWin", args, n );

	rowcol_w = CreateRowColumn( frame1_w, "helloWin", XmVERTICAL, 0 );
	XtVaSetValues( rowcol_w, XmNspacing, 15, NULL );

	/*
	 * Using this awkward creation since
	 * XmALIGNMENT_CENTER did not take.
	 */
	XtVaSetValues( tmp_w = XmCreateLabelGadget( rowcol_w, "MDB", NULL, 0 ),
			XmNhighlightOnEnter,	False,
			XmNalignment,		XmALIGNMENT_CENTER,
			XmNlabelType,		mdb_pixm ? XmPIXMAP : XmSTRING,
			XmNlabelPixmap,		mdb_pixm,
			NULL );
	XtManageChild(tmp_w);

#if !defined(lint) && !defined(__lint)
#if ! defined(XmVERSION_STRING)
#define XmVERSION_STRING ""
#endif
	(void)sprintf( vbuff, XmVERSION_STRING );
	if ( (ptr = strchr( vbuff, ')' )) != NULL )
		ptr++;
	else
		ptr = vbuff;
	(void)sprintf( dbuff, HelloMsg, ptr );
	str = XmStringCreateLtoR( dbuff, XmSTRING_DEFAULT_CHARSET );
#endif


	XtVaSetValues(tmp_w=XmCreateLabelGadget(rowcol_w, "helloText", NULL, 0),
			XmNhighlightOnEnter,	False,
			XmNalignment,		XmALIGNMENT_CENTER,
#if !defined(lint) && !defined(__lint)
        		XmNlabelString,		str,
#endif
			NULL );
	XtManageChild(tmp_w);
	XmStringFree(str);

	XtVaSetValues( tmp_w = XmCreateLabelGadget( rowcol_w,
				"folderInfo", NULL, 0 ),
			XmNhighlightOnEnter,	False,
			XmNalignment,		XmALIGNMENT_CENTER,
			NULL );
	XtManageChild(tmp_w);


	if ( ! sval ) {
		(void)CreateActionArea( rowcol_w, VersionItems,
			XtNumber(VersionItems), NULL, NULL, NULL, False );
	}

	XtManageChild(frame_w);
	XtManageChild(frame1_w);
	XtManageChild(rowcol_w);

	if (sval) {
		XtRealizeWidget(top);
		(void)alarm(sval);
		XtAppMainLoop(app);
	}

	MapDialog( Top, top, 0, 0 );

	return(top);
}


/*
 * An error occured during initialization.
 * Launch an error Dialog and expose the problems
 * to the user.
 */
/*ARGSUSED*/
static void showErrs( FILE *fd, char *prg, char *layout )
{

	Widget err_w, txt_w;
	int n;
	char *dbuff = (char *)XtMalloc( 10000 );
	Arg args[10];

	bzero( dbuff, 10000 );

	XtVaSetValues( Top, XtNtitle, prg, NULL );

	errno = 0;
	err_w = xpmsg( Top, "error: can't continue" );
	XtAddCallback( err_w, XmNcancelCallback,
			(XtCP)main_cb, (XtPointer)ABORT );

	n = 0;
	XtSetArg(args[n], XmNrows,	10); n++;
	XtSetArg(args[n], XmNcolumns,	45); n++;
	XtSetArg(args[n], XmNeditable,	False); n++;
	XtSetArg(args[n], XmNeditMode,	XmMULTI_LINE_EDIT); n++;
	XtSetArg(args[n], XmNcursorPositionVisible, False); n++;
	txt_w = XmCreateScrolledText( err_w, "errText", args, n );
	XtManageChild(txt_w);

	(void)sprintf( dbuff, errmsg, prg, layout );

	(void)fseek( fd, 0L, SEEK_SET );

	(void)fread( &dbuff[strlen(dbuff)], sizeof(char), 10000, fd );

	XmTextSetString( txt_w, dbuff );

	XtFree(dbuff);
	(void)fclose(fd);
}

static void forceExit(void)
{
 
	errno = 0;
	(void)xpmsg( NULL, "fatal: INTERNAL ERROR" );
	/* NOTREACHED */
}

static void forceExit1(void)
{
 
	errno = 0;
	(void)xpmsg( NULL, "fatal: EXTERNAL TERMINATION" );
	/* NOTREACHED */
}

static void xydiff(void)
{
	Dimension x, y;
	XtVaGetValues( Top, XmNx, &x, XmNy, &y,  NULL );
	Xd = x - Xd; Yd = y - Yd;
}


/*ARGSUSED*/
static Pixmap setPixmap( Widget w, int sval )
{
	/*
	 * Define the mdb pixmap label.
	 */
	Display *dpy = XtDisplay(w);
	Pixmap pixmap;
	Colormap cmap;
	XColor fgc, bgc;
	char *cf, *cb;

	if ( !sval ) {
		if (  (cf = GetRes( "*MDB.foreground" )) == NULL )
			cf = "black";

		if (  (cb = GetRes( "*background" )) == NULL )
			cb = "white";

	} else {
		cf = "red";
		cb = "gray75";

	}
	cmap = DefaultColormap( dpy, DefaultScreen(dpy) );
	XParseColor( dpy, cmap, cf, &fgc );
	XAllocColor( dpy, cmap, &fgc );

	XParseColor( dpy, cmap, cb, &bgc );
	XAllocColor( dpy, cmap, &bgc );


	if ( (pixmap = XCreatePixmapFromBitmapData( dpy,
			DefaultRootWindow(dpy),
			(char *)mdb_icon_bits,
			mdb_icon_width, mdb_icon_height,
			fgc.pixel, bgc.pixel,
			DefaultDepth( dpy, DefaultScreen(dpy)))) ) {

		XtVaSetValues( w, XmNiconPixmap, pixmap, NULL );
		return(pixmap);
	}
	return((Pixmap)0);
}
