/*****************************************************************************

	help.c

	Environment:    Unix R40V3/Solaris2/Linux.

	Revision history:	@(#)help.c	1.9	97/06/23


	DESCRIPTION: Part of the Mdb Application.
			Provide help On Version, Context,
			Index and Product.

	To do:		Alphabetic sorting of topics.

	COPYRIGHT NOTICE:
        Permission to use,  copy,  modify,  and  distribute  this
        software  and  its    documentation   is  hereby  granted
        without fee, provided that  the  above  copyright  notice
        appear  in all copies and that both that copyright notice
        and  this  permission   notice   appear   in   supporting
        documentation.  The   author  makes  no   representations
        about   the   suitability   of   this  software  for  any
        purpose.  It  is  provided  "as  is"  without  express or
        implied warranty.

        THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD  TO  THIS
        SOFTWARE,    INCLUDING    ALL   IMPLIED   WARRANTIES   OF
        MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE AUTHOR
        BE  LIABLE  FOR  ANY  SPECIAL,  INDIRECT OR CONSEQUENTIAL
        DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS  OF
        USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
        NEGLIGENCE  OR  OTHER  TORTIOUS   ACTION,   ARISING   OUT
        OF   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
        SOFTWARE.

******************************************************************************/
/******************************************************************************/
#pragma ident "@(#)help.c      1.9		97/06/23"

#include "mdb.h"

#define MAXTOPICS	200	/* Max No. of help messages. */
#define MAXREFS		100	/* Max No. of Xrefs in one page. */
#define MAXHIST		100	/* Max No. logged topics . */

/*
 * Externals.
*/
extern Widget		Hello();

/*
 * Local Variables.
 */
static Widget		PopUp;
static Widget		Help_w;
static Widget		List_w;
static Widget		Back_w;
static Widget		Forw_w;
static Boolean		InUse = False;
static Boolean		Hindx = False;
static Boolean		First = True;
static Boolean		Loghist = True;
static Boolean		*Ppend = NULL;
static int		Ntopic = 0;
static int		Hist[MAXHIST];
static int		Histindx = 0;
static XmString		*XmTopics;
static char		**Topics;

struct xrefs {
	XmTextPosition start;
	XmTextPosition end;
	Boolean last;
};
static struct xrefs	Xrefs[MAXREFS];

#define SELECT		765

/*
 * Forward declarations.
 */
static void help_popup( Widget top, int htype, char *topic );
static void help1_cb( Widget w, int cd, XmListCallbackStruct *cbs );

static ActionAreaItem action_items[] = {
	{ "doprintButton",	(XtCP)help1_cb,	PRINT,	0,	HHE },
	{ "backButton",		(XtCP)help1_cb,	PREV,	0,	QUICK },
	{ "forwButton",		(XtCP)help1_cb,	NEXT,	0,	QUICK },
	{ "cancelButton",	(XtCP)help1_cb,	QUIT,	0,	HCA },
};

/*
 * Fallback resource for HHE.
 */
static
char *helpHelp = {"\
   Select a topic from the list to display further help.\n\
   Push <Print> to print all Help topics.\
"};

static
char *noHelp = {"\
   No Help available for topic \"%s\".\
"};

static
char *noPrt = {"\
There is no default printer defined.\n\
Use the \"Print\" Dialog to define a Printer.\
"};


/*
 * Launch a help Dialog.
 * Synopsis:
 * void help( Widget w, int htype, char *topic )
 * Where:
 *	w	= The widget we are providing help for.
 *	htype	= HINDX: General indexed help.
 *		  HPRD:  Help on Product.
 *		  HVERS: Help on Version.
 *		  HONC:  Help on Context.
 *		  QUIT:  Dismiss Dialog.
 *	topic	= A three letter Short Form of topic.
 *		  Must be used with `htype' == HINDX.
 * Note:
 *      The indexed help will automatically build
 *      highlighted cross references to be clicked
 *      on by searching for these references in
 *      the  actual help text.
 */
/*ARGSUSED*/
void help( Widget w, int htype, char *topic )
{
	XmAnyCallbackStruct cbs;
	Widget item;
	Cursor cursor;
	int i;
	int max =  MAXTOPICS;	/* Max No. of help messages */
	size_t size = 80;	/* Max Length of Topic Title */
	size_t tot;
	char dbuff[1024];
	char *ptr;

	if ( htype == QUIT ) {
		help1_cb( NULL, QUIT, NULL );
		return;
	}

	if ( InUse )
		w = PopUp;
	else if ( XtIsWMShell(w) == False )
		while ( XtIsWMShell( (w = XtParent(w)) ) == False );

	xpmsg_close();

	if ( htype == HONC ) {
		/*
		 * Context sensitive help.
		 * Will force a dhelp_cb() or a qhelp_cb().
		 */
		cursor = XCreateFontCursor(XtDisplay(w), XC_question_arrow);
		if ( (item = XmTrackingLocate(w, cursor, False)) ) {
			cbs.reason = XmCR_HELP;
			XtCallCallbacks( item, XmNhelpCallback, &cbs );
		}
		XFreeCursor(XtDisplay(w), cursor );
		return;
	}


	if ( ((InUse == True) && (Hindx == True) && (htype != HINDX)) ||
			((InUse == True) && (Hindx == False)) ) {
		(void)xpmsg( PopUp, "info: in use" );
		return;
	}

	Ppend = (Boolean *)XtMalloc(sizeof(Boolean));
	*Ppend = False;

	if ( htype == HPRD ) {
		/*
		 * Help On Product.
		 */
		if ( (ptr = GetRes( "*helpProductInformation" )) != NULL ) {
			help_popup( w, htype, NULL );
			XmTextSetString( Help_w, ptr );
		} else {
			errno = 0;
			(void)xpmsg( w, "error: no help available" );
		}
		return;
	}

	if ( htype == HVERS ) {
		/*
		 * Help On Version is our greetings Dialog.
		 */
		InUse = True;
		PopUp = Hello( 0, NULL, NULL, 0 );
		return;
	}


	/*
	 * Index Help.
	 */
	if ( htype != HINDX ) {
		errno = 0;
		(void)xpmsg( w, "error: invalid help request" );
		return;
	}

	tot = max * size;
	Ntopic = 0;

	if ( First == True ) {
		/*
		 * Allocate memory for topics.
		 * We save them as both XmStrings
		 * and strings so that we can
		 * run string operations on them
		 * without conversion.
		 */
		XmTopics = (XmString *)XtMalloc( sizeof(XmString) * tot );
		Topics = (char **)XtMalloc( sizeof(char *) * max );

		/*
		 * Initialize history list.
		 */
		for( i = 0; i < MAXHIST; i++ )
			Hist[i] = -1;
	}

	/*
	 * Look up all topics from our
	 * resource database. It is assumed
	 * that the messages are numbered
	 * correctly, i.e, in ascending order.
	 */
	for( i = 0; i < max; i++ ) {

		/*
		 * Look up topic.
		 */
		if ( (ptr = GetRes( "*helpText%d", i )) == NULL )
			continue;

		/*
		 * Truncate if necessary.
		 */
		tot = strlen(ptr) >= size-1 ? size-1 : strlen(ptr);
		(void)strncpy( dbuff , ptr, tot );
		dbuff[tot] = '\0';

		/*
		 * Terminate first line.
		 */
		if ( (ptr = strchr( dbuff , '\n' )) == NULL )
			continue;
		*ptr = '\0';

		/*
		 * Extract Short Form.
		 */
		if ( (ptr = strchr( dbuff, ' ' )) == NULL )
			continue;
		*ptr++ = '\0';

		if ( ! *ptr )
			continue;

		if ( topic != NULL ) {
			/*
			 * Map the (char *) "topic" to
			 * the appropriate (int) htype.
			 */
			if ( ! strcmp( topic, dbuff ) ) {
				htype = Ntopic;
				topic = NULL;
			}
		}

		if ( First == True ) {
			/*
			 * Save the strings.
			 */
			XmTopics[Ntopic] =
			    XmStringCreateLtoR( ptr, XmSTRING_DEFAULT_CHARSET );
			Topics[Ntopic] = XtMalloc(size);
			(void)strcpy( Topics[Ntopic++], ptr );
		} else Ntopic++;
	}
	First = False;


	if ( ! Ntopic ) {
		errno = 0;
		(void)xpmsg( w, "error: no help available" );
		return;
	}


	if ( (InUse == True) && (Hindx == True) ) {
		/*
		 * Reuse existing popup.
		 */
		if ( topic == NULL ) {
			XmListSelectPos( List_w, htype+1, True );
			XmListSetPos( List_w, htype+1 );
		} else {
			(void)sprintf( dbuff, noHelp, topic );
			XmTextSetString( Help_w, dbuff );
		}
	} else {
		Hindx = True;
		help_popup( w, htype, topic );
	}
	
}


/*
 * Launch the Help Dialog.
 */
/*ARGSUSED*/
static void help_popup( Widget w, int hindx, char *topic )
{
	Widget frame_w, form_w, mdb_w;
	Widget act_w, tmp_w[6];
	char dbuff[1024];
	int n;
	Arg args[20];

	PopUp = CreateDialog( w, "helpWin" );
	InUse = True;

	n = 0;
        if ( XDefaultDepth( XtDisplay(GetTopWidget()), 0 ) == MONOCH ) {
		XtSetArg(args[n], XmNmarginWidth,	5); n++;
		XtSetArg(args[n], XmNmarginHeight,	5); n++;
		XtSetArg(args[n], XmNshadowThickness,	0); n++;
		XtSetArg(args[n], XmNborderWidth,	0); n++;
        }
	frame_w = XmCreateFrame( PopUp, "frameWin", args, n );

	n = 0;
	XtSetArg(args[n], XmNborderWidth, 1); n++;
	form_w = XmCreateForm( frame_w, "helpFormWin", args, n );

	n = 0;
	XtSetArg(args[n], XmNtopAttachment,	XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNlabelType, GetMdbPixmap() ? XmPIXMAP:XmSTRING);n++;
	XtSetArg(args[n], XmNlabelPixmap,	GetMdbPixmap()); n++;
	XtManageChild( (mdb_w=XmCreateLabel( form_w, "MDB", args, n )) );


        act_w = CreateActionArea( form_w, action_items,
                         XtNumber(action_items), NULL, NULL, &tmp_w[0], True );
	if ( hindx == HPRD ) {
		XtUnmanageChild(tmp_w[0]);
		XtUnmanageChild(tmp_w[1]);
		XtUnmanageChild(tmp_w[2]);
	}

	Back_w = tmp_w[1];
	Forw_w = tmp_w[2];

	if ( Hist[Histindx+1] == -1 )
		XtSetSensitive(Forw_w, False);

	n = 0;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment,	XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM); n++;
	XtSetValues( act_w, args, n );

	if ( hindx != HPRD ) {

		n = 0;
		XtSetArg(args[n], XmNtopAttachment,	XmATTACH_WIDGET); n++;
		XtSetArg(args[n], XmNtopWidget,		mdb_w); n++;
		XtSetArg(args[n], XmNleftAttachment,	XmATTACH_POSITION); n++;
		XtSetArg(args[n], XmNleftPosition,	1); n++;
		XtSetArg(args[n], XmNrightAttachment,	XmATTACH_POSITION); n++;
		XtSetArg(args[n], XmNrightPosition,	24); n++;
		XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_WIDGET); n++;
		XtSetArg(args[n], XmNbottomWidget,	act_w); n++;
		XtSetArg(args[n], XmNbottomOffset,	10); n++;
		XtSetArg(args[n], XmNitems,		XmTopics); n++;
		XtSetArg(args[n], XmNitemCount,		Ntopic); n++;
		XtSetArg(args[n], XmNlistSizePolicy,	XmCONSTANT); n++;
		XtSetArg(args[n], XmNselectionPolicy,	XmSINGLE_SELECT); n++;
		List_w = XmCreateScrolledList( form_w,
					"helptopicWin", args, n );
		AddHelp( List_w, "helptopicWin", QUICK );

		XtAddCallback( List_w, XmNsingleSelectionCallback,
			(XtCP)help1_cb, (XtPointer)GO );
		XtManageChild(List_w);
	} 

	n = 0;
	XtSetArg(args[n], XmNtopAttachment,	XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNtopWidget,		mdb_w); n++;
	XtSetArg(args[n], XmNleftAttachment,	XmATTACH_POSITION); n++;
	XtSetArg(args[n], XmNleftPosition,	hindx == HPRD ? 5 : 24); n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_POSITION); n++;
	XtSetArg(args[n], XmNrightPosition,	hindx == HPRD ? 95 : 99); n++;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNbottomWidget,	act_w); n++;
	XtSetArg(args[n], XmNbottomOffset,	10); n++;
	XtSetArg(args[n], XmNeditable,		False); n++;
	XtSetArg(args[n], XmNeditMode,		XmMULTI_LINE_EDIT); n++;
	XtSetArg(args[n], XmNscrollHorizontal,  False); n++;
	XtSetArg(args[n], XmNcursorPositionVisible, False); n++;
	XtSetArg(args[n], XmNhighlightOnEnter,	False); n++;
	XtSetArg(args[n], XmNtraversalOn,       False); n++;
	if ( hindx == HPRD ) {
		XtSetArg(args[n], XmNrows,	14); n++;
	}
	Help_w  = XmCreateScrolledText( form_w, "helpText", args, n );
	XtAddCallback( Help_w, XmNgainPrimaryCallback,
				(XtCP)help1_cb, (XtPointer)SELECT );
	AddHelp( Help_w, "helpText", QUICK );

	n = 0;
	XtSetArg(args[n], XmNtopAttachment,	XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNtopOffset,		5); n++;
	XtSetArg(args[n], XmNleftAttachment,	XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftOffset,	10); n++;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNbottomWidget, hindx == HPRD ? Help_w:List_w); n++;
	XtManageChild( XmCreateLabelGadget( form_w,
		hindx == HPRD ? "helpPrdInfoButton" : "helpIndexButton" ,
		args, n ) );

	if ( hindx == HINDX && topic == NULL )
		XmTextSetString( Help_w, helpHelp );
	else if ( hindx != HPRD ) {

		if ( topic != NULL ) {
			(void)sprintf( dbuff, noHelp, topic );
			XmTextSetString( Help_w, dbuff );
		} else {
			XmListSelectPos( List_w, hindx+1, True );
			XmListSetPos( List_w, hindx+1 );
		}

	}

	XtManageChild(Help_w);
	XtManageChild(form_w);
	XtManageChild(frame_w);

	MapDialog( w, PopUp, 0, 0 );
}

/*ARGSUSED*/
void help_close(Widget top)
{
	/*
	 * External close request.
	 */
	if ( (InUse && ! top) || (InUse && (PopUp == top)))
		help1_cb( NULL, QUIT, NULL );
}


/*ARGSUSED*/
void help1_cb( Widget w, int client_data, XmListCallbackStruct *cbs )
{

	char *ptr, *ptr1;
	int j;
	int i = 0;
	size_t len, len1;
	FILE *fd;

	if ( client_data == QUIT ) {

		if ( InUse == True ) {
			/*
			 * Any pending messages from
			 * lp must now be directed
			 * to the main window.
			 */
			if ( *Ppend == False )
				XtFree(Ppend);
			else
				*Ppend = False;

			InUse = False;
			DestroyDialog(PopUp);
		}

		Hindx = False;
		return;
	}

	if ( client_data == GO ) {
		int xr;
		/*
		 * The user has clicked
		 * on the list of topics.
		 */

		/*
		 * Set all Xrefs to False.
		 */
		for ( i = 0; i < MAXREFS; i++ )
			Xrefs[i].last = True;

		if ( Histindx > 1 )
			XtSetSensitive( Back_w, True );
		else
			XtSetSensitive( Back_w, False );

		if ( (Loghist == True) && (Histindx < MAXHIST) ) {

			if ( Hist[Histindx] !=  cbs->item_position ) {
				if ( Hist[++Histindx] != -1 ) {
				    /*
				     * Insert hist item.
				     */
	 			    for( i = 0; i < (MAXHIST-1)-Histindx; i++ )
				      Hist[(MAXHIST-1)-i] = Hist[(MAXHIST-2)-i];
	 			}
				Hist[Histindx] = cbs->item_position;
			}
		}

		if ( Histindx == MAXHIST )
			Histindx = 1;
		/*
		 * Get and display the message.
		 */
		ptr = &strchr( GetRes( "*helpText%d",
				cbs->item_position-1 ), '\n' )[1];
		len = strlen(ptr);

		XmTextSetString( Help_w, ptr );

		xr = 0;

		for ( i = 0; i < Ntopic; i++ ) {
			/*
			 * Look up all topics and examine
			 * the text so that a registered
			 * topic will be highlighted as
			 * a string to be clicked on.
			 */
			ptr1 = Topics[i];
			len1 = strlen(ptr1)-1;

			for( j = 0; j < len; j++ ) {

				if ( xr >= MAXREFS-1 )
					break;

				if ( ! strncmp( &ptr[j], ptr1, len1 ) ) {
					XmTextSetHighlight( Help_w, j, j+len1,
						XmHIGHLIGHT_SELECTED );
					/*
					 * Register a topic for
					 * the current page.
					 */
					Xrefs[xr].start = j;
					Xrefs[xr].end = j+len1;
					Xrefs[xr++].last = False;
					j += len1;
				}
			}
		}
		return;
	}

	if ( client_data == PRINT ) {
		char *prt;
		char *mpp;
		char *file;

		if ( (prt = GetPrinter()) == NULL ) {
			errno = 0;
			(void)xpmsg( PopUp, "error: %s", noPrt );
			return;
		}

		if ( (fd = fopen( file = GetTempFile(1), "w" )) == NULL ) {
			errno = 0;
			(void)xpmsg( PopUp, "error: open tmpfile" );
			return;
		}

		for( i = 0;; i++ ) {

			if ( (ptr = GetRes( "*helpText%d", i )) == NULL )
				break;

			/*
			 * Skip the Short Form.
			 */
			*(ptr1 = strchr( ptr, ':' )) = '\0';
			ptr = strchr( ptr, ' ' );
			*ptr1 = ':';

			(void)fwrite( ptr, sizeof(char), strlen(ptr), fd );

			(void)fprintf( fd, "\n\n" );
		}

		(void)fclose(fd);

		/*
		 * mp print command,
		 */
		if ( (mpp = GetRes( MPPAPER )) == NULL )
			mpp = MPA4;

		PrintCommand( PopUp, MPPRINT,
			prt, file, "mp -s Help -landscape", mpp, 1, Ppend );
		return;
	}

	if ( client_data == SELECT ) {

		XmTextPosition pos;
		char *start; int xr;
		Boolean found;
		/*
		 * The user has clicked on a
		 * reference to some other topic.
		 */

		/*
		 * We are using GetInsertionPosition
		 * instead of GetSelection since we
		 * may have to examine several words.
		 */
		XmTextClearSelection( w, CurrentTime );
		start = XmTextGetString(Help_w);
		pos = XmTextGetInsertionPosition(w);

		found = False;
		xr = 0;

		while( Xrefs[xr].last == False ) {
			/*
			 * Look up our topics for the
			 * curent screen and check if
			 * the cursor was within.
			 */
			for( i = 0; i < Ntopic; i++ ) {
				if ( ! strncmp( Topics[i],
						&start[Xrefs[xr].start],
						strlen(Topics[i])-1 ) ) {
					if ((pos >= Xrefs[xr].start)
						   && (pos <= Xrefs[xr].end)) {
						found = True;
						break;
					}
				}
			}
			if ( found )
				break;
			xr++;
		}
		XtFree(start);

		if ( found ) {
			/*
			 * This will trigger the
			 * list callback reoutine.
			 */
			XmListSelectPos( List_w, i+1, True );
			XmListSetPos( List_w, i+1 );
			XmTextSetInsertionPosition( Help_w, 0 );
		}
		return;
	}

	if ( client_data == PREV ) {
		Loghist = False;
		--Histindx;
		XmListSelectPos( List_w, Hist[Histindx], True );
		XmListSetPos( List_w, Hist[Histindx] );
		XmTextSetInsertionPosition( Help_w, 0 );
		if ( Histindx < 2 )
			XtSetSensitive(Back_w, False);
		Loghist = True;
		XtSetSensitive(Forw_w, True);
		return;
	}

	if ( client_data == NEXT ) {
		if ( Hist[Histindx+1] != -1 ) {
			Loghist = False;
			Histindx++;
			XmListSelectPos( List_w, Hist[Histindx], True );
			XmListSetPos( List_w, Hist[Histindx] );
			XmTextSetInsertionPosition( Help_w, 0 );
			Loghist = True;
			if ( Hist[Histindx+1] == -1  )
				XtSetSensitive(Forw_w, False);
		} else
			XtSetSensitive(Forw_w, False);
		return;
	}
}


/*
 * Direct Help On Context from <Help> or <F1>.
 */
/*ARGSUSED*/
void dhelp_cb( Widget w, char *client_data, XmAnyCallbackStruct *cbs )
{
	/*
	 * Launch the indexed help Dialog.
	 */
	help( w, HINDX, client_data );
}


/*
 * Quick Help On Context from <Help> or <F1>.
 */
/*ARGSUSED*/
void qhelp_cb( Widget w, String *help, XmAnyCallbackStruct *cbs )
{
	char type;

	/*
	 * Launch the Info Dialog as quick help.
	 */
	if ( InUse )
		w = PopUp;
	else  if ( XmIsRowColumn(XtParent(w)) == True ) {
		/*
		 * Avoid rowColumn as parent
		 * if we are in a menu.
		 */
		XtVaGetValues( XtParent(w), XmNrowColumnType, &type, NULL );
		if ( type == XmMENU_PULLDOWN )
			while ( XtIsWMShell( (w = XtParent(w)) ) == False );
	}
	(void)xpmsg( w, "info: %s", help );
}


/*
 * The help <F1> action to be registred.
 */
/*ARGSUSED*/
XtActionProc
help_action( Widget w, XEvent *event, String *args, Cardinal *num_args)
{
	char type;
	/*
	 * Warning: putting a breakpoint here may
	 * render a situation where the display
	 * is in a `System Modal State' when a
	 * menu pull down is `pulled down'. That
	 * is, we will loose the display completely.
	 */

	if ( XmIsRowColumn(w) == True ) {
		/*
		 * This is to handle a situation where
		 * we get a recursive call form the
		 * row-column widget when we have grabbed
		 * the display from a menu bar or an options meny.
		 */
		XtVaGetValues( w, XmNrowColumnType, &type, NULL );
		if ( type == XmMENU_BAR ) {

			help( w, HONC, NULL );
			/*
			 * Un-post the menu.
			 */
			XtCallActionProc(w,"MenuGadgetEscape", event, NULL, 0);
			return(0);
		}
		if ( type ==  XmMENU_PULLDOWN ) {

			help( w, HONC, NULL );
			/*
			 * Un-post the menu if the parent is
			 * not WMshell, i.e, the pull dowm
			 * is teared off.
			 */
			if ( XtIsWMShell(XtParent(w)) == False )
				XtCallActionProc( w,
					"MenuGadgetEscape", event, NULL, 0 );
			return(0);
		}
	}
	help( w, HONC, NULL );
	return(0);
}


/*
 * Apply help for a widget, explicit from the Help
 * dialog or from resource file (help == QUICK ).
 */
/*ARGSUSED*/
void AddHelp( Widget w, String name, String help )
{
	char *ptr, buff[80];

	(void)sprintf( buff, "*%s.help", name );

	if ( help != QUICK ) {
		XtAddCallback( w, XmNhelpCallback,
			(XtCP)dhelp_cb, (XtPointer)help );
	} else if ( (ptr = GetRes( buff )) != NULL ) {
		XtAddCallback( w, XmNhelpCallback,
			(XtCP)qhelp_cb, (XtPointer)ptr );
	}
}
