/*****************************************************************************

	gchange.c

	Environment:    Unix R40V3/Solaris2/Linux.


	Revision history:	@(#)gchange.c	1.9	97/06/23


	DESCRIPTION: Part of the Mdb Application.
			Launch the Global Change Dialog.

	SEE ALSO:	search.c, gsearch.c and callbacks.c.

        COPYRIGHT NOTICE:
        Permission to use,  copy,  modify,  and  distribute  this
        software  and  its    documentation   is  hereby  granted
        without fee, provided that  the  above  copyright  notice
        appear  in all copies and that both that copyright notice
        and  this  permission   notice   appear   in   supporting
        documentation.  The   author  makes  no   representations
        about   the   suitability   of   this  software  for  any
        purpose.  It  is  provided  "as  is"  without  express or
        implied warranty.

        THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD  TO  THIS
        SOFTWARE,    INCLUDING    ALL   IMPLIED   WARRANTIES   OF
        MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE AUTHOR
        BE  LIABLE  FOR  ANY  SPECIAL,  INDIRECT OR CONSEQUENTIAL
        DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS  OF
        USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
        NEGLIGENCE  OR  OTHER  TORTIOUS   ACTION,   ARISING   OUT
        OF   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
        SOFTWARE.

******************************************************************************/
/******************************************************************************/
#pragma ident "@(#)gchange.c      1.9		97/06/23"

#include "mdb.h"

/*
 * Externals.
 */
extern long	NextPos;
extern items	Item[];
extern Boolean	Fmode;

/*
 * Local variables.
 */
static Widget	PopUp;
static Widget	FieldLabel;
static Widget	OrgText;
static Widget	RepText;
static Widget	Wsens[10];
static Boolean	InUse = False;
static int	Field = 0;

/*
 * Forward declarations.
 */
static void
gchange1_cb(Widget w, int client_data, XmPushButtonCallbackStruct *cbs );

/*
 * The Main Action Area:
 *      LabelString:            Callback:       cbValue:        Sens:   Help:
 */
static ActionAreaItem action_items[] = {
	{ "nextButton",		(XtCP)gchange1_cb,	NEXT,	1,	HNE },
	{ "applyButton",	(XtCP)gchange1_cb,	APPL,	1,	HAP },
	{ "cancelButton",	(XtCP)gchange1_cb,	QUIT,	0,	HCA },
	{ "helpButton",		(XtCP)gchange1_cb,	HELP,	0,	QUICK },
};

#define UP	200
#define DN	201


/*
 * Called from this module,
 * callbacks.c and search.c
 */
/*ARGSUSED*/
Boolean GchSens( Boolean stat )
{
	/*
	 * Set sensitivity of buttons
	 * depending of the state the
	 * main screens item state, and
	 * the Write Protect state.
	 */
	int i = 0;

	if ( InUse == False )
		return(False);

	while( Wsens[i] != NULL )
		XtSetSensitive( Wsens[i++], stat );


	if ( stat == True ) {
		/*
		 * An valid item exist on
		 * the main screen. Copy contents.
		 */
		XmTextSetString( OrgText, xread(Field) );
		/*
		 * The `applyButton'.
		 */
		XtSetSensitive( Wsens[2], Fmode == True ? True : False );
	} else
		XmTextSetString( OrgText, "" );

	return(True);
}


/*ARGSUSED*/
static void
gchange1_cb(Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{

	char *ptr;
	XmString str;

	xpmsg_close();

	if ( client_data == QUIT ) {
		InUse = False;
		DestroyDialog(PopUp);
		return;
	}

	if ( client_data == HELP ) {
		help( PopUp, HINDX, HGC );
		return;
	}

	if ( client_data == APPL ) {
		/*
		 * Apply (save) change.
		 */
		ptr = XmTextGetString( RepText );
		xwrite( ptr, Field );
		XmTextSetString( OrgText, ptr );
		XtFree(ptr);
		save_cb(NULL, 0, NULL);
		copyp_cb( (Widget)NULL, APPL, NULL );
		return;
	}

	if ( client_data == NEXT ) {
		/*
		 * Go to next item. This is
		 * the same as pushing the
		 * `Search' button in the main
		 * action area.
		 */
		search_cb( NULL, 0, NULL );
		XmTextSetString( OrgText, xread(Field) );
		return;
	}

	/*
	 * Select previous field.
	 * Skip Key Items, and non TEXTW fields.
	 */
	if ( client_data == UP ) {

		Field--;

		for( ; ; Field-- ) {

			if ( Field < 0 )
				Field = GetMaxItems() -1;

			if ( Item[Field].type == TEXTW ) {
				if ( Field == GetKeyItem() || (GetSKeyItem() &&
						GetSKeyItem() == Field))
					continue;
				break;
			}
		}

	}

	/*
	 * Select next field.
	 * Skip Key Items, and non TEXTW fields.
	 */
	if ( client_data == DN ) {

		Field++;

		for( ; ; Field++ ) {
			if ( Field >= GetMaxItems()-1 )
				Field = 0;
			if ( Item[Field].type == TEXTW ) {
				if ( Field == GetKeyItem() || ( GetSKeyItem() &&
						GetSKeyItem() == Field))
					continue;
				break;
			}
		}

	}

	/*
	 * Update (as of UP/DN) the field lable title,
	 * as well as the contents of the text widget.
	 */
	str = XmStringCreateSimple( Item[Field].title);
	XtVaSetValues( FieldLabel, XmNlabelString, str, NULL );
	XmStringFree(str);

	XmTextSetString( OrgText, xread(Field) );

}


/*ARGSUSED*/
void gchange_close(Widget top)
{
	/*
	 * External close request.
	 */
	if ( (InUse && ! top) || (InUse && (PopUp == top)))
		gchange1_cb( NULL, QUIT, NULL );
}


/*
 * Launch teh Global Change Dialog.
 */
/*ARGSUSED*/
void gchange( Widget parent )
{

	Widget paned_w, form_w;
	Widget frame_w, rowcol_w;
	Widget tmp_w, lbl_w;
	int sens = 0;

	if ( InUse == True ) {
		(void)xpmsg( PopUp, "info: in use" );
		return;
	}

	/*
	 * Launch the Dialog.
	 */
	PopUp = CreateDialog( parent, "gchangeWin" );
	InUse = True;

	bzero( Wsens, sizeof(Wsens));

	paned_w = CreateRowColumn( PopUp, "gchangeRcWin", XmVERTICAL, 0 );

	form_w = XmCreateForm( paned_w, "formWin", NULL, 0 );

	frame_w = XtVaCreateManagedWidget( "frameGcWin",
		xmFrameWidgetClass,	form_w,
		XmNtopAttachment,	XmATTACH_FORM,
		XmNtopOffset,		5,
		XmNbottomAttachment,	XmATTACH_FORM,
		XmNbottomOffset,	5,
		XmNrightAttachment,	XmATTACH_FORM,
		XmNrightOffset,		5,
		XmNshadowType,		XmSHADOW_ETCHED_IN,
		NULL );

	rowcol_w = CreateRowColumn( frame_w, "rowcolWin", XmVERTICAL, 0 );
	XtManageChild(rowcol_w);
	Wsens[sens++] = rowcol_w;

	(void)CreateLabel( rowcol_w, "gcngFieldLabel" );

	tmp_w = XtVaCreateManagedWidget( "upArrow",
		xmArrowButtonGadgetClass,	rowcol_w,
		XmNarrowDirection,		XmARROW_UP,
		XmNhighlightThickness,		1,
		XmNhighlightOnEnter,		True,
		NULL );
	XtAddCallback( tmp_w, XmNactivateCallback,
			(XtCP)gchange1_cb, (XtPointer)UP );

	tmp_w = XtVaCreateManagedWidget( "dnArrow",
		xmArrowButtonGadgetClass,	rowcol_w,
		XmNarrowDirection,		XmARROW_DOWN,
		XmNhighlightThickness,		1,
		XmNhighlightOnEnter,		True,
		NULL );
	XtAddCallback( tmp_w, XmNactivateCallback,
			(XtCP)gchange1_cb, (XtPointer)DN );

	/*
	 * Find the first valid TEXTW
	 * as the default field title.
	 */
	Field = 0;
	while( ((Item[Field].type != TEXTW) && (Field < GetMaxItems())) ) {
			Field++;
		if ( Field == GetKeyItem() || (GetSKeyItem() &&
				GetSKeyItem() == Field) )
			Field++;
	}
	XtVaSetValues( FieldLabel = CreateLabel( form_w, Item[Field].title ),
		XmNtopAttachment,		XmATTACH_FORM,
		XmNtopOffset,			5,
		XmNleftAttachment,		XmATTACH_FORM,
		XmNwidth,			GetItemXLwidth(),
		XmNrecomputeSize,		False,
		XmNbottomAttachment,		XmATTACH_POSITION,
		XmNbottomPosition,		48,
		NULL );

	XtVaSetValues( OrgText = CreateText( form_w, "orgtxtWin", QUICK ),
		XmNtopAttachment,		XmATTACH_FORM,
		XmNtopOffset,			5,
		XmNleftAttachment,		XmATTACH_WIDGET,
		XmNleftWidget,			FieldLabel,
		XmNrightAttachment,		XmATTACH_WIDGET,
		XmNrightWidget,			frame_w,
		XmNrightOffset,			5,
		XmNbottomAttachment,		XmATTACH_POSITION,
		XmNbottomPosition,		48,
		XmNcolumns,			GetItemXTcolumns(),
		XmNeditable,			False,
		XmNcursorPositionVisible,	False,
		XmNhighlightOnEnter,		False,
		XmNtraversalOn,			False,
		NULL );

	XtVaSetValues( lbl_w = CreateLabel( form_w, "replaceLabel" ),
		XmNtopAttachment,		XmATTACH_POSITION,
		XmNtopPosition,			52,
		XmNbottomAttachment,		XmATTACH_FORM,
		XmNbottomOffset,		5,
		XmNleftAttachment,		XmATTACH_FORM,
		XmNwidth,			GetItemXLwidth(),
		NULL );

	XtVaSetValues( RepText = CreateText( form_w, "replaceLabel", QUICK ),
		XmNtopAttachment,		XmATTACH_POSITION,
		XmNtopPosition,			52,
		XmNbottomAttachment,		XmATTACH_FORM,
		XmNbottomOffset,		5,
		XmNleftAttachment,		XmATTACH_WIDGET,
		XmNleftWidget,			lbl_w,
		XmNrightAttachment,		XmATTACH_WIDGET,
		XmNrightWidget,			frame_w,
		XmNrightOffset,			5,
		NULL );

	tmp_w = CreateActionArea( paned_w, action_items,
		XtNumber(action_items), Wsens, &sens, NULL, True );

	XtManageChild(form_w);
	XtManageChild(paned_w);

	(void)GchSens( *xread( GetKeyItem() ) ? True : False );
		
	MapDialog( parent, PopUp, 0, 200 );

}
