/*****************************************************************************

	export.c

	Environment:    Unix R40V3/Solaris2/Linux.


	Revision history:	@(#)export.c	1.9	97/06/23


	DESCRIPTION: Part of the Mdb Application.
			Launch a file selection box to export
			the database in TAB or HTML address book
			format. Perform necessary international
			(Currently Swedish) character translation.

        COPYRIGHT NOTICE:
        Permission to use,  copy,  modify,  and  distribute  this
        software  and  its    documentation   is  hereby  granted
        without fee, provided that  the  above  copyright  notice
        appear  in all copies and that both that copyright notice
        and  this  permission   notice   appear   in   supporting
        documentation.  The   author  makes  no   representations
        about   the   suitability   of   this  software  for  any
        purpose.  It  is  provided  "as  is"  without  express or
        implied warranty.

        THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD  TO  THIS
        SOFTWARE,    INCLUDING    ALL   IMPLIED   WARRANTIES   OF
        MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE AUTHOR
        BE  LIABLE  FOR  ANY  SPECIAL,  INDIRECT OR CONSEQUENTIAL
        DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS  OF
        USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
        NEGLIGENCE  OR  OTHER  TORTIOUS   ACTION,   ARISING   OUT
        OF   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
        SOFTWARE.

******************************************************************************/
/******************************************************************************/
#pragma ident "@(#)export.c      1.9		97/06/23"

#define EXPORT
#include "mdb.h"


/*
 * Local Variables.
 */
static Widget	PopUp;
static Widget	Fs_w[2];
static Widget	FiltText;
static Widget	FFiltText;
static Widget	FrmText;
static Boolean	InUse = False;

#define TAB	455
#define HTM	456

/*
 * addrHtml: Format a Netscape HTML address book record.
 *
 * Rerurns; -1 error, -2 skip item - get next, -3 record done.
 */
/*ARGSUSED*/
static int addrHtml( int item, char *buf, FILE *ofd, int *first )
{

	char *ptr;
	char *ptr1;
	size_t cnt;
	int i;

	static struct mailUser {
		char	NickName[200];
		char	Name[200];
		char	Email[200];
		char	Desc[400];
	} mu;

	static struct mailFormat {
		int	na;
		int	em;
		int	de0;
		int	de1;
		int	done;
	} au;

	if ( *first ) {
		*first = 0;

		/*
		 * Print header.
		 */
		if ( (ptr = getenv( "LOGNAME")) == NULL )
			ptr = "Mdb";

		ptr1 = db_foldername();

		if ( fprintf( ofd, HREC, ptr, ptr1,  ptr, ptr1 )  < 0 )
			return(-1);

		/*
		 * Get the text item with
		 * mail address.
		 */
		if ( (au.em  = GetMailItem()) < 0 ) {
			errno = EINVAL;
			return(-1);
		}

		/*
		 * Obtain the resource files's format string
		 * and convert to int.
		 */
		(void)sscanf( GetMailFormat(),
			      "%d %d %d", &au.na, &au.de0, &au.de1 );

		if ( ! (au.na + au.de0 + au.de1) ) {
			errno = EINVAL;
			return(-1);
		}
	}

	if ( ! item ) {
		au.done = 0;
		mu.Desc[0] = '\0';
	}

	if ( item == au.na ) {

		/*
		 * Collect the items.
		 */
		au.done++;
		if ( (ptr = strchr( buf , ' ' )) == NULL ) {
			(void)strcpy( mu.NickName, buf ); 
			(void)strcpy( mu.Name, buf ); 
		} else {
			(void)strcpy( mu.Name, buf );
			*ptr = '\0';
			(void)strcpy( mu.NickName, buf );
		}

		/*
		 * Uncase nick-name.
		 */
		cnt = strlen( mu.NickName );
		for ( i = 0; i < cnt; i++ )
			mu.NickName[i] = (int)tolower( mu.NickName[i] );

	} else if ( item == au.em ) {

		au.done++;

		/*
		 * Must have an E-mail address.
		 * If not it won't be exported.
		 */
		if ( !*buf ) {
			au.done = 0;
			return(-2);
		}
		(void)strcpy( mu.Email, buf ); 

	} else if ( item == au.de0 ) {

		au.done++;
		(void)strcat( mu.Desc, buf ); 

	} else if ( item == au.de1 ) {

		au.done++;
		if ( *buf ) {
			(void)strcat( mu.Desc, ", " );
			(void)strcat( mu.Desc, buf ); 
		}
	}

	if ( au.done == (sizeof(struct mailFormat) / sizeof(int)) - 1 ) {

		au.done = 0;
		
		/*
		 * Print the collected items.
		 */
		if ( fprintf( ofd, NREC, mu.Email,
				mu.NickName, mu.Name, mu.Desc ) < 0 )
				return(-1);
		return(-3);
	}

	return(0);
}

/*
 * Export callback.
 */
/*ARGSUSED*/
static void
export_cb( Widget w, int client_data, XmFileSelectionBoxCallbackStruct *cbs)
{

	int i, pos, lgth, j;
	long next = 0;
	int fatal = 0;
	int intr = 0;
	int tot = 0;
	int stat = 0;
	static int first = 1;
	long val = 0;
	Boolean html = FALSE;
	char *file, *path;
	char *filt = NULL;
	char *ptr;
	char *fmt;
	char dbuff[1024];
	XmString str;
	FILE *ofd, *ifd;

	if ( client_data == TAB ) {
		if ( XmToggleButtonGadgetGetState(w) ) {
			(void)strcpy( dbuff, ptr = XmTextGetString(FFiltText) );
			XtFree(ptr);
			ptr = strrchr( dbuff, '/' );
			(void)strcpy( ++ptr, "*.tab" );
			XmTextSetString( FFiltText, dbuff );
			str = XmStringCreateSimple( dbuff );
			XmFileSelectionDoSearch( PopUp, str );
			XmStringFree(str);
		}
		return;
	}

	if ( client_data == HTM ) {
		if ( XmToggleButtonGadgetGetState(w) ) {
			if ( GetMailItem() < 0 ) {
				errno = 0;
				(void)xpmsg( PopUp,
					     "error: no mail item defined" );
			}
			(void)strcpy( dbuff, ptr = XmTextGetString(FFiltText) );
			XtFree(ptr);
			ptr = strrchr( dbuff, '/' );
			(void)strcpy(++ptr, "*.html" );
			XmTextSetString( FFiltText, dbuff );
			str = XmStringCreateSimple( dbuff );
			XmFileSelectionDoSearch( PopUp, str );
			XmStringFree(str);
		}
		return;
	}

	if ( client_data != OK )
		return;

	if ( ! XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &path) )
		return;

	if ( (file = strrchr(path, '/')) == NULL )
		file = path;
	else
		file++;
	/*
	 * Obtain the export option.
	 */
	for( i = 0; i < 2; i++ ) {
		XtVaGetValues( Fs_w[i], XmNset, &val, NULL );
		if ( val )
			break;
	}

	if ( i == 1 )
		html = TRUE;
 
	if ( (ofd = fopen( path, "w" )) == NULL ) {
		file = *file ? file : path;
		(void)xpmsg( PopUp, "error: %s", file );
		XtFree(path);
		return;
	}

	fmt = XmTextGetString( FrmText );

	ptr = XmTextGetString( FiltText );
	if ( strlen( ptr ) )
		filt = ptr;

	if ( ( ifd = db_itemlist( NULL, filt, 0, &i )) == NULL ) {
		(void)xpmsg( PopUp, "error: open itemlist" );
		(void)fclose(ofd);
		XtFree(path);
		XtFree(ptr);
		XtFree(fmt);
		return;
	}

	XtFree(ptr);

	db_silent(True);

	(void)xpmsg( PopUp, "work: Please Wait..." );
	Wait(1);

	while( fgets( dbuff, sizeof(dbuff), ifd ) != NULL ) {

		if ( CheckForInterrupt(30) ) {
			intr++;
			break;
		}

		setitem( dbuff );

		if ((pos = db_access( DB_READ, next, &next, DB_EXACT)) == -1) {
			fatal = errno;
			break;
		}

		if ( ! pos ) {
			fatal = errno;
			break;
		}

		for( i = 0; i < GetMaxItems(); i++ ) {

			if ( Valid( i, fmt ) )
				continue;

			ptr = xread( i );

			if ( html )
				lgth = 0;
			else
				lgth = strlen(ptr);


			/*
			 * Swedish character translation.
			 */
			for( j = 0; j < lgth; j ++ ) {

				switch( (unsigned char)ptr[j] ) {
				   case aring:     ptr[j] = Maring;     break;
				   case adieresis: ptr[j] = Madieresis; break;
				   case odieresis: ptr[j] = Modieresis; break;
				   case Aring:     ptr[j] = MAring;     break;
				   case Adieresis: ptr[j] = MAdieresis; break;
				   case Odieresis: ptr[j] = MOdieresis; break;
				   case eax:       ptr[j] = Meax;       break;
				   case '\n': ptr[j] = VT;  break;
				}

			}

			if ( html ) {
				if ( ( stat = addrHtml( i, ptr,
						ofd, &first )) == -1 ) {
					fatal = errno;
					break;
				} else if ( stat == -2 ) break;
				  else if ( stat == -3 ) { tot++; break; }
			} else {
				if ( fprintf( ofd, "%s\t", ptr ) < 0 ) {
					fatal = errno;
					break;
				}
			}
		}

		if ( fatal )
			break;

		if ( ! html ) {
			(void)fprintf( ofd, "\n" );
			tot++;
		}
	}

	db_silent(False);

	(void)xpmsg( PopUp, "work:" );

	if ( html )
		(void)fprintf( ofd, EREC );

	if ( fatal ) {
		errno = fatal;
		(void)xpmsg( NULL, "error: %s deleted", file );
		(void)unlink(path);
	} else {
		(void)sprintf( dbuff, "info: %d items exported", tot );
		if ( intr )
			(void)strcat( dbuff, "\n- INTERRUPTED" );
		(void)xpmsg( NULL, dbuff );
	}

	if ( ! tot )
		(void)unlink(path);

	(void)fclose(ifd);
	(void)fclose(ofd);
	XtFree(fmt);
	XtFree(path);
	InUse = False;
	XtDestroyWidget(PopUp);
}



/*ARGSUSED*/
static void
export_cancel_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{
	InUse = False;
	XtDestroyWidget(PopUp);
}

/*ARGSUSED*/
void export_close(Widget top)
{
	/*
	 * External close request.
	 */
	if ( (InUse && ! top) || (InUse && (PopUp == top)))
		export_cancel_cb( NULL, QUIT, NULL );
}

/*
 * Launch a file selection box with added filter and format text widgets.
 */
/*ARGSUSED*/
void export( Widget parent )
{

	Widget rowcol, rowcol1;
	int n;
	Arg args[10];

	if ( InUse == True ) {
		(void)xpmsg( PopUp, "info: in use" );
		return;
	}
	InUse = True;

	if ( ! db_folderitems() ) {
		(void)xpmsg( parent, "info: nothing to export" );
		return;
	}

	PopUp = XmCreateFileSelectionDialog( parent, "exportWin", NULL, 0);

	XtAddCallback( PopUp,
		XmNokCallback, (XtCP)export_cb, (XtPointer)OK );

	XtAddCallback( PopUp,
		XmNcancelCallback, (XtCP)export_cancel_cb, NULL );

	AddHelp( PopUp, "", HEX );

	AddHelp( XmFileSelectionBoxGetChild( PopUp,
		XmDIALOG_CANCEL_BUTTON ), "", HCA );

	AddHelp( XmFileSelectionBoxGetChild( PopUp,
		XmDIALOG_OK_BUTTON ), "", HOK );

	AddHelp( XmFileSelectionBoxGetChild( PopUp,
		 XmDIALOG_HELP_BUTTON ), "helpButton", QUICK );
	/*
	 * Could not find the Filter Button ??.
	 */
	FFiltText = XmFileSelectionBoxGetChild(PopUp, XmDIALOG_FILTER_TEXT);

	rowcol =  CreateRowColumn( PopUp, "exportFWin", XmVERTICAL, 0 );

	XtManageChild( rowcol );

	n = 0;
	XtSetArg( args[n], XmNspacing,		8 ); n++;
	XtSetArg( args[n], XmNborderWidth,	1 ); n++;
	XtSetArg( args[n], XmNorientation,	XmHORIZONTAL ); n++;
	rowcol1 = XmCreateRadioBox( rowcol,	"importRWin", args, n );
	XtManageChild(rowcol1);

	Fs_w[0] = CreateToggleButton( rowcol1,
			"exportMdb", (XtCP)export_cb, TAB, QUICK );
	Fs_w[1] = CreateToggleButton( rowcol1,
			"exportEmail", (XtCP)export_cb, HTM, QUICK );

	XtVaSetValues( Fs_w[0], XmNset, True, NULL );

	XtVaSetValues( Fs_w[0], XmNhighlightOnEnter, True, NULL );
	XtVaSetValues( Fs_w[1], XmNhighlightOnEnter, True, NULL );

	(void)CreateLabel( rowcol, "exportFilter" );
	FiltText = CreateText( rowcol, "nameFilter", QUICK );

	(void)CreateLabel( rowcol, "formatLabel" );
	FrmText = CreateText( rowcol, "formatText", HFR );

	XtManageChild( PopUp );
}
