/*****************************************************************************

	diaTmpl.c

	Environment:    Unix R40V3/Solaris2/Linux.

	Revision history:	@(#)diaTmpl.c	1.9	97/06/23


	DESCRIPTION: Part of the Mdb Application.
			Template to add new Dialogs to mdb.


        COPYRIGHT NOTICE:
        Permission to use,  copy,  modify,  and  distribute  this
        software  and  its    documentation   is  hereby  granted
        without fee, provided that  the  above  copyright  notice
        appear  in all copies and that both that copyright notice
        and  this  permission   notice   appear   in   supporting
        documentation.  The   author  makes  no   representations
        about   the   suitability   of   this  software  for  any
        purpose.  It  is  provided  "as  is"  without  express or
        implied warranty.

        THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD  TO  THIS
        SOFTWARE,    INCLUDING    ALL   IMPLIED   WARRANTIES   OF
        MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE AUTHOR
        BE  LIABLE  FOR  ANY  SPECIAL,  INDIRECT OR CONSEQUENTIAL
        DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS  OF
        USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
        NEGLIGENCE  OR  OTHER  TORTIOUS   ACTION,   ARISING   OUT
        OF   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
        SOFTWARE.

******************************************************************************/
/******************************************************************************/
#pragma ident "@(#)diaTmpl.c      1.9		97/06/23"

#include "mdb.h"

/*
 * Local Variables.
 */
static Widget	PopUp;
static Boolean	InUse = False;

/*
 * Forward declarations.
 */
static void
diaTmpl_cb(Widget w, int client_data, XmPushButtonCallbackStruct *cbs );

/*
 * The Main Action Area:
 *	LabelString:		Callback:	cbValue:	Sens:	Help:
 */
static ActionAreaItem action_items[] = {
	{ "okButton",		(XtCP)diaTmpl_cb,	GO,	0,	HOK },
	{ "cancelButton",	(XtCP)diaTmpl_cb,	QUIT,	0,	HCA },
	{ "helpButton",		(XtCP)diaTmpl_cb,	HELP,	0,	QUICK },
};



/*
 * The diaTmpl Dialog's Main Entry Point.
 */
/*ARGSUSED*/
void diaTmpl( Widget parent )
{

	Widget paned_w;
	Arg args[10];
	int n;

	if ( InUse == True ) {
		(void)xpmsg( PopUp, "info: in use" );
		return;
	}

	/*
	 * Create an unmapped Dialog Shell.
	 * The shell's "WM_DELETE_WINDOW" will
	 * go through callbacks.c's "close_cb()",
	 * so we should have an entry there
	 * that tie us to our "diaTmpl_close()"
	 * procedure. "PopUp" is our Bulletin
	 * Board to build our stuff on.
	 */
	PopUp = CreateDialog( parent, "diaTmplWin" );
	InUse = True;

	/*
	 * Create our main pane.
	 */
	paned_w = XmCreatePanedWindow( PopUp, "panedWin", NULL, 0 );


	/*
	 * Add stuff here .....
	 */



	/*
	 * Add the Action Area last.
	 */
	(void)CreateActionArea( paned_w, action_items,
		XtNumber(action_items), NULL, 0, NULL, False );



	/*
	 * Manage and Realize this Dialog.
	 */
	XtManageChild(paned_w);

	/*
	 * Map and set geometry relative
	 * our parent. X = Y = 0, means
	 * centered position.
	 */
	MapDialog( parent, PopUp, /*X*/ 0, /*Y*/ 140 );

}


/*
 * Action Callbacks.
 */

/*ARGSUSED*/
static void
diaTmpl_cb(Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{

	/*
	 * Take down any error Dialog.
	 */
	xpmsg_close();

	/*
	 * Dismiss this Dialog.
	 */
	if ( client_data == QUIT ) {
		InUse = False;
		DestroyDialog(PopUp);
		return;
	}

	/*
	 * Provide Help for this Dialog.
	 */
	if ( client_data == HELP ) {
		help( PopUp, HINDX, "HLP" );
		return;
	}

	/*
	 * The Primary Action.
	 */
	if ( client_data == GO ) {

		return;

	}
}


/*
 * External close request.
 */
void diaTmpl_close(Widget top)
{
	if ( (InUse && ! top) || (InUse && (PopUp == top)))
		diaTmpl_cb( NULL, QUIT, NULL );
}
