/*
 *******************************************************************************************
 *******************************************************************************************
    Copyright (C) 1995   Michael J. Oehler

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 Module Description:
    This file contains a single character constant array which holds a postscript
    program. The program is copied to a file, "mcard.ps" in the current working
    directory when the "Print" command is selected. "Print" then forks "lpr"
    submitting this program to the postscript printer.

 *******************************************************************************************
 *******************************************************************************************
*/

#ifndef PS_PROGRAM_H_ALREADY
#define PS_PROGRAM_H_ALREADY

static char postscript_prog[] = {
"%!\n\
% Variables\n\
/inch { 72 mul } def\n\
/fontsize 12 def\n\
/space fontsize 2 idiv def\n\
/linethick 4 def\n\
/index_lines 1 def\n\
/adrlines 10 def\n\
\n\
% Pick a font & set its size\n\
/Times_Roman findfont\n\
fontsize scalefont\n\
setfont\n\
\n\
%  To determine the width of the box, do not assume its equal 40 * fontsize\n\
%  Use the stringwidth operator.\n\
%  Determining the actual width for any selected font. Then add extra spacing\n\
/width  (1234567890123456789012345678901234567890) stringwidth pop def\n\
/width   width fontsize 2 mul add def\n\
\n\
% Calculate the overal height of a card. Incorporate index, line\n\
%  thickness, font height, and spacing between lines\n\
/height  fontsize space add adrlines mul linethick 2 mul add def\n\
/midpt height linethick fontsize space add add sub def\n\
\n\
% vertical position is off the paper here, adjusted latter.\n\
/hpos 1 inch def\n\
/vpos 8 inch height add def\n\
\n\
% Procedure:   newline\n\
% Description: Simulates a CR by charging the vpos coordinate\n\
/newline\n\
{ /adrtop adrtop fontsize sub def\n\
 hpos fontsize add adrtop moveto } def\n\
\n\
% Procedure: new_page\n\
%  Re-loads the top of the page constants\n\
/new_page\n\
{\n\
/posx hpos def\n\
/posy vpos def\n\
} def\n\
\n\
% Procedure: coordinates\n\
%\n\
/coordinates\n\
{\n\
/posy posy height 25 add sub def\n\
/index_position posy height fontsize sub add def\n\
/adrtop posy midpt fontsize space add sub add def\n\
posx posy\n\
} def\n\
\n\
/goto_index\n\
{\n\
hpos fontsize add index_position moveto\n\
} def\n\
\n\
/goto_address\n\
{\n\
hpos fontsize add adrtop moveto\n\
} def\n\
\n\
% Procedure: box\n\
%    This procedure requires the x y coordinates\n\
%    to start the box.\n\
/box\n\
 { newpath\n\
   moveto\n\
   width 0  rlineto\n\
   0 height fontsize add rlineto            % add index height to box\n\
   -1 width mul 0 rlineto\n\
   closepath\n\
   0 midpt rmoveto\n\
   width 0 rlineto\n\
   stroke\n\
 } def\n\
\n\
\n\
%  CODE\n\
linethick setlinewidth\n\
\n\
% User specific Indexs & Addresses below here\n\
\n\
"
};

#endif