/*
  ************************************************************************
  ************************************************************************
    Copyright (C) 1995   Michael J. Oehler

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 Module Description:

  ************************************************************************
  ************************************************************************
*/


#include "crd.h"


/*
  ************************************************************************
  ************************************************************************
   Name:
     Left_Arrow_Callback
   Purpose:
     Under Card View -> Advance to the next card.
     Under List View -> Advance to the next selected item.
   Calling Sequence:
     Only called when the left arrow is pressed.
 
   Description:

  ************************************************************************
  ************************************************************************

*/
extern void Left_Arrow_Callback(widget, client_data, cbs)
Widget widget;
XtPointer client_data;
XmArrowButtonCallbackStruct *cbs;
{

/* Card View -> move to next card. List View -> Move selection */
     if (head_ptr->card_view) {
	 Grab_Primary_Card_Data(widget);
	 /* Align user data with displayed data */
	 head_ptr->primary_card = head_ptr->primary_card->prior;
	 Redraw_List();
     }
     else 
     {   /* Executed when in "List" View */
	 int *pos_list, pos_cnt, position;
	 
	 if (XmListGetSelectedPos(head_ptr->scroll, &pos_list, &pos_cnt) ) 
	 {
	     position = ((int) *pos_list == 1) ? head_ptr->cards : *pos_list -1;
	     XmListSelectPos(head_ptr->scroll, position, False);
	     XtFree((char *) pos_list);
	     /* Align user data with displayed data */
	     head_ptr->primary_card = head_ptr->primary_card->prior;
	 }
	 
     }
     

} /* end Left_Arrow_Callback */


/*
  ************************************************************************
  ************************************************************************
   Name:
     Right_Arrow_Callback
   Purpose:

   Calling Sequence:

   Description:

  ************************************************************************
  ************************************************************************
*/
extern void Right_Arrow_Callback(widget, client_data, cbs)
Widget widget;
XtPointer client_data;
XmArrowButtonCallbackStruct *cbs;
{

/* Card View -> move to next card. List View -> Move selection */
     if (head_ptr->card_view) {
	 Grab_Primary_Card_Data(widget);
	 /* Align user data with displayed data */
	 head_ptr->primary_card = head_ptr->primary_card->next;
	 Redraw_List();
     }
     else 
     {
	 int *pos_list, pos_cnt, position;
	 
	 if (XmListGetSelectedPos(head_ptr->scroll, &pos_list, &pos_cnt) ) 
	 {
	     position = ((int) *pos_list == head_ptr->cards) ? 1 : *pos_list +1;
	     XmListSelectPos(head_ptr->scroll, position, False);
	     XtFree((char *) pos_list);
	     /* Align user data with displayed data */
	     head_ptr->primary_card = head_ptr->primary_card->next;
	 }
     }
     
} /* end Right_Arrow_Callback */



/*
  ************************************************************************
  ************************************************************************
  Name:
     Active_Card_Callback

  Purpose:
     Determines which card was selected (ie, clicked on) and 
     Brings the selected card to the primary card position where it can
     be fully viewed

  Calling Sequence:
     1. This rotuine was established as a callback in Make_Card() see init.c
     2. Called when the user clicks in the index or address widget
	Note, the index & address are in backgrounded "card widget"s.
        Specifically, a "card widget" is a form widget, surrounded by
        a frame, with 2 text widgets, called index & address.
	I refer to the primary and background "card widgets" frequently.

     Description:
      1. Search for the calling card.
      2. Count how many back it is from the primary card (from the front)
      3. Go forward that many elements in the user data linked list
      4. Prepare the pointers in the head_ptr data structure
      5. Go redraw the list

  ************************************************************************
  ************************************************************************
*/
extern void Active_Card_Callback(widget, client_data, event)
Widget widget;
XtPointer client_data;
XConfigureEvent *event;
{
Widget parent;
Card_Content_Ptr tmp_ptr;
Card_Ptr user_data;
char *char_ptr;
int i;

/*
   The parent of the index or address widget is a form, and its parent
   is the frame widget which is stored in the Card_Content structure.
   The idea is to look for just one widget in the comparison & not
   two (ie, the callback can be made by either the index or address
   widget.
*/
 parent = XtParent(widget);
 parent = XtParent(parent);
/*
   Save the user's data by updating the primary card (the primary card is
   the one at the front of the screen, only one fully viewable, and the
   only one that is editable.
*/
Grab_Primary_Card_Data(widget);

/*
 Search the link list of viewable cards to find which one called the routine.
 Synchronize the data pointed at by "primary_card" as we move along the linked
 list. Set our primary_card pointer to the selected user data too!
 */
  tmp_ptr = head_ptr->viewable_cards->next;
  user_data = head_ptr->primary_card->next;
     for (i = head_ptr->visible_spots; tmp_ptr->form != parent; i--) {
       if (!i)
         Abend(widget,-1,"Could not make contact\n");

       tmp_ptr = tmp_ptr->next;
       user_data = user_data->next;
     }
head_ptr->primary_card = user_data;

/* Go display the updated card data */
     Redraw_List();

/*
  ************************************************************************
  This is the spot to change keyboard focus. ie, the user clicked a card
  Active_Card_Callback brought the card info to the front, but the selected
  (highlighted/blackened) widget is in  the back! What a pain.

   All ideas to change this have failed! These do not work:

 init.c: XtAddCallback(address, XmNfocusCallback, Change_Focus_Callback, NULL);
 x = XmProcessTraversal(widget,XmTRAVERSE_NEXT_TAB_GROUP);
 x = XmProcessTraversal(head_ptr->viewable_cards->index,XmTRAVERSE_CURRENT);
 XmTextSetInsertionPosition(head_ptr->viewable_cards->index,
 XmTextGetInsertionPosition(head_ptr->viewable_cards->index));

  ************************************************************************
Change_Focus_Callback(can't figure this out)

*/

} /* end Active_Card_Callback */


extern void Change_Focus_Callback(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XmAnyCallbackStruct call_data;
{
Boolean x;

x = XmProcessTraversal(head_ptr->viewable_cards->index,XmTRAVERSE_CURRENT);

x = XmProcessTraversal(widget,XmTRAVERSE_CURRENT);

}
