/*
  ************************************************************************
  ************************************************************************

    Copyright (C) 1995   Michael J. Oehler

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


    Yet Another Great Program by:   Michael J. Oehler

    Date of Modifications:          May 95

    Program Name:                   mcard, the "Motif CardFile"          

    Version:                        version 1.2 lite

    Program Description:            An address organizer using Motif

    References:
	C, Kernighan & Ritchie
	Advanced Window Applications Programming, Johnson & Reichard
	X Window System Programming, Naba Barkakati
	Motif Programming Manual for OSF/Motif Version 1.1, Dan Heller
	Unix Network Programming, W. Richard Stevens
	Dr. Dobbs Journal, The Bitmap Format, March & May 1995

    Program Methodology:
     There is extensive use of the Motif Library, the XtIntrinics, and Xlib 
     in this program.  Great attempt has been made to make it extensible with
     foreign languages, see the resource file, Mcard

  ************************************************************************
  ************************************************************************
*/


/* System Includes */
#include <signal.h>

/* Local Includes: crd.h has the data structures needed by this app. */
#define GLOBAL_VARIABLES
#include "crd.h"


/* External Routines are made visible to the main routine here */
#ifdef __STDC__

void		Sigint_Handler( void );
		/* init.c */
extern      Widget		Interface_Initialization(int *, char **, Widget *, XtAppContext *);
extern      List_Ptr		Make_Card( void );
		/* abend.c */
extern      void		Exit_Program( void );
extern      void		Child_Check( void );
extern	    char *		Parse_Arguments(int *, char **);
                /* file_io.c */
extern int Get_CRD_File(char *);
                /* file_callback.c */
extern void Open_File(char *, int);


#else
extern      Widget               Interface_Initialization();
extern      List_Ptr             Make_Card();
	void                 Sigint_Handler();
extern      void                 Exit_Program();
extern      void                 Child_Check();
extern	    char *		 Parse_Arguments();
extern	    int			 Get_CRD_File();
extern	    void		 Open_File();

#endif

main(argc,argv)
int	argc;
char	*argv[];
{

Widget main_widget;

/* This routine establishes the interface and all its widgets */
	Interface_Initialization(&argc, argv, &main_widget, &app);

/* Now that the interface is set, Make the "card widgets" & needed data structs */
        Make_Card();

/* Parse anything remaining in argv & argc for validity */
        if ( argc > 1)
	{
	    head_ptr->file_name = Parse_Arguments(&argc, argv);
	    if (argc > 1)
		    Create_Error_Prompt("Command_Line_Error");
	}

/*
 Catch the SIGINT (^C), SIGKILL (kill process), and SIGQUIT (quit process) signal.
 Call the exit routine to release data structures.
 The signal handler isn't installed until after the data structres allocated.
 signal always returns the previous value assigned to the signal.
 The test to see if any prior signal handler was installed is a bit redundant.
*/
if (signal(SIGINT, SIG_IGN) != SIG_IGN)
    signal(SIGINT, ( void (*)() ) Sigint_Handler);

if (signal(SIGTERM, SIG_IGN) != SIG_IGN)
    signal(SIGTERM, ( void (*)() ) Sigint_Handler);

if (signal(SIGQUIT, SIG_IGN) != SIG_IGN)
    signal(SIGQUIT, ( void (*)() ) Sigint_Handler);

/*
 The previously created: One visible "card widget", 2 arrows, & the menu bar.
 This is the smallest the application can get. Eventually, this program
 should be notified on "resizing" and re-calculated the maximum number of
 "card widgets" to be seen. Right now, it's fixed to 7 "card widgets"
XtAddEventHandler(main_widget, StructureNotifyMask, False,
		Configure_Minimum_Size_Callback,NULL);
*/
     XtVaSetValues(main_widget,
		XmNminHeight,		head_ptr->index_height,
		XmNminWidth,		head_ptr->index_width,
		NULL);

/* Everything has been defined, Lets draw the widgets to the screen */
	XtRealizeWidget(main_widget);

/* Go get the input cardfile if needed.
   XtAddAppInput() isn't needed
   Must call XtRealizeWidget() first before doing this!
   0 specifies an "Open" vs. a "Merge" Operation.
*/
if (head_ptr->file_name)
{
/* No need to call Release_Cards() now! */
    Open_File(head_ptr->file_name,0);
}

/* Activate the Event handlers */
	XtAppMainLoop(app);

} /* end main */



/*
  ************************************************************************
  ************************************************************************
  Name:
     Sigint_Handler

  Purpose:
     Catches the SIGINT, SIGKILL, SIGQUIT & prepares for program termination.
     Signal handler that is friendly to the X event handler,
     No Squashed X protocol packets!

  Calling Sequence:
     main() see mcard.c established that this routine be called
     when the signals ocurr.
     The routine is located here because the app (XtAppContext)
     variable is accessible.

  Description:
     1. Arrive from a signal
     2. Tell the X server that Exit_Program() should be executed, ASAP.

  ************************************************************************
  ************************************************************************
*/
void Sigint_Handler()
{
XtAppAddTimeOut(app, 0, (XtTimerCallbackProc) Exit_Program, NULL);

} /* end Sigint_Handler */


/*
  ************************************************************************
  ************************************************************************
  Name:
         Child_Termination

  Purpose:
     Catch SIGCLD, child termination.
     Signal handler that is friendly to the X event handler.
     No Squashed X protocol packets!

  Calling Sequence:
     Print() see file_callback.c, establishes this signal handler.
     The routine is located here because the app (XtAppContext)
     variable is accessible.

  Description:
     This routine is an X Server friendly Signal handler!
     Do not handle signals directly!

  ************************************************************************
  ************************************************************************
*/
extern void Child_Termination()
{
XtAppAddTimeOut(app, 0, (XtTimerCallbackProc) Child_Check, NULL);
} /* end Child_Termination */
