/*
 **************************************************************************
 **************************************************************************
    Copyright (C) 1995   Michael J. Oehler

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 Module Description:


 **************************************************************************
 **************************************************************************   
*/


/*
crd.h is a Local Includes which has all data structures needed.
This is also where Xm/Xm.h is brought in.
*/
#include "crd.h"

#include <Xm/ArrowBG.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/DialogS.h>
#include <Xm/DrawingA.h>
#include <Xm/Form.h>
#include <Xm/FileSB.h>
#include <Xm/Label.h>
#include <Xm/MainW.h>
/* #include <Xm/RowColumn.h> */
/* #include <Xm/Scale.h> */
#include <Xm/SelectioB.h>
#include <Xm/Separator.h>
#include <Xm/TextF.h>
#include <Xm/Text.h>
#include <Xm/PushB.h>
#include <Xm/Frame.h>

#include "mcard.icon"

#ifdef __STDC__

			/* move_callback.c */
extern	void	Active_Card_Callback(Widget, XtPointer, XConfigureEvent);
extern	void	Left_Arrow_Callback(Widget,  XtPointer, XmArrowButtonCallbackStruct);
extern	void	Right_Arrow_Callback(Widget, XtPointer, XmArrowButtonCallbackStruct);

			/* search_callback.c */
extern	void	Search_Menu_Callback(Widget, int, XmAnyCallbackStruct *);
/* Not working extern	void	Change_Focus_Callback(); */

			/* file_callback.c */
extern	void	File_Menu_Callback(Widget, int, XmAnyCallbackStruct );

			/* callback.c */
extern	void	Configure_Minimum_Size_Callback(Widget, XtPointer, XConfigureEvent *);
extern  void    List_View_Callback(Widget, XtPointer, XmListCallbackStruct);

			/* edit_callback.c */
extern	void	Edit_Menu_Callback(Widget, int, XmAnyCallbackStruct *);

			/* card_callback.c */
extern	void	Card_Menu_Callback(Widget, int, XmAnyCallbackStruct *);

			/* view_callback.c */
extern	void	View_Menu_Callback(Widget, int );

			/* help_callback.c */
extern	void	Help_Menu_Callback(Widget, int);

#else
extern	void	File_Menu_Callback();	/* file_callback.c */
extern	void	Configure_Minimum_Size_Callback();
extern	void	Edit_Menu_Callback();	/* edit_callback.c */
extern	void	Card_Menu_Callback();	/* card_callback.c */

extern	void	View_Menu_Callback();	/* view_callback.c */
extern	void	Help_Menu_Callback();	/* help_callback.c */

extern	void	Search_Menu_Callback();	/* search_callback.c */
extern	void	Active_Card_Callback();	/* move_callback.c */
extern	void	Left_Arrow_Callback();	/* move_callback.c */
extern	void	Right_Arrow_Callback();	/* move_callback.c */
extern	void	Change_Focus_Callback();
extern  void    List_View_Callback();

#endif


#ifdef All_FALLBACKS_INCLUDED
static String fallbacks[] = {
"*labelString: Install App-default File!",
"*background: orange",

"*fontList: r14",
"*Main_Menu.background: yellow",

"*Main_Menu.button_0.labelString: File",
"*Main_Menu.button_1.labelString: Edit",
"*Main_Menu.button_2.labelString: View",
"*Main_Menu.button_3.labelString: Card",
"*Main_Menu.button_4.labelString: Search",
"*Main_Menu.button_5.labelString: Help",

"*File_Menu.button_0.labelString: New",
"*File_Menu.button_1.labelString: Open",
"*File_Menu.button_2.labelString: Save",
"*File_Menu.button_3.labelString: Save As",
"*File_Menu.button_4.labelString: Print",
"*File_Menu.button_5.labelString: Print All",
"*File_Menu.button_6.labelString: Merge",
"*File_Menu.button_7.labelString: Exit",
"*File_Menu.button_3.Sensitive: False",

"*Edit_Menu.button_0.labelString: Undo",
"*Edit_Menu.button_1.labelString: Cut",
"*Edit_Menu.button_2.labelString: Copy",
"*Edit_Menu.button_3.labelString: Paste",
"*Edit_Menu.button_4.labelString: Restore",
"*Edit_Menu.button_5.labelString: Text",
"*Edit_Menu.button_6.labelString: Picture",

"*Edit_Menu.button_1.Sensitive: False",
"*Edit_Menu.button_4.Sensitive: False",
"*Edit_Menu.button_5.Sensitive: False",
"*Edit_Menu.button_6.Sensitive: False",

"*View_Menu.button_0.labelString: Card",
"*View_Menu.button_1.labelString: List",
"*View_Menu.button_1.Sensitive: False",

"*Card_Menu.button_0.labelString: Add",
"*Card_Menu.button_1.labelString: Delete",
"*Card_Menu.button_2.labelString: Duplicate",
"*Card_Menu.button_3.labelString: Auto Dial",
"*Card_Menu.button_3.Sensitive: False",

"*Search_Menu.button_0.labelString: Goto...",
"*Search_Menu.button_1.labelString: Find...",
"*Search_Menu.button_2.labelString: Find Next",

"*Help_Menu.button_0.labelString: About",
"*Help_Menu.button_1.labelString: Help",
"*Help_Menu.button_1.Sensitive: False",

"*Card*background: seagreen3",

"*Arrow*width: 25",
"*Arrow*height: 25",
"*Label*labelString: Cards",

"*Goto_Prompt.selectionLabelString: Enter Index String to Search for",
"*Find_Prompt.selectionLabelString: Enter Text to Find",
NULL };

#else
String fallbacks[] = { 
"*fontList: r14", 
"*Main_Menu.button_0.labelString: File", 
"*Main_Menu.button_1.labelString: Edit", 
"*Main_Menu.button_2.labelString: View", 
"*Main_Menu.button_3.labelString: Card", 
"*Main_Menu.button_4.labelString: Search", 
"*Main_Menu.button_5.labelString: Help",

"*button_0.labelString: Install App-default File!",
"*button_1.labelString: Install App-default File!",
"*button_2.labelString: Install App-default File!",
"*button_3.labelString: Install App-default File!",
"*button_4.labelString: Install App-default File!",
"*button_5.labelString: Install App-default File!",
"*button_6.labelString: Install App-default File!",
"*File_Menu.button_7.labelString: Exit",
"*Label*labelString: Cards",
 NULL};
#endif


/*
 ************************************************************************ 
 ************************************************************************ 
 Name:
    Interface_Initialization

 Calling Sequence:
    main() see mcard.c

 Purpose:
    Opens the server connection and creates the interface.

 Description: 
    1. Open the server connection 
    2. Create Main Form, Place all children under the form
    3. Create the programs icon
    4. Create the main menu bar
    5. Create the associated pull down for each entry in the menu.
    6. Create the "card forward/back" arrows
    7. Create the form upon which the "card widgets reside, card view (default)
    8. Create the unmanaged form for the "list" view.
 ************************************************************************ 
 ************************************************************************ 
*/
extern Widget Interface_Initialization(
#ifdef __STDC__
 int		*argc,  char		*argv[],
 Widget		*top,   XtAppContext	*app)
#else
argc,argv, top, app)
int		*argc;
char		*argv[];
Widget		*top;
XtAppContext	*app;
#endif
{

/*
 Most widgets aren't reference via their variable name again.
 They're used primary as a place checker.
 Always coding for your convienance.
*/
Widget main_widget;
Widget main_form;
Widget menu_bar;

Widget view_sub_menu;
Widget whopper;
Widget card_area;
Widget left_arrow;


XtAppContext	local_app;
Pixmap icon_pixmap;





/*
 ************************************************************************ 
 ************************************************************************ 
  Initialize toolkit and create the top-level widget
  Toolkit Initialization which opens the server connection
  and Parses Cmd Line for:
       -[ bg|background ]	 -[ fg|foreground ]    -[ bw|borderwidth ]
       -[ disp|display ]         -[ bd|bordercolor ]   -[ fn|font ]
       -[ geometry ]             -[ iconic ]           -[ name ]
       -[ reverse | rv ]         -[ title ]            -[ xrm ]
  The argc in main gets altered! Passed as a pointer!
 ************************************************************************ 
 ************************************************************************ 
*/
*top = main_widget=	XtVaAppInitialize(&local_app,	"Mcard",
			NULL,			0,
			argc,			argv,
			fallbacks, NULL);
*app = local_app;

/* Go set the icon */
icon_pixmap = XCreateBitmapFromData(
			XtDisplay(main_widget),
			RootWindowOfScreen(XtScreen(main_widget)),
			icon_bits, icon_width, icon_height);

XtVaSetValues(main_widget,
			XmNiconPixmap,		icon_pixmap,
			NULL);

XFreePixmap(XtDisplay(main_widget), icon_pixmap);


/*
   ************************************************************************
   ************************************************************************
    Widget Group 0: Placement Widgets 
    Create the Form widget that will position all other widgets.

   ************************************************************************
   ************************************************************************
*/
main_form	=	XtVaCreateManagedWidget("Main_Form",
			xmFormWidgetClass,
			main_widget,
			XmNfractionBase,	2,
			NULL);
/*
  ************************************************************************
   Set up the head pointer and associated values before destroying
   these local values.
   Unfortunately, its a global variable at this time. Sorry.
  ************************************************************************
*/
        if ( !(head_ptr = (List_Ptr)  XtMalloc( sizeof(Link_List_Head))) )
	  Abend(main_form,-1,"Cannot allocate Master Structure. Very Bad!\n");


/*
   ************************************************************************
   ************************************************************************
    Widget Group 1: menu bar at the top of the application
      The menu buttons consist of the
     File Edit View Card & Help entries across the top of the screen
        your typical menu selections.
   Note, the label, mnemonics, accelerators, and language specific entries
   are in the ".mcard", the resource file.
   ************************************************************************
   ************************************************************************
 */
menu_bar	=	XmVaCreateSimpleMenuBar(main_form,
			"Main_Menu",
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNtopAttachment,	XmATTACH_FORM,
			XmVaCASCADEBUTTON,	NULL,	NULL,     /* file */
			XmVaCASCADEBUTTON,	NULL,	NULL,     /* edit */
			XmVaCASCADEBUTTON,	NULL,	NULL,     /* view */
			XmVaCASCADEBUTTON,	NULL,	NULL,     /* card */
			XmVaCASCADEBUTTON,	NULL,	NULL,     /* search */
			XmVaCASCADEBUTTON,	NULL,	NULL,     /* help */
			NULL);

			XtManageChild(menu_bar);

/* 
  ************************************************************************
  ************************************************************************
   Widget Group 2: The Sub Menus (ie, Pull Down Menu off the main menu)


   File sub Menu
      New, Open, Save, Save As, Print, Print All, Merge.
   See the resource file for user definable options
  ************************************************************************
  ************************************************************************
*/

/* The Pull down menu for the FILE command */
		XmVaCreateSimplePulldownMenu(		menu_bar,
			"File_Menu", 	0, (XtCallbackProc)	File_Menu_Callback,
			XmVaPUSHBUTTON,	NULL,	NULL,  NULL, NULL, /* new */
			XmVaPUSHBUTTON,	NULL,	NULL,  NULL, NULL, /* open */
			XmVaPUSHBUTTON,	NULL,	NULL,  NULL, NULL, /* save */
			XmVaPUSHBUTTON,	NULL,	NULL,  NULL, NULL, /*save as*/
			XmVaPUSHBUTTON,	NULL,	NULL,  NULL, NULL, /* print */
			XmVaPUSHBUTTON,	NULL,	NULL,  NULL, NULL, /*print al*/
			XmVaPUSHBUTTON,	NULL,	NULL,  NULL, NULL,  /* merge */
		        XmVaSEPARATOR,
			XmVaPUSHBUTTON,	NULL,	NULL,  NULL, NULL,  /* exit */
			NULL);

/*
  ************************************************************************
   Edit sub Menu
     Undo, Cut, Copy, Paste,
   See the resource file for user definable options
  ************************************************************************
*/

   XmVaCreateSimplePulldownMenu(		menu_bar,
	    "Edit_Menu", 	1, (XtCallbackProc)	Edit_Menu_Callback,
		        XmVaPUSHBUTTON,	NULL,	NULL, NULL, NULL,   /* undo */
		        XmVaSEPARATOR,
			XmVaPUSHBUTTON,	NULL,	NULL, NULL, NULL,   /* cut */
			XmVaPUSHBUTTON,	NULL,	NULL, NULL, NULL,   /* copy */
			XmVaPUSHBUTTON,	NULL,	NULL, NULL, NULL,   /* paste */
			NULL);

/*
  ************************************************************************
    Card sub Menu

  ************************************************************************
*/

view_sub_menu	=	XmVaCreateSimplePulldownMenu(		menu_bar,
			"View_Menu", 	2, (XtCallbackProc)	View_Menu_Callback,
			XmVaRADIOBUTTON,	NULL,	NULL,	NULL, NULL,
			XmVaRADIOBUTTON,	NULL,   NULL,	NULL, NULL,
                        XmNradioBehavior, True,
                        XmNradioAlwaysOne, True,
			NULL);

/* Initialize view_sub_menu so that "card" view is selected */
if (whopper =  XtNameToWidget(view_sub_menu, "button_0"))
    XtVaSetValues(whopper, XmNset, True, NULL);

	XmVaCreateSimplePulldownMenu(		menu_bar,
			"Card_Menu", 	3, (XtCallbackProc) 	Card_Menu_Callback,
			XmVaPUSHBUTTON,	NULL,	NULL, NULL, NULL,
			XmVaPUSHBUTTON,	NULL,   NULL, NULL, NULL,
			XmVaPUSHBUTTON,	NULL,   NULL, NULL, NULL,
			XmVaPUSHBUTTON,	NULL,   NULL, NULL, NULL,
			NULL);
/*
  ************************************************************************
    Search sub Menu

  ************************************************************************
*/

	XmVaCreateSimplePulldownMenu(		menu_bar,
			"Search_Menu", 	4,(XtCallbackProc) 	Search_Menu_Callback,
			XmVaPUSHBUTTON,	NULL,	NULL, NULL, NULL,
			XmVaPUSHBUTTON,	NULL,   NULL, NULL, NULL,
			XmVaPUSHBUTTON,	NULL,   NULL, NULL, NULL,
			NULL);
/*
  ************************************************************************
    Help sub Menu

  ************************************************************************
*/

	XmVaCreateSimplePulldownMenu(		menu_bar,
			"Help_Menu", 	5, (XtCallbackProc) 	Help_Menu_Callback,
			XmVaPUSHBUTTON,	NULL,	NULL, NULL, NULL,
			XmVaPUSHBUTTON,	NULL,   NULL, NULL, NULL,
			NULL);


/* 
  ************************************************************************
  ************************************************************************
  Widget Group 3: Decorative Widgets.

   Left_arrow will be used latter to position another form, card_area.
   The arrow buttons are on the main_form, with a fractional base set to 2
   This gives it the "Centered Look".
  ************************************************************************
  ************************************************************************
*/

left_arrow =XtVaCreateManagedWidget("Arrow",
			xmArrowButtonGadgetClass,
			main_form, 
			XmNmultiClick,		XmMULTICLICK_KEEP,
			XmNarrowDirection,	XmARROW_LEFT,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		menu_bar,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	1,
			NULL);

XtAddCallback(left_arrow,XmNactivateCallback,(XtCallbackProc) Left_Arrow_Callback,NULL);

/* 
This is the right arrow. No need to give this widget a var name
It's never referenced again
*/
whopper = XtVaCreateManagedWidget("Arrow",
			xmArrowButtonGadgetClass,
			main_form, 
			XmNarrowDirection,	XmARROW_RIGHT,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		menu_bar,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	1,
			NULL);

XtAddCallback(whopper,XmNactivateCallback, (XtCallbackProc) Right_Arrow_Callback,NULL);

/*
This is the label which displays the number of cards.
*/
head_ptr->label = XtVaCreateManagedWidget("Label",
			xmLabelWidgetClass,
			main_form,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		menu_bar,
			XmNrightOffset,	10,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	2,
			NULL);

/*
  ************************************************************************
   This Form positions ALL "cards". It has a nice frame around it.
  ************************************************************************
*/
whopper =    XtVaCreateManagedWidget("Frame",
			xmFrameWidgetClass,
			main_form,
			XmNshadowType,		XmSHADOW_OUT,
			XmNtopAttachment,  	XmATTACH_WIDGET,
			XmNtopWidget,		left_arrow,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,	
			XmNbottomAttachment,	XmATTACH_FORM,
			NULL);


          /* This is an important form! All cards sit on it! */
card_area =  XtVaCreateManagedWidget("Card_Area",
			xmFormWidgetClass,
			whopper,
			XmNfractionBase,	5,
			XmNtopAttachment,  	XmATTACH_WIDGET,
			XmNtopWidget,		left_arrow,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,	
			XmNbottomAttachment,	XmATTACH_FORM,
			NULL);
return head_ptr->parent_form = card_area;

} /* end Interface_Initialization */


/*
  ************************************************************************
  ************************************************************************
   Name:
     Make_Card

   Purpose:
     This routine creates a "card widget" which is composed of a form
     and two text widgets. Since this is the principle means in which
     the user interacts with mcard, there is an associated structure
     List_Ptr which hold all relevant information.

   Calling Sequence:
     1. main() see mcard.c

   Description:
     The routine is passed a form widget upon which all "card widgets"
     will be placed. A "card widget" consists of a form, frame, and two
     text widgets, the index and address. This is the principle way the
     user interacts with this program.
	1. Create a card widget
	2. Get the card widgets width & height.
	3. Using these values determine an acceptable size for all cards
	4. Set the parent forms size.
	5. Create 6 more Unmanaged card widgets
	6. Using the fractional placement resource position all cards
	7. Store all relevant information in the data structures
  ************************************************************************
  ************************************************************************
*/
extern List_Ptr Make_Card()

{

Widget parent = head_ptr->parent_form;
Widget whopper;
Widget card;
Widget index, address;
int i;

whopper =    XtVaCreateManagedWidget("Card",
			xmFrameWidgetClass,
			parent,
			XmNshadowType, XmSHADOW_OUT,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_NONE,
			NULL);
				     
card   =  XtVaCreateManagedWidget("Card",
			xmFormWidgetClass,
			whopper,
			NULL);


index =      XtVaCreateManagedWidget("Card",
			xmTextFieldWidgetClass,
			card,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNeditMode,		XmMULTI_LINE_EDIT,
			XmNcolumns,		CARD_CHAR_WIDTH,
			NULL);

/* 
  ************************************************************************
   "There are no bugs just undocumented features"
   The address is entered into a text widget 40 char wide by 10 lines.
   However, I know of no way to limit a MULTI_LINE_EDITable text widget
   to just 10 lines! A user could enter 20 lines of text, save the file,
   and port to the PC. On the PC, the user wouldn't be able to access
   those 20 lines, whereas, Motif will let the user use the arrow keys.

   Using XmNmaxLenth = 40 * 10; won't help... CR count in that length. 
  ************************************************************************
*/
address =      XtVaCreateManagedWidget("Card",
			xmTextWidgetClass,
			card,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		index,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,

			XmNeditMode,		XmMULTI_LINE_EDIT,
/*			XmNeditMode,		XmSINGLE_LINE_EDIT, */
			XmNscrollHorizontal,	False,
			XmNscrollVertical,	False,
			XmNrows,		CARD_CHAR_ROW,
			XmNcolumns,		CARD_CHAR_WIDTH,
			XmNwordWrap,		True,
			NULL);


/*
  ************************************************************************
   Now that we have some reference-able sizes for the card.
   Determine an acceptable width & height for the form
   upon which the cards sit.
  ************************************************************************
*/
{
Dimension index_width,index_height;
Dimension address_width, address_height;
Dimension card_height;
Dimension form_width, form_height;
int frac, spot;

/* get the index's width & height */
     XtVaGetValues(index,
			XmNheight,		&index_height,
			XmNwidth,		&index_width,
			NULL);

     card_height = index_height;
     XtVaGetValues(address,
			XmNheight, 		&address_height,
			XmNwidth,		&address_width,
			NULL);
     card_height += address_height;

/*
  Want the index to be viewable (fudge factor of 5 added for luck :-),
  so the "fractional" part should equal this height.
  Need to determine total number of "fractional" parts for the entire form.
  How many "fractional" parts does the form need?
  As many needed to display 5 indexes and one entire card.
  This value is a constant (ie, no units) & is calculated as:
  The Overall card height (in pixels) divided by index height (in pixels).
  A Constant.
  Plus 1 to account for truncation, and then add the 5 viewable indexes.
 */
card_height += 5;
frac = 5 + (1 + card_height / index_height);

/*
   Want to display 5 indexes, and then the primary card as stated above,
   so position the primary card after these 5 viewable indexes.
 */
spot =  6;

/*
 Best guess on the form's height & width, Its calculated by
 Width: use fractional base * index's height (opposite of above) & 
 a little extra for for a border
 Height: The width of one card plus indentation for 5 more indexes.
 Since the fractional part is based upon the index's height, we'll use it.
 I know its strange.
*/
form_height = frac * index_height + CARD_CHAR_ROW;
form_width  = index_width + 5 * index_height + 20;

/*  Set the updated resources for the form */
     XtVaSetValues(parent, XmNheight, form_height,
		   XmNwidth,			form_width,
		   XmNfractionBase,		frac,
		   XmNminHeight,		form_height,
		   XmNminWidth,			form_width,
		   NULL);

/*
  Position the primary card, all other cards will be recessed behind this one.
*/
     XtVaSetValues(whopper, XmNleftAttachment,	XmATTACH_POSITION,
		   XmNleftPosition,		0, 
		   XmNtopAttachment,		XmATTACH_POSITION,
		   XmNtopPosition,		spot,
		   NULL);

/*
 head_ptr holds important card sizes to be used when a resize event occurs
 */
head_ptr -> index_height = index_height;
head_ptr -> index_width  = index_width;
head_ptr -> card_height  = card_height; 
head_ptr -> parent_form =  parent;
head_ptr -> frac = frac;
head_ptr -> available_spots = spot;
head_ptr -> card_view = head_ptr -> visible_spots = 1;
 head_ptr -> file_name = NULL;
 head_ptr -> search_for = NULL;
head_ptr->scroll  = NULL;

/*
   This structure holds all data ENTERED by the user
   This structure will be circularly linked listed with others of its kind.
 */
if (!(head_ptr->primary_card = head_ptr->card_data = (Card_Ptr)
  XtMalloc(sizeof(Card))) )
	  Abend(parent,-1,"Cannot allocate User Card Structure.\n");

head_ptr->cards = 1;
head_ptr->card_data->next = head_ptr->card_data;
head_ptr->card_data->prior = head_ptr->card_data;
head_ptr->card_data->address = XmTextGetString(address);
head_ptr->card_data->index = XmTextGetString(index);

/*
  Storing Widgets Not char*  Storing Widgets Not char*
 Store the address & index widgets!
  Storing Widgets Not char* Storing Widgets Not char*
 */
        if (!(head_ptr->viewable_cards = (Card_Content_Ptr) XtMalloc(sizeof(Card_Content))) )
	  Abend(parent,-1,"Cannot allocate");

        head_ptr->viewable_cards->next = NULL;
        head_ptr->viewable_cards->address = address;
        head_ptr->viewable_cards->index = index;
        head_ptr->viewable_cards->form = whopper;


}

/*
Local indentation, cause not sure if this will remain.
*/
{
Card_Content_Ptr tmp_ptr;

/* Traverse the linked list of widgets to get to the last card widget */
for (tmp_ptr = head_ptr->viewable_cards; tmp_ptr->next != NULL; )
	tmp_ptr = tmp_ptr->next;

/*
   Create more Card Widgets, placing they behind the primary card
   and one up and over from the primary card. This gives the program
   an ascending & ordered appearance
*/
for (i=head_ptr->available_spots; i>0; i--) {

whopper = XtVaCreateManagedWidget("Card",
			xmFrameWidgetClass,
			parent,
			XmNshadowType,		XmSHADOW_OUT,
			XmNtopAttachment,	XmATTACH_POSITION,
			XmNtopPosition,		i-1,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	head_ptr->available_spots+1-i,
			XmNmappedWhenManaged,	False,
			NULL);

				     
  card   =  XtVaCreateManagedWidget("Card",
			xmFormWidgetClass,
			whopper,
			NULL);


  index =      XtVaCreateManagedWidget("Card",
			xmTextFieldWidgetClass,
			card,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNeditable,		False,
			XmNcursorPositionVisible,False,
			XmNrows,		5,
			XmNcolumns,		CARD_CHAR_WIDTH,
			NULL);

XtAddEventHandler(index, ButtonRelease, False, (XtEventHandler) Active_Card_Callback, NULL);

address =      XtVaCreateManagedWidget("Card",
			xmTextWidgetClass,
			card,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		index,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,

			XmNeditable,		False,
			XmNcursorPositionVisible,False,

			XmNeditMode,		XmMULTI_LINE_EDIT,
			XmNrows,		CARD_CHAR_ROW,
			XmNcolumns,		CARD_CHAR_WIDTH,
			NULL);

XtAddEventHandler(address, ButtonRelease, False, (XtEventHandler) Active_Card_Callback, NULL);

/*
XtAddCallback(address, XmNfocusCallback, Change_Focus_Callback, NULL);
*/

/* Store the frame, address, & index widgets! */
   if (!(tmp_ptr->next = (Card_Content_Ptr) XtMalloc(sizeof(Card_Content))) )
	  Abend(parent,-1,"Cannot allocate");
tmp_ptr = tmp_ptr->next;
tmp_ptr->next = NULL;
tmp_ptr->address = address;
tmp_ptr->index = index;
tmp_ptr->form  = whopper;

} /* end for */

} /* end local define */

/* This is the widget for the "List View" */
{
    Arg args[8];
    Widget tmp;
    
    XtSetArg(args[0],	XmNtopAttachment,  	XmATTACH_FORM);
    XtSetArg(args[1],	XmNleftAttachment,	XmATTACH_FORM);
    XtSetArg(args[2],	XmNrightAttachment,	XmATTACH_FORM);
    XtSetArg(args[3],	XmNbottomAttachment,	XmATTACH_FORM);
    XtSetArg(args[4],	XmNselectionPolicy,	XmBROWSE_SELECT);
    XtSetArg(args[5],	XmNtopItemPosition,	1);
/*    XtSetArg(args[5],	XmNmappedWhenManaged,	False); */


    tmp = (Widget) XmCreateScrolledList(head_ptr->parent_form,"Scroll",args,6);
    XtManageChild(tmp);
    XtAddCallback(tmp,XmNbrowseSelectionCallback, 
		  (XtCallbackProc) List_View_Callback, NULL);
    head_ptr->scroll = tmp;	 
}
return head_ptr;

}
