/*
  ************************************************************************
  ************************************************************************

    Copyright (C) 1995   Michael J. Oehler

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  ************************************************************************
  ************************************************************************
*/

/*
 This file contains the procedures that are motif independent.
 Generally, these procedures manipulate the link list that holds
 the user data. Note that #include "xcard.h" isn't needed.
*/
#include "crd.h"
extern List_Ptr head_ptr;

/* -library_includes */
#include "crd.h"

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>

#define HEADER_SIZE 5
#define INDEX_RESERVED 6
#define ADR_OF_RECORD 4
#define START_FLAGS 1
#define END_FLAGS 1


/*
  ************************************************************************
  ************************************************************************

  ************************************************************************
  ************************************************************************
*/
extern Card_Ptr Add_Card(index, address, start_here)
char *index;
char *address;
Card_Ptr start_here;
{
Card_Content_Ptr tmp_ptr;
Card_Ptr user_data, dummy;
int i;

/*
    Place the user's data for the newly created card in the right spot in the
    linked list. Note, this a just a sequential search, lots of room for
    improvement here.
*/
user_data = start_here;
     for(i=0; i < head_ptr->cards; i++) {
       if ( strcmp(index,user_data->index ) <= 0) {
	 user_data = user_data->prior;
	 break;
       }
       user_data = user_data->next;
     }


/* This structure will hold all data entered by the user */
        if (!(dummy = (Card_Ptr) XtMalloc(sizeof(Card))) )
          return( (Card_Ptr) NULL);

/* If true, place card at the end of the list */
        if (i == head_ptr->cards)
		user_data = head_ptr->card_data->prior;

/* Better check & see if the primary card is also the first card in the list */
       if (i ==0 )
	       head_ptr->card_data = dummy;

/*
  Go to the newly created structure then, 
  continue the creatation of a circular linked list
*/
   (head_ptr->cards)++;
     dummy->next = user_data->next;
     user_data->next = dummy;
     dummy->next->prior = dummy;
     dummy->prior = user_data;

/* init rest of the structure */
     dummy->address = address;
     dummy->index = index;

return dummy;
} /* End Add_Card */

/*
  ************************************************************************
  ************************************************************************
  Name:
      Get_CRD_File

  Purpose:

  Calling Sequence:


  Description:

  ************************************************************************
  ************************************************************************
*/
extern int Get_CRD_File(fname)
char *fname;
{

/* Variables required for file handling */
        unsigned char *header;
        FILE *fp, *fopen();
        struct stat file_status;
        int num_bytes;
	off_t file_size;

/* Used to set up applications variables */
	int num_cards;
	long int file_adr_pos;
	char *index, *address;
	int i,tmp;

/* Attempt to open the file for the input */

        if ( !(fp = fopen(fname, "r")) ) {
           fclose(fp);
           return(0);
        }

/* Get file status */
     if (stat(fname, &file_status) < 0)
     {
	 fclose(fp);
	 return(0);
      }	
    file_size =  file_status.st_size;

/*
 DANGER WILL ROBINSON!
 See if we can get space. This is risky, assuming we have room for it all!!!
*/
        if ( !(header = (unsigned char *) XtMalloc(file_size)) )
	{
	    fclose(fp);
	    return(0);
	}
	

/* Get the header info. */
        num_bytes = fread( (unsigned char *) header, 1, file_size, fp);
        if ( num_bytes != file_size) {
          fclose(fp);
          return(0);
        }

/* Wow, got the whole thing. Now, close the file */
	fclose (fp);

/* The "magic cookie", MGC identifies it as .CRD file */
       if (header[0] != 'M' && header[1] != 'G' && header[2] != 'C') {
          /* fprintf(stderr, "File is not in cardfile format\n"); */
          fclose(fp);
          return(0);
        }
	 
/* Get the number of cards LSB then MSB, remember, this file format came from a PC. */
	num_cards = header[3] + 0x100 * header[4];

/* Start 5 bytes for the beginning to offset from the header information */
	for (i=5, tmp = 0x34 * num_cards + 5; i< tmp; i+=0x34) {

/*
 Test index header. memcmp returns Zero if same, non-zero otherwise.
 Watch the offset "i"!
*/
	  if ( memcmp(header + i, "\0\0\0\0\0\0", 6) && header[i + 0xA] != '\0' ) {
	    /* fprintf(stderr, "Index unreadable\n"); */
	    fclose(fp);
	    return(0);
	  }

/* Get the index for the card */
	  index = XtMalloc( CARD_CHAR_WIDTH );
	  memcpy(index, header + i+ 0xB, 0x27);

/* Get position in the file of the "address data. Add one since indexing from 0. */
  file_adr_pos  = header[i+6] + (header[i+7] << 8);
  file_adr_pos += (header[i+8] << 16) +  (header[i+9] << 24);


/* Translate which kind of card */
{
int bitmap_length;
int dummy;
int string_length;
int tricky;

bitmap_length = header[file_adr_pos] +  (header[file_adr_pos + 1] << 8);
dummy = header[file_adr_pos + 2] +  (header[file_adr_pos + 3] << 8);

tricky = (!bitmap_length<<1) +  (!dummy);


      switch (tricky) {
	/*  Try a NULL (or empty) address */
      case 3:
	{
	  address = XtMalloc(1);
	  address[0] = '\0';
	  break;
	}
	
	/* If first two bytes were NULL & 2nd two btyes have data, This is text only  card */
      case 2:
	{
	  string_length = dummy+1;
	  address = XtMalloc(string_length);
	  strncpy(address, header + file_adr_pos + 4,string_length);
	  dummy = strlen(address);
	  break;
	}
	
      case 1:
	{
	  break;
	}
	/* OK There's some sort of graphic */
	
	
      } /*end switch */
} /* local indent */

/* Get ride of the CR */
{
int n;

/*
Unix requires only a LF '\012' and no CR '\015'
*/
       for (n= strlen(index); n>=0 ; n--)
	if ( *(index+i) == '\015')
		strcpy(index + n, index + n + 1);

       for (n= strlen(address); n>=0 ; n--)
	if ( *(address+n) == '\015')
		strcpy(address + n, address + n + 1);
}

/*
 Go do the motif independent stuff
 Note, the implied alphabetical order from the "card file"
 Add_Card updates head_ptr.
 */
	  if ( !(head_ptr->primary_card = Add_Card(index, address, head_ptr->primary_card)))
	    return(0);
	  
	} /* for */

/* Free the mamouth buffer we grabbed */
    XtFree(header);

return num_cards;

} /* end Get_CRD_File */


/*
  ************************************************************************
  ************************************************************************
  Name:
      Put_CRD_File

  Purpose:

  Calling Sequence:


  Description:

  ************************************************************************
  ************************************************************************
*/
extern int Put_CRD_File(fname)
char *fname;
{

/* Variables required for file handling */
        char *header,*ptr;
	FILE *fp, *fopen();
        int header_size;
	int *adr_size;
	int adr_header_size;
	char *adr_header;
	int lsb_no_cards, msb_no_cards;
	int n, i, size, location;
	Card_Ptr crd_ptr;
char *cptr;

/* Used to set up applications variables */
	int num_cards = head_ptr->cards;

/* Just in case no file name was passed, return */
     if (!fname) return 0;

/* Determine the MSB & LSB of the number of cards. Save as bytes! */
     msb_no_cards = (char) num_cards >>8;
     lsb_no_cards = (char) num_cards - (msb_no_cards << 8);

/* Compute size of index header */
     header_size = HEADER_SIZE;
     header_size += (INDEX_RESERVED + ADR_OF_RECORD + START_FLAGS + CARD_CHAR_WIDTH + END_FLAGS) * num_cards;
     header  = (char *) XtMalloc(sizeof( char ) * header_size);

/*
 The raw cardfiles that I examined contained a lot of prior data.
 This is an Object Reuse problem. Must clear Malloc'ed areas to SP!
 This clears the index header.
*/
  for (i=header_size; i ; i--)
	*(header+i) = ' ';

/* Allocate an array to hold the strlen of each address */
  if (!(adr_size  = (int *) XtMalloc(sizeof( int ) * num_cards) ))
	return 0;

{
int more_room, size;

/* Determine the size of each card's address & missing CRs/LFs */
  crd_ptr = head_ptr->card_data;
  adr_header_size = 0;
  for (i=0; i<num_cards ; i++) {

/*
 UNIX doesn't need CL & LF, thus CR was removed in Get_CRD_File()
 Count the number of LFs removed
 prepare to put LF back to maintain compatibility with DOS
*/
   more_room = 0;
   cptr = crd_ptr->address;
   size = strlen(cptr);

/* 
 CR removed in Get_CRD_File(). A CR may of gotton insert (How ???)
 Won't need to count them.
*/
   for (n=0; n < size ; n++)
     if ( *(cptr+n) == '\012' && *(cptr+n-1) != '\015' )
	    more_room++;

/*
  4 bytes equals entry's "address header" within address header.
  A card w/ no address is implicitly taken care of!
  It's size is 0 and header consists of 4 NULL bytes.
*/
    adr_size[i] = size + more_room;
    adr_header_size += adr_size[i] + 4;
    crd_ptr = crd_ptr->next;
} /* end adrress size loop */
}

/* Allocate address header */
if (!(adr_header  = (char *) XtMalloc( sizeof( char ) * adr_header_size ) ))
	return 0;

/* Create a tmp place to insert CR/LF into the addresses */
  if (!(cptr = XtMalloc(CARD_CHAR_WIDTH * CARD_CHAR_ROW)) )
	return 0;

/* Insert the addresses */
{
unsigned char msb,lsb;
int tmp;

  ptr = adr_header;
  crd_ptr = head_ptr->card_data;
  for (i=0; i<num_cards ; i++) {

  msb = (char) adr_size[i] >>8;
  lsb = (char) adr_size[i] - (msb << 8);

/*
   Store two NULL bytes to indicate text only card
   A card with no address is implicitly handled!
   ie, It's size in msb & lsb are zero.
 */
    ptr[0] = '\0';
    ptr[1] = '\0';
    ptr[2] = lsb;
    ptr[3] = msb;

/*
 UNIX doesn't need CL & LF, thus CR was removed in Get_CRD_File()
 Put the LF back to maintain compatibility with DOS
 The +1 assures that the NULL char is inserted.
*/
  size=strlen(crd_ptr->address)+1;

for (n=0, location = 0; location<size ; n++, location++) {
    *(cptr+n)= *(crd_ptr->address + location);
    if ( *(cptr+n) == '\012'  && *(crd_ptr->address + n -1) != '\015')
    {
	*(cptr+n)= '\015';
	n++;
	*(cptr+n)='\012'; 
    }
} /* copied all char */	    



/* Store the address into the address header */
strcpy(ptr+4,cptr);

/* Store the location of this record */
tmp =  adr_size[i];
adr_size[i] = ptr - adr_header;

/* Move to the next record location */
ptr += 4 + tmp;
crd_ptr = crd_ptr->next;

} /* for */
} /* end local indent */
/* The 5 byte header of a cardfile consists of "MRG" & then the number of cards */
 header[0] = 'M';
 header[1] = 'G';
 header[2] = 'C';
 header[3] = lsb_no_cards;
 header[4] = msb_no_cards;

/* Store all of the indexes */
  ptr = header + 5;
  crd_ptr = head_ptr->card_data;
  for (i=0; i < num_cards; i++) {
      /* 6 NULLs reserved in the index entry */
      ptr[0] = '\0';
      ptr[1] = '\0';
      ptr[2] = '\0';
      ptr[3] = '\0';
      ptr[4] = '\0';
      ptr[5] = '\0';

      /* Location in the file of address data */
location = header_size + adr_size[i];
      ptr[6] = location & 0xFF;
      ptr[7] = (location >> 8 ) & 0xFF;
      ptr[8] = (location >> 16 ) & 0xFF;
      ptr[9] = (location >> 24 ) & 0xFF;

      /* FLAG BYTE */
      ptr[0xA] = '\0';

      /* Copy in the index, Remaining characters are SP */
      strcpy( (ptr+0xB), crd_ptr->index);
      
      /* Null Byte */
      ptr[0x33] = '\0';

      /* next card & next index position */
      ptr += 0x34;
      crd_ptr = crd_ptr->next;
  } /* end for */



	
/* Attempt to open the file for the output */

        if ( !(fp = fopen(fname, "w")) ) {
           fclose(fp);
           return(0);
        }


	fwrite(header, 1, header_size, fp);
	fwrite(adr_header, 1, adr_header_size, fp);
	fclose(fp);

/* release memory */
	XtFree(header);
	XtFree(adr_header);
	XtFree(cptr);
	XtFree((char *) adr_size);

}


#ifdef MIKEY
/*
  ************************************************************************
  ************************************************************************

Calling Sequence: This routine is not compiled
Description: It is intended to be used by the "About" callback
to bring in some fancy pixmap with color to wow the user about
this program.

  ************************************************************************
  ************************************************************************
*/
static void Create_Pixmap(width, hieght, data)
int width;
int height;
unsigned char *data;
{
Display *dpy;

dpy = XtDisplay(widget);
if ( !(pixmap = XCreatePixmap(dpy, DefaultRootWindow(dpy), width, height, 1);
       XtAppError();

if ( !(gc = XCreateGC(dpy, pixmap,NULL, 0)))
       XtAppError();

fill in some colors

XCopyArea(dpy, 

}
#endif MIKEY
