/*
  ************************************************************************
  ************************************************************************
    Copyright (C) 1995   Michael J. Oehler

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 Module Description:


  ************************************************************************
  ************************************************************************
*/

#ifndef CRD_H_ALREADY
#define CRD_H_ALREADY

#define CARD_CHAR_WIDTH 40
#define CARD_CHAR_ROW   10

/*
  Motif specific resources, eg, "Widget" is defined here
   In turn, the X includes are brought in:
    X11/Intrinsics
     X11/Xlib.h
     X11/Xutil.h
     X11/Xresources.h
     X11/Xos.h
    X11/Vendors.h
    X11/VirtKeys.h
 */
#include <Xm/Xm.h>

/* 
 This structure holds the "index" & "address" widget for each viewable card.
 The "index" & "address" are text widgets in which the addresses are viewed.
 The "form" variable hold the frame widget that surronds the index & address.
 "form" is used to map/unmap the "card widget".
*/
typedef struct _card_widget_contents
{
struct _card_widget_contents *next;
Widget address;
Widget index;
Widget form;
} Card_Content, *Card_Content_Ptr;

/*
This structure holds the users card data.
Its a circular linked list.
*/
typedef struct _card_list
{
  struct _card_list *next;
  struct _card_list *prior;
  char *address;
  char *index;
} Card, *Card_Ptr;


/*
This is the primary structure from which all references begin.
It holds all relevant information.

 index_height
 index_width
 card_height: 		Pixel height.

available_spots: 	Number of card widgets that can be mapped.

visible_spots:		Number of mapped Card Widgets

cards:			Total number of user inputed cards.
			NOT WIDGETS.

card_view:		Boolean either Card_View or List_View

parent_form:		The form on which the card view or list is put.

label:			The text label. Tells the user how many cards.

viewable_cards:		Linked list of card widgets.

card_data:		Linked list of user data (indexes & addresses)
 
 Important, the number of viewable cards is dependent upon:
    1. the width & height of the parent form.
       This changes when the user resizes the window.
    2. The number of cards.
 For example, the user has 10 cards, but the window holds 5. You'll see 5.
 The window holds 10 cards, but the users has 5. You'll see 5 again.



*/
typedef struct _linked_list_head
{
Card_Content_Ptr viewable_cards;
Card_Ptr card_data;
Card_Ptr primary_card;
  int index_height;
  int index_width;
  int card_height;
  int frac;
  int available_spots;		/*  the max number of visible card widgets */
  int visible_spots;		/*  the number of  visible card widgets */
  int cards;			/*  the current number of cards */
  int card_view;		/*  Card View or List View */
  Widget parent_form;
  Widget label;
  Widget scroll;
  char *file_name;
  char *search_for;
} Link_List_Head, *List_Ptr;


#ifdef GLOBAL_VARIABLES

/*
 This is the primary data structure through which all data is reference
 in this program. I understand that global variables are not good,
 but all callbacks don't easily provide data passing.
 Only main() will have this declaration! All other routines access it as
 an external!
 */
List_Ptr head_ptr;
XtAppContext	app;

#else
/*
  All other parts of the program address the primary data structure as an external.
*/
extern List_Ptr head_ptr;


#ifdef __STDC__
extern      Widget               Create_Prompt(char *);
extern      void                 Create_Info_Prompt(char *);
extern      Card_Ptr             Add_Card(char *, char *, Card_Ptr); /* file_io.c */
extern      void                 Grab_Primary_Card_Data(Widget);
extern      Widget               Create_Error_Prompt(char *);
extern      void                 Release_Cards( void );
extern      void                 Any_To_Map( int );

#else

/* The external routines below are accessible by all */
extern      Widget               Create_Prompt();
extern      void                 Create_Info_Prompt();
extern      Card_Ptr             Add_Card(); 
extern      void                 Redraw_List();
extern      void                 Usuage();
extern      void                 Grab_Primary_Card_Data();
extern      Widget               Create_Error_Prompt();
extern      void                 Any_To_Map();
extern      void                 Release_Cards();

#endif

#endif /* ends global_variales */
#endif /* ends included_already */


