/*
  ************************************************************************
  ************************************************************************
    Copyright (C) 1995   Michael J. Oehler

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 Module Description:


  ************************************************************************
  ************************************************************************
*/


#include "crd.h"

#ifdef __STDC__
static void Add_Card_Callback(Widget, XtPointer, XmSelectionBoxCallbackStruct *);
extern void Delete_Card( void );
static void Duplicate_Card(Widget);

#else
static void Add_Card_Callback();
extern void Delete_Card();
static void Duplicate_Card();
#endif

/*
These defines are only used to pass client_data to the callback helper
routines. They are used when similar, but not exactly the same,
functionality is performed by one of the callbacks. For instance,
Duplicating and Adding a card, and Open and Merging a file, have
similar functionality. Instead of redundant code, these defines
introduce a conditional to control the minut differences.
*/
#define GOVERN 0


/*
  ************************************************************************
  ************************************************************************
   Name:
	Card_Menu_Callback

   Calling Sequence:
	This routine is called only from one of the buttons off the "Card"
	button in the main menu.  This callback is established during the
	creation of the sub menu. See init.c
	"card_sub_menu=XmVaCreateSimplePulldownMenu(menu_bar,"

    Description:
	The routine is passed in an integer representing which button
	in the sub menu initiated this callback. A Switch statement
	then controls which function will be performed.

  ************************************************************************
  ************************************************************************
*/
extern void Card_Menu_Callback(widget, item_no, call_data)
Widget widget;
int item_no;
XmAnyCallbackStruct *call_data;
{

switch (item_no) {

 /* Add a card */
 case 0: {
    XtAddCallback(Create_Prompt("New_Index_Prompt"), XmNokCallback, (XtCallbackProc) Add_Card_Callback,NULL);
   break;
  }

 /* Delete a card */
 case 1: {
     Delete_Card();
     Redraw_List();
  break;
 }

 /* Duplicate a card */
 case 2: {
    Duplicate_Card(widget);
  break;
 }
 /* AutDial */
 case 3: {
	Create_Error_Prompt("Rabbit");
  break;
 }
 }
/* Do not put "Redraw_List()", here. It won't work! */


} /* end Card_Menu_Callback */



/*
  ************************************************************************
  ************************************************************************
   Name:
      Delete_Card

    Calling Sequence:
      This routine is typically called from Card_Menu_Callback.

  ************************************************************************
  ************************************************************************
*/
extern void Delete_Card()
{
Card_Content_Ptr tmp_ptr;
Card_Ptr dummy;
int i;

/* NOT NEEDED -> Grab_Primary_Card_Data() <- gonna be wiped out anyway */

/* Clean out the USER data stored in the primary card */
   XtFree(head_ptr->primary_card->index);
   XtFree(head_ptr->primary_card->address);

/* If there is only one card, link list manipulation isn't needed */
   if (head_ptr->cards <= 1) {
       head_ptr->primary_card->index = XtMalloc(1);
       head_ptr->primary_card->address = XtMalloc(1);
       head_ptr->primary_card->index[0]='\0';
       head_ptr->primary_card->address[0]='\0';
   }

/* Better check & see if the primary card is also the first card in the list */
   dummy = head_ptr->primary_card;
   if (head_ptr->card_data == dummy)
	   head_ptr->card_data = dummy->next;

/* Fix link list, free the memory, & decrease the number of cards in the list. */
   head_ptr->primary_card = dummy->next;
   head_ptr->primary_card->prior = dummy->prior;
   dummy->prior->next = dummy->next;

   (head_ptr->cards)--;
   XtFree((char *) dummy);

/*
   Unmap "Card Widget" Operation.
 If there is less user data then visible card_widgets, hide that "card widget"
 1 Million cards and only 7 are visibile, don't unmap one of the seven. Get it!
 Nor do we want to unmap to less than one card.
*/
if ( head_ptr->card_view) 
{
    
    if (head_ptr->cards < head_ptr->visible_spots && 
	head_ptr->visible_spots > 1) {

	/* Increase the number of available spots */
	(head_ptr->available_spots)++;

	/* Go to the end of the link list */
	tmp_ptr = head_ptr->viewable_cards;
	for (i = head_ptr->visible_spots-1; i > 0; i--)
		tmp_ptr = tmp_ptr->next;

	/* Reduce the number of mapped card widgets, then actually un-map */
	(head_ptr->visible_spots)--;
	XtUnmapWidget(tmp_ptr->form);
    }
}
else { /* List View */
    int *pos_list, pos_cnt;

    if ( XmListGetSelectedPos(head_ptr->scroll, &pos_list, &pos_cnt) ) 
    {
	XmListDeletePos(head_ptr->scroll,  *pos_list);
	XmListSelectPos(head_ptr->scroll,*pos_list+1,False);
	XtFree((char *) pos_list);
    }
    

} /* end Delete_Card */

}


/*
  ************************************************************************
  ************************************************************************
     Name
         Add_Card_Callback

     Calling Sequence:
         This routine is only called from the "Prompt for an Index" dialog.
         This callback is established when the dialog is created in 
         "Card_Menu_Callback" 

     Description:
         0.  The user was prompted for an "index" via a popped up PromptDialog
	 1.  Get this newly type index.
	 2.  Create a blank address (ie, \0 )
	 3.  Goto a routine common to Add_Card & Duplicate_Card
                 Add_Card. This is independent of Motif.
         1.  Update the primary card's data, index & address.
         2.  Convert the XmString from that dialog to a char pointer.
         3.  Create a new data structure to hold user data
         4.  Store the index from the dialog in the structure
         5.  Initialize the address to \0
         6.  Insert the structure in alphabetical order in the user data list
             Update the circular linked list here
         7.  Set the primary card to view/edit as this new card.
             ie, primary card points to this new structure.
         8.  Manage a "card widget" if one is available.
         9.  Go redraw the list.

  ************************************************************************
  ************************************************************************
*/
static void Add_Card_Callback(widget,data,cbs)
Widget widget;
XtPointer data;
XmSelectionBoxCallbackStruct *cbs;
{
char *new_index;
char *new_address;
/*
  Go convert the XmString entered by the user to a character string
  This string  XtFree()'ed during Delete() or Release_Cards().
 */
     XmStringGetLtoR(cbs->value,XmSTRING_DEFAULT_CHARSET,&new_index);

/* Dismissed the PromptDialog */
     XtDestroyWidget(widget);

/* There may have been updates in the primary card widgets. Go check. */
     if (head_ptr->card_view) Grab_Primary_Card_Data(widget);

/* Newly added cards don't have any data in the address */
     new_address = XtMalloc(1);
     new_address[0]='\0';

/* Go do the motif independent stuff */
    if ( !(head_ptr->primary_card = Add_Card(new_index, new_address, head_ptr->card_data)))
	  Abend(widget,-1,"Cannot allocate a new card");

/* ---> NO! XtFree(new_index); NOT here! in Release_Cards() etc... */

/* 
 There may be enough space to show another viewable card. Go check
 GOVERN tells the procedure to limit the number to map up to 1.
*/
     Any_To_Map(GOVERN);

/*
  The beginning of the viewable data is at this newly created card.
  Then want to display the card data.
*/
     Redraw_List();

} /* Add_Card_Callback */


/*
  ************************************************************************
  ************************************************************************
     Name
	Duplicate_Card

     Calling Sequence:
         This routine is only called from "Card_Menu_Callback"
         when the second sub-button is selected, "Duplicate"
     Description:
      This routine duplicated the primary card and its
      duplicate data right after itself. That new card
      becomes the primary card.
         0. Save the current card data!
         1. Convert the XmString data in the primary card
            to a char pointer
         2. Allocate space and copy the data.
         3. Create a new user data structure.
         4. Initialize the structure to point to the copied data
         5. Insert the structure right after the primary card.
         6. The new card becomes the primary card.
         7. Redraw the list

  ************************************************************************
  ************************************************************************
*/
static void Duplicate_Card(widget)
Widget widget;
{
char *new_index, *new_address;

/* There may have been updates in the primary card widgets. Go check. */
     Grab_Primary_Card_Data(widget);

/* There may be enough space to show another viewable card. Go check */
     Any_To_Map(GOVERN);

/* The primary card's data becomes the duplicated card's data */
  new_index      = XtMalloc(strlen(head_ptr->primary_card->index) + 1);
  new_address    = XtMalloc(strlen(head_ptr->primary_card->address) + 1);

  strcpy(new_index, head_ptr->primary_card->index);
  strcpy(new_address, head_ptr->primary_card->address);

/* Go do the motif independent stuff */
    if ( !(head_ptr->primary_card = Add_Card(new_index, new_address, head_ptr->primary_card)))
	  Abend(widget,-1,"Cannot allocate a new card");

/* Go draw just changed list */
     Redraw_List();

} /* end Duplicate_Card */
