/*
   KARAOKE

   Copyright (c) 1993 JP COCATRIX , L TAIEB. All rights reserved.

   kplay.c : the midi reader and player
*/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/uio.h>
#include <sys/ioctl.h>
#include <stdlib.h>
#include <fcntl.h>
#include <co.h>
#include "kplay.h"

#ifdef linux
SEQ_USE_EXTBUF();
#endif

extern	int initmidi(void);
extern  void playevents(void);
extern  void kreceive(int) ;

extern int seqfd;
extern struct DATACOM *pmc;

int karalin = FALSE; /* TRUE si karalin, FALSE si stand_alone */
fd_set fd_set_kplay;
int recu;		/* nombre de message recu	*/
union MSG rmes;	/* buffer de reception d'un message */
int rlength;		/* taille du message recu  	*/
int status;



/* ==================================================================== */
/*  retourne le nombre de messages recus en attente       		*/
/* ==================================================================== */
int received(int tempo)
{
  struct timeval timout;
  timout.tv_sec = 0;
  timout.tv_usec = tempo*1000; /* en milli secondes */
  FD_ZERO(&fd_set_kplay);
  FD_SET(l_co_socket_c34  , &fd_set_kplay);
  return ( select (FD_SETSIZE, &fd_set_kplay,0,0,&timout));
}


/* ==================================================================== */
/* dump le buffer evt midi sur le sequencer				*/
/* ==================================================================== */
void seqbuf_dump()
{
#ifdef linux
   if (_seqbufptr)
      if (write(seqfd, _seqbuf, _seqbufptr) == -1)
      {
	 perror("write " SEQUENCER_DEV );
	 exit(-1);
      }
   _seqbufptr = 0;
   ioctl(seqfd, SNDCTL_SEQ_SYNC);  /* attend que le buffer soit vide */
#endif
}




/* ==================================================================== */
/* initialise kplay : lecture des devices son de la config              */
/* ==================================================================== */
void kplay_init(void)
{
#ifdef linux
   int i;

   if ((seqfd = open(SEQUENCER_DEV, O_WRONLY, 0)) < 0)
   {
      perror("open " SEQUENCER_DEV);
      exit(-1);
   }
   if (ioctl(seqfd, SNDCTL_SEQ_NRSYNTHS, &(pmc->nbrSynth)) == -1)
   {
      Dprintf(stderr, "there is no soundcard\n");
      exit(1);
   }
   if (ioctl(seqfd, SNDCTL_SEQ_NRMIDIS, &(pmc->nbrMidi)) == -1)
   {
      Dprintf(stderr, "there is no midi output\n");
   }
   for (i = 0; i < pmc->nbrSynth; i++)
   {
      pmc->synth_Info[i].device = i;
      if (ioctl(seqfd, SNDCTL_SYNTH_INFO, &(pmc->synth_Info[i])) == -1)
      {
	 Dprintf(stderr, "cannot get info on soundcard\n");
	 perror(SEQUENCER_DEV);
	 exit(-1);
      }
   }
   for (i = 0; i < pmc->nbrMidi; i++)
   {
      pmc->midi_Info[i].device = i;
      if (ioctl(seqfd, SNDCTL_SYNTH_INFO, &(pmc->midi_Info[i])) == -1)
      {
	 Dprintf(stderr, "cannot get info on soundcard\n");
	 perror(SEQUENCER_DEV);
	 exit(-1);
      }
   }
#endif
}

void kplay_list()
{
int i,isub;
char type[3][7]={"FM","SAMPLE","MIDI"};
char subtype[3][6]={"ADLIB","OPL3","GUS"};
#ifdef linux
   printf( "Nombre de synthe : %d\nNombre de midi : %d\n",pmc->nbrSynth,pmc->nbrMidi);
   for (i=0;i<pmc->nbrSynth;i++)
   {
      if (pmc->synth_Info[i].synth_subtype==0x10) isub = 2;
      else isub = pmc->synth_Info[i].synth_subtype;
      printf( "   Synthe : %d    %s\n",i+1,pmc->synth_Info[i].name);
      printf( "        type : %s , subtype : %s\n",type[pmc->synth_Info[i].synth_type] 
      ,subtype[isub]);
      printf( "       voices: %d , bank size 0x%x\n",
       pmc->synth_Info[i].nr_voices,pmc->synth_Info[i].instr_bank_size);
      printf("        capabilities : 0x%x\n",pmc->synth_Info[i].capabilities); 
   }   
   for (i=0;i<pmc->nbrMidi;i++)
   {
      printf( "   Midi  : %d    %s\n",i+1,pmc->midi_Info[i].name);
      printf( "        type : %d \n",type[pmc->midi_Info[i].dev_type] );
      printf("        capabilities : 0x%x\n",pmc->midi_Info[i].capabilities); 
   }   
#endif
}
int main(argc, argv)
   int argc;
char **argv;
{
int l_co_socket_srv_c5;
/* cherche si on est avec karalin ou stand_alone */
/* Si la memoire commune existe, alors karalin   */
  if( f_co_shm_attach() == 0) karalin = TRUE;

  if (karalin)
  {
    pmc = p_co_share_tables;
    /* connection a kmusic */
    Dprintf(stderr,"Kplay: avant connexion a kmusic socket %x\n",l_co_socket_c34);
    if (!f_co_cnx_c34()) exit(1);


    Dprintf(stderr,"Kplay: connecte a kmusic socket %x\n",l_co_socket_c34);
    /* declaration de la socket avec klyric */

     if ( f_co_dcl_serveur(K_CO_SOCKADDR_C5, &l_co_socket_srv_c5) == False)
   {
    Dprintf (stderr, "\nImpossible de declarer le serveur c5 \n");
    exit (-1);
   }

   /* attente connexion de klyric */
   l_co_socket_c5 = f_co_get_connexion (l_co_socket_srv_c5); 

  }
  else
  {
    if ((pmc = malloc(sizeof(struct DATACOM)))==NULL)
      exit(-1);
     if (argc >1)
        strcpy(pmc->fileToPlay,argv[1]);
     else
        strcpy(pmc->fileToPlay, "/dos/kara/da/pastoi.mid");
  }
   if (!karalin)
   {
     pmc->typeOutput = GUS ; /* GUS ou SB ou MIDI 		*/
     pmc->wantopl3 = TRUE;  /* pour SB en mode opl3	*/
   }

   kplay_init();
   if (!karalin) kplay_list();

/* boucle si karalin (attend les ordres) ou joue une chanson et exit 	*/
/*  si stand_alone  							*/
  if (karalin)
  {
	while (TRUE)
        {
          kreceive(200);
        }        
  }
  else
  {

    if (initmidi())   playevents();

  }
return 0;
}

