/*****************************************************************************/
/*          KaraLin  Le Karaoke pour linux                                   */
/*                                         Copyright(C) JP.Cocatrix L.Taieb  */
/*****************************************************************************/

/*****************************************************************************/
/* kplay.h : include pour kplay                                          */
/*****************************************************************************/

#define SEQUENCERBLOCKSIZE	1024
#define SEQUENCER_DEV		"/dev/sequencer"
/* le mode par defaut en opl  0= opl2 1= opl3 */
#define FM_DEFAULT_MODE		0
/* le masque des canaux drums  canal 10*/
#define PERCUSSION	0x0200
/* le masque des canaux parole canal 1 */
#define PAROLE		0x0001
#define ISPERC(x)	(pmc->drum & (1 << x))
#define ISLYRIC(x)	(pmc->parole & (1 << x))
#define ISMIDI(x)	(play_ext)

/* default pour les chemins et noms de banks */
#define PATCH_PATH_GUS	"/dos/ultrasnd/midi"
#define SB_MELODIC	"./std.sb"
#define SB_MELODIC_O3	"./std.o3"
#define SB_DRUMS	"./drums.sb"
#define SB_DRUMS_O3	"./drums.o3"


/*  nombre max de track dans un fichier midi  */
#define NBTRACK 36

struct HEAD {            	/*  Header chunk informations	*/
	WORD smf;		/*  type de fichier smf		*/
	WORD nb_tracks; 	/*  nombre de tracks dans le fichier	*/
	WORD delta_ticks;	/*  nombre de delta ticks par quart de note*/
	WORD numerator;
	WORD denominator;
	WORD tickPerClick;	/*  nombre de ticks par midi click	*/
	WORD n32Quart;   	/*  nb de 1/32 de notes  par quart	*/
	struct TEMPO *ptempo;	/*  chaine des tempos		*/
	struct LYRIC *plyric;	/*  chaine des textes		*/
	BYTE midiclock;	/*  nombre de midi clock par quart de note*/
	}  ;
struct TMIDI {			/*  midi event structure	*/
	LONG delta;	/*  delta time				*/
	BYTE nb;	/*  nombre d'octets significatifs	*/
	BYTE event[3];	/*  tableau d'evenements		*/
	}  ;
struct TRACK {		/*  Track chunk structure	*/
	LONG nb_events;	/* nombre d'evenement midi dans le track*/
	LONG maxDelta;	/*  nombre max de delta dans le track	*/
	struct TMIDI (*debut)[1];	/*  adresse du tableau	*/
	LONG cur; 	/*  index de la position courante	*/
	LONG cdelta;	/* delta courant sur le track		*/
	}  ;
struct TEMPO {		/* tempo event structure		*/
	LONG delta;	/*  delta time				*/
	LONG tempo;	/*  nombre de microsecondes par quart de note*/
	struct TEMPO *next;	/*  cellule suivant		*/
	}  ;
struct LYRIC {			/*  cellule des paroles		*/
	LONG delta;	/*  delta time				*/
	WORD  type;	/*  note on ou off			*/
	struct LYRIC *next;	/*  cellule suivante		*/
	} ;
struct CHUNK {
	BYTE nom[4];		/*  MThd ou MTtk		*/
	LONG	len;	/*  longueur en octet			*/
	}  ;

