/*
	 KARAOKE

	 Copyright (c) 1993 JP COCATRIX , L TAIEB. All rights reserved.

kplay.c : the midi reader and player
*/

#include <stdlib.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include <co.h>
#include "kplay.h"
#include "karainst.h"
#ifndef linux
#include "soundcard.h"
#endif

#ifdef USE_SEQUENCER2
#define seq_set_patch(a, b, c) (SEQ_SET_PATCH(a, b, c))
#define seq_key_pressure(a, b, c, d) (SEQ_KEY_PRESSURE(a, b, c, d))
#define seq_start_note(a, b, c, d) (SEQ_START_NOTE(a, b, c, d))
#define seq_stop_note(a, b, c, d) (SEQ_STOP_NOTE(a, b, c, d))
#define seq_control(a, b, c, d) (SEQ_CONTROL(a, b, c, d))
#define seq_chn_pressure(a, b, c) (SEQ_CHN_PRESSURE(a, b, c))
#define seq_bender(a, b, c) (SEQ_BENDER(a, b, c))
#define seq_reset() (ioctl(seqfd, SNDCTL_SEQ_RESET, 0))
#else
extern void seq_set_patch(int, int, int);
extern void seq_key_pressure(int, int, int, int);
extern void seq_start_note(int, int, int, int);
extern void seq_stop_note(int, int, int, int);
extern void seq_control(int, int, int, int);
extern void seq_chn_pressure(int, int, int);
extern void seq_bender(int, int, int);
extern void seq_reset();
#endif

double mf_ticks2sec (unsigned long ticks, int division, unsigned long tempo);
void ksend(union MSG msg);
void ksendl(char * msg);
void ksend5(union MSG msg);
void kexit(int r);
int received(int time);
void finmidi(void);
int  initmidi(void);
void playevents(void);
void resmidi(void);
void allnotesoff(void);




extern	void gus_load(int);
extern 	void loadfm();
extern  int getstring(int,char*,int);
extern  int parse(char *,char,char); 
extern  void sampling(char*);

void setrythme(LONG);

/*  PROVISOIRE POUR SIMULER LA MEMOIRE PARTAGEE */
struct DATACOM *pmc;
char lyr[8000][80];
int ilyr=0;
/*--------------------------------------------------------------*/
#ifdef linux
SEQ_DEFINEBUF(SEQUENCERBLOCKSIZE);
#endif
int midifile;		/*  file reference du midi en lecture	*/
int textefile;		/*  file reference du texte		*/
int seqfd=0XFFFF;	/*  file reference du device sequenceur */

int texteflag;		/* TRUE si .txk				*/
int karflag;		/* TRUE si .kar				*/

#define STOP 	0
#define START	1

/* memoire locale des mutes pour decider de stopper les notes */
BYTE mute[16];
byte transpose;
byte mute_a_faire = FALSE;

int playing  = START;	/* START si musique peut jouer		*/

int f_run = FALSE;	/* TRUE si midi  actif			*/
int f_loaded = FALSE;	/* TRUE si midi charge 			*/

float skew = 100.0;	/* facteur de temps	*/
float current = 0.0, dtime = 0.0;

	LONG nextdelta = 0;	/* le delta suivant		*/
	LONG cumuldelta = 0;

int gus_dev,sb_dev,ext_dev;	/* device pour les sorties */

int use_dev;
int play_gus,play_sb,play_ext;	/* flag du choix utilisateur */
int wantopl3;			/* si play_sb 	*/
int force8bits;			/* si GUS	*/
int reverb=0;
int verbose = 0;


WORD hardware;

struct HEAD  head;
struct TRACK track[NBTRACK]; /* NBTRACK tracks possibles	*/
struct CHUNK chunk;
struct TMIDI *midi;
struct TEMPO *ptempo;
struct LYRIC *plyric;


struct TMIDI  smidi;
BYTE patchload[256];  	/*  patches a charges pour GUS		*/
int  patchloaded[256];	/*  patches charges pour GUS		*/
LONG tempoDelta;
LONG lyricDelta;

struct CHUNK   chunk;


LONG deltadelt = 0; 		/*  pour rattrapage evt midi si meta ou system
*/
LONG tempodelt = 0; 		/*  cumul delta pour events  tempo	*/
LONG lyricdelt = 0; 		/*  cumul delta pour lyrics mode texte	*/
LONG maxDelta  = 0; 		/*  cumul delta absolu			*/

LONG	tempo;			/*  le tempo courant			*/
int ticks;			/* pour timestamp			*/

BYTE  uno;	/*  le caractere courant lu.			*/
LONG olu;	/*  nb BYTEs lus dans file par chunk		*/


LONG timeSinceBegin;	/*  le temps courant en ticks			*/
LONG maxTime;		/*  le nombre de ticks maximum			*/

union MSG msg;
union MSG amsg[128];	/* queue de msg C34		*/
union MSG bmsg[128];	/* queue de msg C5		*/
extern union MSG rmes;
extern int rlength;
extern int recu;

int iamsg = 0;		/* index sur amsg	*/
int ibmsg = 0;		/* index sur bmsg	*/

extern int   karalin ;  /*  FALSE si stand alone	*/




/*------------------------------------------------------------------------*/
/* Une erreur a signaler a l'utilisateur				  */
void sayError(char * erreur)
{
  Dprintf(stderr,"Error : %s\n",erreur);
}
/**************************************************************************/
/* pour linker	*/
void SayError(char *string)
{
  Dprintf(stderr,"Error %s\n",string);
}
void SayHello(char *texte)
{
  Dprintf(stderr,"Hello %s\n",texte);
}
void SaySo(char *texte)
{
  strcpy(pmc->trackName,texte);
  msg.s.code = C5_TRACKN;
  msg.s.par1 = strlen(texte);
  ksend5(msg);
  ksendl(texte);
  /*fprintf(stderr,"Kplay: Track: %s\n",texte);*/
  ilyr=0;
}  
void noroom(char *mes)
{
  Dprintf(stderr,"NoRoom: %s\n",mes);
    kexit(-5);
}    
void ligning(void)
{
  msg.s.code=C5_CRLF;
  ksend5(msg);
  if (lyr[ilyr][0] == 0)
	strcpy(&lyr[ilyr][0],"\n");  
  else
	strcat(&lyr[ilyr][0],"\n");
}  
void lyring(char*str)
{
  if (strcmp(str,"\n")==0) ligning();
  else
  {
    msg.s.code=C5_LENGTH;
    msg.s.par1= strlen(str);
    ksend5(msg);
    ksendl(str); 
    strcat(&lyr[ilyr++][0],str);  
/*fprintf (stderr, "\nKPLAY : string [%s], len [%d]", str,strlen (str));
*/  }
}  
  
/**************************************************************************/

/*------------------------------------------------------------ debut playmidi */
/* ouvre le fichier name meme s'il est zippe et retourne l'entier descripteur de
fichier*/
#define GUNZIP "gunzip -c"
int copen(name)
char *name;
{

    int compressed = 0, namelen = strlen(name);
    char *command = NULL;
    FILE *myfile;

    if (namelen >= 2)
	if (!strncmp(name + namelen - 2, ".Z", 2) ||
	    !strncmp(name + namelen - 2, ".z", 2))
	    compressed++;
	else if (namelen >= 3)
	    if (!strncmp(name + namelen - 3, ".gz", 3))
		compressed++;

    if (!compressed) {
	if ((myfile = fopen(name, "rb")) == NULL) {
	    perror(name);
	    return -1;
	}
    } else {
	command = (char *) malloc(strlen(name) + strlen(GUNZIP) + 1);
	sprintf(command, "%s '%s'", GUNZIP, name);
	if ((myfile = popen(command, "rb")) == NULL) {
	    perror(name);
	    free(command);
	    return -1;
	}
	free(command);
    }
    return fileno(myfile);
}
/*----------------------------------------------------------------------- fin playmidi */
/*		Communications						*/
/*----------------------------------------------------------------------*/
/* mise en queue d'un message C34*/
void ksendq(BYTE code,BYTE par1,BYTE par2,BYTE par3)
{
  amsg[iamsg].s.code = code;
  amsg[iamsg].s.par1 = par1;
  amsg[iamsg].s.par2 = par2;
  amsg[iamsg].s.par3 = par3;
  iamsg++;
}
/* mise en queue d'un message C5*/
void ksendq5(BYTE code,BYTE par1,BYTE par2,BYTE par3)
{
  bmsg[ibmsg].s.code = code;
  bmsg[ibmsg].s.par1 = par1;
  bmsg[ibmsg].s.par2 = par2;
  bmsg[ibmsg].s.par3 = par3;
  ibmsg++;
}

/* emission de la queue de messages */
void kflush(void)
{
  int i;
  if (iamsg == 0) return;
  for (i=0;i<iamsg;i++) ksend(amsg[i]);
  for (i=0;i<ibmsg;i++) ksend5(bmsg[i]);
  iamsg = 0;
  ibmsg = 0;
}

/* emission immediate d'un message */
void ksend(union MSG msg)
{
  if (karalin)
  {
    write (l_co_socket_c34,&msg,4);
  }
}
/* emission immediate d'un message */
void ksend5(union MSG msg)
{
  if (karalin)
  {
/*    fprintf(stderr,"KPLAY:ksend5 %x\n",msg.i);*/
    write (l_co_socket_c5,&msg,4);
  }
  else  if (msg.s.code ==C5_TXT_ON)
  {
      fprintf(stderr,"%s",&lyr[ilyr++][0]);
  }
}

/* emission immediate d'un message long de texte */
void ksendl(char * msg)
{
  if (karalin)
  {
/*    fprintf(stderr,"KPLAY:ksendl %s len=%d\n",msg,strlen(msg));*/
    if (strlen(msg) != 0)
    write (l_co_socket_c5,msg,strlen (msg));
    else
    write (l_co_socket_c5," ",1);

  }
}

void kexit(int r)
{
	Dprintf(stderr,"Kplay exiting with %x\n",r);
	msg.s.code= C4_EXITED;
	ksend(msg);
	if (!karalin)
	{
		Dprintf(stderr,"Kplay exit\n");
		exit(r);
	}
}

void kreceive(int combien_de_temps)
{
#ifndef linux
	if((recu=received(skew/2))!= 0) 
#else
	if ((recu=received(combien_de_temps)) != 0) 
#endif
	switch(recu)
	{
            case -1 : kexit (-1);
            case 0  : break;
            default:
            {
		rlength = read (l_co_socket_c34,&rmes,4);
       		if (rlength == 0) kexit (-2);
        	Dprintf(stderr,"Recu kplay %x f_run %d playing %d\n",rmes.i,f_run,playing);
        	switch (rmes.s.code)
        	{
          	case C3_LOAD:
			if (f_run) finmidi();

            		if (initmidi()) 
            			Dprintf(stderr,"Kplay: midi loaded\n");
			else
            			Dprintf(stderr,"Kplay: midi not loaded\n");
				
            		break;
          	case C3_START:
			skew = 100.0;
       			playing = START;
			if (f_loaded && !f_run)
			{
				playevents();
			}
            		break;
          	case C3_STOP :
			allnotesoff();
            		playing = STOP;
            		break;
		case C3_REWIND:
			skew = 100.0;
			if (f_loaded) resmidi();
			break;
		case C3_SPEED:
			skew = rmes.s.par1;
			break;
		case C3_BPM:
			if (pmc->bpm != 0)
			tempo = (60000000/(pmc->bpm + (signed)pmc->ppm));
 Dprintf(stderr,"KPLAY: tempo = %d  bpm = %d ppm = %d\n",tempo,pmc->bpm,(signed)pmc->ppm);
			break;
		case C3_FORWARD:
		case C3_BACKWARD:
			break;
          	case C3_EXIT : exit (0);
          	default : Dprintf(stderr," Kplay: recu %d . Pourquoi?\n",rmes.i);
		} 	
	    }
	}
}



/********************************************************/
/* reserve un espace et lit le fichier 			*/
/********************************************************/
static char *pchar;
static char *pcharsave;
char* readininit(int file,int length)
{

	if ((pchar=(char*)malloc(length+1))==NULL) return NULL;
	pcharsave = pchar;
	read(file,pchar,length);
	return pchar;
}

/********************************************************/
/* retourne un char de l'espace 			*/
/********************************************************/
#define readin(c)	c=*(pchar++)


/********************************************************/
/* libere l'espace					*/
/********************************************************/
#define  readinfree()	free(pcharsave)
	


/********************************************************/
LONG calc4head()	  /* calcul une valeur lue sur 4 BYTEs	*/
{
	int i;
	union UNION {
	BYTE entier[4];
	LONG vrai;
	} resultat;

	resultat.vrai = 0;
#ifdef linux
	for ( i=3;i!=-1;i--)
#else
	for (i=0;i<4;i++)
#endif
	read(midifile,&resultat.entier[i],1);
	olu += 4;
	return resultat.vrai;
}
/********************************************************/
LONG calc4()	  /* calcul une valeur lue sur 4 BYTEs	*/
{
	int i;
	union UNION {
	BYTE entier[4];
	LONG vrai;
	} resultat;

	resultat.vrai = 0;
#ifdef linux
	for ( i=3;i!=-1;i--)
#else
	for (i=0;i<4;i++)
#endif
	readin(resultat.entier[i]);
	olu += 4;
	return resultat.vrai;
}
/********************************************************/
LONG calc3()	  /* calcul une valeur lue sur 3 BYTEs		*/
{
	int i;
	union {
	BYTE entier[4];
	LONG vrai;
	} resultat;

	resultat.vrai = 0;
#ifdef linux
	for ( i=2;i!=-1;i--)
#else
	for (i=1;i<4;i++)
#endif
	readin(resultat.entier[i]);
   	olu += 3;
	return resultat.vrai;
}

/********************************************************/
WORD calc2()		/* calcul une valeur lue sur 2 BYTEs	*/
{
	int i;
	union {
	BYTE entier[2];
	 WORD vrai;
	} resultat;

	resultat.vrai = 0;
#ifdef linux
	for ( i=1;i!=-1;i--)
#else
	for (i=0;i<2;i++)
#endif
	readin(resultat.entier[i]);
	olu += 2;
	return resultat.vrai;
}

/********************************************************/
LONG calcdelta() /* calcul une valeur en format delta		*/
{
	LONG delta;
	WORD nombre;
	BYTE lu;
	nombre = 0; /* pour controle	*/
	delta = 0;
	lu = 0X80;
	while (((lu&0X80) !=0)&&(nombre < 5))
	{
		readin(lu) ; /* bug si on depasse EOF */
		olu ++;nombre++;
		delta = (delta<<7) | (lu&0x7F);
	}
	if (nombre >=5) SayError("file error delta");
	return delta;
}

/********************************************************/
void increment( WORD combien)	/* saute combien d'BYTE dans le fichier */
{
  int i;
 for (i=0;i<combien;i++)
 {readin(uno);olu++;}
}


/********************************************************/
void chunk_head()			/* lit le nom et la longueur		*/
{
	int i;
	for (i=0;i<4;i++)
	{
		read(midifile,&uno,1);
		chunk.nom[i] = uno;
	}
	chunk.len = calc4head();
	if(readininit(midifile,chunk.len)==NULL)
	{
		SayError("kplay: Chunk Head space");
		kexit(-3);
	}
}


/********************************************************/
int mthd()			          /* interprete le chunk header		*/
{
	char texte[80];
	 
	chunk_head();
	if (strncmp("MThd",(char *)chunk.nom,4)!=0)  
	{
		SayError("not a Midi file");
		return FALSE;
	}
	head.smf = calc2();
	sprintf (texte,"Midi type %d",head.smf);
	Dprintf (stderr, "Midi type %d\n",head.smf);
	head.nb_tracks = calc2();
	head.delta_ticks = calc2();
/* la premiere tempo */
	ptempo= (struct TEMPO *)calloc(1,sizeof(struct TEMPO));
	if (ptempo == NULL) noroom("Head tempo");
	ptempo->next = NULL;
	if (head.delta_ticks > 0x8000) /*SMPTE*/
	{
		ptempo->delta = 0xFFFFFFFF; /* never */
	}
	else
	{
		ptempo->tempo = 500000; /* 120 bpm par defaut */
		ptempo->delta = 0;
        }
        setrythme(500000);
	head.ptempo = ptempo;
/* le premier evt lyric */
	plyric= (struct LYRIC *)calloc(1,sizeof(struct LYRIC));
	if (plyric == NULL) noroom("Head lyric");
	plyric->next = NULL;
	head.plyric = plyric;

	readinfree();

	return TRUE;
}

/********************************************************/
WORD inrange(BYTE cc,BYTE min,BYTE max)
{
	if ((cc >= min) && (cc <= max)) return 1;
	else return 0;
}
/********************************************************/
/* lyric a completer + reserver le suivant		*/
void cmlyric ( int type, LONG *delta)
{
	 plyric->delta =  *delta;
	 *delta = 0;  /*lyricdelt = 0;*/
	 plyric->type = type;
	 
	 plyric->next = (struct LYRIC *)calloc(1,sizeof(struct LYRIC));
	 plyric = plyric->next;
	 if (plyric == NULL) noroom("lyric");
	 plyric->delta = 4*head.delta_ticks; /* pour eteindre */
	 plyric->next = NULL;
}
/********************************************************/

char tibm[]={
0xc7,0xfc,0xe9,0xe2,0xe4,0xe0,0xe5,0xe7,0xea,0xeb,
0xe8,0xef,0xee,0xec,0xc4,0xc5,
0xc9,0xe6,0xc6,0xf4,0xf6,0xf2,0xfb,0xf9,0xff,0xd6,
0xdc,0xa2,0xa3,0xa5,0xbf,0xbf};

/* conversion d'un caractere DOS en jeu ISO			*/
unsigned char ibm(unsigned char car)
{
	if ( (car < 0X80)||(car >= 0xa0)) return(car);
	car-=0X80;
	Dprintf(stderr,"KPLAY: convert %x en %x\n",car+0x80,tibm[car]);
	return(tibm[car]);
}

/* lyric a creer pour evenement meta			*/
/* avec conversion des caracteres ansi en jeu IBM	*/
void createlyric(LONG taille,BYTE leun)
{
	BYTE buf[132];
	BYTE *ptr;
	LONG ofdelta;
	int index = 0;

	if ((taille|leun) !=0)
	{
/* genere une extinction si le precedent est trop long	*/
		if (lyricdelt > (3*head.delta_ticks))
		{
			ofdelta = (3*head.delta_ticks);
			cmlyric(0,&ofdelta);
			lyricdelt-=(3*head.delta_ticks);
		}
		else
		{ /* eteint juste*/
			if (plyric != head.plyric)cmlyric(0,&lyricdelt);/*si pas le
			premier*/
		}
	}
	if (leun !=0) buf[index++]=ibm(leun);
	while (taille >0)
	{
		increment(1);taille--;
		buf[index++]=ibm(uno);
	}
	buf[index] = (BYTE) 0;
	ptr = (BYTE *)malloc( strlen(buf) +1);
	if (ptr == 0) noroom("createlyric");
	strcpy(ptr,buf);

	lyring(ptr); 
/*   send the texte to klyric */
   
/* creer le lyric correspondant*/
	cmlyric(1,&lyricdelt);
}


/********************************************************/
void evtmidi()			/* evt midi pur		*/
{
	BYTE cod,chan;

	midi->delta += deltadelt;
	deltadelt = 0;
	midi->event[0] = uno;		/* evt		*/
	cod=uno;
	chan = cod & 0x0F;
	if ((inrange(uno,128,176+15)) || (inrange(uno,224,224+15)))
	{ 				/* note off, note on,polyp. aftertouch	*/
					/* ,controlchange, pitch bender		*/
		readin(uno);olu++;
		midi->event[1] = uno;	/*evt*/
		readin(uno);olu++;
		midi->event[2] = uno;	/*evt*/
		midi->nb = 3;


		if (( (cod&0XF0)==0X90)&&(midi->event[2]==0))
		{
			midi->event[0] &= 0XEF; /* transforme en note off	*/
			cod=midi->event[0];
		}
/* pour GUS : prendre au vol les instruments de percussions utilises.		*/
		if (( (cod&0xF0)==0X90)&&ISPERC(chan)&&(midi->event[1]>26))
		{
			patchload[(midi->event[1])+128] = 1;
    		}
/* si mode texte alors generer les lyrics au rythme des notes on et off	*/
/* du canal parole							*/
		if (texteflag)
		{
			if (( (cod&0xF0)==0X90)&&ISLYRIC(chan))
			{
				cmlyric(1,&lyricdelt);
			}
			if (( (cod&0xF0)==0X80)&&ISLYRIC(chan))
			{
				cmlyric(0,&lyricdelt);
			}
		}
	}

	else if (inrange(uno,192,192+15))
	{					/* program change	*/
		readin(uno);
		olu++;
		midi->event[1] = uno;		/*evt*/
		midi->nb = 2;

		/* charger l'instrument (patch) si pas deja fait.	*/
		if (~ISPERC(chan))
		{
	        	patchload[uno] = 1;
		}
	}

	else if (inrange(uno,208,208+15))
	{						/* aftertouch	*/
		readin(uno);olu++;
		midi->event[1] = uno;		/*evt*/
		midi->nb = 2;
	}
}


/********************************************************/
void evtmidicas(BYTE last)			/* evt midi running status*/
{
	BYTE cod,chan;

	midi->delta += deltadelt;
	deltadelt = 0;
	midi->event[0] = last;		/*evt*/
	cod = last&0xF0;
	chan = last &0x0F;
	if ((inrange(last,128,176+15)) || (inrange(last,224,224+15)))
	{ 					/* note off, note on,polyp. aftertouch*/
						/* ,controlchange, pitch bender	*/
		midi->event[1] = uno;		/*evt*/
		readin(uno);olu++;
		midi->event[2] = uno;		/*evt*/
		if (( cod==0X90)&&(uno==0))
		{
			midi->event[0] &= 0XEF; /* transforme en note off	*/
		}
		midi->nb = 3;
		cod=midi->event[0];

/* pour GUS : prendre au vol les instruments de percussions utilises.		*/
		if (( (cod&0xF0)==0X90)&&ISPERC(chan)&&(midi->event[1]>26))
       			patchload[(midi->event[1])+128] = 1;

/* si mode texte alors generer les lyrics au rythme des notes on et off		*/
/* du canal parole								*/
		if (texteflag)
		{
			if (( (cod&0xF0)==0X90)&&ISLYRIC(chan))
			{
				cmlyric(1,&lyricdelt);
			} else
			if (( (cod&0xF0)==0X80)&&ISLYRIC(chan))
			{
				cmlyric(0,&lyricdelt);
			}
		}
	}
	else if (inrange(last,192,192+15))
	{					/* program change	*/
		midi->event[1] = uno;		/*evt*/
		midi->nb = 2;
		/* charger l'instrument (patch) si pas deja fait.		*/
		if (~ISPERC(chan))
		{
		        patchload[uno] = 1;
		}
	}

	else if (inrange(last,208,208+15))
	{					/*  aftertouch		*/
		midi->event[1] = uno;		/*evt*/
		midi->nb = 2;

	}
}

/********************************************************/
/* 	traiter les evenements systeme . ignorer 	*/
void evtsyst()
{
	deltadelt += midi->delta; /* pour le prochain midi evt */
	increment( calcdelta());
}

/********************************************************/
void evtmeta(  WORD *numt)
{
	LONG taille;
	LONG us;     /*micro secondes	*/
	BYTE *pban;
	BYTE *cban;
	BYTE *clig;
	BYTE lignetexte[80];
	WORD index;

		deltadelt += midi->delta; /* pour le prochain midi evt		*/
		readin(uno);olu++;  /* evt meta				*/
		switch (uno) {
		case 0x51 : 			/* positionne le tempo		*/
			ptempo->delta =  tempodelt;
			tempodelt = 0;
			increment(1);
			us=calc3();
			if (head.delta_ticks > 0) ptempo->tempo = us;
			else /* SMPTE */
				break;
			ptempo->next = (struct TEMPO *)calloc(1,sizeof(struct TEMPO));
			ptempo=ptempo->next;
			if (ptempo == NULL) noroom("tempo");
			ptempo->next = NULL;
			ptempo->delta = -1;
		 break;

		case 0x58:        	/* signature temporelle			*/
		 increment(2);
		 head.numerator = uno;
		 increment(1);
		 uno *= uno;
		 head.denominator = uno;
		 increment(1);
		 head.tickPerClick = uno;
		 increment(1);
		 head.n32Quart = uno;
		 break;

		case 0X03:
		 taille = calcdelta();
		 clig=lignetexte;
				 while (taille >0)
				 {
					 increment(1);taille--;
					 *(clig++)=uno;
				 }
		 *clig=0;
 		  SaySo(lignetexte);
		 break;

		case 0X2F:
			olu = chunk.len; /* force la fin			*/
			increment(calcdelta()); /* saute (provisoire)	*/
			break;

    		case 0X05:
      			if (texteflag==FALSE){karflag=TRUE;}
           		/* warning no break intentionally	*/
		case 0X01:				/* texte info		*/
    		if (!*numt&&(pmc->Banner.info==0)) *numt=TRUE;
		if (*numt/*&&karflag*/)
		{
			taille = calcdelta();
			index=0;
			if (taille != 0)
			{
			  taille--;
			  increment(1);
			  switch (uno)
			{
			  case '@':
			   increment(1);taille--;
			   if (uno != 'T')
         			{
           				ligning();
           				increment(taille);
         			}
			   else 	/* infos de titre			*/
			   {
           			if (!karflag&&!texteflag) /* kar recupere d'un mid*/
           			{
             				karflag=TRUE;
             				pmc->Banner.info=1;
           			}

           			switch (pmc->Banner.info++)
				{
					   case 0: pban = (BYTE*)(pmc->Banner.Title);
					   	strcpy(pmc->Banner.Comment1,"");
					   	strcpy(pmc->Banner.Comment2,"");
						break;
					   case 1: pban = (pmc->Banner.Comment1);
					   	strcpy(pmc->Banner.Comment2,"");
						break;
					   case 2:
					   default:pban = (pmc->Banner.Comment2);
					   	break;
				 }
				 cban=pban;
				 while (taille >0)
				 {
					 increment(1);taille--;
					 *(cban++)=ibm(uno);
				 }
				 *cban=0;
				/* init banner*/
				msg.s.code = C5_BANNER; /* affiche banner */
				msg.s.par1= strlen(pmc->Banner.Title);
				msg.s.par2= strlen(pmc->Banner.Comment1);
				msg.s.par3= strlen(pmc->Banner.Comment2);
				ksend5(msg);
				ksendl(pmc->Banner.Title);
				ksendl(pmc->Banner.Comment1);
				ksendl(pmc->Banner.Comment2);
			   }
			   break;
			  case 0X5C:
			   ligning();
			   ligning();
/* 		 paging();*/
			  case '/':
			   ligning();
			   createlyric(taille,0);
			   break;
			  default:
			   if ((uno >= 'A') &&(uno <= 'Z')) ligning(); /* si majuscule */
			   createlyric(taille,uno);
			  }
		  } else
			   createlyric(0,0);  /* zero */
		  break;
		}

		default:
			increment(calcdelta()); /* saute (provisoire) */
		}
}



/********************************************************/
int mttk()		/* interprete les chunk tracks	*/
{
	BYTE last=0;
	WORD reelnumt=0;
  	WORD flagp=TRUE; /* si pas encore d'evts midi musique		*/
	 int cur,numt;
	LONG left=0; /* il reste left memoire				*/
	

	for (numt=0;numt<head.nb_tracks;numt++)
	{
		tempodelt=0;	/* delta par track pour tempo			*/
		lyricdelt=0;	/* delta par track pour lyric			*/
		deltadelt = 0;  /* si system ou meta alors il faut corriger le prochain midi evt */
		chunk_head();
		if (strncmp("MTrk",(char *)chunk.nom,4)!=0)
		{
      			strcat(chunk.nom," not MTrk");
			SayError(chunk.nom);
		}
		olu = 0;
		track[numt].debut = (struct TMIDI (*)[])calloc(1,sizeof(struct TMIDI));
		if (track[numt].debut == NULL) noroom("mttk");
		midi = track[numt].debut[0];
		midi->nb = 0;
		track[numt].nb_events = 0;
		track[numt].cur=0;
		track[numt].maxDelta=0;
		while (olu < chunk.len)
		{
			midi->delta = calcdelta();
			tempodelt += midi->delta;
			lyricdelt += midi->delta;
			track[numt].maxDelta+=midi->delta;
			readin(uno);olu++;
			if ((uno >= 0x80) && (uno <0xF0))
			{
				if (track[numt].nb_events==0)
				{
           				flagp=FALSE;
					left =((chunk.len*64)/64)*sizeof(struct TMIDI);
					left = (left/sizeof(struct TMIDI)) ;
					track[numt].debut=
					(struct TMIDI ( *)[])realloc((struct TMIDI (*)[])track[numt].debut,left*sizeof(struct TMIDI));
					if (track[numt].debut == NULL) noroom("mttk");
					midi = track[numt].debut[0];
					midi->nb = 0;
				}
				last = uno;
				evtmidi();
				track[numt].cur++;
				if (track[numt].cur > left)
        			{
           				left++;
					track[numt].debut=
					(struct TMIDI (*)[])realloc((struct TMIDI (*)[])track[numt].debut,left*sizeof(struct TMIDI));
					if (track[numt].debut == NULL) noroom("mttkr");
					midi = (track[numt].debut)[track[numt].cur-1];
        			}

				track[numt].nb_events++;
				midi++;
			}
			else if ((uno == 0xF0) || (uno == 0xF7)) evtsyst();
			else if ( uno == 0xFF)  evtmeta(&flagp);
			else if (uno < 0X80)
			{
				evtmidicas(last);
				track[numt].cur++;
				if (track[numt].cur > left)
          			{
            				left++;
					track[numt].debut=
					(struct TMIDI (*)[])realloc((struct TMIDI (*)[])track[numt].debut,left*sizeof(struct TMIDI));
					if (track[numt].debut == NULL) noroom("mttkr1");
					midi = (track[numt].debut)[track[numt].cur-1];
          			}
				track[numt].nb_events++;
				midi++;
			}else
			{
				SayError("file error");
				return FALSE;
			}
		}
		readinfree();
		if (track[numt].nb_events != 0)
		{
			midi->delta = 0xffffffff; /* derniere cellule midi du track courant*/
			midi->nb = 0;
			track[numt].nb_events++;
			track[numt].debut=
				(struct TMIDI (*)[])realloc((struct TMIDI (*)[])track[numt].debut,(track[numt].nb_events+1)*sizeof(struct TMIDI));
			if (track[numt].debut == NULL)
				noroom("realloc1");

		} else
		{
			free (track[numt].debut);
			head.nb_tracks--;
			numt--;
		}
		reelnumt++;
	}
	for (numt=0;numt<head.nb_tracks;numt++)  /* max sur le track max	*/
		if (track[numt].maxDelta > pmc->maxTime) pmc->maxTime=track[numt].maxDelta;


/* load patch */
    if (play_gus)
    {
    	Dprintf (stderr, "Patches loading ... ");
    	fflush(stdout);
    	for (cur=0;cur<128;cur++)
	/* charger l'instrument (patch). */
    	{
 		if (patchload[cur]==1)
 		{	
			strcpy(pmc->patchName,gMidiInst[cur]); 
			/*  fprintf(stderr,"Kplay: Patch: %s\n",gMidiInst[cur]);*/
			msg.s.code=C5_PATCHN;
			msg.s.par1=strlen(gMidiInst[cur]);
			ksend5(msg);
			ksendl(gMidiInst[cur]);
 			gus_load(cur);	 				
 		}
	 	if (patchload[cur+128]==1)
	 	{
			strcpy(pmc->patchName,"Drums "); 
			msg.s.code=C5_PATCHN;
			msg.s.par1=strlen("Drums ");
			ksend5(msg);
			ksendl("Drums ");
	 		gus_load(cur+128);
		}
		fflush(stdout);
    	}
    	Dprintf(stderr, "Done\n");
    }

	return TRUE;
}

/********************************************************/
void setrythme(LONG temp)
{
   tempo = temp;
   pmc->bpm = 60000000/tempo;
   tempo =   60000000/(pmc->bpm+(signed)pmc->ppm); /* plus le ppm */
   Dprintf(stderr,"KPLAY: set tempo = %d  bpm = %d ppm = %d\n",tempo,pmc->bpm,(signed)pmc->ppm);
   msg.s.code = C4_TEMPO;
   msg.s.par1 = pmc->bpm;
   ksend(msg);
}


/********************************************************/

/********************************************************/
/* initialisation : 					*/
/* remise en tete des pointeurs				*/
/********************************************************/
void resmidi()
{
	register int i;
	ptempo = head.ptempo;
	tempoDelta = ptempo->delta;
	pmc->SecSinceBegin = 0;
	plyric = head.plyric;
	lyricDelta= plyric->delta;
	for (i=0 ;i<head.nb_tracks;i++)
	{
		track[i].cur=0;
		track[i].cdelta=track[i].debut[0]->delta;
	}
	msg.s.code = C5_BEGIN;
	ksend5(msg);
	nextdelta = 0;
	cumuldelta = 0;
	current  = 0.0;
	skew = 100.0;
	if (f_run)
	{
#ifdef linux
	  seq_reset();
	  SEQ_START_TIMER();
	  SEQ_DUMPBUF();
Dprintf(stderr,"KPLAY: resmidi, \n");
#endif
	}
}


/* ////////////////////////////////////////////////////////////// */ 
/*  lecture et interpretation du fichier demande dans fileToPlay/ */
/*  init de la memoire commune avec les valeurs par defaut si  	  */
/*   pas initialise.						  */
/* ////////////////////////////////////////////////////////////// */ 
int initmidi()
{
	int i;
	int ret=FALSE;
        char corps[256];
        char ext[5];
        char *ppoint;
        struct stat info;
        char uneligne [132];
        /* La palette de compatibilite avec KaraDos */
	char palette[MaxColors][40] = {
/*00*/ "black",
/*01*/ "blue1",
/*02*/ "green3",
/*03*/ "cyan3",
/*04*/ "red3",
/*05*/ "magenta3",
/*06*/ "brown3",
/*07*/ "gray80",
/*08*/ "gray20",
/*09*/ "LightBlue1",
/*10*/ "green1",
/*11*/ "cyan1",
/*12*/ "red1",
/*13*/ "magenta1",
/*14*/ "yellow1",
/*15*/ "white"
	};



	for (i=0;i<8000;i++) lyr[i][0]=0;
        ilyr = 0;       
	/* init patch a charger */
	for (i=0;i<256;i++) patchload[i]=0; /* init patches array*/
	
/* init memoire commune par defaut */
	/* path et chemin par defaut si non precise	*/
	if (pmc->patch_path_gus[0]=='\0')
		strcpy(pmc->patch_path_gus,PATCH_PATH_GUS);
	if (pmc->sb_melodic[0]=='\0')
		strcpy(pmc->sb_melodic,SB_MELODIC);
	if (pmc->sb_melodic_o3[0]=='\0')
		strcpy(pmc->sb_melodic_o3,SB_MELODIC_O3);
	if (pmc->sb_drum[0]=='\0')
		strcpy(pmc->sb_drum,SB_DRUMS);
	if (pmc->sb_drum_o3[0]=='\0')
		strcpy(pmc->sb_drum_o3,SB_DRUMS_O3);
		
	/* palette si non initialise */
	if (pmc->palette[0][0] == '\0')
	memcpy(pmc->palette , palette,sizeof(palette));

	/* canaux parole et drum	*/
	if (pmc->parole == 0) pmc->parole = PAROLE;
	if (pmc->drum == 0) pmc->drum = PERCUSSION;
	
	/* user name */
	if (pmc->user[0] == '\0') strcpy (pmc->user,"Shareware");

	/* instrument */
	for (i=0;i<128;i++) pmc->instrument[i][0] = 0;

	/* volume */
	if (pmc->volume ==0) pmc->volume = 0x7f;
	for (i=0;i<16;i++) if (pmc->volumeCanal[i]==0) pmc->volumeCanal[i] = 0x7f;

	/* divers */
	pmc->maxTime = 0; 	/* le nombre max de delta ticks */
	pmc->trackName[0] = 0;	/* nom du patch en chargement   */
	pmc->patchName[0] = 0;  /* patch en chargement		*/

	/* init Banner */
	strcpy(pmc->Banner.Title,"");
	strcpy(pmc->Banner.Comment1,"");
	strcpy(pmc->Banner.Comment2,"");
	pmc->Banner.info = 0;


/* init klyric */
	msg.s.code = C5_NEW; /* efface les paroles */
	ksend5(msg);

/* copie locale de mute */
	for (i=0;i<16;i++) mute[i]=pmc->mute[i];
	transpose = pmc->transpose;

/* init kplay */
        karflag = FALSE;
        texteflag = FALSE;
	
	play_gus = FALSE;
	play_sb =  FALSE;
	play_ext = FALSE;
	gus_dev = sb_dev = ext_dev = -1;
	switch (pmc->typeOutput)
	{
		case MIDI:
			play_ext = TRUE;
			ext_dev  = pmc->deviceNumber;
			use_dev = ext_dev;
			break;
		case GUS:
			play_gus = TRUE;
			gus_dev  = pmc->deviceNumber;
			use_dev = gus_dev;
			gus_load(-1);  /* init gus */
			break;
		case SB:
			play_sb  = TRUE;
			sb_dev   = pmc->deviceNumber;
			use_dev = sb_dev;
			loadfm();      /* init de la sb */
			break;
		default :
			break;
	}

/* recherche si c'est un <.kar> ou <.mid> ou <.mid et txk>*/
   	strcpy(corps,pmc->fileToPlay);
        if ((ppoint=rindex(corps,'.'))==NULL)
        {
          ext[0]= '\0';
        }
        else
        {
          strncpy(ext,ppoint,strlen(ppoint)+1);
          *ppoint = '\0';
          if (strcmp(ext,".kar") == 0) karflag = TRUE;
          else 
          {
            strcat(corps,".txk");
            if (stat(corps ,&info) == 0) texteflag = TRUE;
          }  
        }   
/* ouverture et lecture du fichier .txk */
   	if (texteflag)
        {
		Dprintf(stderr," open de %s\n",corps);
        	textefile = copen(corps);
 
 		getstring(textefile,uneligne,132);
		
		strcpy(pmc->Banner.Title,uneligne);
		/* commentaire */
		getstring(textefile,uneligne,132);
		strcpy(pmc->Banner.Comment2,"");
		strcpy(pmc->Banner.Comment1,uneligne);
		/* init banner*/
		msg.s.code = C5_BANNER; /* affiche banner */
		msg.s.par1= strlen(pmc->Banner.Title);
		msg.s.par2= strlen(pmc->Banner.Comment1);
		msg.s.par3= strlen(pmc->Banner.Comment2);
		ksend5(msg);
		ksendl(pmc->Banner.Title);
		ksendl(pmc->Banner.Comment1);
		ksendl(pmc->Banner.Comment2);
		while ((getstring(textefile,uneligne,132)>0))
		{
			if (parse(uneligne,'#',0))  ;
			else sampling(uneligne);
		}
                close(textefile);
        }

/* ouverture du fichier de musique */
   	if((midifile = copen(pmc->fileToPlay))== -1)
	{
        	if (karalin)
        	{
        		msg.s.code = C4_LOADED;
	        	msg.s.par1 = L_INEX;
        		ksend(msg);
			return FALSE;
	        }
        	else
	        kexit(-4);;
	}
	
	else {

/* lecture du fichier midi et interpretation */        
		if (mthd())	/* header 	*/
		  ret= mttk();	/* tracks	*/
                else ret = FALSE;
/* fermeture du fichier midi */        
	        close(midifile);
	
		msg.s.code= C4_LOADED;
		msg.s.par1= ret ? L_OK:L_NOK;
		ksend(msg);
		if (ret) 
		{
			resmidi();
			f_loaded = TRUE;
		}
	}
	return ret;
}

void control_change(WORD channel, WORD control, WORD value);
void finmidi()
{
        int ii;
	void *pt,*ptn;
        allnotesoff();
#ifdef linux
#endif	       

	for (ii = 0;ii<16;ii++)
	{
	  control_change(ii,0X07,0X7F); 	/* volume maxi		*/
    	  control_change(ii,0X0A,0X40); 	/* pan middle		*/
    	  control_change(ii,0X01,0X00); 	/* modulation		*/
	  control_change(ii,0x79,0); 	/* reset all controllers*/
	  control_change(ii,100,0);  	/* RPN MSB 0		*/
	  control_change(ii,101,0);  	/* RPN LSB 0		*/
	  control_change(ii,6,2);    	/* Pitch Bend Sensitivity MSB*/
	  control_change(ii,38,0);   	/* Pitch Bend Sensitivity LSB*/
#ifdef linux
	kflush();
	SEQ_STOP_TIMER();
	SEQ_DUMPBUF();
#endif
  	}

	/* free all TEMPO */
	pt = (void*)head.ptempo;
	ptn =(void*)((struct TEMPO*)pt)->next;
	while (pt != NULL)
	{
		free(pt);
		pt = ptn;
		if (ptn != NULL) ptn =(void*)((struct TEMPO*)pt)->next;
	}
	/* free all LYRICS*/
	pt = (void*)head.plyric;
	ptn =(void*)((struct LYRIC*)pt)->next;
	while (pt != NULL)
	{
		free(pt);
		pt = ptn;
		if (ptn != NULL) ptn =(void*)((struct LYRIC*)pt)->next;
	}
	/* free all tracks */
	for (ii=0;ii<head.nb_tracks;ii++)
	  free(track[ii].debut);
	f_loaded = FALSE;
	f_run = FALSE;
}

void sound(struct TMIDI *);

void control_change(WORD channel, WORD control, WORD value)
{
	smidi.nb=3;
	smidi.event[1]=control;
	smidi.event[2]=value;
	smidi.event[0]= (0xB0|channel);
	sound(&smidi);
#ifdef linux
	SEQ_DUMPBUF();
#endif
}

/************************************************************/
/* analyse l'evenement ( mute, transpose volume) et joue le */
/************************************************************/
void sound(struct TMIDI *ptr)
{
	static char lastCod ;	/*le dernier channel code emis */
	register BYTE cc;
	int i;
	WORD hs;
	WORD value;
	register BYTE prog,progi,chan,sec;

	hs = hardware;
	cc  = ptr->event[0];
	chan= ptr->event[0]&0X0F;
	prog= ptr->event[1];
	sec = ptr->event[2];

	if ((mute[chan]!= pmc->mute[chan])||(transpose!=pmc->transpose))
	{
/*           allnotesoff();	*/
	   mute_a_faire = TRUE;
           for (i=0;i<16;i++) mute[i] = pmc->mute[i];
           transpose = pmc->transpose;
	}
	if (((hs&0X8000) != 0)||(pmc->mute[chan]==1))
	{
		if (cc < 0XA0) /* note on et off ....	*/
		{
		  if ((cc&0xF0) == MIDI_NOTEON) 
		    ksendq(C4_ON,chan,prog,sec);
		    else ksendq(C4_OFF,chan,prog,sec);	
		  return;  /* en silence		*/
		}  
                  hardware &= 0X07FFF;
	}


	if (cc < 0XA0) /* note on et off		*/
	{
		progi = prog;
		if ( !ISPERC(chan))
			 prog += pmc->transpose + pmc->transposeCanal[chan];

		if (sec == 0) cc&=0xEF; /* retransforme en note off	*/
		else /* volume de la voix parole ou de l'ensemble si non .txk */
		{
			 sec = (BYTE)((sec * pmc->volumeCanal[chan])/128);
			 sec = (BYTE)((sec * pmc->volume)/128);
		}
	}

/* parse la commande midi */
	switch ( cc&0xF0 )
	{
		case MIDI_KEY_PRESSURE:
		  if (ISPERC(chan)&& sec && !ISMIDI(chan) )
		    seq_set_patch(use_dev, chan,prog+128);
		  else 
		    seq_key_pressure(use_dev,chan,prog,sec);
		  break; 
		case MIDI_NOTEON:
		  if (ISPERC(chan) && sec && !ISMIDI(chan))
		    seq_set_patch(use_dev,chan,prog+128);
		  if (!ISPERC(chan)|| sec|| ISMIDI(chan))
		    seq_start_note(use_dev,chan,prog,sec);
		  ksendq(C4_ON,chan,progi,sec);
		  break;
		case MIDI_NOTEOFF:
		  if (!ISPERC(chan) || ISMIDI(chan))
		    seq_stop_note(use_dev,chan,prog,sec);
		  ksendq(C4_OFF,chan,progi,sec);
		  break;
		case MIDI_CTL_CHANGE:
		  seq_control(use_dev,chan,prog,sec);
		  pmc->ctrl[prog][chan]=sec;
		  ksendq(C4_CTRL,chan,prog,sec);
		  break;
		case MIDI_CHN_PRESSURE:
		  seq_chn_pressure(use_dev,chan,prog);
		  break;
		case MIDI_PITCH_BEND:
		  value = (prog&0X7F)+(sec<<7);
		  seq_bender(use_dev,chan,value);
		  pmc->pitch[chan]=value;
		  ksendq(C4_PITCH,chan,prog,sec);
		  break;
		case MIDI_PGM_CHANGE:
		  if (ISMIDI(chan) || !ISPERC(chan))
		  {
		    seq_set_patch(use_dev,chan,prog);
		    strcpy(pmc->instrument[chan],gMidiInst[prog]);
		  }
		  ksendq(C4_PGMCH,chan,prog,0);
		  break;
		default:
		  break;
		      
	}

	hardware = hs;
	lastCod = cc;
}


/********************************************************/
void allnotesoff(void)
{
   	int i;
	for ( i = 0;i<16;i++)
	{
		control_change(i,0x7b,0); /* all notes off	*/
		control_change(i,0x78,0); /* all sounds off	*/
	}
#ifdef linux
	SEQ_DUMPBUF();
#endif
}
/********************************************************/
void playevents()	/* le nouveau moteur */
{
	struct TMIDI ( *ptr)[1];
	struct TRACK *trk;
	LONG cur;	/* index de la position sur l'evenement MIDI en cours	*/

	int iTrack;		/* index sur le track courant 	*/
	int tactic=0;		/* bouffe les noteon lyrics	*/
	 
	int division;
	
	division = head.delta_ticks;
	seq_reset();
#ifdef linux
	SEQ_START_TIMER();
#endif
	f_run = TRUE;
	if (!karalin)
	{
		playing = TRUE;
	} 
	Dprintf(stderr,"kplay: playing now , playing %d , f_run %d\n",playing,f_run);
	while (f_run )
	{
	    if (mute_a_faire) 
	    {
		allnotesoff();
        	mute_a_faire = FALSE;
	    }
            if (playing)
            {
		/* on a le delta suivant alors on scrute */	  

		/*	dater les evenements a venir 	*/
		cumuldelta += nextdelta;
		dtime = mf_ticks2sec(nextdelta,division,tempo) * skew;
		current += dtime;
		pmc->timeSinceBegin = cumuldelta;
		pmc->SecSinceBegin = mf_ticks2sec(cumuldelta,division,tempo);
#ifdef linux
		if (dtime < 8192)
		{
			if (dtime > 0.75) SEQ_WAIT_TIME((ticks=((int)current)));	
/*			if (dtime > 0.75) SEQ_DELTA_TIME((ticks=((int)dtime)));	*/
		} else f_run = FALSE;	
#endif

		if (ptempo != NULL)
		{
			tempoDelta-= nextdelta;
			while ((tempoDelta == 0))
			{
				setrythme(ptempo->tempo);
				ptempo= ptempo->next;
				if (ptempo != NULL)
					tempoDelta=ptempo->delta;
				else tempoDelta = 0XFFFFFFFF;
			}
		}


		if (plyric != NULL)
		{
			lyricDelta-= nextdelta;
			while ((plyric!=NULL)&&(lyricDelta == 0))
			{
				if (plyric->type==1)
				{
					if (tactic != 0) 
					{  /* texte off */
						tactic--;
						ksendq5(C5_TXT_OFF,0,0,0);
					}
					 /* texte on */
					ksendq5(C5_TXT_ON,0,0,0);
					tactic++;
				}
				else /* if(plyric->type==0) */
				{
					if (tactic !=0)
					{ 
						tactic--;
						if (tactic ==0 )
						{  /* texte off */
							ksendq5(C5_TXT_OFF,0,0,0);
						}
					}
				}
				plyric= plyric->next;
				if (plyric != NULL) lyricDelta=plyric->delta;
				else lyricDelta = 0XFFFFFFFF;
			}
		}
	
		f_run=FALSE;
		for (iTrack=0;iTrack<head.nb_tracks;iTrack++)
		{
			trk = &track[iTrack];
			if (trk->nb_events != 0)
			{
				cur = trk->cur;
				ptr = trk->debut;
				trk->cdelta-=nextdelta;
				while (trk->cdelta ==0)
				{
					/*disTic(ptr[cur]); */
	                                sound(ptr[cur]);
					cur++;
					trk->cdelta=ptr[cur]->delta;
				}
				trk->cur = cur;
				if (ptr[cur]->delta != 0Xffffffff)
				{
					f_run=TRUE;
				}
			}

	
		} 

		/* cherche le suivant */
		nextdelta = tempoDelta;
		if (lyricDelta < nextdelta) nextdelta = lyricDelta;
		for (iTrack=0;iTrack<head.nb_tracks;iTrack++)
		{
			if (track[iTrack].cdelta < nextdelta) nextdelta =
			track[iTrack].cdelta;
		}

#ifdef linux
		SEQ_DUMPBUF();	/* attend l'ecriture des evts midi */
#endif
		kflush();	/* poste les messages correspondants */

	    if (karalin) kreceive(0);	/* traite les messages recus  	     */

	    } /* if playing */
            else
	    {
#ifdef linux
		SEQ_START_TIMER();
		current = 0.0;
		SEQ_DUMPBUF();
#endif
		kflush();
	    if (karalin) kreceive(100);	/* traite les messages recus  	     */
	    }
	} /* while */	

	if (f_loaded) resmidi();
/*	Dprintf(stderr," kplay end playing f_run %x playing %x\n",f_run,playing);*/
	sleep(4);
	msg.s.code = C4_IDLE;
	ksend(msg);
}


