/************************************************************************
 * emumidi.c  -- emulate /dev/sequencer2 ('cause it's broke)
 *
 * This code was written by by Nathan Laredo (laredo@gnu.ai.mit.edu)
 * Source code may be freely distributed in unmodified form.
 *************************************************************************/
#include <sys/ioctl.h>
#include <co.h>
#include "kplay.h"
#ifndef USE_SEQUENCER2

#ifdef linux
SEQ_USE_EXTBUF();
#endif

extern int seqfd, play_ext, play_gus, play_sb, gus_dev, sb_dev, wantopl3;
extern int perc, ticks;
extern struct DATACOM *pmc;
struct chanstate {
    int program;
    int bender;
    int bender_range;
    int controller[255];
    int pressure;
};

struct voicestate {
    int program;
    int note;
    int channel;
    int bender;
    int bender_range;
    int pan;
    int volume;
    int timestamp;
    int dead;
};

static struct voicestate voice[2][64];
static struct chanstate channel[16];

#define CN (play_gus ? 0 : 1)

void seq_reset()
{
#ifdef linux
    int i;
    ioctl(seqfd, SNDCTL_SEQ_RESET);
    if (play_gus || play_sb) {
	for (i = 0; i < 16; i++) {
	    channel[i].bender = 0x2000;
	    channel[i].bender_range = 1600;
	    channel[i].controller[CTL_PAN] = 0;
	    channel[i].controller[CTL_SUSTAIN] = 0;
	    channel[i].controller[0x07] = 0x7f;/* volume*/
	}
	if (play_gus)
	    for (i = 0; i < pmc->synth_Info[gus_dev].nr_voices; i++) {
		SEQ_BENDER(gus_dev, i, voice[CN][i].bender = 0x2000 );
		SEQ_BENDER_RANGE(gus_dev, i, voice[CN][i].bender_range = 1600);
		if (voice[CN][i].note)
		    SEQ_STOP_NOTE(gus_dev, i, voice[CN][i].note, 64);
		voice[CN][i].dead = voice[CN][i].timestamp =
			voice[CN][i].program = -1;
		voice[CN][i].volume = 0x7f;
	    }
	if (play_sb)
	    for (i = 0; i < pmc->synth_Info[sb_dev].nr_voices; i++) {
		SEQ_BENDER(sb_dev, i, voice[CN][i].bender = 1 << 13);
		SEQ_BENDER_RANGE(sb_dev, i, voice[CN][i].bender_range = 1600);
		if (voice[CN][i].note)
		    SEQ_STOP_NOTE(sb_dev, i, voice[CN][i].note, 64);
		voice[CN][i].dead = voice[CN][i].timestamp =
			voice[CN][i].program = -1;
		voice[CN][i].volume = 0x7f;
	    }
		
    }
#endif
}

void seq_notesoff(char chn)
{
#ifdef linux
int i;
	if (play_gus)
	    for (i = 0; i < pmc->synth_Info[gus_dev].nr_voices; i++) {
		if (voice[CN][i].note&&(voice[CN][i].channel==chn))
		{
		  SEQ_STOP_NOTE(gus_dev, i, voice[CN][i].note, 64);
		}
	    }
	if (play_sb)
	    for (i = 0; i < pmc->synth_Info[sb_dev].nr_voices; i++) {
		if (voice[CN][i].note&&(voice[CN][i].channel==chn))
		{
		  SEQ_STOP_NOTE(sb_dev, i, voice[CN][i].note, 64);
		}
	    }
#endif
}
void seq_set_patch(dev, chn, pgm)
int dev, chn, pgm;
{
#ifdef linux
   if (ISMIDI(chn)) {
	SEQ_MIDIOUT(dev, MIDI_PGM_CHANGE + chn);
	SEQ_MIDIOUT(dev, pgm);
   } else
	channel[chn].program = pgm;
#endif
}

void seq_stop_note(dev, chn, note, vel)
int dev, chn, note, vel;
{
#ifdef linux
    int i, card = CN;
    if (ISMIDI(chn)) {
	SEQ_MIDIOUT(dev, MIDI_NOTEOFF + chn);
	SEQ_MIDIOUT(dev, note);
	SEQ_MIDIOUT(dev, vel);
    } else
	for (i = 0; i < pmc->synth_Info[dev].nr_voices; i++)
	    if (voice[card][i].channel == chn &&
		voice[card][i].note == note) {
		voice[card][i].dead = 1;
		voice[card][i].timestamp /= 2;
		if (!channel[chn].controller[CTL_SUSTAIN])
		    SEQ_STOP_NOTE(dev, i, note, vel);
	    }
#endif
}

void seq_key_pressure(dev, chn, note, vel)
int dev, chn, note, vel;
{
#ifdef linux
    int i, card = CN;
    if (ISMIDI(chn)) {
	SEQ_MIDIOUT(dev, MIDI_KEY_PRESSURE + chn);
	SEQ_MIDIOUT(dev, note);
	SEQ_MIDIOUT(dev, vel);
    } else if (vel == 0)
	seq_stop_note(dev, chn, note, 64);
    else
	for (i = 0; i < pmc->synth_Info[dev].nr_voices; i++)
	    if (voice[card][i].channel == chn &&
		voice[card][i].note == note)
		SEQ_KEY_PRESSURE(dev, i, note, vel);
#endif
}

void seq_start_note(dev, chn, note, vel)
int dev, chn, note, vel;
{
#ifdef linux
    int i, oldest = 0, card = CN;
    if (ISMIDI(chn)) {
	SEQ_MIDIOUT(dev, MIDI_NOTEON + chn);
	SEQ_MIDIOUT(dev, note);
	SEQ_MIDIOUT(dev, vel);
    } else if (vel == 0)
	seq_stop_note(dev, chn, note, 64);
    else {
	for (i = 0; i < pmc->synth_Info[dev].nr_voices; i++)
	    if (voice[card][i].timestamp < voice[card][oldest].timestamp)
		    oldest = i;
	i = oldest;
	if (channel[chn].program != voice[card][i].program - 1)
	    SEQ_SET_PATCH(dev, i, (voice[card][i].program =
		channel[chn].program + 1) - 1);
	if (channel[chn].bender_range != voice[card][i].bender_range)
	    SEQ_BENDER_RANGE(dev, i, voice[card][i].bender_range =
		channel[chn].bender_range);
	if (channel[chn].bender != voice[card][i].bender)
	    SEQ_BENDER(dev, i, voice[card][i].bender =
		channel[chn].bender);
	if (channel[chn].controller[CTL_PAN] != voice[card][i].pan)
	    SEQ_CONTROL(dev, i, CTL_PAN, voice[card][i].pan = 
		channel[chn].controller[CTL_PAN]);
        if (channel[chn].controller[0x07] != voice[card][i].volume)
           SEQ_CONTROL(dev, i, 0x07 , voice[card][i].volume = 
                channel[chn].controller[0x07]);

	SEQ_START_NOTE(dev, i, note, vel);
	voice[card][i].note = note;
	voice[card][i].channel = chn;
	voice[card][i].timestamp = ticks;
	if (ISPERC(chn))	/* percussion is lowest priority */
	    voice[card][i].timestamp /= 2;
	voice[card][i].dead = 0;
    }
#endif
}

static int rpn1[16] =
{ 127, 127, 127, 127, 127, 127, 127, 127,
  127, 127, 127, 127, 127, 127, 127, 127};
static int rpn2[16] =
{ 127, 127, 127, 127, 127, 127, 127, 127,
  127, 127, 127, 127, 127, 127, 127, 127};

void seq_control(dev, chn, p1, p2)
int dev, chn, p1, p2;
{
#ifdef linux
    int i, card = CN;
    if (ISMIDI(chn)) {
	SEQ_MIDIOUT(dev, MIDI_CTL_CHANGE + chn);
	SEQ_MIDIOUT(dev, p1);
	SEQ_MIDIOUT(dev, p2);
    } else {
	channel[chn].controller[p1] = p2;
	switch (p1) {
	case CTL_MAIN_VOLUME:	/* main volume */
            for (i = 0; i < pmc->synth_Info[card].nr_voices; i++)
                if (voice[card][i].channel == chn && voice[card][i].volume != p2)
                    SEQ_CONTROL(dev, i, p1, voice[card][i].volume = p2);
 
	case CTL_PAN:
	    for (i = 0; i < pmc->synth_Info[card].nr_voices; i++)
		if (voice[card][i].channel == chn && voice[card][i].pan != (p2))
		    SEQ_CONTROL(dev, i, p1, voice[card][i].pan = p2);
	    break;
	case CTL_SUSTAIN:
	    if (!p2) {
		for (i = 0; i < pmc->synth_Info[card].nr_voices; i++)
		    if (voice[card][i].channel == chn
			&& voice[card][i].dead) {
			SEQ_STOP_NOTE(dev, i, voice[card][i].note, 64);
			voice[card][i].dead = 0;
		    }
	    }
	    break;
	case CTL_REGIST_PARM_NUM_MSB:
	    rpn1[chn] = p2;
	break;
	case CTL_REGIST_PARM_NUM_LSB:
	    rpn2[chn] = p2;
	break;
	case CTL_DATA_ENTRY:
	    if (rpn1[chn] == 0 && rpn2[chn] == 0) {
		p2= p2*100   ;
	printf ("P2 %x\n",p2);
		channel[chn].bender_range = p2;
		rpn1[chn] = rpn2[chn] = 127;
		for (i = 0; i < pmc->synth_Info[card].nr_voices; i++)
		    if (voice[card][i].channel == chn
			&& voice[card][i].bender_range != p2)
			SEQ_BENDER_RANGE(dev, i,
			    voice[card][i].bender_range = p2);
	    }
	case 0x7B: /* all notes off */
	    seq_notesoff(chn);
	    break;
	default:
	    break;
	}
    }
#endif
}

void seq_chn_pressure(dev, chn, vel)
int dev, chn, vel;
{
#ifdef linux
    if (ISMIDI(chn)) {
	SEQ_MIDIOUT(dev, MIDI_CHN_PRESSURE + chn);
	SEQ_MIDIOUT(dev, vel);
    } else
	channel[chn].pressure = vel;
#endif
}

void seq_bender(dev, chn, val)
int dev, chn, val;
{
#ifdef linux
    int card = CN, i;
    if (ISMIDI(chn)) {
	SEQ_MIDIOUT(dev, MIDI_PITCH_BEND + chn);
	SEQ_MIDIOUT(dev, val & 0x7f);
	SEQ_MIDIOUT(dev, val >> 7);
    } else {
	return;
	printf("B %x\n",val);
	channel[chn].bender = val;
	for (i = 0; i < pmc->synth_Info[dev].nr_voices; i++)
	    if (voice[card][i].bender != (val) && voice[card][i].channel == chn)
		SEQ_BENDER(dev, i, voice[card][i].bender = (val));
    }
#endif
}
#endif
