/************************************************************************
 * emumidi.c  -- emulate /dev/sequencer2 ('cause it's broke)
 *
 * This code was written by by Nathan Laredo (laredo@gnu.ai.mit.edu)
 * Source code may be freely distributed in unmodified form.
 *************************************************************************/
#include "playmidi.h"
#ifndef USE_SEQUENCER2

SEQ_USE_EXTBUF();

extern int seqfd, play_ext, play_gus, play_sb, gus_dev, sb_dev, wantopl3;
extern struct synth_info card_info[MAX_CARDS];
extern int perc, ticks;

struct chanstate {
    int program;
    int bender;
    int bender_range;
    int controller[255];
    int pressure;
};

struct voicestate {
    int program;
    int note;
    int channel;
    int bender;
    int bender_range;
    int pan;
    int timestamp;
    int dead;
};

static struct voicestate voice[2][64];
static struct chanstate channel[16];
#define CN (ISGUS(chn) ? 0 : 1)

void seq_reset()
{
    int i;
    ioctl(seqfd, SNDCTL_SEQ_RESET);
    if (play_gus || play_sb) {
	for (i = 0; i < 16; i++) {
	    channel[i].bender = 1 << 13;
	    channel[i].bender_range = 16;
	    channel[i].controller[CTL_PAN] = 0;
	    channel[i].controller[CTL_SUSTAIN] = 0;
	}
	if (play_gus)
	    for (i = 0; i < card_info[gus_dev].nr_voices; i++) {
		SEQ_BENDER(gus_dev, i, voice[0][i].bender = 1 << 13);
		SEQ_BENDER_RANGE(gus_dev, i, voice[0][i].bender_range = 16);
		if (voice[0][i].note)
		    SEQ_STOP_NOTE(gus_dev, i, voice[0][i].note, 64);
		voice[0][i].dead = voice[0][i].timestam 231.71 170.33 T
1 F
(\051) 433.36 170.33 T
(Display) 108 158.33 T
4 F
(*display;) 141.61 158.33 T
1 F
(Pixmap) 108 146.33 T
4 F
(*pixmap;) 141.06 146.33 T
1 F
(Pixmap) 108 134.33 T
4 F
(*shapemask;) 141.06 134.33 T
1 F
(XpmImage) 108 122.33 T
4 F
(*xpmimage) 155.49 122.33 T
1 F
(XpmAttributes) 108 110.33 T
4 F
(*attributes;) 170.5 110.33 T
FMENDPAGE
%%EndPage: "30" 30
%%Page: "31" 31
612 792 0 FMBEGINPAGE
[0 0 0 1 0 0 0]
[ 0 1 1 0 1 0 0]
[ 1 0 1 0 0 1 0]
[ 1 1 0 0 0 0 1]
[ 1 0 0 0 0 1 1]
[ 0 1 0 0 1 0 1]
[ 0 0 1 0 1 1 0]
 7 FrameSetSepColors
FrameNoSep
0 0 0 1 0 0 0 K
0 0 0 1 0 0 0 K
0 0 0 1 0 0 0 K
0 0 0 1 0 0 0 K
261 729 369 738 R
7 X
0 0 0 1 0 0 0 K
V
4 10 Q
0 X
(XPM Manual) 287.92 731.33 T
0 12 Q
(31) 300 56.01 T
4 10 Q
(display) 72 686.33 T
1 F
(Specifies the connection to the X server.) 171 686.33 T
4 F
(pixmap) 72 670.33 T
1 F
(Specifies the pixmap.) 171 670.33 T
4 F
(shapemask) 72 654.33 T
1 F
(Specifies the shape mask pixmap.) 171 654.33 T
4 F
(xpmimage) 72 638.33 T
1 F
(Specifies the location of an) 171 638.33 T
0 F
(XpmImage) 282.37 638.33 T
1 F
(structure.) 332.64 638.33 T
4 F
(attributes) 72 622.33 T
1 F
(Specifies the location of a structure containing information \050or NULL\051.) 171 622.33 T
-0.02 (From the given pixmaps and) 72 598.33 P
0 F
-0.02 (XpmAttributes) 188.84 598.33 P
1 F
-0.02 ( if not) 253.83 598.33 P
0 F
-0.02 (NULL) 280.15 598.33 P
1 F
-0.02 (,) 307.93 598.33 P
0 F
-0.02 (XpmCreateXpmImageFromPixmap) 312.91 598.33 P
1 F
-0.02 (gets the related X) 469.8 598.33 P
0.02 (images by calling) 72 586.33 P
0 F
0.02 (XGetImage) 145.11 586.33 P
1 F
0.02 (, then it gives them to) 194.54 586.33 P
0 F
0.02 (XpmCreateXpmImageFromImage) 283.84 586.33 P
1 F
0.02 ( \050page 29\051 to create an) 432.13 586.33 P
0 F
0.02 (Xp-) 523.89 586.33 P
(mImage) 72 574.33 T
1 F
( which is returned to) 106.99 574.33 T
4 F
(xpmimage) 191.7 574.33 T
1 F
(. Finally it destroys the created X images using) 232.8 574.33 T
0 F
(XDestroyImage) 423.34 574.33 T
1 F
(.) 490.54 574.33 T
0 12 Q
(3.2.7) 72 531 T
(Miscellaneous functions) 108 531 T
1 10 Q
(To free possible data stored into an) 72 506.33 T
0 F
(XpmImage) 215.03 506.33 T
1 F
(structure use) 265.3 506.33 T
0 F
(XpmFreeXpmImage) 318.62 506.33 T
1 F
(.) 406.93 506.33 T
(int XpmFreeXpmImage\050) 72 488.33 T
4 F
(image) 171.15 488.33 T
1 F
(\051) 195.59 488.33 T
(XpmImage) 108 476.33 T
4 F
(*image;) 155.49 476.33 T
(image) 72 460.33 T
1 F
(Specifies the structure to free.) 98.94 460.33 T
(The) 72 436.33 T
0 F
(XpmFreeXpmImage) 90.05 436.33 T
1 F
(frees the structure members which are not) 180.86 436.33 T
0 F
(NULL) 351.09 436.33 T
1 F
(, but not the structure itself.) 378.87 436.33 T
(To free possible data stored into an) 72 404.33 T
0 F
(XpmInfo) 215.03 404.33 T
1 F
(structure use) 256.42 404.33 T
0 F
(XpmFreeXpmInfo) 309.74 404.33 T
1 F
(.) 389.17 404.33 T
(int XpmFreeXpmInfo\050) 72 386.33 T
4 F
(info) 162.82 386.33 T
1 F
(\051) 178.38 386.33 T
(XpmInfo) 108 374.33 T
4 F
( *info;) 144.66 374.33 T
(info) 72 358.33 T
1 F
(Specifies the structure to free.) 90.06 358.33 T
(The) 72 334.33 T
0 F
(XpmFreeXpmInfo) 90.05 334.33 T
1 F
(frees the structure members which are not) 171.98 334.33 T
0 F
(NULL) 342.21 334.33 T
1 F
(, but not the structure itself.) 369.99 334.33 T
FMENDPAGE
%%EndPage: "31" 31
%%Page: "32" 32
612 792 0 FMBEGINPAGE
[0 0 0 1 0 0 0]
[ 0 1 1 0 1 0 0]
[ 1 0 1 0 0 1 0]
[ 1 1 0 0 0 0 1]
[ 1 0 0 0 0 1 1]
[ 0 1 0 0 1 0 1]
[ 0 0 1 0 1 1 0]
 7 FrameSetSepColors
FrameNoSep
0 0 0 1 0 0 0 K
0 0 0 1 0 0 0 K
0 0 0 1 0 0 0 K
0 0 0 1 0 0 0 K
261 729 369 738 R
7 X
0 0 0 1 0 0 0 K
V
4 10 Q
0 X
(XPM Manual) 287.92 731.33 T
0 12 Q
(32) 300 56.01 T
FMENDPAGE
%%EndPage: "32" 32
%%Page: "33" 33
612 792 0 FMBEGINPAGE
[0 0 0 1 0 0 0]
[ 0 1 1 0 1 0 0]
[ 1 0 1 0 0 1 0]
[ 1 1 0 0 0 0 1]
[ 1 0 0 0 0 1 1]
[ 0 1 0 0 1 0 1]
[ 0 0 1 0 1 1 0]
 7 FrameSetSepColors
FrameNoSep
0 0 0 1 0 0 0 K
0 0 0 1 0 0 0 K
0 0 0 1 0 0 0 K
0 0 0 1 0 0 0 K
0 0 0 1 0 0 0 K
225 639 396 657 R
7 X
0 0 0 1 0 0 0 K
V
1 18 Q
0 X
(Index) 290.01 645 T
0 12 Q
(33) 300 56.01 T
261 729 369 738 R
7 X
V
4 10 Q
0 X
(XPM Manual) 287.92 731.33 T
1 F
(XpmAttributes, 11) 72 569.33 T
(XpmAttributesSize, 23) 72 557.33 T
(XpmColorSymbol, 14) 72 545.33 T
(XpmCreateBufferFromImage, 21) 72 533.33 T
(XpmCreateBufferFromPixmap, 22) 72 521.33 T
(XpmCreateBufferFromXpmImage, 28) 72 509.33 T
(XpmCreateDataFromImage, 19) 72 497.33 T
(XpmCreateDataFromPixmap, 19) 72 485.33 T
(XpmCreateDataFromXpmImage, 28) 72 473.33 T
(XpmCreateImageFromBuffer, 20) 72 461.33 T
(XpmCreateImageFromData, 18) 72 449.33 T
(XpmCreateImageFromXpmImage, 29) 72 437.33 T
(XpmCreatePixmapFromBuffer, 21) 72 425.33 T
(XpmCreatePixmapFromData, 18) 72 413.33 T
(XpmCreatePixmapFromXpmImage, 30) 72 401.33 T
(XpmCreateXpmImageFromBuffer, 28) 72 389.33 T
(XpmCreateXpmImageFromData, 27) 72 377.33 T
(XpmCreateXpmImageFromImage, 29) 72 365.33 T
(X