#include <ihm.h>
#include <kdir.h>

void f_setup_change_toggle(Widget widget, int * tag, XmAnyCallbackStruct *data);
void f_pb_ok_activate (Widget widget, int * tag, XmAnyCallbackStruct *data);


static Widget tog_opl3_8, tog_midi_5, tog_gus_6, tog_blaster_7;

static Widget lab_opl3, lab_sb, lab_gus, path_opl3, path_gus, path_sb;

f_kdir_SetupMidi(parent)
Widget parent;
{
 static Widget shell_setup_driver;
 static Widget  form_setup_driver, xmForm2_3, xmFrame0_3,
		xmFrame0_2, xmForm1_3, xmRowColumn0_4,
		lab_driver_setup_9, xmRowColumn0_5,
		row_gus, row_sb, row_opl3, lab_path_setup,
		pb_ok, pb_cancel;


 if (shell_setup_driver == NULL)
   {
    shell_setup_driver = XtVaCreateWidget("DriverSetup", xmDialogShellWidgetClass,
	parent,
	XmNallowShellResize, True,
	NULL);


    form_setup_driver = XtVaCreateWidget("FormSetupDriver", xmFormWidgetClass,
	shell_setup_driver,
	XmNx, 100,
	XmNy, 100,
	XmNwidth, 391,
	XmNheight, 404,
	XmNminWidth, 391,
	XmNminHeight, 404,
	NULL);

    xmFrame0_2 = XtVaCreateManagedWidget("xmFrame0", xmFrameWidgetClass, form_setup_driver,
		XmNbottomAttachment, XmATTACH_POSITION,
		XmNrightAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_FORM,
		XmNbottomPosition, 50,
		XmNleftOffset, 10,
		XmNrightOffset, 10,
		XmNtopOffset, 10,
		NULL);

    pb_ok = XtVaCreateManagedWidget ("setup_ok", xmPushButtonWidgetClass,
	form_setup_driver,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 5,
	XmNleftAttachment, XmATTACH_FORM,
	XmNleftOffset, 50,
	XmNrightAttachment, XmATTACH_POSITION,
	XmNrightPosition, 40,
	XmNwidth, 100,
 	NULL);

    XtAddCallback (pb_ok, XmNactivateCallback, f_pb_ok_activate, NULL);
	
    pb_cancel = XtVaCreateManagedWidget ("setup_cancel", xmPushButtonWidgetClass,
	form_setup_driver,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNbottomOffset, 5,
	XmNrightAttachment, XmATTACH_FORM,
	XmNrightOffset, 50,
	XmNleftAttachment, XmATTACH_POSITION,
	XmNleftPosition, 60,
	XmNwidth, 100,
 	NULL);

    xmFrame0_3 = XtVaCreateManagedWidget("xmFrame1", xmFrameWidgetClass, form_setup_driver,
		XmNbottomAttachment, XmATTACH_WIDGET,
		XmNrightAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNbottomWidget, pb_ok,
		XmNbottomOffset, 2,
		XmNleftOffset, 10,
		XmNrightOffset, 10,
		XmNtopWidget, xmFrame0_2,
		NULL);

    xmForm1_3 = XtVaCreateManagedWidget("xmForm1", xmFormWidgetClass, xmFrame0_2,
		NULL);

    xmForm2_3 = XtVaCreateManagedWidget("xmForm2", xmFormWidgetClass, xmFrame0_3,
		NULL);


    lab_gus = XtVaCreateManagedWidget("LabPathGusPatchs", xmLabelWidgetClass,
		xmForm2_3,
		XmNtopAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		XmNtopOffset, 10,
		XmNleftOffset, 10,
		NULL);

    path_gus = XtVaCreateManagedWidget("PathGusPatchs", xmTextFieldWidgetClass,
		xmForm2_3,
		XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
		XmNtopWidget, lab_gus,
		XmNtopOffset, -3,
		XmNleftAttachment, XmATTACH_WIDGET,
		XmNleftWidget, lab_gus,	
		XmNrightAttachment, XmATTACH_FORM,
		NULL);
		

    lab_sb = XtVaCreateManagedWidget("LabPathSb", xmLabelWidgetClass,
		xmForm2_3,
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget, lab_gus,
		XmNtopOffset, 30,
		XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET,
		XmNleftWidget, lab_gus,	
		NULL);

    path_sb = XtVaCreateManagedWidget("PathSb", xmTextFieldWidgetClass,
		xmForm2_3,
		XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
		XmNtopWidget, lab_sb,
		XmNtopOffset, -3,
		XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET,
		XmNleftWidget, path_gus,	
		XmNrightAttachment, XmATTACH_FORM,
		NULL);
		
		
    lab_opl3 = XtVaCreateManagedWidget("LabPathOpl3", xmLabelWidgetClass,
		xmForm2_3,
		XmNtopAttachment,XmATTACH_WIDGET,
		XmNtopWidget, lab_sb,
		XmNtopOffset, 30,
		XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET,
		XmNleftWidget, lab_sb,	
		NULL);

    path_opl3 = XtVaCreateManagedWidget("PathOpl3", xmTextFieldWidgetClass,
		xmForm2_3,
		XmNtopAttachment,XmATTACH_OPPOSITE_WIDGET,
		XmNtopWidget, lab_opl3,
		XmNtopOffset, -3,
		XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET,
		XmNleftWidget, path_gus,	
		XmNrightAttachment, XmATTACH_FORM,
		NULL);
		
		
    xmRowColumn0_4 = XtVaCreateManagedWidget (NULL, xmRowColumnWidgetClass,
		xmForm1_3,
		XmNradioBehavior, True,
		NULL);

    tog_midi_5 = XtVaCreateManagedWidget("tog_midi", xmToggleButtonWidgetClass,
		xmRowColumn0_4,
		NULL);


    tog_gus_6 = XtVaCreateManagedWidget("tog_gus", xmToggleButtonWidgetClass,
		xmRowColumn0_4,
		0, 0);


    tog_blaster_7 = XtVaCreateManagedWidget("tog_blaster", xmToggleButtonWidgetClass,
		xmRowColumn0_4, 
		NULL);


    XtAddCallback (tog_blaster_7, XmNvalueChangedCallback, f_setup_change_toggle, NULL);

    tog_opl3_8 = XtVaCreateManagedWidget("tog_opl3", xmToggleButtonWidgetClass,
		xmForm1_3,
		XmNleftAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, xmRowColumn0_4,
		XmNleftOffset, 50,
		XmNtopOffset, 20,
		XmNsensitive, False,
		NULL);


    lab_driver_setup_9 = XtVaCreateManagedWidget("lab_driver_setup", xmLabelWidgetClass,
		xmFrame0_2,
		XmNchildType, XmFRAME_TITLE_CHILD,
		 NULL);

    lab_path_setup = XtVaCreateManagedWidget("lab_path_setup", xmLabelWidgetClass,
		xmFrame0_3,
		XmNchildType, XmFRAME_TITLE_CHILD,
		 NULL);

   if (!InterfaceKnown)
     {
      XtVaSetValues (tog_midi_5, XmNset, False, NULL);
      XtVaSetValues (tog_gus_6, XmNset, False, NULL);
      XtVaSetValues (tog_blaster_7, XmNset, True, NULL);
      XtVaSetValues (tog_opl3_8, XmNset, True, NULL);
      XtVaSetValues (path_sb, XmNlabelString, f_xm_string ("/etc"), NULL);
      XtVaSetValues (path_gus, XmNlabelString, f_xm_string ("/etc"), NULL);
      XtVaSetValues (path_opl3, XmNlabelString, f_xm_string ("/etc"), NULL);
     }
   else
     {
      f_kdir_set_toggles();
     }
	
   }

 XtManageChild (form_setup_driver);
}



void f_setup_change_toggle(widget, tag, data)
Widget widget;
int *tag;
XmAnyCallbackStruct * data;
{
 Boolean set;


 XtVaGetValues (widget, XmNset, &set, NULL);

 if (set)
   XtVaSetValues (tog_opl3_8, XmNsensitive, True, NULL);
 else
   XtVaSetValues (tog_opl3_8, XmNsensitive, False, NULL);
}

void f_pb_ok_activate (widget, tag, data)
Widget widget;
int *tag;
XmAnyCallbackStruct * data;
{
 Boolean set;
 FILE * fp;
 char * s, file [500];

 fp = fopen (kdir_ressource_file, "w");

 XtVaGetValues (tog_blaster_7, XmNset, &set, NULL);
 if (set)
   {
    p_co_share_tables->typeOutput = SB;
 
    fprintf (fp, "interface:SB\n");

    XtVaGetValues (tog_opl3_8, XmNset, &set, NULL);
    if (set)
      {
       p_co_share_tables->wantopl3 = TRUE;
       fprintf (fp, "wantOPL3:TRUE\n");
      }
    else
      fprintf (fp, "wantOPL3:FALSE\n");
   }
 else
   {
    XtVaGetValues (tog_gus_6, XmNset, &set, NULL);
    if (set)
      {
       fprintf (fp, "interface:GUS\n");
       p_co_share_tables->typeOutput = GUS;
      }
    else
      {
       p_co_share_tables->typeOutput = MIDI;
       fprintf (fp, "interface:MIDI\n");
      }
   }    

 f_kdir_write_path_gus(fp);
 f_kdir_write_path_sb(fp);
 f_kdir_write_path_opl3(fp);

 fclose (fp);
}    

f_kdir_write_path_sb (fp)
FILE * fp;
{
 char * s;
 char file [500];

 s = XmTextGetString (path_sb);
 fprintf (fp, "pathSB:%s\n", s);
 sprintf (file, "%s/std.sb", s);
 strcpy (p_co_share_tables->sb_melodic, file);
 sprintf (file, "%s/drums.sb", s);
 free (s);
 strcpy (p_co_share_tables->sb_drum, file);
}

f_kdir_write_path_opl3 (fp)
FILE * fp;
{
 char * s;
 char file [500];

 s = XmTextGetString (path_opl3);
 fprintf (fp, "pathOPL3:%s\n", s);
 sprintf (file, "%s/std.o3", s);
 strcpy (p_co_share_tables->sb_melodic_o3, file);
 sprintf (file, "%s/drums.o3", s);
 free (s);
 strcpy (p_co_share_tables->sb_drum_o3, file);

}

f_kdir_write_path_gus (fp)
FILE * fp;
{
 char * s;

 s = XmTextGetString (path_gus);
 strcpy (p_co_share_tables->patch_path_gus, s);
 fprintf (fp, "pathGUS:%s\n", s);
 free (s);

}

f_kdir_set_toggles()
{

 XtVaSetValues (tog_gus_6, XmNset, False, NULL);
 XtVaSetValues (tog_midi_5, XmNset, False, NULL);
 XtVaSetValues (tog_blaster_7, XmNset, False, NULL);
 XtVaSetValues (tog_opl3_8, XmNset, True, NULL);

 switch (p_co_share_tables->typeOutput)
   {
    case GUS :  XtVaSetValues (tog_gus_6, XmNset, True, NULL);

    case MIDI:  XtVaSetValues (tog_midi_5, XmNset, True, NULL); break;

    case SB  :  XtVaSetValues (tog_blaster_7, XmNset, True, NULL); 

  	if (p_co_share_tables->wantopl3)
          {
           XtVaSetValues (tog_opl3_8, XmNset, True, NULL); break;
          }

    default : break;
   }

 XtVaSetValues (path_sb, XmNvalue,   s_path_sb, NULL);
 XtVaSetValues (path_gus, XmNvalue,  s_path_gus, NULL);
 XtVaSetValues (path_opl3, XmNvalue, s_path_opl3, NULL);
}
