#include <ihm.h>

#include <empty_pixmap.xpm>

Pixel		Col_red, Col_yellow,
		Col_cyan, Col_DarkTurquoise,
		Col_black, Col_white, Col_blue, Col_grey40,
		Col_magenta, Col_Brown, Col_green, Col_orange,
		Col_grey70, Col_MidnightBlue;

XFontStruct     *X11_font_helv_16b, * X11_font_helv_14b;

Pixmap empty_pixmap;

Boolean Iconic;

void f_kar_InitializeColorsAndFonts()
{
 int ErrorStatus;
 char file [500];

 Col_black      =  BlackPixel(app_display, screen);

 Col_white      =  WhitePixel(app_display, screen);

 Col_grey40     =  f_kar_Pixel(app_display, "grey40", Col_black);

 Col_blue     =  f_kar_Pixel(app_display, "DeepSkyBlue1", Col_white);

 Col_orange     =  f_kar_Pixel(app_display, "orange1", Col_white);

 Col_magenta     =  f_kar_Pixel(app_display, "magenta", Col_white);

 Col_Brown     =  f_kar_Pixel(app_display, "Brown", Col_white);

 Col_green     =  f_kar_Pixel(app_display, "green1", Col_white);

 Col_grey70     =  f_kar_Pixel(app_display, "grey70", Col_white);

 Col_red        =  f_kar_Pixel(app_display, "red", Col_white);

 Col_yellow     =  f_kar_Pixel(app_display, "yellow", Col_white);

 Col_cyan       =  f_kar_Pixel(app_display, "cyan", Col_white);

 Col_DarkTurquoise =  f_kar_Pixel(app_display, "DarkTurquoise", Col_black);
 Col_MidnightBlue =  f_kar_Pixel(app_display, "Midnight Blue", Col_black);

 X11_font_helv_16b  = XLoadQueryFont(app_display,"-*-helvetica-bold-r-normal-*-16-*-*-*-*-*-*-*");
 X11_font_helv_14b  = XLoadQueryFont(app_display,"-*-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*");

/*
 sprintf (file, "%s/empty_pixmap.xpm", PIXMAP_DIR);

 ErrorStatus = XpmReadFileToPixmap(app_display, DefaultRootWindow(app_display), file, &empty_pixmap, NULL, NULL);
*/

 ErrorStatus = XpmCreatePixmapFromData(app_display, DefaultRootWindow(app_display), empty_pixmap_xpm, &empty_pixmap, NULL, NULL);


 if (ErrorStatus != XpmSuccess)
   exit (0);
}

Pixel f_kar_Pixel(display, c, defaut)
char * c;
Pixel defaut;
Display *  display;
{
 XColor    color, ignore;

 if (XAllocNamedColor(display, colormap, c, &color, &ignore))
   return (color.pixel);


 return (defaut);
}


/*
   Creation d'une pixmap
*/

Pixmap f_kar_CreatePixmap (iconFile, IconName)
char * iconFile;
char * IconName[];
{
 XpmIcon Icon;
 int ErrorStatus;
 char IconFile [500];
 static XpmColorSymbol attr_colorsymbols[] = {
    {NULL, "none",  0},  /* transparent pixel to assign filled in later */
 };

Dprintf (stderr, "\nIconfile %s\n", iconFile);
 

 Icon.attributes.valuemask = XpmReturnPixels|XpmExactColors|XpmCloseness|XpmColorSymbols;
 Icon.attributes.exactColors = False;
 Icon.attributes.colorsymbols = attr_colorsymbols;
 Icon.attributes.numsymbols = XtNumber(attr_colorsymbols);
 Icon.attributes.closeness = 40000;

/*
 sprintf (IconFile, "%s/%s", PIXMAP_DIR, iconFile);
 ErrorStatus = XpmReadFileToPixmap(app_display, DefaultRootWindow(app_display), IconFile, &Icon.pixmap, &Icon.mask, &Icon.attributes);
 */

 ErrorStatus = XpmCreatePixmapFromData(app_display, DefaultRootWindow(app_display), IconName, &Icon.pixmap, &Icon.mask, &Icon.attributes);


 XpmErrorMessage(iconFile, ErrorStatus);

 if (ErrorStatus != XpmSuccess)
   return (empty_pixmap);

 return (Icon.pixmap);
}

XpmErrorMessage(file,ErrorStatus)
char * file;
int ErrorStatus;
{
 char *error = NULL;
 char *warning = NULL;

 switch (ErrorStatus)
   {
    case XpmSuccess:
        return;
    case XpmColorError:
        warning = "Could not parse or alloc requested color";
        break;
    case XpmOpenFailed:
        error = "Cannot open file";
        break;
    case XpmFileInvalid:
        error = "Invalid XPM file";
        break;
    case XpmNoMemory:
        error = "Not enough memory";
        break;
    case XpmColorFailed:

        error = "Failed to parse or alloc some color";
        break;
   }

 if (warning)
   Dprintf(stderr,"\n%s Xpm Warning: %s.\n", file, warning);

 if (error)
   {
    Dprintf(stderr, "\n%s Xpm Error: %s.\n", file, error);
    exit (-1);
   }
}

XmString f_xm_string(chaine)
char * chaine;
{
 static XmString str;

 if (str)
  XmStringFree (str);

 str = XmStringCreateLocalized (chaine);

 return str;
}

void IconicStateWatcher (w, unused, event)
Widget w;
caddr_t unused;
XEvent *event;
{
 if (event->type == MapNotify)
   Iconic = False;
 else if (event->type == UnmapNotify)
   Iconic = True;
 
}

void ChgIconifyShell(widget)
Widget widget;
{
 static Boolean New;
 int initial;

 if (!New)
   {
    New = True;
    XtVaGetValues (widget, XmNinitialState, &initial, NULL);
    if (initial == IconicState) 
      Iconic = True;
    else 
      Iconic = False;
   } 
 if (widget)
   {
    if (!Iconic)
      XIconifyWindow (app_display, XtWindow (widget), screen);
    else
      XMapWindow (XtDisplay (widget), XtWindow (widget));
   }
 
}

