#include <co.h>



/*-----------------------------------------------------------------------*
 *                                                                       *
 *  Nom de la fonction  :  f_co_dcl_serveur                              *
 *                                                                       *
 *  Sequence d'appel    :  if (f_co_dcl_serveur(server_path)) { erreur } *
 *                                                                       *
 *  Description         :  Mise en place d'une socket d'attente serveur  *
 *                                                                       *
 *-----------------------------------------------------------------------*
 *                                                                       *
 *  Parametres d'entree  : server_path (Chaine de caracteres)            *
 *                                                                       *
 *  Parametres d'entree/sortie : Aucun                                   *
 *                                                                       *
 *  Parametres de retour : code d'erreur                                 *
 *                                                                       *
 *  Variables globales   : l_co_socket_srv                               *
 *                                                                       *
 *  Fonctions locales    : -                                             *
 *                                                                       *
 *  Fonctions globales   : -                                             *
 *                                                                       *
 *-----------------------------------------------------------------------*/
int f_co_dcl_serveur(a_sockaddr_srv, l_co_socket_srv)
char a_sockaddr_srv[];
int *l_co_socket_srv;
{
struct sockaddr_un s_sockaddr_srv;

 	bzero ((char *) &s_sockaddr_srv, sizeof (s_sockaddr_srv));

/*
 * Mise en place de la socket
 */
	unlink(a_sockaddr_srv);
	* l_co_socket_srv = socket(PF_UNIX, SOCK_STREAM, 0);
	if (*l_co_socket_srv >= 0) {
/*
 * 0 n'est pas un numero correct pour cette socket
 */
		if (*l_co_socket_srv == 0) {
			*l_co_socket_srv = dup(*l_co_socket_srv);
			close(0);
			if (*l_co_socket_srv < 0) {
				return False;
			}
		}
/*
 * Attachement et declaration de file d'attente pour la socket
 */
		s_sockaddr_srv.sun_family = AF_UNIX;
		strcpy(s_sockaddr_srv.sun_path, a_sockaddr_srv);
		if (!bind(*l_co_socket_srv, (struct sockaddr *)&s_sockaddr_srv,
					   sizeof(s_sockaddr_srv))) {
			if (!listen(*l_co_socket_srv, 5)) {
				return True;
			}
		}
/*
 * Erreur, pas de socket
 */
		close(*l_co_socket_srv);
		*l_co_socket_srv = 0;
	}
	return False;
}
