/*****************************************************************************/
/*          KaraLin  Le Karaoke pour linux                                   */
/*                                         Copyright(C) JP.Cocatrix L.Taieb  */
/*****************************************************************************/

/*****************************************************************************/
/* co_types.h : structure des donnees communes                                */
/*****************************************************************************/

#include <X11/Xmd.h>
#ifdef linux
#include <sys/soundcard.h>
#endif


typedef  unsigned int           LONG ;
typedef  unsigned short         WORD ;

typedef  char           CHAR;

/* LA STRUCTURE DES MESSAGES ENTRE PROCESS */
struct SMSG 
{
  BYTE  code;
  BYTE  par1;
  BYTE  par2;
  BYTE  par3;
};

union MSG
{
  struct SMSG s;
  int         i;
};



struct BANNER {    /*  info sur la musique	*/
	BYTE Title[100];
	BYTE Comment1[100];
	BYTE Comment2[100];
	BYTE typeMidi;		/*  '0' ou '1'*/
	WORD info; 
	};


/************************************/
/* la structure des donnes communes */
/************************************/
struct DATACOM { 
/*  Pour kdir
// Liste des quipements son sur la configuration
// structures definies dans <sys/soundcard.h>
// Synthetiseurs	*/
int nbrSynth;	/*  nombre de synth	*/
#ifdef linux
struct synth_info synth_Info[4];
#endif

/*  ports MIDI	*/
int nbrMidi;	/*  nombre de port Midi	*/
#ifdef linux
struct midi_info midi_Info[4];
#endif
/*  Le choix de l'utilisateur	*/
/*==============================*/
char user[40];			/* nom de l'utilisateur (ou Shareware) 	*/
int registerflag;		/* vrai si l'utilisateur est enregistre	*/
#define		NONE	0
#define		MIDI	1
#define		GUS	2
#define		SB	3
int 	typeOutput;		/* MIDI ou GUS ou SB*/
int	deviceNumber;
int 	wantopl3;		/* pour SB uniquement	*/
int 	drum ;			/* le masque de canal batterie  (10) */
int 	parole;			/* le masque de canal parole (.txk) 1 par defaut */

char	patch_path_gus[256];	/* le chemin pour les .pat de la GUS		*/
char	sb_melodic[256];	/* chemin et nom de la bank melodic pour sb	*/
char	sb_melodic_o3[256];	/* chemin et nom de la bank melodic pour opl3 	*/
char	sb_drum[256];		/* chemin et nom de la bank drum    pour sb	*/
char	sb_drum_o3[256];	/* chemin et nom de la bank drum    pour opl3 	*/



/*  pour klyric		*/
char fileToPlay[256]; 		/*  le nom du fichier a charger et jouer	*/

/*===============================*/

struct BANNER Banner;
unsigned char trackName[40];	/*  commentaire sur le track en lecture	*/
unsigned char patchName[40];	/*  le nom du patch en chargement	*/
/* */
LONG timeSinceBegin;		/*  le temps courant en ticks			*/
LONG SecSinceBegin;		/*  le temps courant en Secondes	*/
LONG maxTime;			/*  le nombre de ticks maximum			*/

unsigned char instrument[40][16]; 	/*  le nom de l'instrument courant par canal*/


BYTE mute[16];		/*  si 1 le canal ne joue pas.			*/
CHAR volume;		/*  le volume general du player (agit sur tous les */
			/*  canaux a la fois				*/
BYTE volumeCanal[16];	/*  Volume par canal				*/
BYTE panningCanal[16];	/*  Panning par canal				*/
byte transpose;		/*  La transposition generale du player		*/
byte transposeCanal[16];/*  La transposition par canal			*/
short ppm;		/*  le delta (bpm Reel = ppm + bpm)		*/
WORD bpm;		/*  Le bpm de base (celui du fichier midi)	*/

/* WORD ctrl[controlleur][channel] ;	*/
BYTE ctrl[128][16];
/* Pitch Bend */
WORD pitch[16];

/*  les attributs suivants sont a utiliser par klyric pour chaque troncon ou
  ligne de texte recu.*/
char font[80]; 		/*  le font par defaut		*/
char nbackground[40];	/*  la couleur de fond par defaut	*/
char fforeground[40];	/*  la couleur texte par defaut		*/
char abackground[40];	/*  la couleur fond texte actif par defaut*/
char aforeground[40];	/*  la couleur texte actif par defaut	*/
char pforeground[40];	/*  la couleur texte actif par defaut	*/
unsigned int styleBack;		/*  style du fond			*/


/* La palette de compatibilite avec KaraDos */
#define MaxColors	16
char palette[MaxColors][40] ;
/* la table de compatibilite des fonts pour KaraDos */
char fontnum [10][80];

};

