/*****************************************************************************/
/*          KaraLin  Le Karaoke pour linux                                   */
/*                                         Copyright(C) JP.Cocatrix L.Taieb  */
/*****************************************************************************/

/*****************************************************************************/
/* co_csts.h : defines utilise communs                                       */
/*****************************************************************************/



#define K_CO_TYPE_C12		1
#define K_CO_TYPE_C34		(K_CO_TYPE_C12+1)
#define K_CO_TYPE_C5		(K_CO_TYPE_C34+1)
#define K_CO_TYPE_C6		(K_CO_TYPE_C5+1)
 
#define K_CO_LAST_TYPE          (K_CO_TYPE_C6)


#define K_CO_SOCKADDR_C12	"/tmp/socket_C12"
#define K_CO_SOCKADDR_C34	"/tmp/socket_C34"
#define K_CO_SOCKADDR_C5	"/tmp/socket_C5"
#define K_CO_SOCKADDR_C6	"/tmp/socket_C6"


#define K_CO_ZONE1_PATH		"/tmp/shm_zone1"
#define K_CO_ZONE1_KEY		0x56


#define True			1
#define False			0 

#define byte		 	char



/* LISTE DES CODES MESSAGES */
				/* KDIR vers KMUSIC	*/
#define	C1_LOAD		01
#define	C1_STATUS	02
#define	C1_EXIT		03	
#define	C1_SHELL	04	
				/* KMUSIC vers KDIR	*/
#define	C2_LOADED	0x10
#define	C2_BUSY		0x11
#define	C2_IDLE		0x12
#define	C2_EXITED	0x13	
#define	C2_SHELL	0x14	
				/* KMUSIC vers KPLAY	*/
#define	C3_LOAD		0x20
#define	C3_START	0x21
#define	C3_STOP		0x22
#define	C3_SPEED	0x23
#define	C3_FORWARD	0x24
#define	C3_BACKWARD	0x25
#define	C3_REWIND	0x26
#define	C3_BPM		0x27
#define	C3_EXIT		0x28
#define C3_PANNING	0x29
				/* KPLAY vers KMUSIC	*/
#define	C4_LOADED	0x30
#define	C4_IDLE		0x31
#define	C4_CTRL		0x32
#define	C4_PGMCH	0x33
#define	C4_PITCH	0x34
#define	C4_ON		0x35
#define	C4_OFF		0x36
#define	C4_TEMPO	0x37
#define	C4_BPM		0x37
#define	C4_EXITED	0x38			
				/* KPLAY vers KLYRIC	*/
#define	C5_NEW		0x40
#define	C5_TRACKN	0x41
#define	C5_PATCHN	0x42
#define	C5_LENGTH	0x43
#define	C5_CRLF		0x44
#define	C5_BEGIN	0x45
#define	C5_SILENT	0x46
#define	C5_ON		0x47
#define	C5_TXT_ON	0x48
#define	C5_TXT_OFF	0x49
#define	C5_FT		0x4a
#define	C5_FF		0x4b
#define	C5_NB		0x4c
#define	C5_AF		0x4d
#define	C5_AB		0x4e
#define	C5_PF		0x4f
#define	C5_ST		0x50
#define	C5_EXIT		0x51
#define	C5_BANNER	0x52
				/* KLYRIC vers KMUSIC	*/
#define	C6_EXITED	0x60
#define	C6_START	0x61
#define	C6_SHELL	0x62
#define	C6_READY	0x63





/* Reponses  Cx_LOADED	par1	*/
#define	L_OK	0
#define	L_INEX	1
#define	L_NOK	2

/* Controleurs	de C4_CTRL	*/
#define	MODULATION	0x01
#define	BREATH		0x02
#define	FOOT		0x04
#define	PORTAMENTO	0x05
#define	VOLUME		0x07
#define	PAN		0x0A
#define	EXPRESSION	0x0B



/* Nbre max d'instruments gerable */
#define K_NB_MAX_INST           16

/* Pour Xfm */
#define true    True
#define false   False

/* redefine "max" and "min" macros to take into account "unsigned" values */
#define max(a,b) ((int)(a)>(int)(b)?(int)(a):(int)(b))
#define min(a,b) ((int)(a)<(int)(b)?(int)(a):(int)(b))


#define TRUE    1
#define FALSE   0


#ifndef DEBUG
#define Dprintf
#else
#define Dprintf fprintf
#endif

