/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */

/* $Id: range.c,v 1.1.1.1 1996/04/16 15:12:05 leon Exp $ */
#include <X11/Intrinsic.h>
#include <Xm/Scale.h>
#include "rangeD.h"
#include "main.h"
#include "Day.h"




void
ApplyRangeCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    int first, last;
    XmScaleGetValue(rangeD_first, &first);
    XmScaleGetValue(rangeD_last, &last);
    if(first < last) {
	XtVaSetValues(day, 
		      XtNfirstHour, first,
		      XtNlastHour, last,
		      0);
	DayScanAppointments(day);
    }
}



static void
ModifyRangeCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    int first, last;
   
    XmScaleGetValue(rangeD_first, &first);
    XmScaleGetValue(rangeD_last, &last);
    if(first >= last) {
	if(last < 1) last = 1;
	if(first > 22) first = 22;
	if(w == rangeD_first) {
	    XmScaleSetValue(rangeD_first, first);
	    XmScaleSetValue(rangeD_last, first+1);
	}
	else {
	    XmScaleSetValue(rangeD_first, last-1);
	    XmScaleSetValue(rangeD_last, last);
	}
    }
}






void
RangeCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    int first, last;
    if(NULL == rangeD) {
	Build_rangeD_1(toplevel);
	XtAddCallback(rangeD_ok, XmNactivateCallback, ApplyRangeCB, 0);
	XtAddCallback(rangeD_first, XmNdragCallback, ModifyRangeCB, 0);
	XtAddCallback(rangeD_last, XmNdragCallback, ModifyRangeCB, 0);
    }
    
    XtVaGetValues(day, 
		  XtNfirstHour, &first,
		  XtNlastHour, &last,
		  0);
    XmScaleSetValue(rangeD_first, first);
    XmScaleSetValue(rangeD_last, last);
    XtManageChild(rangeD);
}
