/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */

/* $Id: group.c,v 1.1.1.1 1996/04/16 15:12:04 leon Exp $ */

#include <X11/Intrinsic.h>
#include <Xm/SelectioB.h>
#include <Xm/List.h>
#include "main.h"
#include "cm.h"
#include "misc.h"


static void 
SaveChangesCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    Widget groupD = (Widget)client_data;
    XmStringTable xmses;
    int itemCount, i;
    char *p;
    CmGroup group;
    char buf[1024];
    
    XtVaGetValues(groupD, 
		  XmNlistItems, &xmses, 
		  XmNlistItemCount, &itemCount,
		  XmNuserData, &group,
		  0);
    buf[0] = '\0';
    for(i = 0; i < itemCount; i++) {
	XmStringGetLtoR(xmses[i], XmFONTLIST_DEFAULT_TAG, &p);
	strcat(buf, p);
	strcat(buf, " ");
	XtFree(p);
    }
    strcat(buf, "\n");
    group->nusers = itemCount;
    group->emails = Strdup(buf);
    CmSaveGroup(group);
}




static void 
InsertCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    Widget list = (Widget)client_data;
    XmSelectionBoxCallbackStruct *cs = 
	(XmSelectionBoxCallbackStruct *)call_data;

    XmListAddItemUnselected(list, cs->value, 999);
}



static void 
DeleteCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    Widget list = (Widget)client_data;
    XmSelectionBoxCallbackStruct *cs = 
	(XmSelectionBoxCallbackStruct *)call_data;
    if(XmListItemExists(list, cs->value)) {
	XmListDeleteItem(list, cs->value);
    }
}


void
GroupCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    Widget groupD = NULL;
    Calendar cal;
    CmGroup group;
    char *names;
    char name[32];
    char buf[64];
    XmString xms;
    Widget list, text;
    int len;

    cal = AgendaGetCalendar(agenda, XtName(w));
    if(cal) {
	group = cal->group;
	names = group->emails;
    }
    if(NULL == groupD) {
	groupD = XmCreateSelectionDialog(toplevel, "groupD", 0, 0);
	list = XmSelectionBoxGetChild(groupD, XmDIALOG_LIST);
	XtAddCallback(groupD, XmNapplyCallback, InsertCB, list);
	XtAddCallback(groupD, XmNcancelCallback, DeleteCB, list);
	XtAddCallback(groupD, XmNhelpCallback, UnmanageCB, groupD);
	XtAddCallback(groupD, XmNokCallback, SaveChangesCB, groupD);
	XtAddCallback(groupD, XmNokCallback, UnmanageCB, groupD);
    }
    /* sets group's name */
    sprintf(buf, "group: %s", XtName(w));
    xms = XmStringCreateSimple(buf);
    XtVaSetValues(groupD, 
		  XmNlistLabelString, xms, 
		  XmNuserData, group,
		  0);
    XmStringFree(xms);

    list = XmSelectionBoxGetChild(groupD, XmDIALOG_LIST);
    text = XmSelectionBoxGetChild(groupD, XmDIALOG_TEXT);
    XmListDeleteAllItems(list);
    while(0 != (len=strcspn(names, " \t\n"))) {
	strncpy(name, names, len);
	name[len] = '\0';
	xms = XmStringCreateSimple(name);
	XmListAddItemUnselected(list, xms, 0);
	XmStringFree(xms);
	names += len;
	/* skip trailing blanks */
	len = strspn(names, " \t\n");
	names += len;
    }
    XtManageChild(groupD);
}
