/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */

/* $Id: cal.c,v 1.1.1.1 1996/04/16 15:12:04 leon Exp $ */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "cal.h"
#include "misc.h"


Calendar
ClOpen(char *filename, char *name)
{
    Calendar cal;
    FILE *file;

    cal = NULL;
    file = fopen(filename, "r");
    if(NULL != file) {
	char buffer[1024];
	Appointment ap;
	cal = (Calendar)malloc(sizeof(CalendarRec));
	cal->name = Strdup(name);
	cal->selected = 1;
	cal->appointments =  NULL;
	while(fgets(buffer, 1024, file)) {
	    ap = AppointmentCreate();
	    AppointmentSscan(buffer, ap);
	    AppointmentSprint(buffer, ap);
#ifdef Debug
	    fprintf(stderr, "reading [%s], from %s\n", buffer, cal->name);
#endif /* Debug */
	    ap->next = cal->appointments;
	    cal->appointments = ap;
	}
    }
    fclose(file);
    cal->group = CmOpenGroup(APP_NAME, cal->name, getenv("USER"));
    return cal;
}


void
ClSave(Calendar cal, char *filename)
{
    FILE *file;

    file = fopen(filename, "w");
    if(NULL != file) {
	char buffer[1024];
	Appointment ap;
	
	for(ap = cal->appointments; NULL != ap; ap = ap->next) {
	    AppointmentSprint(buffer, ap);
	    fputs(buffer, file);
	    fputc('\n', file);
	}
	fclose(file);
    }
}



void
ClRegisterAppointment(Calendar cal, Appointment ap)
{
    ap->next = cal->appointments;
    cal->appointments = ap;
}


Appointment
ClAddAppointment(Calendar cal,
		 Appointment old)
{
    Appointment ap;
    char buf[1024];
    char header[64];

    ap = AppointmentCreate();
    ap->user = cuserid(NULL);
    ap->timestamp = time(NULL);
    ap->date = old->date;
    ap->start = old->start;
    ap->end = old->end;
    ap->repeat = old->repeat;
    ap->note = Strdup(old->note);
    ap->private = old->private;
    ap->alarm = old->alarm;
    ap->every = old->every;

    ap->next = cal->appointments;
    cal->appointments = ap;

    /* dispatching message */
    
    sprintf(header, "ADD %s %ld", ap->user, ap->timestamp);
    AppointmentSprint(buf, ap);
    CmSendString(cal->group, header, buf);

    return ap;
}


Appointment
ClFindAppointment(Calendar cal, char *user, time_t timestamp)
{
    Appointment id;
    for(id=cal->appointments; NULL != id; id = id->next){
	if((id->timestamp == timestamp) &&
	   (!strcmp(id->user, user)))
	    return id;
    }
    return NULL;
}




void
ClDestroyAppointment(Calendar cal, 
		    Appointment id)
{
    Appointment last;
    
    if(cal->appointments == id) {
	cal->appointments = id->next;
	Destroy(id);
    }
    else {
	for(last = cal->appointments; NULL != last; last=last->next) {
	    if(last->next == id) {
		last->next = id->next;
		Destroy(id);

		
		return;
	    }
	}
    }
}



void
ClRemoveAppointment(Calendar cal, 
		    Appointment id)
{
    char buf[1024];
    char header[64];
    
    /* dispatching message */
    sprintf(header, "DEL %s %ld", id->user, id->timestamp);
    AppointmentSprint(buf, id);
    CmSendString(cal->group, header, buf);
    
    ClDestroyAppointment(cal, id);
}



void
ClEnumerateAppointments(Calendar cal, 
			Date date, 
			ClEnumerateProc proc, 
			void *closure)
{
    Appointment id;
    for(id=cal->appointments; NULL != id; id = id->next){
	if(AppointmentMatch(id, &date))
	    (*proc)(cal, id, closure);
    }
}



void
ClEnumerateAnyAppointments(Calendar cal, 
			   ClEnumerateProc proc, 
			   void *closure)
{
    Appointment id;
    for(id=cal->appointments; NULL != id; id = id->next){
	    (*proc)(cal, id, closure);
    }
}


int
ClFindDayAppointment(Calendar cal, 
		      Date date)
{
    Appointment id;
    for(id=cal->appointments; NULL != id; id = id->next){
	if(AppointmentDayMatch(id, &date))
	    return 1;
    }
    return 0;
}
