/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */

/* $Id: DayP.h,v 1.1.1.1 1996/04/16 15:12:03 leon Exp $ */

#ifndef _DayP_h
#define _DayP_h

#include "Day.h"
#include <X11/CoreP.h>
#include <X11/Xlib.h>
#include "agenda.h"



struct _DayAppointmentRec;
typedef struct _DayAppointmentRec {
    AppointmentId id;
    char *note;
    Repeat repeat;
    CalendarId cal;
    struct _DayAppointmentRec *next;
} DayAppointmentRec, *DayAppointment;



typedef struct {
    int empty;
} DayClassPart;

typedef struct _DayClassRec {
    CoreClassPart	core_class;
    DayClassPart	day_class;
} DayClassRec;

extern DayClassRec dayClassRec;

typedef struct {
    /* resources */
    Agenda agenda;
    Date date;
    Pixel appointmentColor;
    Pixel hourColor;
    XFontStruct *hourFont;
    XFontStruct *appointmentFont;
    int firstHour;
    int lastHour;
    Boolean milTime; /* display the time in 24 hour time format */
    int devideHourIn;
    XtPointer userData;
    Boolean redraw;  /* if True,we'll receive a synthetic expose */

    /* private state */

    GC ap_gc;
    GC hour_gc;
    XtCallbackList appointmentCallback;  
    XtCallbackList noteCallback;   
    DayAppointment appointments[24];
    int appNum[24];
} DayPart;

typedef struct _DayRec {
    CorePart		core;
    DayPart	day;
} DayRec;



#endif /* _DayP_h */
