/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */

/* $Id: Day.h,v 1.1.1.1 1996/04/16 15:12:03 leon Exp $ */

#ifndef _Day_h
#define _Day_h

#include "date.h"
#include "agenda.h"

/****************************************************************
 *
 * Day widget
 *
 ****************************************************************/

typedef struct _DayClassRec*	DayWidgetClass;
typedef struct _DayRec*	DayWidget;

#define XtNagenda "agenda"
#define XtCAgenda "Agenda"
#define XtNdate "date"
#define XtCDate "Date"
#define XtRDate "Date"
#define XtNappointmentColor "appointmentColor"
#define XtCAppointmentColor "AppointmentColor"
#define XtNhourColor "hourColor"
#define XtCHourColor "HourColor"
#define XtNhourFont "hourFont"
#define XtNappointmentFont "appointmentFont"
#define XtNfirstHour "firstHour"
#define XtCFirstHour "FirstHour"
#define XtNlastHour "lastHour"
#define XtCLastHour "LastHour"
#define XtNmilTime "milTime"
#define XtCMilTime "MilTime"
#define XtNappointmentCallback "appointmentCallback"
#define XtNnoteCallback "noteCallback"
#define XtNdevideHourIn "devideHourIn"
#define XtCDevideHourIn "DevideHourIn"
#define XtNuserData "userData"
#define XtCUserData "UserData"
#define XtNredraw "redraw"
#define XtCRedraw "Redraw"


extern WidgetClass dayWidgetClass;


typedef struct _DayCallbackStruct {
    int reason;
    XEvent *event;
    Date date;
    AppointmentId id;
    char *note;
    Repeat repeat;
    Agenda ag;
    CalendarId cal;
} DayCallbackStruct;

extern void
DayAddAppointment(Widget w, 
		  int hour, 
		  char *note, 
		  CalendarId cal, 
		  AppointmentId id,
		  Repeat repeat,
		  Boolean redraw);

extern void
DayClearAllAppointments(Widget w);


extern void
DayScanAppointments(Widget w);


extern void
DaySetDate(Widget w,
	   Date date);


extern void
DayGetDateString(Widget w,
		 Date date,
		 char *str);

#endif /* _Day_h */
