#undef HAVE_CONFIG_H
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qfiledlg.h>
#include <ktopwidget.h>
#include <kstatusbar.h>
#include "klocale.h"
#include <kiconloader.h>
#include <ktoolbar.h>
#include <ktablistbox.h>
#include <kwm.h>
#include <qmsgbox.h>

#include "accwidget.h"

#include "accountwidget.h"
#include "balancedlg.h"
#include "newacctdlg.h"
#include "transferdlg.h"
#include "editacctdlg.h"
#include "notesdlg.h"

#define IDX_ASSETS  1
#define IDX_PROFITS 2

int loglevel = 5;


// extern "C" AccountGroup *topgroup;



extern "C" {
 void errorBox (void *, char *buf) { QMessageBox::information (0, "KAcc error", buf); }

 int verifyBox (void *, char *buf) { return 0 == QMessageBox::warning (0, "KAcc error",
buf, "Yes", "No"); }
}

void AccWidget::initMenu() {

  KWM::setIcon(winId(), kapp->getIcon());
  KWM::setMiniIcon(winId(), kapp->getMiniIcon());
  
  QPopupMenu *file = new QPopupMenu;
  file->insertItem( klocale->translate("&New File..."), ID_FILE_NEWFILE);
  file->insertItem(  klocale->translate("&Open File..."), ID_FILE_OPEN);
  file->insertItem(  klocale->translate("&Import QIF..."), ID_FILE_IMPORT );
  file->insertSeparator();
  file->insertItem(  klocale->translate("&Save"), ID_FILE_SAVE);
  file->insertItem(  klocale->translate("Save &As..."), ID_FILE_SAVEAS);
  file->insertSeparator();
  file->insertItem(  klocale->translate("&Quit"), ID_FILE_QUIT);

  QPopupMenu *account = new QPopupMenu;
  account->insertItem( klocale->translate("&New Account..."),ID_ACCT_NEWACCT);
  account->insertItem(  klocale->translate("&Open Account"), ID_ACCT_OPENACCT);
  account->insertItem(  klocale->translate("Open &Subaccounts"),ID_ACCT_OPENSUBACCT );
  account->insertItem(  klocale->translate("&Edit Account..."),ID_ACCT_EDITACCT);
  account->insertItem(  klocale->translate("&Delete Account..."),ID_ACCT_DELETEACCT);
  account->insertSeparator();
  account->insertItem(  klocale->translate("&Transfer"), ID_ACCT_TRANSFER);
  account->insertItem(  klocale->translate("&Report"), ID_ACCT_REPORT);
  account->insertItem(  klocale->translate("Hide &Inc/Exp..."),ID_ACCT_HIDEINCEXP);

  QPopupMenu *help = new QPopupMenu;
  help->insertItem( klocale->translate("&About..."), ID_HELP_ABOUT);
  help->insertItem( klocale->translate("&Help..."), ID_HELP_HELP);
  help->insertItem( klocale->translate("Accounts..."), ID_HELP_ACCTS);
  help->insertSeparator();
  help->insertItem( klocale->translate("&License..."), ID_HELP_LICENSE);

  connect (file, SIGNAL (activated (int)), SLOT (menuCallback (int)));
  connect (account, SIGNAL (activated (int)), SLOT (menuCallback (int)));
  connect (help, SIGNAL (activated (int)), SLOT (menuCallback (int)));

  menu = new KMenuBar( this );
  CHECK_PTR( menu );
  menu->insertItem( klocale->translate("&File"), file );
  menu->insertItem( klocale->translate("&Account"), account );
  menu->insertSeparator();
  menu->insertItem( klocale->translate("&Help"), help );
  menu->show();
  setMenu(menu);
}

AccWidget::AccWidget() {
  KStatusBar *sb;
  KToolBar *tb;

  KIconLoader *loader = kapp->getIconLoader();
  QPixmap pixmap;

  tb = new KToolBar (this);
  addToolBar (tb);
  tb->setBarPos(KToolBar::Top);
  tb->show();
  connect(tb, SIGNAL(clicked(int)), this, SLOT(menuCallback(int)));

  pixmap = loader->loadIcon ("filenew2.xpm");
  tb->insertButton (pixmap,ID_FILE_NEWFILE); 

  pixmap = loader->loadIcon ("fileopen.xpm");
  tb->insertButton (pixmap,ID_FILE_OPEN); 

  pixmap = loader->loadIcon ("filefloppy.xpm");
  tb->insertButton (pixmap,ID_FILE_SAVE);  

   tb->insertSeparator();

   pixmap.load ("toolbar/acctopen.xpm");
   tb->insertButton (pixmap, ID_ACCT_OPENACCT);

   pixmap.load ("toolbar/acctnew.xpm");
   tb->insertButton (pixmap, ID_ACCT_NEWACCT);

   pixmap.load ("toolbar/acctedit.xpm");
   tb->insertButton (pixmap, ID_ACCT_EDITACCT);

   pixmap.load ("toolbar/acctdele.xpm");
   tb->insertButton (pixmap, ID_ACCT_DELETEACCT);


//  tb->insertSeparator();
  
  sb = new KStatusBar(this);
  setStatusBar (sb);

  sb->insertItem ("Assets: 12233,34 DM",IDX_ASSETS);   
  sb->insertItem ("Profits: 12233,34 DM",IDX_PROFITS);
  sb->insertItem ("",-1);

  // main list
  acctList = new KTabListBox (this,"",3);
  setView (acctList);
  acctList->setAutoUpdate (true);

//  acctList->setColumn (0,"", 20, KTabListBox::PixmapColumn);
  acctList->setColumn (0,"Account name", 200);
  acctList->setColumn (1,"Type", 100);   
  acctList->setColumn (2,"Balance", 100);

  acctList->insertItem ("\nABC Bank\nBank\n$ 1738.00");
  acctList->insertItem ("\nBest Bank\nBank\n$ 500.00");
  acctList->insertItem ("\nCredit Card\nCredit Card\n-$ 721.32");
  acctList->insertItem ("\nABC Corp Stock\nStock\n$ 2550.00");

  connect (acctList, SIGNAL(selected(int,int)), SLOT (selectAccount (int)));

  initMenu();
  setCaption(kapp->getCaption());  

  resize(650,400);
  show();
}

AccWidget::~AccWidget() {
  delete menu;

//  xaccGroupWindowDestroy (topgroup);
//  freeAccountGroup (topgroup);
}

int main(int argc, char **argv) {
  KApplication a(argc,argv,"KAcc");  

  AccWidget *aw = new AccWidget();
  a.setMainWidget(aw);

/*  AccountWidget *aw2 = new AccountWidget();
  aw2->show(); 
  
  BalanceDlg *bd = new BalanceDlg();
  bd->show();

  NewAcctDlg *na = new NewAcctDlg();
  na->show(); 

  TransferDlg *td = new TransferDlg();
  td->show(); 

  EditAcctDlg *ea = new EditAcctDlg ();
  ea->show();    

  NotesDlg *nd = new NotesDlg ();
  nd->show(); */ 
  
  return a.exec();
}

void AccWidget::selectAccount (int idx) {
  AccountWidget *aw = new AccountWidget();
  aw->show(); 
}

void AccWidget::menuCallback (int item) {
  switch (item) {
    case ID_FILE_OPEN : doFileOpen(); break;
    case ID_FILE_SAVE :  doFileSave(); break;
    case ID_FILE_SAVEAS :  doFileSaveAs(); break;
    case ID_FILE_CLOSE :  break;
    case ID_FILE_QUIT :  kapp->quit();
    case ID_FILE_NEWFILE : doFileNew(); break;
    case ID_FILE_IMPORT  : doFileImport(); break;

    case ID_ACCT_NEWACCT     : doNewAcct(); break; 
    case ID_ACCT_OPENACCT    : doOpenAcct(); break;
    case ID_ACCT_OPENSUBACCT :  break;
    case ID_ACCT_EDITACCT    : doEditAcct(); break;
    case ID_ACCT_DELETEACCT  : break;
    case ID_ACCT_TRANSFER    : doTransfer();
    case ID_ACCT_REPORT      : break;
    case ID_ACCT_HIDEINCEXP  : break;

    case ID_HELP_ABOUT   : break;
    case ID_HELP_HELP    : break;
    case ID_HELP_ACCTS   : break;
    case ID_HELP_LICENSE : break;
  }
}

void AccWidget::doFileOpen () {
//  AccountGroup *grp = topgroup; 

  QString s = QFileDialog::getOpenFileName();

  if (s.isNull()) return;

  acctList->clear(); 
  acctList->appendItem (" \n \n ");
  acctList->appendItem (" \n \n ");
  acctList->appendItem (" \n \n ");
  acctList->appendItem (" \n \n ");
  acctList->changeItem ("Test\nTest2\nTest3",acctList->count()-1);
  acctList->changeItemPart ("Test a",acctList->count()-2,0);
  acctList->changeItemPart ("Test b",acctList->count()-2,1);
  acctList->changeItemPart ("Test c",acctList->count()-2,2);

  return;

  /* destroy open windows first, before destroying the group itself */
//  xaccGroupWindowDestroy (grp);
//  freeAccountGroup (grp);



  /* load the accounts from the users datafile */
//  grp = readData ((const char *)s);

//  if( NULL == grp ) {
    /* the file could not be found */
//    grp = mallocAccountGroup();
//  }
//  topgroup = grp;        

//  acctList->clear(); 

//  xaccRecomputeBalance ((Account*)grp);
//  addAccountGroup (grp, 0);
//  redisplayBalance (); 
}

void AccWidget::doFileSave () {
  QString s = QFileDialog::getSaveFileName();
}

void AccWidget::doFileSaveAs () {
  QString s = QFileDialog::getSaveFileName();
}

void AccWidget::doFileNew () {
  // TODO
}

void AccWidget::doFileImport () {
  QString s = QFileDialog::getOpenFileName();
}

void AccWidget::doNewAcct () {
  NewAcctDlg *na = new NewAcctDlg();
  na->exec();
}

void AccWidget::doEditAcct () {
  EditAcctDlg *ea = new EditAcctDlg();
  ea->exec();    
}

void AccWidget::doOpenAcct () {
  AccountWidget *aw = new AccountWidget();
//  aw->show(); 
}

void AccWidget::doTransfer () {
  TransferDlg *td = new TransferDlg();
  td->exec(); 
}

// void AccWidget::addAccountGroup (AccountGroup *grp, int depth) {
//  int i;  /* Add all the top-level accounts to the list */
//  for( i=0; i<grp->numAcc; i++ )
//    {
//    String cols[XACC_MAIN_NUM_COLS];
//    Account *acc = getAccount( grp, i );
//    double dbalance;
    
//    if (/* (0 == show_categories) && */ 
//       ((INCOME == acc->type) || (EXPENSE == acc->type))) continue;
//    /* fill in the arrow and the account type fileds */
//    cols[XACC_MAIN_ACC_ARRW] = XtNewString("");
//    cols[XACC_MAIN_ACC_TYPE] = XtNewString(account_type_name[acc->type]);

//    acctList->appendItem ("\n\n\n");
//    acctList->changeItemPart ("Test",1,acctList->currentItem());
    

//    /* fill in the account name field, indenting for sub-accounts */
//    buf[0] = 0x0;
//    for (j=0; j<depth; j++) {
//       strcat (buf, "    ");
//    }
//    strcat (buf, acc->accountName);
//    cols[XACC_MAIN_ACC_NAME] = XtNewString(buf);
//
//    /* fill in the balance column */
//    dbalance = acc->balance;
//    /* if the account has children, add in thier balance */
//    if (acc->children) {
//       dbalance += acc->children->balance;
//    }
//    
//    /* the meaning of "balance" for income and expense 
//     * accounts is reversed, since a deposit of a paycheck in a
//     * bank account will appear as a debit of the corresponding
//     * amount in the income account */
//    if ((EXPENSE == acc->type) ||
//        (INCOME  == acc->type) ) {
//      dbalance = -dbalance;
//    }
//    amt = xaccPrintAmount (dbalance, PRTSYM);
//    cols[XACC_MAIN_ACC_BALN] = XtNewString(amt);
//    
//    XtVaGetValues (acctrix, XmNrows, &currow, NULL);
//    XbaeMatrixAddRows( acctrix, currow, cols, NULL, NULL, 1 );
//
//    for (k=0; k<XACC_MAIN_NUM_COLS; k++) {
//      XtFree (cols[k]);
//    }
//    
//    /* associate a pointer to the actual account with the row */
//    XbaeMatrixSetRowUserData ( acctrix, currow, (XtPointer) acc); 
//
//    /* If the account has sub-accounts, then add an arrow button 
//     * next to the account name.  Clicking on the arrow button will 
//     * expand the display to list the sub-accounts.  The arrow button
//     * will be a cell-wdiget, and will be stored with the account 
//     * structure */
//    if (acc->children) {
//       /* if the arrow button doesn't exist, add it */
//       if (NULL == acc->arrowb) {
//          int height;
//          /* adjust arrow size for font size */
//          height = XbaeMatrixGetRowPixelHeight (acctrix);
//          acc->arrowb = XtVaCreateManagedWidget ("accarrow", 
//                                      xmArrowButtonWidgetClass, acctrix,
//                                      XmNwidth, height,
//                                      XmNheight, height,
//                                      XmNshadowThickness, 0,
//                                      XmNarrowDirection, XmARROW_DOWN, 
//                                      NULL);
//
//          XtAddCallback (acc->arrowb, XmNactivateCallback, 
//                         expandListCB, (XtPointer *) acc);
//       }
//       XbaeMatrixSetCellWidget (acctrix, currow, XACC_MAIN_ACC_ARRW, acc->arrowb);
//       XtManageChild (acc->arrowb);
//
//       /* recursively display children accounts */
//       if (acc->expand) {
//          xaccMainWindowAddAcct (acctrix, acc->children, depth+1);
//       }
//    } else {
//       /* if there are no children, make sure that there is no
//        * arrow too.  This situation can occur if a sub-account
//        * has been deleted. 
//        */
//       if (acc->arrowb) {
//          XbaeMatrixSetCellWidget (acctrix, currow, XACC_MAIN_ACC_ARRW, NULL);
//          XtRemoveCallback (acc->arrowb, XmNactivateCallback,
//                            expandListCB, (XtPointer *) acc);
//
//          XtUnmanageChild (acc->arrowb);
//          XtDestroyWidget (acc->arrowb);
//          acc->arrowb = NULL;
//       }
//    }
//  }
//}

void AccWidget::redisplayBalance () {
}



#include "accwidget.moc"




