/********************************************************************\
 * top-level.c -- top-level ui functions for gnucash                *
 * Copyright (C) 1997 Robin D. Clark                                *
 *                                                                  *
 * This program is free software; you can redistribute it and/or    *
 * modify it under the terms of the GNU General Public License as   *
 * published by the Free Software Foundation; either version 2 of   *
 * the License, or (at your option) any later version.              *
 *                                                                  *
 * This program is distributed in the hope that it will be useful,  *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of   *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    *
 * GNU General Public License for more details.                     *
 *                                                                  *
 * You should have received a copy of the GNU General Public License*
 * along with this program; if not, write to the Free Software      *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.        *
 *                                                                  *
 *   Author: Rob Clark                                              *
 * Internet: rclark@cs.hmc.edu                                      *
 *  Address: 609 8th Street                                         *
 *           Huntington Beach, CA 92648-4632                        *
\********************************************************************/

#include <stdlib.h>

#include <Xm/Xm.h>
#include <X11/Shell.h>
#include <assert.h>

#include "config.h"

#include "FileBox.h"
#include "FileIO.h"
#include "Group.h"
#include "top-level.h"
#include "MainWindow.h"
#include "messages.h"
#include "TransLog.h"
#include "util.h"

/** PROTOTYPES ******************************************************/

/** GLOBALS *********************************************************/
char    *datafile = NULL;
Widget   toplevel = 0;
Boolean  realized = False;   /* Has the toplevel been realized? */
XtAppContext app;

AccountGroup *topgroup = NULL;


/** FALLBACK RESOURCES **********************************************/
/* NOTE: These will eventually be moved out into a site-default file,
 *       but default-resources are here for now, for convenience */
String fbRes[] = {
  "*Foreground:               black",
  "*Background:               grey",
  "*fontList:                 -*-helvetica-bold-r-normal--*-120-*-*-*-*-*-*",
  "*text.fontList:            -*-helvetica-medium-r-normal--*-100-*-*-*-*-*-*",
  /* Help stuff" */
  "*help*geometry:            530x480-0-0",
/*  "*help*View*Background:     #ffffff",  */
  /* MenuBar stuff: */
  "*menubar*marginHeight:     1",
  "*menubar*marginWidth:      1",

  /* Register window account type specific stuff: */ 
  "*regbank.oddRowBackground:      #aaccff",
  "*regcash.oddRowBackground:      #ccffcc",
  "*regasset.oddRowBackground:     #aaffcc",
  "*regcredit.oddRowBackground:    #ffffaa",
  "*regliability.oddRowBackground: #ffcccc",
  "*ledportfolio.oddRowBackground: #ccffff",
  "*regmutual.oddRowBackground:    #ccffff",
  "*regincome.oddRowBackground:    #aaccff",
  "*regexpense.oddRowBackground:   #ffcccc",
  "*regequity.oddRowBackground:    #ffffaa",
  "*ledgportfolio.evenRowBackground:grey",
  "*regmutual.evenRowBackground:   grey",

  /* Other register window account stuff: */
  "*reg*fontList:            -*-helvetica-medium-r-normal--*-100-*-*-*-*-*-*",
  "*reg*evenRowBackground:   white",
  "*reg*shadowType:          SHADOW_IN",
  "*reg*shadowThickness:     1",
  "*reg*cellShadowThickness: 1",
  "*reg*cellShadowType:      SHADOW_IN",
  "*reg*cellMarginWidth:     1",
  "*reg*cellMarginHeight:    0",

  /* Reconcile window matrices stuff: */
  "*recn*fontList:            -*-helvetica-medium-r-normal--*-100-*-*-*-*-*-*",
  "*recn*.oddRowBackground:   white",
  "*recn*.evenRowBackground:  white",
  "*recn*shadowType:          SHADOW_ETCHED_IN",
  "*recn*shadowThickness:     1",
  "*recn*cellShadowThickness: 1",
  "*recn*cellShadowType:      SHADOW_ETCHED_IN",
  "*recn*cellMarginWidth:     0",
  "*recn*cellMarginHeight:    0",

  /* combobox -- don't want the cell to be outlined */
  "*reg*combocell*shadowThickness:     0",
  "*reg*combocell*list*shadowThickness:     1",  /* we *do* want the combobox scroll bar to show, thoguh */
  "*reg*combocell*list*thickness:     24",  /* slider width ignored ... why ??? */
  "*reg*combocell*list*VertScrollBar*width:     24",  /* slider width ignored ... why ??? */
  "*reg*combocell*list*troughColor:    #9999aa",  /* ignored -- why ???*/
  NULL,
  };


/* These gnucash_lowlev and gnucash_ui functions are just hacks to get
   the guile stuff up and running.  Expect a more formal definition of
   what they should do soo, and expect that the open/select functions
   will be merged with the code in FMB_OPEN in MainWindow.c */

int
gnucash_lowlev_app_init()
{
#if DEBUG_MEMORY
  char *blk;
  DEBUG("Initializing memory");
  blk = (char *)_malloc(8192);
  _free(blk);
  printf(" coresize = %d\n",_coresize());
  DEBUG("Done initializing memory");
#endif
  
  printf ("\n\n");
  printf ("This is a BETA development version.  We think everything works \n");
  printf ("but we're not sure yet.  Feel free to try this, but please do \n");
  printf ("make backups of your data.  Please report bugs and other prblems \n");
  printf ("to http://www.gnucash.org/ \n");
  printf ("The last stable version was xacc-1.0.18 \n");
  printf ("The next stable version will be gnucash-1.2.x \n");
  printf ("\n\n");
  
  {
    int fake_argc = 1;
    char *fake_argv[] = {"gnucash"};
   
    /* We're going to have to have other ways to handle X and GUI
       specific args... */
    toplevel = XtVaOpenApplication( &app, "Xacc", NULL, 0,
                                    &fake_argc, fake_argv, fbRes,
                                    topLevelShellWidgetClass,
                                    NULL );
  } 
  return 0;
}
  

int
gnucash_lowlev_app_main()
{  
  /* Make main window */
  mainWindow(toplevel);
  
  /* Draw toplevel */
  XtRealizeWidget(toplevel);
  realized = TRUE;
  
  /* Enter event loop */
  XtAppMainLoop(app);

  return 0;
}



int
gnucash_ui_open_file(const char name[]) {
  /* FIXME: This should eventually be merged with the FMB_OPEN code in
     MainWindow.c */
  /* FIXME: This code looks gui-independent to me ...
   *  (nothing in thisroutine depends on motif/gtk/etc.)
   */
  
  datafile = name;
  
  if( NULL != datafile ) 
  {
    xaccLogSetBaseName (datafile);
    topgroup = xaccReadAccountGroup (datafile); /* load accounts from file */
  }
  
  /* FIXME: this should not really be here.  We should make
     gnc_ui_select_file more independent.  You should be able to call
     it at any time and have it DTRT.  Code should be stolen from
     MainWindow.c FMB_OPEN.  In fact, that whole callback routine
     should probably be broken up into sub-functions that we can use
     from the Guile level.  */
  if( NULL == topgroup )
  {
    topgroup = xaccMallocAccountGroup();   /* the file could not be found */
  }
  return (topgroup != NULL);
  
}
  
int
gnucash_ui_select_file() {

  datafile = fileBox( toplevel, OPEN_STR, "*.xac" );
  gnucash_ui_open_file(datafile);
  return (topgroup != NULL);
}
