/* gnucash.c -- gnucash startup function.
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.
                                                                   
   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
                                                                   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
   (C) 1998 Rob Browning <rlb@cs.utexas.edu>
*/

#include <libguile.h>
#include <gnome.h>

static void
gnucash_main(int argc, char *argv[]) {

  printf("gnucash: starting up\n");
  
  /* Get the functions you need to initialize things and get going. */
  if(gh_eval_file("./startup.scm") == SCM_BOOL_F) {
    fprintf(stderr, "gnucash: startup file load failed");
    exit(1);
  }
  
  /* Your code here */
  /* gtk_init(); */
  /* gtk_main(); */
  /* etc. */

  printf("gnucash: shutting down\n");
}

int
main(int argc, char *argv[]) {
  gnome_init("GnuCash", NULL, argc, argv, ARGP_SILENT, &argc);

  fprintf(stderr, "arg count: %d\n", argc);

  gh_enter(argc, argv, gnucash_main);
  return 0;
}

/*
  Local Variables:
  tab-width: 2
  indent-tabs-mode: nil
  mode: c-mode
  c-indentation-style: gnu
  eval: (c-set-offset 'block-open '-)
  End:
*/
