/* NEVER EVER edit this manually, fix the mkhelp script instead! */
#include <stdio.h>
void hugehelp(void)
{
puts ( 
"\n"
"Warning! This is a modified version of urlget!\n"
"This is *not* the original source!!\n"
"                            _            _   \n"
"                 _   _ _ __| | __ _  ___| |_ \n"
"                | | | | '__| |/ _` |/ _ \\ __|\n"
"                | |_| | |  | | (_| |  __/ |_ \n"
"                 \\__,_|_|  |_|\\__, |\\___|\\__| - Gets your URL!\n"
"                              |___/          \n"
"\n"
"NAME\n"
"  urlget - get a file from a FTP, GOPHER or HTTP server.\n"
"\n"
"SYNOPSIS\n"
"  urlget [options] <url>\n"
" \n"
"DESCRIPTION\n"
"  urlget is a client to get documents/files from servers, using any of the\n"
"  supported protocols. The command is designed to work without user\n"
"  interaction or any kind of interactivity.\n"
"\n"
"OPTIONS\n"
"   The following options may be specified at the command line:\n"
"\n"
"   -d <data> (HTTP ONLY)\n"
"        Sends the specified data in a POST request to the HTTP server. Note\n"
"        that the data is sent exactly as specified with no extra processing.\n"
"        The data is expected to be \"urlencoded\".\n"
"\n"
"   -e <url> (HTTP ONLY)\n"
"        Sends the \"Referer Page\" information to the HTTP server. Some badly\n"
"        done CGIs fail if it's not set.\n"
"\n"
"   -f   (HTTP ONLY)\n"
"        Fail silently (no output at all) on server errors. This is mostly done\n"
"        like this to better enable scripts etc to better deal with failed\n"
"        attempts. In normal cases when a HTTP server fails to deliver a\n"
"        document, it returns a HTML document stating so (which often also\n"
"        describes why and more). This flag will prevent urlget from outputting\n"
"        that and fail silently instead.\n"
"\n"
"   -i   (HTTP ONLY)\n"
"        Include the HTTP-header in the output. The HTTP-header includes things\n"
"        like server-name, date of the document, HTTP-version and more...\n"
"\n"
"   -I   (HTTP ONLY)\n"
"        Fetch the HTTP-header only! HTTP-servers feature the command HEAD\n"
"        which this uses to get nothing but the header of a document.\n"
"\n"
"   -k   (HTTP ONLY)\n"
"        Use Keep-Alive connection. There is currently no real gain to use this.\n"
"\n"
"   -l   (FTP ONLY)\n"
"        When listing an FTP directory, this switch forces a name-only view.\n"
"        Especially useful if you want to machine-parse the contents of an FTP\n"
"        directory since the normal directory view doesn't use a standard look\n"
"        or format.\n"
"\n"
"   -m <seconds>\n"
"        Maximum time in seconds that you allow the whole operation to take.\n"
"        This is useful for preventing your batch jobs from hanging for hours\n"
"        due to slow networks or links going down.\n"
"\n"
"   -o <file>\n"
"        Write output to <file> instead of stdout.\n"
"\n"
"   -O\n"
"        Write output to a local file named like the remote file we get. (Only\n"
"        the file part of the remote file is used, the path is cut off.)\n"
"\n"
"   -r <range>   (HTTP ONLY)\n"
"        Retrieve a byte range (i.e a partial document) from a HTTP/1.1\n"
"        server. Ranges can be specified in a number of ways.\n"
"        0-499           - specifies the first 500 bytes\n"
"        500-999         - specifies the second 500 bytes\n"
"        -500            - specifies the last 500 bytes\n"
"        9500-           - specifies the bytes from offset 9500 and forward\n"
"        0-0,-1          - specifies the first and last byte only(*)\n"
"        500-700,600-799 - specifies 300 bytes from offset 500\n"
"        100-199,500-599 - specifies two separate 100 bytes ranges(*)\n"
"\n"
"        (*) = NOTE that this will cause the server to reply with a multipart\n"
"        response!\n"
"\n"
"   -p <port>\n"
"        Use port other than default for current protocol. This is typically\n"
"        most used together with the proxy-flag (-x).\n"
"\n"
"   -s\n"
"        Silent mode. Don't show progress meter or error messages.  Makes\n"
"        Urlget mute.\n"
"\n"
"   -t  (FTP only)\n"
"	Transfer the stdin data to the specified file. Urlget will read\n"
"	everything from stdin until EOF and store with the supplied name.\n"
"\n"
"   -T <file> (FTP)\n"
"        Like -t, but this transfers the specified local file. If there is no\n"
"        file part in the specified URL, Urlget will append the local file\n"
"        name. NOTE that you must use a trailing / on the last directory to\n"
"        really prove to Urlget that there is no file name or urlget will think\n"
"        that your last directory name is the remote file name to use. That\n"
"        will most likely cause the upload operation to fail.\n"
"\n"
"   -T <file> (HTTP and HTTPS)\n"
"        Specify a file containing raw HTTP comands. Typically, this file\n"
"        will have a POST header including Content-Type and Content-Length\n"
"        fileds, and then a blank line followed by POST data.\n"
"\n"
"   -u <user:password>\n"
"        Specify user and password to use when fetching. See below for detailed\n"
"        examples of how to use this.\n"
"\n"
"   -U <user:password>\n"
"        Specify user and password to use for Proxy authentication.\n"
"\n"
"   -v \n"
"        Makes the fetching more verbose/talkative. Mostly usable for\n"
"        debugging. Lines starting with '>' means data sent by urlget, '<'\n"
"        means data received by urlget that is hidden in normal cases and lines\n"
"	starting with '*' means additional info provided by urlget.\n"
"\n"
"   -x <host>\n"
"        Use proxy. The port number to use is set to 1080 when this is used and\n"
"        the port flag (-p) is not.\n"
"\n"
"SIMPLE USAGE\n"
"\n"
"  Get the main page from netscape's web-server:\n"
"\n"
"        urlget http://www.netscape.com/\n"
"\n"
"  Get the root README file from funet's ftp-server:\n"
"\n"
"        urlget ftp://ftp.funet.fi/README\n"
"\n"
"  Get a gopher document from funet's gopher server:\n"
"\n"
"        urlget gopher://gopher.funet.fi\n"
"\n"
"  Get a web page from a server using port 8000:\n"
"\n"
"        urlget http://www.weirdserver.com:8000/\n"
"\n"
"  Get a list of the root directory of an FTP site:\n"
"\n"
"        urlget ftp://ftp.fts.frontec.se/\n"
"\n"
"DOWNLOAD TO A FILE\n"
"\n"
"  Get a web page and store in a local file:\n"
"\n"
"        urlget -o thatpage.html http://www.netscape.com/\n"
"\n"
"  Get a web page and store in a local file, make the local file get the name\n"
"  of the remote document (if no file name part is specified in the URL, this\n"
"  will fail):\n"
"\n"
"        urlget -O http://www.netscape.com/index.html\n"
"\n"
"USING PASSWORDS\n"
"\n"
" FTP\n"
"\n"
"   To ftp files using name+passwd, include them in the URL like:\n"
"\n"
"        urlget ftp://name:passwd@machine.domain:port/full/path/to/file\n"
"\n"
"   or specify them with the -u flag like\n"
"\n"
"        urlget -u name:passwd ftp://machine.domain:port/full/path/to/file\n"
"\n"
" HTTP\n"
"\n"
"   The HTTP URL doesn't support user and password in the URL string. Urlget\n"
"   does support that anyway to provide a ftp-style interface and thus you can\n"
"   pick a file like:\n"
"\n"
"        urlget http://name:passwd@machine.domain/full/path/to/file\n"
"\n"
"   or specify user and password separately like in\n"
"\n"
"        urlget -u name:passwd http://machine.domain/full/path/to/file\n"
"\n"
"   NOTE! Since HTTP URLs don't support user and password, you can't use that\n"
"   style when using Urlget via a proxy. You _must_ use the -u style fetch\n"
"   during such circumstances.\n"
"\n"
" GOPHER\n"
"\n"
"   Urlget features no password support for gopher.\n"
"\n"
"PROXY\n"
"\n"
" Get a web page using a proxy named my-proxy that uses port 888:\n"
"\n"
"        urlget -p 888 -x my-proxy http://www.web.com/\n"
"\n"
" Get an ftp file using a proxy named my-proxy that uses port 888:\n"
"\n"
"        urlget -p 888 -x my-proxy ftp://ftp.leachsite.com/README\n"
"\n"
" Get a file from a HTTP server that requires user and password, using the\n"
" same proxy as above:\n"
"\n"
"        urlget -u user:passwd -p 888 -x my-proxy http://www.get.this/\n"
"\n"
"RANGES\n"
"\n"
"  With HTTP 1.1 byte-ranges were introduced. Using this, a client can request\n"
"  to get only one or more subparts of a specified document. Urlget supports\n"
"  this with the -r flag.\n"
"\n"
"  Get the first 100 bytes of a document:\n"
"\n"
"        urlget -r 0-99 http://www.get.this/\n"
"\n"
"  Get the last 500 bytes of a document:\n"
"\n"
"        urlget -r -500 http://www.get.this/\n"
"\n"
"UPLOADING\n"
"\n"
" FTP\n"
"\n"
"   Upload all data on stdin to a specified ftp site:\n"
"\n"
"        urlget -t ftp://ftp.upload.com/myfile\n"
"\n"
"   Upload data from a specified file, login with user and password:\n"
"\n"
"        urlget -T uploadfile -u user:passwd ftp://ftp.upload.com/myfile\n"
"\n"
"   Upload a local file to the remote site, and use the local file name remote\n"
"   too:\n"
" \n"
"        urlget -T uploadfile -u user:passwd ftp://ftp.upload.com/\n"
"\n"
" HTTP\n"
"\n"
"   See the POST section below.\n"
"\n"
"VERBOSE / DEBUG\n"
"\n"
"  If urlget fails where it isn't supposed to, if the servers don't let you in,\n"
"  if you can't understand the responses: use the -v flag to get VERBOSE\n"
"  fetching. Urlget will output lots of info and all data it sends and receives\n"
"  in order to let the user see all client-server interaction.\n"
"\n"
"        urlget -v ftp://ftp.upload.com/\n"
"\n"
"POST\n"
"\n"
"  It's easy to post data using urlget. This is done using the -d <data>\n"
"  option.  The post data must be urlencoded.\n"
"\n"
"  Post a simple \"name\" and \"phone\" guestbook.\n"
"\n"
"  urlget -d \"name=Rafael%20Sagula&phone=3320780\" http://www.where.com/guest.cgi\n"
"\n"
"REFERER\n"
"\n"
"  A HTTP request has the option to include information about which address\n"
"  that referred to actual page, and urlget allows the user to specify that\n"
"  referrer to get specified on the command line. It is especially useful to\n"
"  fool or trick stupid servers or CGI scripts that rely on that information\n"
"  being available or contain certain data.\n"
"\n"
"  Example:\n"
"\n"
"	urlget -e www.coolsite.com http://www.showme.com/\n"
"\n"
"BUGS\n"
"  Nope. :-) But don't try excessive string lengths, we don't do many boundary\n"
"  checks so those will without doubt crash this.\n"
"\n"
"VERSION\n"
"  This document attempts to describe the usage of urlget 3.10.\n"
"  Written by Daniel Stenberg 1998-02-04.\n"
"\n"
"AUTHORS\n"
"  Daniel Stenberg <Daniel.Stenberg@sth.frontec.se>\n"
"  Rafael Sagula <sagula@inf.ufrgs.br>\n"
"  Bjorn Reese <breese@imada.ou.dk>\n"
"  Johan Anderson <johan@homemail.com>\n"
"  Kjell Ericson <Kjell.Ericson@sth.frontec.se>\n"
"    \n"
"HOMEPAGE\n"
"  http://www.inf.ufrgs.br/~sagula/urlget.html\n"
 ) ; 
}
