/* 
 * FILE:
 * SplitLedger.h 
 *
 * FUNCTION:
 * Definitions for a number of functions that interface 
 * between the transaction engine, and the register GUI.
 *
 * The xaccGetCurrentSplit() method returns the split at which 
 *    the cursor is curently located.
 *
 * The xaccSRLoadRegEntry() method will copy data from the indicated
 *    split to the table cursor; i.e. to the current table 
 *    register entry.  It does not refresh the GUI afte the
 *    copy.
 *
 * The xaccSRLoadRegister() subroutine will copy transaction
 *    information from a list of splits to the rows of the
 *    register GUI.  The third argument, default_source_acc,
 *    will be used to initialize the source account of a new,
 *    blank split appended to the tail end of the register.
 *    This "blank split" is the place where the user can 
 *    edit info to create new tranasactions.
 *
 * The xaccSRSaveRegEntry() method will copy the contents 
 *    from the cursor to a split.  The split/transaction
 *    that is updated is the one associated with the current 
 *    cursor (register entry) position.
 *
 * The xaccSRRedrawRegEntry() method should be called soon 
 *    after the xaccSRSaveRegEntry() method.  It checks the 
 *    change flag for the current entry/split, and if it
 *    has been modified, it causes a redraw of any register
 *    window that could be affected.  That is, it causes 
 *    a rdraw of any window showing this split, or any other
 *    split that belongs to this same tansaction.
 */

#ifndef __XACC_SPLIT_LEDGER_H__
#define __XACC_SPLIT_LEDGER_H__

#include "Group.h"
#include "splitreg.h"
#include "Transaction.h"

Split * xaccSRGetCurrentSplit (SplitRegister *reg);
void    xaccSRLoadRegEntry (SplitRegister *reg, Split *split);
void    xaccSRLoadRegister (SplitRegister *reg, Split **slist,
                          Account *default_source_acc);

void    xaccSRSaveRegEntry (SplitRegister *reg);
void    xaccSRRedrawRegEntry (SplitRegister *reg);

void    xaccLoadXferCell (ComboCell *cell, AccountGroup *grp, Account *base_acc);

#endif /* __XACC_SPLIT_LEDGER_H__ */
