/* $Id: tty_lynx.i,v 1.1 1995/02/26 14:51:23 me Exp $ */
/*
 * Tty manipulation routines for MACH systems.
 *
 * Author: Stephen Dahmen
 * Date: May 10th, 1994.
 * Description: Various routines for tweaking ttys on LYNX 2.2 machines.
 *
 * Revision History:
 *
 * $Log: tty_lynx.i,v $
# Revision 1.1  1995/02/26  14:51:23  me
# LYNX stuff by SMD
#
 */

/* Mandatory */
#ifndef _TTY_INCLUDED
#define _TTY_INCLUDED
#endif

#ifndef _TTY_LYNX_INCLUDED
#define _TTY_LYNX_INCLUDED

/* lynx is bsd based */
#include <ttychars.h>

#include "sysdep/tty_bsd.i"
#include "sysdep/tty_posix.i"
/* Include the posix stuff */

Local void
tty_set_nonblocking(w, fd)
TermWidget w;
int fd;
{
     /* Generic bsd does what we want - just inherit it */
     bsd_tty_set_nonblocking(w, fd);
}

/*
 * Search for an available pty, putting descriptor in passed "descr" and
 * returning name, if found. Since we're only called once (better be), it's
 * OK to stick this name in static storage.
 *
 * Provided that the #defines for PTY_ITERATION/PTYCHAR1/.. are done
 * properly for your system in os.h, this should be reasonably system
 * independent, meaning you may be able to just grab this intact for your
 * system. It is system dependent nonetheless, so it goes in this file
 * rather than tty.c.
 *
 * The process code is expected to take care of the hairy mode/process
 * group/controlling tty/etc. setup stuff later when the child is forked
 * off, so we don't do it now.
 *
 */
Export String
tty_find_pty(w)
TermWidget w;
{
     /* Generic unix pty finding code works for us */
     return(unix_tty_find_pty(w));
}

/* Set a new tty size */
Export void
tty_set_size(w, rows, cols, width, height)
TermWidget w;
int rows, cols, width, height;
{
     /* Generic bsd does what we want */
     bsd_tty_set_size(w, rows, cols, width, height);
}

/* Add a utmp/wtmp entry for a tty */
Export void tty_add_utmp(w)
TermWidget w;
{
     /* Generic POSIX does what we want */
     bsd_tty_add_utmp(w);
}

/* Remove a utmp/wtmp entry for a tty */
Export void tty_remove_utmp(w)
TermWidget w;
{
     /* Generic POSIX does what we want */
     bsd_tty_remove_utmp(w);
}

/*
 * These next three routines complement eachother by getting and setting
 * some number of tty values using a private (and probably machine dependent)
 * format. It is up to the implementor of these routines to devise some
 * suitable data structure for getting, setting and properly storing said
 * values for their particular operating system. The term widget will
 * encode these values as "generic" and leave it to the implementor to keep
 * them straight.
 *
 */

/* Get the current settings for tty */
Export Generic
tty_get_values(w)
TermWidget w;
{
     /* POSIX code does what we want */
     return posix_tty_get_values(w);
}

/* Must return some "sane" set of hardwired values */
Export Generic
tty_get_sane(w)
TermWidget w;
{
     /* POSIX code does what we want */
     return posix_tty_get_sane(w);
}

/* Whap some settings onto the tty */
Export void
tty_set_values(w, val)
TermWidget w;
Generic val;
{
     /* POSIX code does what we want */
     posix_tty_set_values(w, val);
}

#endif	/* _TTY_MACH_INCLUDE */
