/*

This little piece of code tells you how many colors are available
in your default colormap, it is not very clever, but it is useful :

*/

#include <stdio.h>
#include <X11/Xlib.h>

main (argc,argv)
int  argc;
char *argv[];
{
    Display	*dpy;
    int		scrn;
    Colormap	cmap;
    XColor	color,color2;
    Status	status;
    int		i,j,n,pixel;
    int		pixels[256];
    float	dr,dg,db;
    float	red,green,blue;

    dpy  = XOpenDisplay    (NULL);
    if (dpy == (Display*) 0) {
        fprintf (stderr, "Can't open display.\n");
        exit (1);
    }
    scrn = DefaultScreen   (dpy);
    cmap = DefaultColormap (dpy, scrn);

    /* if user specified a color to fill it with, parse it here */
    if (argc > 1) {
	if (! XParseColor(dpy, cmap, *++argv, &color)) {
	   fprintf(stderr,"Color not found: %s\n",*argv);
	   exit(1);
	}
	if (argc > 2) {
	    if (! XParseColor(dpy, cmap, *++argv, &color2)) {
		fprintf(stderr,"Color not found: %s\n",*argv);
		exit(1);
	    }
	    /* save the rgb values so we can preset the cells to black */
	    red = color.red;
	    green = color.green;
	    blue = color.blue;
	    color.red = color.green = color.blue = 0;
	}
    }

    color.flags = color2.flags = (DoRed | DoGreen | DoBlue);

    for (i = 0; i < 256; i++) {
	/* if user didn't specify a color, get the next grey value */
	if (argc <= 1) {
	    color.red   = (256 * i + 123) % 65535;
	    color.green = (256 * i + 234) % 65535;
	    color.blue  = (256 * i + 456) % 65535;
	}
	if (! XAllocColorCells (dpy, cmap, False, 0, 0, &pixel, 1))
		break;
	pixels[i] = pixel;
	color.pixel = pixel;
	if (argc <= 2)
		XStoreColor(dpy, cmap, color);
    }
    printf ("%d color cells are free\n", i);
    if (argc <= 2)
	exit(0);

    /* user wants a blending from the first color to the second, calculate delta rgb's */
    dr = ((float)color2.red - red)/(float)(i-1);
    dg = ((float)color2.green - green)/(float)(i-1);
    db = ((float)color2.blue - blue)/(float)(i-1);
    /* start after the first color we allocated (that one has the correct color) */
    for (j=1; j<i; j++) {
	color.pixel = pixels[j];
	red   += dr;
	green += dg;
	blue  += db;
	color.red = (unsigned int) (red+0.5);
	color.green = (unsigned int) (green+0.5);
	color.blue = (unsigned int) (blue+0.5);
	XStoreColor(dpy, cmap, color);
    }
    XFlush(dpy);
    exit(0);
}
