/*static char         sccsid[] = "@(#)%E% P.Hoad@ee.surrey.ac.uk %I% %M%";*/
/*
 * Copyright (C) 1992, 1993, 1994, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include "XmgfMalloc.h"

#include "XmgfStruct.h"
#include <X11/StringDefs.h>
#include <Xm/Scale.h>
#include <Xm/ToggleB.h>
#include <Xm/FileSB.h>

#include "XmgfDefines.h"
#include "callbacks.h"
#include "GUI.h"
#include "InitX.h"
#include "Init.h"
#include "Parse.h"
#include "Menus.h"
#include "Read3DSet.h"
#include "3Droutines.h"
#include "BackDrop.h"
#include "XmError.h"
#include "Pixmaps.h"
#include "XmgfGlobal.h"
#include "Printer.h"
#include "MotifUtils.h"
#include "Animator.h"
#include "XmgfFont.h"



#define DEF_SCALE 8.0
int                 default_scale = DEF_SCALE;

#ifndef _NO_PROTO
Boolean             NewRotate(void);
void                DumpScreenImage(void);
void                DrawHighLights(void);
void                XmgfPtSizeChange(void);

#else
Boolean             NewRotate();
void                DumpScreenImage();
void                DrawHighLights();
void                XmgfPtSizeChange();

#endif

static int          Anrunning = 0;

/*static int AnPid = 0;*/
static XtWorkProcId AnPid = 0;


/*#define MENU_UPD 1*/


Pixmap SafeScreen;
int SafeScreenOn=0;


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
TouchScaleCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  Touchit();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
Touchit()
{
  Arg                 args[3];

  SetIconToggles();
  XmScaleGetValue(OX, &Ox);
  XmScaleGetValue(OY, &Oy);
  XmScaleGetValue(OZ, &Oz);
  XtVaGetValues(w_Theta, XtNvalue, &Theta, NULL);
  XtVaGetValues(w_Phi, XtNvalue, &Phi, NULL);
  XtVaGetValues(w_Gamma, XtNvalue, &Gamma, NULL);
  if (!OrthoGraphicProj) {
    XtSetArg(args[0], XmNsensitive, TRUE);
    XtSetValues(DistScal, args, 1);
    XmScaleGetValue(DistScal, &DistSC);
  } else {
    XtSetArg(args[0], XmNsensitive, FALSE);
    XtSetValues(DistScal, args, 1);
  }

  XmScaleGetValue(ImgScale, &ScaleNumber);
  Scale_factor = LogScale(ScaleNumber);
  MakeTwoDim();
/*  UpdateRotationParms();*/
  SetScale();
  switch (RotateGuide) {
   case 0:
    Redraw();
    break;
   case 1:
    QuickRedraw();
    break;
  }
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ReleaseRheoCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  Arg                 args[3];

  XmScaleGetValue(OX, &Ox);
  XmScaleGetValue(OY, &Oy);
  XmScaleGetValue(OZ, &Oz);
  XtVaGetValues(w_Theta, XtNvalue, &Theta, NULL);
  XtVaGetValues(w_Phi, XtNvalue, &Phi, NULL);
  XtVaGetValues(w_Gamma, XtNvalue, &Gamma, NULL);
  if (!OrthoGraphicProj) {
    XtSetArg(args[0], XmNsensitive, TRUE);
    XtSetValues(DistScal, args, 1);
    XmScaleGetValue(DistScal, &DistSC);
  } else {
    XtSetArg(args[0], XmNsensitive, FALSE);
    XtSetValues(DistScal, args, 1);
  }
  XmScaleGetValue(ImgScale, &ScaleNumber);
  Scale_factor = LogScale(ScaleNumber);
  MakeTwoDim();
/*  UpdateRotationParms();*/
  SetScale();
  Redraw();
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
PointSizeCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  XmScaleGetValue(PtSizeScal, &DefaultPointSize);
  XmgfPtSizeChange();
  UpDateVisible();
  Redraw();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
AxisSizeCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  XmScaleGetValue(AxisSizeScal, &DefaultAxisSize);
  Redraw();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Draw A Highlighted polygon                                    */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
DrawHighLights()
{
  if (HighLightedPoly != NULL) {
    if (SizeLL(HighLightedPoly) > 0)
      DrawSingleItem(HighLightedPoly);
  }
  return;
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
AnimSpeedCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  XmScaleGetValue(AnimSpeedScal, &DefaultAnimSpeed);
}



/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ARSizeCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  XmScaleGetValue(ARThetaScal, &DefaultARThetaStep);
  XmScaleGetValue(ARPhiScal, &DefaultARPhiStep);
  XmScaleGetValue(ARGammaScal, &DefaultARGammaStep);
  if (ARScale > 0) {
    if (DefaultARThetaStep != 0)
      ARThetaStep = DefaultARThetaStep / ARScale;
    else
      ARThetaStep = 0;
    if (DefaultARPhiStep != 0)
      ARPhiStep = DefaultARPhiStep / ARScale;
    else
      ARPhiStep = 0;
    if (DefaultARGammaStep != 0)
      ARGammaStep = DefaultARGammaStep / ARScale;
    else
      ARGammaStep = 0;
  } else {
    ARThetaStep = 0;
    ARPhiStep = 0;
    ARGammaStep = 0;
  }
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SetScale()
{
  Arg                 args[3];

#ifdef DEBUG
  fprintf(stderr,"Ox Oy Oz %d %d %d\n",Ox,Oy,Oz);
#endif
  XmScaleSetValue(OX, Ox);
  XmScaleSetValue(OY, Oy);
  XmScaleSetValue(OZ, Oz);
  XtVaSetValues(w_Theta, XtNvalue, Theta, NULL);
  XtVaSetValues(w_Phi, XtNvalue, Phi, NULL);
  XtVaSetValues(w_Gamma, XtNvalue, Gamma, NULL);
  if (!OrthoGraphicProj) {
    XtSetArg(args[0], XmNsensitive, TRUE);
    XtSetValues(DistScal, args, 1);
    XmScaleSetValue(DistScal, DistSC);
  } else {
    XtSetArg(args[0], XmNsensitive, FALSE);
    XtSetValues(DistScal, args, 1);
  }

  XmScaleSetValue(ImgScale, ScaleNumber);
  ChangeThetaLab(w_Theta, (caddr_t) 0, (caddr_t) 0);
  ChangePhiLab(w_Phi, (caddr_t) 0, (caddr_t) 0);
  ChangeGammaLab(w_Gamma, (caddr_t) 0, (caddr_t) 0);
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ResetScale()
{
  Ox = defOX;
  Oy = defOY;
  Oz = defOZ;
  Theta = defTheta;
  Phi = defPhi;
  Gamma = defGamma;
  DistSC = defscal;
  ScaleNumber = defScale_factor;
  if (viewtype == 1) {
    ScaleNumber = defScale_factor / 2;
    Midx = DrawingAreaWidth / 2;
    Midy = DrawingAreaHeight / 2;
  }
  if (viewtype == 0) {
    ScaleNumber = defScale_factor;
    Midx = DrawingAreaWidth / 2;
    Midy = DrawingAreaHeight / 2;
  }
  Scale_factor = LogScale(ScaleNumber);
  MakeTwoDim();
/*  UpdateRotationParms();*/
  SetScale();
  Redraw();
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ResetScaleNoRedraw()
{
  Ox = defOX;
  Oy = defOY;
  Oz = defOZ;
  Theta = defTheta;
  Phi = defPhi;
  Gamma = defGamma;
  DistSC = defscal;
  ScaleNumber = defScale_factor;
  if (viewtype == 1) {
    ScaleNumber = defScale_factor / 2;
    Midx = DrawingAreaWidth / 2;
    Midy = DrawingAreaHeight / 2;
  }
  if (viewtype == 0) {
    ScaleNumber = defScale_factor;
    Midx = DrawingAreaWidth / 2;
    Midy = DrawingAreaHeight / 2;
  }
  Scale_factor = LogScale(ScaleNumber);
  MakeTwoDim();
/*  UpdateRotationParms();*/
  SetScale();
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
ResetTrans()
{
  XmgfMessage("Reset Translation");
  Ox = defOX;
  Oy = defOY;
  Oz = defOZ;
  SetScale();
  Redraw();
  return 0;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
PresetTrans()
{
  XmgfMessage("Reset Translation");
  Ox = -DrawingAreaWidth / 2;
  Oy = -DrawingAreaHeight / 2;
  Oz = 0;
  DistSC = 400;
  ScaleNumber = 2;
  Scale_factor = LogScale(ScaleNumber);
  MakeTwoDim();
  SetScale();
  Redraw();
  return 0;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
Redraw()
{
  switch (DoubleBuff) {
    case 0:{
      UnDraw();
      SetScale();
      DumpScreenImage();
      REDRAW_SCREEN;
      DrawHighLights();
#ifdef BLIT_EXPOSES
      SaveScreen(w_Orth);
#endif
      break;
    }
   case 1:{
      switch (viewtype) {
       case 0:
	DumpScreenImage();
	REDRAW_SCREEN;
	DrawHighLights();
	SwapBuff(w_Orth, DrawingAreaWidth, DrawingAreaHeight);
#ifdef BLIT_EXPOSES
        SaveScreen(w_Orth);
#endif
	UnDraw();
	break;
       case 1:
	UnDraw();
	DumpScreenImage();
	REDRAW_SCREEN;
	DrawHighLights();
#ifdef BLIT_EXPOSES
        SaveScreen(w_Orth);
#endif
	break;
       case 2:
	UnDraw();
	DumpScreenImage();
	REDRAW_SCREEN;
	DrawHighLights();
#ifdef BLIT_EXPOSES
        SaveScreen(w_Orth);
#endif
	break;
      }
      break;
    }
  }
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
QuickRedraw()
{
  switch (DoubleBuff) {
    case 0:{
      UnDraw();
      SetScale();
      DumpScreenImage();
      QuickReDraw();
      break;
    }
   case 1:{
      switch (viewtype) {
       case 0:
	DumpScreenImage();
	QuickReDraw();
	SwapBuff(w_Orth, DrawingAreaWidth, DrawingAreaHeight);
	UnDraw();
	break;
       case 1:
	UnDraw();
	DumpScreenImage();
	QuickReDraw();
	break;
       case 2:
	UnDraw();
	DumpScreenImage();
	QuickReDraw();
	break;
      }
      break;
    }
  }
  return;
}



/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
AutoRotate(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  static int          running = 0;

/*	static int Pid = 0;*/
  static XtWorkProcId Pid = 0;

  AutoRotateFlag = (XmToggleButtonGetState(w) ? 1 : 0);
  if (AutoRotateFlag)
    XmgfMessage("Auto Rotate ON");
  else
    XmgfMessage("Auto Rotate OFF");

  if (AutoRotateFlag) {
    Pid = XtAppAddWorkProc(appContext, (XtWorkProc) NewRotate, NULL);
    running = 1;
  }
  if (!AutoRotateFlag && running) {
    SetScale();
    XtRemoveWorkProc((XtWorkProcId) Pid);
    running = 0;
  }
#ifdef MENU_UPD
  XmToggleButtonSetState(Rotate_Button, AutoRotateFlag, FALSE);
#endif
  SetIconToggles();
}



/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
Boolean
NewRotate()
{
  Theta = Theta + DefaultARThetaStep;
  Phi = Phi + DefaultARPhiStep;
  Gamma = Gamma + DefaultARGammaStep;
  if (Theta >= 360)
    Theta = Theta - 360;
  if (Phi >= 360)
    Phi = Phi - 360;
  if (Gamma >= 360)
    Gamma = Gamma - 360;
  if (Theta < 0)
    Theta = Theta + 360;
  if (Phi < 0)
    Phi = Phi + 360;
  if (Gamma < 0)
    Gamma = Gamma + 360;
  UpdateRotationParms();
  Redraw();
  return 0;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
OldSetLine(width)
int                 width;
{
#ifdef DEBUG
  fprintf(stderr, "Line Width =  %d\n", width);
#endif
  XSetLineAttributes(theDisplay, theGC, width, LineSolid, CapRound, JoinRound);
  return 0;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SetLine(width, linestyle)
int                 width;
int                 linestyle;
{
  static int          last_style = LineSolid;
  static int          last_width = 1;

  int                 newlinestyle;

#ifdef DEBUG
  fprintf(stderr, "Line Width =  %d %d\n", width, style);
#endif
  if ((last_style == linestyle) && (last_width == width))
    return;
  else {
    last_style = linestyle;
    last_width = width;
  }

  switch (linestyle) {
   case SOLIDLS:
    newlinestyle = LineSolid;
    break;
   case DOTLS:
    newlinestyle = LineOnOffDash;
    break;
   case DASHLS:
    newlinestyle = LineDoubleDash;
    break;
   default:
    newlinestyle = LineSolid;
    break;
  }
  XSetLineAttributes(theDisplay, theGC, width, newlinestyle, CapRound, JoinRound);
  return;
}




/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
LineAttrCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  t_XmgfSet          *SelectedSet;
  t_XmgfLine         *SelectedLine;
  t_XmgfObject       *SelectedObject;
  t_XmgfPoly         *Poly;
  char               *MessageString;

  int                 width = (int) client_data;

  MessageString = XmgfMalloc(100 * sizeof(char));
  assert(MessageString);
  sprintf(MessageString, "Line Width = %d ", width);
  SetXmgfMessage(MessageString);
  XmgfFree(MessageString);


  DefaultLineWidth = width;
  ForeachLL_M(gfSets.ListXmgfSets, SelectedSet) {
    ForeachLL_M(SelectedSet->ListXmgfLines, SelectedLine) {
      ForeachLL_M(SelectedLine->ListXmgfObjects, SelectedObject) {
	ForeachLL_M(SelectedObject->ListXmgfPolys, Poly) {
	  Poly->LineWidth = width;
	}
      }
    }
  }
  UpDateVisible();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
LineSAttrCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  t_XmgfSet          *SelectedSet;
  t_XmgfLine         *SelectedLine;
  t_XmgfObject       *SelectedObject;
  t_XmgfPoly         *Poly;
  char               *MessageString;

  int                 style = (int) client_data;

  MessageString = XmgfMalloc(100 * sizeof(char));
  assert(MessageString);
  sprintf(MessageString, "Line Style = %d ", style);
  SetXmgfMessage(MessageString);
  XmgfFree(MessageString);

  ForeachLL_M(gfSets.ListXmgfSets, SelectedSet) {
    ForeachLL_M(SelectedSet->ListXmgfLines, SelectedLine) {
      ForeachLL_M(SelectedLine->ListXmgfObjects, SelectedObject) {
	ForeachLL_M(SelectedObject->ListXmgfPolys, Poly) {
	  Poly->LineStyle = style;
	}
      }
    }
  }
  UpDateVisible();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
PointAttrCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  t_XmgfSet          *SelectedSet;
  t_XmgfLine         *SelectedLine;
  t_XmgfObject       *SelectedObject;
  t_XmgfPoly         *Poly;

  int                 Pttype = (int) client_data;

  ForeachLL_M(gfSets.ListXmgfSets, SelectedSet) {
    ForeachLL_M(SelectedSet->ListXmgfLines, SelectedLine) {
      ForeachLL_M(SelectedLine->ListXmgfObjects, SelectedObject) {
	ForeachLL_M(SelectedObject->ListXmgfPolys, Poly) {
	  Poly->PtType = Pttype;
	}
      }
    }
  }
  UpDateVisible();
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
PolyAttrCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  t_XmgfSet          *SelectedSet;
  t_XmgfLine         *SelectedLine;
  t_XmgfObject       *SelectedObject;
  t_XmgfPoly         *Poly;
  int                 NewFillStyle;

  int                 FillStyle = (int) client_data;

  DefaultFillStyle = FillStyle;
  NewFillStyle = FillStyle;
  switch (FillStyle) {
   case SHADED_FILL:
    SelectColours = 0;
    NewFillStyle = FILLEDCOLOR;
    break;
   case SHADED_LINES:
    SelectColours = 0;
    NewFillStyle = NOTFILLED;
    break;
   case FILLEDCOLOR:
    SelectColours = 1;
    NewFillStyle = FILLEDCOLOR;
    break;
   case NOTFILLED:
    SelectColours = 1;
    NewFillStyle = NOTFILLED;
    break;
  }
  ForeachLL_M(gfSets.ListXmgfSets, SelectedSet) {
    ForeachLL_M(SelectedSet->ListXmgfLines, SelectedLine) {
      ForeachLL_M(SelectedLine->ListXmgfObjects, SelectedObject) {
	ForeachLL_M(SelectedObject->ListXmgfPolys, Poly) {
	  Poly->FillStyle = NewFillStyle;
	}
      }
    }
  }
  UpDateVisible();
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ItemNumCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  int                 Pttype = (int) client_data;

  char               *MessageString;

  MessageString = XmgfMalloc(100 * sizeof(char));
  assert(MessageString);
  sprintf(MessageString, "Fill Type -%d", Pttype);
  SetXmgfMessage(MessageString);
  XmgfFree(MessageString);

#ifdef DEBUG
  fprintf(stderr, "Fill Type -%d\n", Pttype);
#endif
  FillPolys = Pttype;
  Redraw();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
HighLightColourCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  int                 Pttype = (int) client_data;

#ifdef DEBUG
  fprintf(stderr, "Fill Type -%d\n", Pttype);
#endif
  FillPolys = Pttype;
  Redraw();
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
BackFaceCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  BackFace = (XmToggleButtonGetState(w) ? 1 : 0);

  if (BackFace)
    XmgfMessage("Backface Culling ON");
  else
    XmgfMessage("Backface Culling OFF");

#ifdef DEBUG
  fprintf(stderr, "Backface Culling %d\n", BackFace);
#endif
#ifdef MENU_UPD
  XmToggleButtonSetState(BackCull, BackFace, FALSE);
#endif
  SetIconToggles();
  Redraw();
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
AxisTypeCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  char               *MessageString;

  AxisType = (int) client_data;

  MessageString = XmgfMalloc(100 * sizeof(char));
  assert(MessageString);
  sprintf(MessageString, "Axis Type %d", AxisType);
  SetXmgfMessage(MessageString);
  XmgfFree(MessageString);

}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
BackGrdCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  int                 BackGrdType = (int) client_data;
  Pixel               fg, bg;

#ifdef DEBUG
  fprintf(stderr, "Fill Type -%d\n", BackGrdType);
#endif
  switch (BackGrdType) {
   case BACK_GRD_COL:
    XmgfMessage("Background Colour");
    CreateColorPall(toplevel, BACK_COLOUR);
    BackDropImage = 0;
    break;
   case BACK_GRD_IMG:
    XmgfMessage("Background Image");
    XmFileSelect("Load PGM File", LOAD_IMG_FILE, IMGFIL, "In.pgm*", IMGDIR);
    break;
   case DEF_GRD_IMG:
    XmgfMessage("Default Background");
    fg = colorpixels[DEFAULTCOL];
    bg = colorpixels[DEFAULTCOL];
    BackGroundColour = DEFAULTCOL;
    XtVaSetValues(Orthdr, XmNbackground, bg, NULL);
    XtVaSetValues(Orthdr, XmNforeground, fg, NULL);
    BackDropImage = 0;
    Redraw();
    break;

  }
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
OutLineColCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  XmgfMessage("Select Outline Colour");
  CreateColorPall(toplevel, OUTL_COLOUR);
  Redraw();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
HaloColCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  XmgfMessage("Select Haloed Colour");
  CreateColorPall(toplevel, HALO_COLOUR);
  Redraw();
}
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
StereoCOlCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  switch((int)client_data){
  case LEFTEYE: {
		XmgfMessage("Select Left Eye Colour");
		CreateColorPall(toplevel, LEFTEYECOL);break;
		}
  case RIGHTEYE: {
		XmgfMessage("Select Left Right Colour");
		CreateColorPall(toplevel, RIGHTEYECOL);break;
		}
  }
}
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
RedBlueCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  XmgfMessage("Dual Colour Stereo");
  RedBlue = (XmToggleButtonGetState(w) ? 1 : 0);

  if (RedBlue)
    XmgfMessage("Dual Colour Stereo ON");
  else
    XmgfMessage("Dual Colour Stereo OFF");

  Redraw();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SelColorCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  SelectColours = (XmToggleButtonGetState(w) ? 1 : 0);
#ifdef DEBUG
  fprintf(stderr, "Colour Selection %d\n", SelectColours);
#endif

  SetIconToggles();
  Redraw();
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
FixateTButtCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  Arg                 args[1];

  FixateType = (XmToggleButtonGetState(w) ? 1 : 0);
  if (FixateType) {
    XmgfMessage("Fixate on Centroid");
    XtSetArg(args[0], XmNlabelString, Str2MotStr(" Fixate on Centroid"));
    XtSetValues(w, args, 1);
  } else {
    XmgfMessage("Fixate on Centre");
    XtSetArg(args[0], XmNlabelString, Str2MotStr(" Fixate on Centre"));
    XtSetValues(w, args, 1);
  }
  InitViewScale();
  SetIconToggles();
  Redraw();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
AutoSTButtCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  Arg                 args[1];

  ScaleObectType = (XmToggleButtonGetState(w) ? 1 : 0);
  if (ScaleObectType) {
    XmgfMessage("AutoScale on All");
    XtSetArg(args[0], XmNlabelString, Str2MotStr(" AutoScale on All"));
    XtSetValues(w, args, 1);
  } else {
    XmgfMessage("AutoScale on Visible");
    XtSetArg(args[0], XmNlabelString, Str2MotStr(" AutoScale on Visible"));
    XtSetValues(w, args, 1);
  }
  SetIconToggles();
  Redraw();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
AxisCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  Axis = (XmToggleButtonGetState(w) ? 1 : 0);

#ifdef DEBUG
  fprintf(stderr, "Axis Toggle State %d\n", Axis);
#endif
  if (Axis)
    XmgfMessage("Axis ON");
  else
    XmgfMessage("Axis OFF");
#ifdef MENU_UPD
  XmToggleButtonSetState(DrawAxisLabel, Axis, FALSE);
#endif
  SetIconToggles();
  Redraw();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
DoubleBCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  DoubleBuff = (XmToggleButtonGetState(w) ? 1 : 0);
  if (DoubleBuff)
    XmgfMessage("Double Buffering ON");
  else
    XmgfMessage("Double Buffering OFF");
#ifdef MENU_UPD
  XmToggleButtonSetState(DoubleBuffer, DoubleBuff, FALSE);
#endif
  SetIconToggles();
  Redraw();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
OutLineCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  OutLine = (XmToggleButtonGetState(w) ? 1 : 0);
  if (OutLine)
    XmgfMessage("Out Line ON");
  else
    XmgfMessage("Out Line  OFF");
#ifdef MENU_UPD
  XmToggleButtonSetState(OutLineBu, OutLine, FALSE);
#endif
  SetIconToggles();
  Redraw();
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
DitherCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  DitherFill = (XmToggleButtonGetState(w) ? 1 : 0);
  if (DitherFill) {
    XmgfMessage("Dither ON");
    XSetFillStyle(theDisplay, theGC, FillOpaqueStippled);
  } else {
    XmgfMessage("Dither  OFF");
    XSetFillStyle(theDisplay, theGC, FillSolid);
  }
#ifdef MENU_UPD
  XmToggleButtonSetState(ColDither, DitherFill, FALSE);
#endif
  SetIconToggles();
  Redraw();
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
AxisLABCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  AxisLabel = (XmToggleButtonGetState(w) ? 1 : 0);
  Axis = AxisLabel;
  if (AxisLabel)
    XmgfMessage("Axis ON");
  else
    XmgfMessage("Axis OFF");
#ifdef DEBUG
  fprintf(stderr, "Axis+Label Toggle State %d\n", AxisLabel);
#endif
#ifdef MENU_UPD
  XmToggleButtonSetState(DrawAxisLabel, Axis, FALSE);
#endif
  SetIconToggles();
  Redraw();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SelPointsCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  SelectPoints = (XmToggleButtonGetState(w) ? 1 : 0);
#ifdef DEBUG
  fprintf(stderr, "Point Selection %d\n", SelectPoints);
#endif
  SetIconToggles();
  Redraw();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
DepthCueCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  DepthCueing = (XmToggleButtonGetState(w) ? 1 : 0);
  if (DepthCueing)
    XmgfMessage("Depth Cueing ON");
  else
    XmgfMessage("Depth Cueing OFF");
#ifdef DEBUG
  XmToggleButtonSetState(DepthCue, DepthCueing, FALSE);
#endif
  SetIconToggles();
  Redraw();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
PointCueCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  PointCueing = (XmToggleButtonGetState(w) ? 1 : 0);
  if (PointCueing)
    XmgfMessage("Point Cueing ON");
  else
    XmgfMessage("Point Cueing OFF");
#ifdef DEBUG
  XmToggleButtonSetState(PointCue, PointCueing, FALSE);
#endif
  SetIconToggles();
  Redraw();
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
RotateBBCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  RotateGuide = (XmToggleButtonGetState(w) ? 1 : 0);
  if (RotateGuide)
    XmgfMessage("Rotation Guide ON");
  else
    XmgfMessage("Rotation Guide OFF");
#ifdef MENU_UPD
  XmToggleButtonSetState(RotBB, RotateGuide, FALSE);
#endif
  SetIconToggles();
  Redraw();
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SelLabelsCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  SelectLabels = (XmToggleButtonGetState(w) ? 1 : 0);
  if (SelectLabels)
    XmgfMessage("Text Labels Visible");
  else
    XmgfMessage("Text Labels Removed");
#ifdef DEBUG
  fprintf(stderr, "Point Selection %d\n", SelectLabels);
#endif
#ifdef MENU_UPD
  XmToggleButtonSetState(SelLabels, SelectLabels, FALSE);
#endif
  SetIconToggles();
  Redraw();
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
OrthoGraphicCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  static              OldDistSC = 400;

  OrthoGraphicProj = (XmToggleButtonGetState(w) ? 1 : 0);
  if (OrthoGraphicProj) {
    XmgfMessage("OrthoGraphic Projection");
    OldDistSC = DistSC;
    DistSC = 100000;
  } else {
    XmgfMessage("Perspective Projection");
    DistSC = OldDistSC;
  }
  UpdateRotationParms();
  SetScale();
#ifdef MENU_UPD
  XmToggleButtonSetState(OrthOPro, OrthoGraphicProj, FALSE);
#endif
  SetIconToggles();
  Redraw();

}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SetOriginCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  OriginClean();
  Origin = (XmToggleButtonGetState(OriginButt) ? 1 : 0);
  if (Origin)
    XmgfMessage("Origin ON");
  else
    XmgfMessage("Origin OFF");
#ifdef DEBUG
  fprintf(stderr, "Origin On %d\n", Origin);
#endif
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SelExpandCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{

  XmgfMessage("Expand Image");
  ExpandImage = (XmToggleButtonGetState(w) ? 1 : 0);
  if (BackDropImage != 1) {
    XmErr(NO_IMAGE_PRESENT);
    return;
  }
  if (BackDropImage == 1) {
    if (ExpandImage)
      ScaleNumber = ScaleNumber + 1;
    else
      ScaleNumber = ScaleNumber - 1;
    Scale_factor = LogScale(ScaleNumber);
  }
  MakeTwoDim();
#ifdef MENU_UPD
  XmToggleButtonSetState(SelExpand, ExpandImage, FALSE);
#endif
  SetIconToggles();
  SetScale();
  Redraw();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SortCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  Sorting = (XmToggleButtonGetState(w) ? 1 : 0);
  if (Sorting)
    XmgfMessage("Sorting of Polygons ON");
  else
    XmgfMessage("Sorting of Polygons OFF");
#ifdef DEBUG
  fprintf(stderr, "Axis Toggle State %d\n", Sorting);
#endif
#ifdef MENU_UPD
  XmToggleButtonSetState(SortPolyButt, Sorting, FALSE);
#endif
  SetIconToggles();
  Redraw();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
Set2DCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  TwoDimSettings = (XmToggleButtonGetState(w) ? 1 : 0);
  if (TwoDimSettings)
    XmgfMessage("2D Settings ON : Coordinates in Data Mode");
  else
    XmgfMessage("2D Settings OFF: Coordinates in Screen Mode");

  Gamma = 180;
  MakeTwoDim();
/*  UpdateRotationParms();*/
  SetScale();
#ifdef MENU_UPD
  XmToggleButtonSetState(Set2DButt, TwoDimSettings, FALSE);
#endif
  SetIconToggles();
  Redraw();
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
QuitCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
#ifdef DEBUG_SUN
  ieee_retrospective_();
#endif
  exit(0);
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
NoneCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  XmgfMessage("Invalid Operation");
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ConButtCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  XtManageChild(ControlShellDia);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SetCButtCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  XtManageChild(SetControlShellDia);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
IconCButtCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  XtManageChild(IconShellDia);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
AboutCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  CreateAboutPanel();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
PrintCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  CreatePrintPanel();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
LoadCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  XmgfMessage("Load GF Set");
  XmFileSelect("Load GF File", LOAD_GF_FILE, GFFIL, "Out.gf", GFDIR);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ReReadCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  ReLoad();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
AnimationCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  CreateAnimPal(toplevel);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
PlayCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  FlagPlay = 1;
  if (Anrunning != 1) {
    AnPid = XtAppAddWorkProc(appContext, (XtWorkProc) PlaySingleFrame, NULL);
    Anrunning = 1;
  } else {
    XtRemoveWorkProc((XtWorkProcId) AnPid);
    Anrunning = 0;
  }
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
RecordCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  RecordFrame();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
AutoRevCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  FlagAutoRev  = (XmToggleButtonGetState(w) ? 1 : 0);
  if (FlagAutoRev)
    XmgfMessage("Auto Reverse Turned ON");
  else
    XmgfMessage("Auto Reverse Turned OFF");
	 
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
NewAnimCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  KillAnimation();
  NewAnimation();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
FForwardCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  FlagForward = 1;
  FlagRewind = 0;
  FlagPlay = 1;
  FlagStop = 0;
}
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
FRewindCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  FlagForward = 0;
  FlagRewind = 1;
  FlagPlay = 1;
  FlagStop = 0;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ReverseCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  FlagPlay = 1;
  FlagRewind = 2;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
StopCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  FlagForward = 0;
  FlagRewind = 0;
  FlagPlay = 0;
  FlagStop = 1;
  if (Anrunning)
    XtRemoveWorkProc((XtWorkProcId) AnPid);
  Anrunning = 0;

}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
PauseCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  if (FlagPause)
    FlagPause = 0;
  else
    FlagPause = 1;
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
LoadAniCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  XmFileSelect("Load Animation File", LOAD_ANIM_FILE, ANIMFIL, "Out.ani", ANIMDIR);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SaveAniCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  XmFileSelect("Save Animation File", SAVE_ANIM_FILE, ANIMFIL, "Out.ani", ANIMDIR);
}





/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
LoadCMapCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  XmgfMessage("Load Colour Map");
  XmFileSelect("Load Colour Map File", LOAD_CMAP_FILE, CMAPFIL, "Out.cmap", CMAPDIR);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
LoadGMapCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  XmgfMessage("Load Grey Map");
  XmFileSelect("Load Grey Map File", LOAD_GMAP_FILE, CMAPFIL, "Out.cmap", CMAPDIR
    );
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ImportCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  char               *Message;
  int                 ImportType = (int) client_data;

  Message = (char *) XmgfMalloc(100 * sizeof(char));

  switch (ImportType) {
   case IMPORT_OFF_FILE:
    XmgfMessage("Import OFF CAD File");
    strcpy(Message, "Import OFF CAD File");
    break;
   case IMPORT_NFF_FILE:
    XmgfMessage("Import NFF CAD File");
    strcpy(Message, "Import NFF CAD File");
    break;
   case IMPORT_OBJ_FILE:
    XmgfMessage("Import OBJ CAD File");
    strcpy(Message, "Import OBJ CAD File");
    break;
   case IMPORT_RAY_FILE:
    XmgfMessage("Import RAY CAD File");
    strcpy(Message, "Import RAY CAD File");
    break;
   case IMPORT_SLA_FILE:
    XmgfMessage("Import SLA CAD File");
    strcpy(Message, "Import SLA CAD File");
    break;
  }
  XmFileSelect(Message, ImportType, IMPORTFIL, "Out.gf", IMPORTDIR);
  XmgfFree(Message);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
AppendCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  XmgfMessage("Append GF Set");
  XmFileSelect("Append GF File", APPEND_GF_FILE, GFFIL, "Out.gf", GFDIR);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
AutoScaleCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  AutoScaleCMD();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
AutoScaleCMD()
{
  InitViewScale();
  SetScale();
  Redraw();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
AutoScaleVisibleCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  InitViewScale();
  SetScale();
  Redraw();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ReDrawCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
 /* Uncoment this line if Redraw Draws all sets */
  DrawClear();
  EmptyLL(HighLightedPoly);
  InitViewScale();
  DumpScreenImage();
  DrawAllSets();
  if (DoubleBuff == 1)
    Redraw();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
double
Deg2Rad(Deg)
double              Deg;
{
  return (double) (Deg * 0.017453292);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
double
Rad2Deg(Rad)
double              Rad;
{
  return ((Rad / PI) * 180);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
double
LogScale(sca)
int                 sca;
{
  double              result;

  result = (double) exp((((double) sca) / UserScaleFactor));
  return (result);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
Scale2Log(result)
double              result;
{
  int                 sca;
  sca = (int) UserScaleFactor *log(result);

  return (sca);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ThetaTogCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  Boolean             ThetaOn;
  Arg                 args[3];
  static              OldTheta = 0;

  ThetaOn = (XmToggleButtonGetState(w) ? TRUE : FALSE);
  XtSetArg(args[0], XmNsensitive, !ThetaOn);
  if (ThetaOn) {
    XmScaleGetValue(ARThetaScal, &OldTheta);
    DefaultARThetaStep = 0;
    XmScaleSetValue(ARThetaScal, ARThetaStep * ARScale);
    XtSetValues(ARThetaScal, args, 1);
  } else {
    DefaultARThetaStep = OldTheta;
    XmScaleSetValue(ARThetaScal, ARThetaStep * ARScale);
    XtSetValues(ARThetaScal, args, 1);
  }
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
PhiTogCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  Boolean             PhiOn;
  Arg                 args[3];
  static              OldPhi = 0;

  PhiOn = (XmToggleButtonGetState(w) ? TRUE : FALSE);
  XtSetArg(args[0], XmNsensitive, !PhiOn);
  if (PhiOn) {
    XmScaleGetValue(ARPhiScal, &OldPhi);
    DefaultARPhiStep = 0;
    XmScaleSetValue(ARPhiScal, ARPhiStep * ARScale);
    XtSetValues(ARPhiScal, args, 1);
  } else {
    DefaultARPhiStep = OldPhi;
    XmScaleSetValue(ARPhiScal, ARPhiStep * ARScale);
    XtSetValues(ARPhiScal, args, 1);
  }
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
GammaTogCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  Boolean             GammaOn;
  Arg                 args[3];
  static int          OldGamma = 0;

  GammaOn = (XmToggleButtonGetState(w) ? TRUE : FALSE);
  XtSetArg(args[0], XmNsensitive, !GammaOn);
  if (GammaOn) {
    XmScaleGetValue(ARGammaScal, &OldGamma);
    DefaultARGammaStep = 0;
    XmScaleSetValue(ARGammaScal, ARGammaStep * ARScale);
    XtSetValues(ARGammaScal, args, 1);
  } else {
    DefaultARGammaStep = OldGamma;
    XmScaleSetValue(ARGammaScal, ARGammaStep * ARScale);
    XtSetValues(ARGammaScal, args, 1);
  }
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ARScaleCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  XmScaleGetValue(w, &ARScale);
  if (!(XmToggleButtonGetState(ThetaTog)))
    DefaultARThetaStep = ARThetaStep * ARScale;
  if (!(XmToggleButtonGetState(PhiTog)))
    DefaultARPhiStep = ARPhiStep * ARScale;
  if (!(XmToggleButtonGetState(GammaTog)))
    DefaultARGammaStep = ARGammaStep * ARScale;

 /* Check Size */
  if (DefaultARThetaStep > 30)
    DefaultARThetaStep = 30;
  if (DefaultARThetaStep < -30)
    DefaultARThetaStep = -30;
  if (DefaultARPhiStep > 30)
    DefaultARPhiStep = 30;
  if (DefaultARPhiStep < -30)
    DefaultARPhiStep = -30;
  if (DefaultARGammaStep > 30)
    DefaultARGammaStep = 30;
  if (DefaultARGammaStep < -30)
    DefaultARGammaStep = -30;

  XmScaleSetValue(ARThetaScal, DefaultARThetaStep);
  XmScaleSetValue(ARPhiScal, DefaultARPhiStep);
  XmScaleSetValue(ARGammaScal, DefaultARGammaStep);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
UpDateVisibleCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  UpDateVisible();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
UpdateXYCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  UpdateXY();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
QuitOper(w, event, params, num_params)
Widget              w;
XEvent             *event;
String             *params;
int                *num_params;
{
  exit(0);
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
NearOper(w, event, params, num_params)
Widget              w;
XEvent             *event;
String             *params;
int                *num_params;
{
  ScaleNumber = ScaleNumber / 2;
  Scale_factor = LogScale(ScaleNumber);
  MakeTwoDim();
/*  UpdateRotationParms();*/
  SetScale();
  Redraw();
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
NearCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  ScaleNumber--;
  Scale_factor = LogScale(ScaleNumber);
  MakeTwoDim();
/*  UpdateRotationParms();*/
  SetScale();
  Redraw();
  return;
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
AutoRotateOper(w, event, params, num_params)
Widget              w;
XEvent             *event;
String             *params;
int                *num_params;
{
  AutoRotateFlag = !AutoRotateFlag;
  XmToggleButtonSetState(Rotate_Button, AutoRotateFlag, TRUE);
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
DoubleOper(w, event, params, num_params)
Widget              w;
XEvent             *event;
String             *params;
int                *num_params;
{
  DoubleBuff = !DoubleBuff;
  XmToggleButtonSetState(DoubleBuffer, DoubleBuff, TRUE);
  return;
}



/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
FarOper(w, event, params, num_params)
Widget              w;
XEvent             *event;
String             *params;
int                *num_params;
{
  ScaleNumber = ScaleNumber * 2;
  Scale_factor = LogScale(ScaleNumber);
  MakeTwoDim();
/*  UpdateRotationParms();*/
  SetScale();
  Redraw();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
FarCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  ScaleNumber++;
  Scale_factor = LogScale(ScaleNumber);
  MakeTwoDim();
/*  UpdateRotationParms();*/
  SetScale();
  Redraw();
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
PlusThetaOper(w, event, params, num_params)
Widget              w;
XEvent             *event;
String             *params;
int                *num_params;
{
  Theta = Theta + 5;
  if (Theta >= 360)
    Theta = Theta - 360;
  MakeTwoDim();
/*  UpdateRotationParms();*/
  SetScale();
  Redraw();
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
PlusPhiOper(w, event, params, num_params)
Widget              w;
XEvent             *event;
String             *params;
int                *num_params;
{
  Phi = Phi + 5;
  if (Phi >= 360)
    Phi = Phi - 360;
  MakeTwoDim();
/*  UpdateRotationParms();*/
  SetScale();
  Redraw();
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
PlusGammaOper(w, event, params, num_params)
Widget              w;
XEvent             *event;
String             *params;
int                *num_params;
{
  Gamma = Gamma + 5;
  if (Gamma >= 360)
    Gamma = Gamma - 360;
  MakeTwoDim();
/*  UpdateRotationParms();*/
  SetScale();
  Redraw();
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
MinusThetaOper(w, event, params, num_params)
Widget              w;
XEvent             *event;
String             *params;
int                *num_params;
{
  Theta = Theta - 5;
  if (Theta < 0)
    Theta = Theta + 360;
  MakeTwoDim();
/*  UpdateRotationParms();*/
  SetScale();
  Redraw();
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
MinusPhiOper(w, event, params, num_params)
Widget              w;
XEvent             *event;
String             *params;
int                *num_params;
{
  Phi = Phi - 5;
  if (Phi < 0)
    Phi = Phi + 360;
  MakeTwoDim();
/*  UpdateRotationParms();*/
  SetScale();
  Redraw();
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
MinusGammaOper(w, event, params, num_params)
Widget              w;
XEvent             *event;
String             *params;
int                *num_params;
{
  Gamma = Gamma - 5;
  if (Gamma < 0)
    Gamma = Gamma + 360;
  MakeTwoDim();
/*  UpdateRotationParms();*/
  SetScale();
  Redraw();
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
NoneOper(w, event, params, num_params)
Widget              w;
XEvent             *event;
String             *params;
int                *num_params;
{
  XmgfMessage("Invalid Operation");
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
XmgfMessage(MessBuff)
char               *MessBuff;
{
  char               *MessageString;

  MessageString = (char *) XmgfMalloc(100 * sizeof(char));
  assert(MessageString);
  strcpy(MessageString, MessBuff);
  SetXmgfMessage(MessageString);
  XmgfFree(MessageString);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
DumpScreenImage()
{

  MakeTwoDim();
  if (BackDropImage) {
    if (ImagePix == NULL) {
      ImagePix =
	MakeImage(BackImage, w_Orth, BackDropWidth, BackDropHeight, ExpandImage);
    }
    if (DoubleBuff) {
      if (ImageDraw == NULL) {
	ImageDraw =
	  MakeImage(BackImage, theDrawable, BackDropWidth, BackDropHeight, ExpandImage);
      }
    }
    if (DoubleBuff)
      PlaceImage(ImageDraw, theDrawable,
	theGC, Ox, Oy, BackDropWidth, BackDropHeight);
    else
      PlaceImage(ImagePix, w_Orth, theGC, Ox, Oy, BackDropWidth, BackDropHeight);
  }
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
NewDumpScreenImage()
{

  if (BackDropImage && !DoubleBuff) {
    ImagePix =
    MakeImage(BackImage, w_Orth, OrBackDropWidth, OrBackDropHeight, ExpandImage);
  }
  if (BackDropImage && DoubleBuff) {
    ImageDraw =
      MakeImage(BackImage, theDrawable, OrBackDropWidth, OrBackDropHeight, ExpandImage);
  }
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SetIconTogglesCB(w, client_data, call_data)
Widget              w;
caddr_t             client_data;
caddr_t             call_data;
{
  SetIconToggles();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
XmgfFontChange()
{
  t_XmgfSet          *SelectedSet;
  t_XmgfLine         *SelectedLine;
  t_XmgfObject       *SelectedObject;
  t_XmgfPoly         *Poly;

  ForeachLL_M(gfSets.ListXmgfSets, SelectedSet) {
    ForeachLL_M(SelectedSet->ListXmgfLines, SelectedLine) {
      ForeachLL_M(SelectedLine->ListXmgfObjects, SelectedObject) {
	ForeachLL_M(SelectedObject->ListXmgfPolys, Poly) {
	  Poly->Font = FontFamily;
	  Poly->FontSize = FontSize;
	  Poly->FontWeight = FontWeight;
	  Poly->FontSlant = FontSlant;
	}
      }
    }
  }
  UpDateVisible();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
XmgfPtSizeChange()
{
  t_XmgfSet          *SelectedSet;
  t_XmgfLine         *SelectedLine;
  t_XmgfObject       *SelectedObject;
  t_XmgfPoly         *Poly;

  ForeachLL_M(gfSets.ListXmgfSets, SelectedSet) {
    ForeachLL_M(SelectedSet->ListXmgfLines, SelectedLine) {
      ForeachLL_M(SelectedLine->ListXmgfObjects, SelectedObject) {
	ForeachLL_M(SelectedObject->ListXmgfPolys, Poly) {
	  Poly->PtSize = DefaultPointSize;
	}
      }
    }
  }
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SaveScreen(theWindow)
Window theWindow;
{
	if (!SafeScreenOn) {
		MakeSaveScreen(theWindow);
	}
	if (SafeScreenOn){
	XCopyArea(theDisplay, theWindow, SafeScreen, theGC, 0, 0, 
	 (unsigned int)DrawingAreaWidth, (unsigned int)DrawingAreaHeight, 0, 0);
	}
	return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
RestoreScreen(theWindow)
Window theWindow;
{

	if (SafeScreenOn) {
	XCopyArea(theDisplay, SafeScreen, theWindow, theGC, 0, 0, 
	 (unsigned int)DrawingAreaWidth, (unsigned int)DrawingAreaHeight, 0, 0);
	}
	return;
}
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
RestoreScreenArea(theWindow,x,y,width,height)
Window theWindow;
int x,y;
int width,height;
{

        if (SafeScreenOn) {
        XCopyArea(theDisplay, SafeScreen, theWindow, theGC, x, y,
         (unsigned int)width, (unsigned int)height, x, y);
        }
        return;
}
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
MakeSaveScreen(theWindow)
Window theWindow;
{
	int BackDepth;

	BackDepth = XDefaultDepth(theDisplay, theScreen);

	if(!SafeScreenOn){
	SafeScreen = XCreatePixmap(theDisplay, theWindow, 
		DrawingAreaWidth, DrawingAreaHeight,(unsigned int) BackDepth);
	SafeScreenOn=1;
	}
	return;
}
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
DestroySaveScreen()
{
	XFreePixmap(theDisplay, SafeScreen);
	SafeScreenOn=0;
	return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
XImage *
GrabSaveScreen()
{
	XImage *ximage;
	int format = ZPixmap;

        ximage = XGetImage(theDisplay, SafeScreen, 0, 0,
	(unsigned int) DrawingAreaWidth-3,(unsigned int) DrawingAreaHeight-3, AllPlanes, format);
	return ximage;
}

