static char sccsid[]="@(#)%E% P.Hoad@ee.surrey.ac.uk %I% %M%";
/*
 * Copyright (C) 1992, 1993, 1994, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include <X11/StringDefs.h>
#include <X11/Xlib.h>
#include "XmgfStruct.h"
#include "XmgfGlobal.h"
#include "XmgfDefines.h"
#include "InitX.h"
#include "Polygon.h"
#include "callbacks.h"
#include "Parse.h"
#include "Pixmaps.h"
#include "XmError.h"
#include "XmgfFont.h"

#define FRCTSPERBATCH 1024

#ifndef _NO_PROTO 
void DrawDot(XPoint pt, Window TmpWind);
void DrawBox(XPoint pt, Window TmpWind);
void DrawTri(XPoint pt, Window TmpWind);
void DrawCross(XPoint pt, Window TmpWind);
void DrawCircle(XPoint pt, Window TmpWind);
void DrawPlus(XPoint pt, Window TmpWind);
void DrawFilledB(XPoint pt, Window TmpWind);
void DrawFilledT(XPoint pt, Window TmpWind);
void DrawFilledCircle(XPoint pt, Window TmpWind);
void DrawBitmap(XPoint pt, Window TmpWind);
void MakeOutLine(XPoint *Pts,int num,Window TmpWind);
#else 
void DrawDot();
void DrawBox();
void DrawTri();
void DrawCross();
void DrawCircle();
void DrawPlus();
void DrawFilledB();
void DrawFilledT();
void DrawFilledCircle();
void DrawBitmap();
void MakeOutLine();
#endif 

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
Polygon(Pts, num, fill, TmpWind, Color, PtType, BaseType, LineStyle, LineWidth, FillStyle,ShadedVal)
XPoint *Pts;
int num;
int fill;
Window TmpWind;
int Color;
int PtType;
int BaseType;
int LineStyle;
int LineWidth;
int FillStyle;
int ShadedVal;
{

	int i;
	int DisplayHaloedColor=BackGroundColour;

	fill =  DetermineFillType(fill,num,PtType,FillStyle,BaseType);
	SetColor(Color);

	if (HaloedColor==63) DisplayHaloedColor = BackGroundColour;
	else DisplayHaloedColor=HaloedColor;

	SetLine(LineWidth, LineStyle);
	switch (fill) {
	    case DOT:{
			DrawDot(Pts[0], TmpWind);
			break;
		}
	    case PLUS:{
			DrawPlus(Pts[0], TmpWind);
			break;
		}
	    case BOX:{
			DrawBox(Pts[0], TmpWind);
			break;
		}
	    case TRI:{
			DrawTri(Pts[0], TmpWind);
			break;
		}
	    case CROSS:{
			DrawCross(Pts[0], TmpWind);
			break;
		}
	    case PTCIRCLE:{
			DrawCircle(Pts[0], TmpWind);
			break;
		}
	    case FILLEDBOX:{
			DrawFilledB(Pts[0], TmpWind);
			break;
		}
	    case FILLEDTRI:{
			DrawFilledT(Pts[0], TmpWind);
			break;
		}
	    case FILLEDCIRCLE:{
			DrawFilledCircle(Pts[0], TmpWind);
                        break;
		}
	    case FILLEDSPHERE:{
			DrawBitmap(Pts[0], TmpWind);
                        break;
		}
	    case FILLEDOPAQUE:{
			SetColor(BackGroundColour);
			XFillPolygon(theDisplay, (Drawable) TmpWind, theGC, Pts, num, CoordModeOrigin, Complex);
			SetColor(0);
			XDrawLines(theDisplay, (Drawable) TmpWind, theGC, Pts, num, CoordModeOrigin);
			break;
		}
	    case COLOUREDOPAQUE:{
			SetColor(BackGroundColour);
			XFillPolygon(theDisplay, (Drawable) TmpWind, theGC, Pts, num, CoordModeOrigin, Complex);
                        SetColor(Color);
                        XDrawLines(theDisplay, (Drawable) TmpWind, theGC, Pts, num, CoordModeOrigin);
			break;

	     	}
	    case WHITELINES:{
			SetColor(63);
			CheckDither();
			XDrawLines(theDisplay, (Drawable) TmpWind, theGC, Pts, num, CoordModeOrigin);
			ReturnDither();
			break;
		}
	    case BLACKLINES:{
			SetColor(0);
			CheckDither();
/*			fprintf(stderr,"BlackLines\n");*/
			XDrawLines(theDisplay, (Drawable) TmpWind, theGC, Pts, num, CoordModeOrigin);
			ReturnDither();
			break;
		}
	    case COLOUREDLINES:{
			SetColor(Color);
                        XDrawLines(theDisplay, (Drawable) TmpWind, theGC, Pts, num, CoordModeOrigin);
                        break;
                }
	    case HALOEDLINES:{
                SetColor(DisplayHaloedColor);
		XSetLineAttributes(theDisplay, theGC, DefaultLineWidth+HALSIZE, DefaultLineStyle, CapRound, JoinRound); 
		XDrawLines(theDisplay, (Drawable) TmpWind, theGC, Pts, num, CoordModeOrigin);
		XSetLineAttributes(theDisplay, theGC, DefaultLineWidth, DefaultLineStyle, CapRound, JoinRound); 
		SetColor(Color);
                XDrawLines(theDisplay, (Drawable) TmpWind, theGC, Pts, num, CoordModeOrigin);
			break;
		}
	    case FILLEDHIDDENLINE:{
                    SetColor(10);
                    ChangeTile(ShadedVal);
                        XFillPolygon(theDisplay, (Drawable) TmpWind, theGC, Pts, num , CoordModeOrigin, Complex);
                        SetColor(50);
                        XDrawLines(theDisplay, (Drawable) TmpWind, theGC, Pts, num,
CoordModeOrigin);
                        MakeOutLine(Pts,num,TmpWind);
                        break;
            }

  case FILLEDCOLOR:{
/*   SetColor(Color);*/
   ChangeTile(ShadedVal);
   XFillPolygon(theDisplay,(Drawable)TmpWind,theGC,Pts,num,CoordModeOrigin,Complex);
   MakeOutLine(Pts,num,TmpWind);
   break;
		}
 case FILLEDDITHER:{
	fprintf(stderr,"Should not be in here \n");
	SetColor(Color);
        if (DitherFill){
	if (ShadedVal>=0 && ShadedVal<64) ChangeTile(ShadedVal);
	}
	XFillPolygon(theDisplay, (Drawable) TmpWind, theGC, Pts, num , CoordModeOrigin, Complex);
                      XSetForeground(theDisplay, theGC, 0);
			break;
			}
 case POINTS_ONLY:{
	SetColor(Color);
	 for(i=0;i<num+1;i++){ switch(PtType){ 
	   case MENU_POINT: DrawDot(Pts[i],TmpWind); break;
	   case MENU_BOX: DrawBox(Pts[i],TmpWind); break;
	   case MENU_TRI: DrawTri(Pts[i],TmpWind); break;
	   case MENU_CROSS: DrawCross(Pts[i],TmpWind);break;
	   case MENU_CIRCLE: DrawCircle(Pts[i],TmpWind); break;
	   case MENU_PLUS: DrawPlus(Pts[i],TmpWind); break;
	   case MENU_FILLEDBOX: DrawFilledB(Pts[i],TmpWind); break;
	   case MENU_FILLEDTRI: DrawFilledT(Pts[i],TmpWind); break;
	   case MENU_FILLEDCIRCLE: DrawFilledCircle(Pts[i],TmpWind); break;
	   case MENU_FILLEDSPHERE: DrawBitmap(Pts[i], TmpWind);break;
	   default: DrawDot(Pts[i],TmpWind); break;
		} 
	} 
	XSetForeground(theDisplay, theGC, 0);
	break;
		}
	    case TEXTLABEL:{
		SetColor(Color);
		XmgfSetFont();
                XDrawString(theDisplay, (Drawable) TmpWind, theGC, Pts[0].x,Pts[0].y,CurrentString, strlen(CurrentString));
		break;
        }
	    default:{		/* NOFILL */
		SetColor(Color);
		XDrawLines(theDisplay, (Drawable) TmpWind, theGC, Pts, num, CoordModeOrigin);
		break;
		}
	}
	return ;
}

void
DrawDot(pt, TmpWind)
XPoint pt;
Window TmpWind;
{
	XDrawPoint(theDisplay, (Drawable) TmpWind, theGC, pt.x, pt.y);
}

void
DrawPlus(pt, TmpWind)
XPoint pt;
Window TmpWind;
{
	int P;

	P = DefaultPointSize;
	XDrawLine(theDisplay, (Drawable) TmpWind, theGC, pt.x - P, pt.y, pt.x + P, pt.y);
	XDrawLine(theDisplay, (Drawable) TmpWind, theGC, pt.x, pt.y + P, pt.x, pt.y - P);
}

void
DrawBox(pt, TmpWind)
XPoint pt;
Window TmpWind;
{
	int P;

	P = DefaultPointSize;
	XDrawLine(theDisplay, (Drawable) TmpWind, theGC, pt.x - P, pt.y - P, pt.x + P, pt.y - P);
	XDrawLine(theDisplay, (Drawable) TmpWind, theGC, pt.x + P, pt.y - P, pt.x + P, pt.y + P);
	XDrawLine(theDisplay, (Drawable) TmpWind, theGC, pt.x + P, pt.y + P, pt.x - P, pt.y + P);
	XDrawLine(theDisplay, (Drawable) TmpWind, theGC, pt.x - P, pt.y + P, pt.x - P, pt.y - P);
}

void
DrawTri(pt, TmpWind)
XPoint pt;
Window TmpWind;
{
	int P;

	P = DefaultPointSize;
	XDrawLine(theDisplay, (Drawable) TmpWind, theGC, pt.x - P, pt.y + P, pt.x + P, pt.y + P);
	XDrawLine(theDisplay, (Drawable) TmpWind, theGC, pt.x + P, pt.y + P, pt.x, pt.y - P);
	XDrawLine(theDisplay, (Drawable) TmpWind, theGC, pt.x, pt.y - P, pt.x - P, pt.y + P);
}

void
DrawCross(pt, TmpWind)
XPoint pt;
Window TmpWind;
{
	int P;

	P = DefaultPointSize;
	XDrawLine(theDisplay, (Drawable) TmpWind, theGC, pt.x - P, pt.y + P, pt.x + P, pt.y - P);
	XDrawLine(theDisplay, (Drawable) TmpWind, theGC, pt.x + P, pt.y + P, pt.x - P, pt.y - P);
}

void
DrawCircle(pt, TmpWind)
XPoint pt;
Window TmpWind;
{
	int P;

	P = DefaultPointSize;
	XDrawArc(theDisplay, (Drawable) TmpWind, theGC, pt.x - P, pt.y - P, (unsigned int)(2 * P), (unsigned int)(2 * P), 0, 360 * 64);
}

void
DrawFilledCircle(pt, TmpWind)
XPoint pt;
Window TmpWind;
{
	int P;

	P = DefaultPointSize;
	XFillArc(theDisplay, (Drawable) TmpWind, theGC, pt.x - P, pt.y - P, (unsigned int)(2 * P), (unsigned int)(2 * P), 0, 360 * 64);
}


void
DrawFilledB(pt, TmpWind)
XPoint pt;
Window TmpWind;
{
	int P;
	static XPoint Tmp[5];

	P = DefaultPointSize;
	Tmp[0].x = pt.x - (P + 1);
	Tmp[0].y = pt.y - (P + 1);
	Tmp[1].x = pt.x + (P + 1);
	Tmp[1].y = pt.y - (P + 1);
	Tmp[2].x = pt.x + (P + 1);
	Tmp[2].y = pt.y + (P + 1);
	Tmp[3].x = pt.x - (P + 1);
	Tmp[3].y = pt.y + (P + 1);
	Tmp[4].x = pt.x - (P + 1);
	Tmp[4].y = pt.y - (P + 1);
	XFillPolygon(theDisplay, (Drawable) TmpWind, theGC, Tmp, 5, CoordModeOrigin, Complex);
}

void
DrawFilledT(pt, TmpWind)
XPoint pt;
Window TmpWind;
{
	int P;
	static XPoint Tmp[4];

	P = DefaultPointSize;
	Tmp[0].x = pt.x - (P + 1);
	Tmp[0].y = pt.y + (P + 1);
	Tmp[1].x = pt.x;
	Tmp[1].y = pt.y - (P + 1);
	Tmp[2].x = pt.x + (P + 1);
	Tmp[2].y = pt.y + (P + 1);
	Tmp[3].x = pt.x - (P + 1);
	Tmp[3].y = pt.y + (P + 1);
	XFillPolygon(theDisplay, (Drawable) TmpWind, theGC, Tmp, 4, CoordModeOrigin, Complex);
}

void
MakeOutLine(Pts,num,TmpWind)
XPoint *Pts;
int num;
Window TmpWind;
{

    if(OutLine){
    SetColor(OutLineColour);
    if (DitherFill) XSetFillStyle(theDisplay,theGC,FillSolid);
    XDrawLines(theDisplay,(Drawable)TmpWind,theGC,Pts,num,CoordModeOrigin); 
    if (DitherFill) XSetFillStyle(theDisplay,theGC,FillOpaqueStippled);
    }
}

void
DrawBitmap(pt, TmpWind)
XPoint pt;
Window TmpWind;
{
        int P;

	P = DefaultPointSize;
	if (P>28) P=28;
	ChangeSphere(P);	
        ReturnSphere();
	XSetTSOrigin(theDisplay,theGC,pt.x - P, pt.y - P);
        XFillArc(theDisplay, (Drawable) TmpWind, theGC, pt.x - P, pt.y - P, (unsigned int)
(2 * P), (unsigned int)(2 * P), 0, 360 * 64);
	CheckSphere();
	if(OutLine){
	SetColor(OutLineColour);
        XDrawArc(theDisplay, (Drawable) TmpWind, theGC, pt.x - P, pt.y - P, 
		(unsigned int)(2 * P), (unsigned int)(2 * P), 0, 360 * 64);
	}
}

